/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.controlling.AccountController;
import jd.http.Browser;
import jd.http.Cookies;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.parser.html.InputField;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountInvalidException;
import jd.plugins.AccountRequiredException;
import jd.plugins.AccountUnavailableException;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.components.PluginJSonUtils;
import jd.plugins.components.SiteType;
import jd.plugins.components.UserAgents;
import org.appwork.storage.StorageException;
import org.appwork.storage.TypeRef;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.parser.UrlQuery;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.AbstractCloudflareTurnstileCaptcha;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CaptchaHelperHostPluginCloudflareTurnstile;
import org.jdownloader.captcha.v2.challenge.hcaptcha.AbstractHCaptcha;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.AbstractRecaptchaV2;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.CaptchaHelperHostPluginRecaptchaV2;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.antiDDoSForHost;
import org.jdownloader.scripting.JavaScriptEngineFactory;

@HostPlugin(revision="$Revision: 51205 $", interfaceVersion=2, names={}, urls={})
public abstract class YetiShareCore
extends antiDDoSForHost {
    private static Map<String, String> agent = new HashMap<String, String>();
    public static final String PROPERTY_INTERNAL_FILE_ID = "INTERNALFILEID";
    public static final String PROPERTY_UPLOAD_DATE_RAW = "UPLOADDATE_RAW";
    public static final String PROPERTY_IS_NEW_YETISHARE_VERSION = "is_new_yetishare_version";
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    private static final String error_you_have_reached_the_download_limit = "error_you_have_reached_the_download_limit";
    private static final String error_you_have_reached_the_download_limit_this_file = "error_you_have_reached_the_download_limit_this_file";
    private static final String error_you_must_register_for_a_premium_account_for_filesize = "error_you_must_register_for_a_premium_account_for_filesize";
    private static final String error_file_is_not_publicly_shared = "error_file_is_not_publicly_shared";
    private static final String error_you_must_be_a_x_user_to_download_this_file = "error_you_must_be_a_x_user_to_download_this_file";
    private static final String error_you_have_reached_the_maximum_daily_download_limit = "error_you_have_reached_the_maximum_daily_download_limit";
    private static final String error_you_have_reached_the_maximum_band_width_per_day_in_the_last_24_hours = "error_you_have_reached_the_maximum_band_width_per_day_in_the_last_24_hours";
    private static final String error_you_have_reached_the_maximum_daily_download_limit_this_file = "error_you_have_reached_the_maximum_daily_download_limit_this_file";
    private static final String error_you_have_reached_the_maximum_permitted_downloads_in_the_last_24_hours = "error_you_have_reached_the_maximum_permitted_downloads_in_the_last_24_hours";
    private static final String error_you_have_reached_the_max_permitted_downloads = "error_you_have_reached_the_max_permitted_downloads";
    private static final String error_you_must_wait_between_downloads = "error_you_must_wait_between_downloads";
    protected static final String PROPERTY_API_ACCESS_TOKEN = "ACCESS_TOKEN";
    protected static final String PROPERTY_API_ACCOUNT_ID = "ACCOUNT_ID";
    protected static final String PROPERTY_API_KEY1 = "API_KEY1";
    protected static final String PROPERTY_API_KEY2 = "API_KEY2";
    protected static final String API_LOGIN_HAS_BEEN_SUCCESSFUL_ONCE = "API_LOGIN_HAS_BEEN_SUCCESSFUL_ONCE";

    public YetiShareCore(PluginWrapper wrapper) {
        super(wrapper);
    }

    public static final String getDefaultAnnotationPatternPart() {
        return "/(?!folder|shared|account|upgrade|faq|register)[A-Za-z0-9]+(?:/[^/<>]+)?";
    }

    public static String[] buildAnnotationUrls(List<String[]> pluginDomains) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String[] domains : pluginDomains) {
            ret.add("https?://(?:www\\.)?" + YetiShareCore.buildHostsPatternPart(domains) + YetiShareCore.getDefaultAnnotationPatternPart());
        }
        return ret.toArray(new String[0]);
    }

    protected List<String> getDeadDomains() {
        return null;
    }

    @Override
    public String getAGBLink() {
        if (this.isNewYetiShareVersion(null)) {
            return this.getMainPage((String)null) + "/terms";
        }
        return this.getMainPage((String)null) + "/terms.html";
    }

    public String getPurchasePremiumURL() {
        if (this.isNewYetiShareVersion(null)) {
            return this.getMainPage((String)null) + "/upgrade";
        }
        return this.getMainPage((String)null) + "/upgrade.html";
    }

    @Override
    public String getLinkID(DownloadLink link) {
        String fuid = this.getFUID(link);
        if (fuid != null) {
            return this.getHost() + "://" + fuid;
        }
        return super.getLinkID(link);
    }

    protected String getCorrectHost(DownloadLink link, URL url) {
        return url.getHost();
    }

    protected String getContentURL(DownloadLink link) {
        if (link == null) {
            return null;
        }
        String originalURL = link.getPluginPatternMatcher();
        if (originalURL == null) {
            return null;
        }
        try {
            URL url = new URL(originalURL);
            String urlHost = this.getCorrectHost(link, url);
            String urlHostWithoutWww = urlHost.replaceFirst("(?i)www\\.", "");
            List<String> deadDomains = this.getDeadDomains();
            String protocol = this.getProtocol(originalURL);
            if (deadDomains == null || !deadDomains.contains(urlHost) && !deadDomains.contains(urlHostWithoutWww)) {
                return protocol + this.appendWWWIfRequired(urlHost) + url.getPath();
            }
            String pluginHost = this.getHost();
            String host = StringUtils.equalsIgnoreCase((String)urlHost, (String)pluginHost) ? urlHost : urlHost.replaceFirst("(?i)" + Pattern.quote(Browser.getHost((URL)url, (boolean)false)) + "$", pluginHost);
            return protocol + this.appendWWWIfRequired(host) + url.getPath();
        }
        catch (MalformedURLException e) {
            LogController.getRebirthLogger(this.logger).log((Throwable)e);
            return originalURL;
        }
    }

    protected String appendWWWIfRequired(String host) {
        if (!this.requiresWWW() || StringUtils.startsWithCaseInsensitive((String)host, (String)"www.")) {
            return host;
        }
        String hostTld = Browser.getHost((String)host, (boolean)false);
        if (!StringUtils.equalsIgnoreCase((String)host, (String)hostTld)) {
            return host;
        }
        return "www." + host;
    }

    protected String getInfoPageURL(DownloadLink link) {
        String url = this.getContentURL(link);
        return new Regex(url, "(?i)(https?://[^/]+)").getMatch(0) + "/" + this.getFUID(link) + "~i";
    }

    @Override
    public boolean isResumeable(DownloadLink link, Account account) {
        if (account != null && account.getType() == Account.AccountType.FREE) {
            return true;
        }
        if (account != null && account.getType() == Account.AccountType.PREMIUM) {
            return true;
        }
        return true;
    }

    public int getMaxChunks(Account account) {
        if (account != null && account.getType() == Account.AccountType.FREE) {
            return 0;
        }
        if (account != null && account.getType() == Account.AccountType.PREMIUM) {
            return 0;
        }
        return 0;
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return Integer.MAX_VALUE;
    }

    public int getMaxSimultaneousFreeAccountDownloads() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxSimultanPremiumDownloadNum() {
        return Integer.MAX_VALUE;
    }

    protected static String getDownloadModeDirectlinkProperty(Account account) {
        if (account != null && account.getType() == Account.AccountType.FREE) {
            return "freelink2";
        }
        if (account != null && account.getType() == Account.AccountType.PREMIUM) {
            return "premlink";
        }
        return "freelink";
    }

    public boolean supports_https() {
        return true;
    }

    public boolean supports_availablecheck_over_info_page(DownloadLink link) {
        return link.getTempProperties().getBooleanProperty(this.getHost() + ".supports_availablecheck_over_info_page", Boolean.TRUE);
    }

    protected boolean supports_availablecheck_filesize_html() {
        return true;
    }

    protected boolean requiresWWW() {
        return true;
    }

    public boolean enableRandomUserAgent() {
        return false;
    }

    @Deprecated
    protected boolean enforce_old_login_method() {
        return false;
    }

    protected String[] getFileInfoArray() {
        return new String[2];
    }

    @Override
    public boolean enoughTrafficFor(DownloadLink link, Account account) throws Exception {
        String directlinkproperty = YetiShareCore.getDownloadModeDirectlinkProperty(account);
        String dllink = link.getStringProperty(directlinkproperty, null);
        if (StringUtils.isNotEmpty((String)dllink)) {
            return true;
        }
        return super.enoughTrafficFor(link, account);
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink link) throws Exception {
        Account account;
        if (this.supportsAPISingleAvailablecheck(link) && (account = this.findAccountWithAPICredentials()) != null) {
            return this.requestFileInformationAPI(this.br, link, account);
        }
        return this.requestFileInformationWebsite(link, null, false);
    }

    public DownloadLink.AvailableStatus requestFileInformationWebsite(DownloadLink link, Account account, boolean isDownload) throws Exception {
        block28: {
            if (!link.isNameSet()) {
                this.setWeakFilename(link);
            }
            this.br.setFollowRedirects(true);
            this.prepBrowserWebsite(this.br);
            String[] fileInfo = this.getFileInfoArray();
            try {
                if (this.supports_availablecheck_over_info_page(link) && !isDownload) {
                    this.getPage(this.getInfoPageURL(link));
                    try {
                        this.checkErrors(this.br, link, account);
                    }
                    catch (AccountRequiredException e) {
                        String errorMsgURL = this.getErrorMsgURL(this.br);
                        if (errorMsgURL != null && StringUtils.startsWithCaseInsensitive((String)errorMsgURL, (String)"File is not publicly available") || StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"Plik nie jest publicznie")) {
                            link.getTempProperties().setProperty(this.getHost() + ".supports_availablecheck_over_info_page", Boolean.FALSE);
                            return this.requestFileInformationWebsite(link, account, isDownload);
                        }
                        throw e;
                    }
                    if (!this.br.getURL().contains("~i") || this.br.getHttpConnection().getResponseCode() == 404) {
                        throw new PluginException(32);
                    }
                    this.parseAndSetYetiShareVersion(this.br, account);
                    this.scanInfo(link, fileInfo);
                    if (!StringUtils.isEmpty((String)fileInfo[0])) {
                        String filename = Encoding.htmlDecode((String)fileInfo[0]).trim();
                        link.setName(filename);
                    }
                    if (fileInfo[1] != null) {
                        link.setDownloadSize(SizeFormatter.getSize((String)Encoding.htmlDecode((String)fileInfo[1].replace(",", ""))));
                    }
                    if (this.br.containsHTML(">\\s*Status\\s*:?\\s*</[^>]*>\\s*<[^>]*>\\s*(Deleted|Usuni\u0119to|Usuni\u0119ty|Silindi|\u00c7\u00f6p)\\s*</")) {
                        throw new PluginException(32);
                    }
                    break block28;
                }
                String contenturl = this.getContentURL(link);
                URLConnectionAdapter con = null;
                boolean hasGoneThroughVerifiedLoginOnce = false;
                if (account != null) {
                    hasGoneThroughVerifiedLoginOnce = this.loginWebsite(account, false);
                }
                int attemptNumber = 0;
                do {
                    if (isDownload) {
                        this.dl = BrowserAdapter.openDownload(this.br, link, contenturl, this.isResumeable(link, account), this.getMaxChunks(account));
                        con = this.dl.getConnection();
                    } else {
                        con = this.br.openGetConnection(contenturl);
                    }
                    if (this.looksLikeDownloadableContent(con)) {
                        this.logger.info("Direct download");
                        String filename = Plugin.getFileNameFromDispositionHeader(con);
                        if (filename != null) {
                            link.setFinalFileName(Encoding.htmlDecode((String)filename).trim());
                        }
                        if (con.getCompleteContentLength() > 0L) {
                            if (con.isContentDecoded()) {
                                link.setDownloadSize(con.getCompleteContentLength());
                            } else {
                                link.setVerifiedFileSize(con.getCompleteContentLength());
                            }
                        }
                        return DownloadLink.AvailableStatus.TRUE;
                    }
                    this.br.followConnection(true);
                    this.runPostRequestTask(this.br);
                    this.dl = null;
                    if (account == null || hasGoneThroughVerifiedLoginOnce || this.isLoggedin(this.br, account)) break;
                    this.logger.warning("Possible login failure -> Trying again");
                    this.loginWebsite(account, true);
                    hasGoneThroughVerifiedLoginOnce = true;
                } while (++attemptNumber <= 1);
                if (hasGoneThroughVerifiedLoginOnce) {
                    this.loggedInOrException(this.br, account);
                }
                this.checkErrors(this.br, link, account);
                if (this.isOfflineWebsite(this.br, link)) {
                    throw new PluginException(32);
                }
                this.parseAndSetYetiShareVersion(this.br, account);
                this.scanInfo(link, fileInfo);
                if (!StringUtils.isEmpty((String)fileInfo[0])) {
                    String filename = Encoding.htmlDecode((String)fileInfo[0]).trim();
                    link.setName(filename);
                }
                if (fileInfo[1] != null) {
                    link.setDownloadSize(SizeFormatter.getSize((String)Encoding.htmlDecode((String)fileInfo[1].replace(",", ""))));
                }
            }
            catch (PluginException e) {
                if (isDownload || e.getLinkStatus() == 32) {
                    throw e;
                }
                this.logger.log((Throwable)e);
                return DownloadLink.AvailableStatus.TRUE;
            }
        }
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && !StringUtils.startsWithCaseInsensitive((String)link.getName(), (String)"[NewYetiShare]") && !StringUtils.startsWithCaseInsensitive((String)link.getName(), (String)"[OldYetiShare]")) {
            if (this.isNewYetiShareVersion(account)) {
                link.setName("[NewYetiShare] " + link.getName());
            } else {
                link.setName("[OldYetiShare] " + link.getName());
            }
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    public String[] scanInfo(DownloadLink link, String[] fileInfo) {
        String fuid = this.getFUID(link);
        boolean currentUrlIsFileInfoURL = this.br.getURL().contains(fuid + "~i");
        if (this.isNewYetiShareVersion(null) || this.supports_availablecheck_over_info_page(link) || currentUrlIsFileInfoURL) {
            String betterFilesize;
            String betterFilename = this.br.getRegex("(?i)>\\s*File Page Link\\s*</span>\\s*<pre>https?://[^/]+/[A-Za-z0-9]+/([^<]+)</pre>").getMatch(0);
            if (betterFilename == null) {
                betterFilename = this.br.getRegex("(?i)>\\s*(?:Information about|Informa\u00e7\u00e3o sobre|Informacja o|Nazwa pliku) \"([^\"]+)\"\\s*<").getMatch(0);
            }
            if (betterFilename != null) {
                fileInfo[0] = betterFilename;
            }
            if (!StringUtils.isEmpty((String)(betterFilesize = this.br.getRegex("Filesize\\s*:\\s*</span>\\s*<span>([^<>\"]+)<").getMatch(0)))) {
                fileInfo[1] = betterFilesize;
            }
            if (betterFilename != null && betterFilesize != null) {
                return fileInfo;
            }
        }
        if (this.supports_availablecheck_over_info_page(link) || currentUrlIsFileInfoURL) {
            String name;
            String name2;
            ArrayList<String> fileNameCandidates = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)fileInfo[0])) {
                fileNameCandidates.add(Encoding.htmlDecode((String)fileInfo[0]).trim());
            }
            String[] tableData = this.br.getRegex("class=\"responsiveInfoTable\">([^<>\"/]*?)<").getColumn(0);
            String lang_str_information = PluginJSonUtils.getJson(this.br, "file_information_left_description");
            if (StringUtils.isEmpty((String)lang_str_information)) {
                lang_str_information = "(?:Information about|Informa\u00e7\u00e3o sobre)";
            }
            if ((name2 = this.br.getRegex("data\\-animation\\-delay=\"\\d+\"\\s*>\\s*" + Pattern.quote(lang_str_information) + "\\s*([^<>\"]*?)\\s*</div>").getMatch(0)) == null) {
                name2 = this.br.getRegex(">\\s*" + Pattern.quote(lang_str_information) + "\\s*([^<>\"]+)<").getMatch(0);
            }
            String string = name2 = name2 != null ? Encoding.htmlOnlyDecode((String)name2).trim() : null;
            if (name2 != null && !fileNameCandidates.contains(name2)) {
                fileNameCandidates.add(name2);
            }
            String string2 = name = (name = this.br.getRegex("<meta\\s*name\\s*=\\s*\"description[^\"]*\"\\s*content\\s*=\\s*\"\\s*(?:Information about|informacje o)\\s*([^<>\"]+)\\s*\"").getMatch(0)) != null ? Encoding.htmlOnlyDecode((String)name).trim() : null;
            if (name != null && !fileNameCandidates.contains(name)) {
                fileNameCandidates.add(name);
            }
            String string3 = name = (name = this.br.getRegex("class\\s*=\\s*\"description\\-1[^\"]*\"\\s*>\\s*(?:Information about|informacje o)\\s*([^<>\"]+)\\s*<").getMatch(0)) != null ? Encoding.htmlOnlyDecode((String)name).trim() : null;
            if (name != null && !fileNameCandidates.contains(name)) {
                fileNameCandidates.add(name);
            }
            String string4 = name = (name = (fileInfo[0] = this.br.getRegex("(?:Filename|Dateiname|\u0627\u0633\u0645 \u0627\u0644\u0645\u0644\u0641|Nome|Dosya Ad\u0131|Nazwa Pliku)\\s*:[\t\n\r ]*?</td>[\t\n\r ]*?<td(?: class=\"responsiveInfoTable\")?>\\s*([^<>\"]*?)\\s*<").getMatch(0))) != null ? Encoding.htmlOnlyDecode((String)name).trim() : null;
            if (name != null && !fileNameCandidates.contains(name)) {
                fileNameCandidates.add(name);
            }
            if (StringUtils.isEmpty((String)fileInfo[1])) {
                fileInfo[1] = this.br.getRegex("(?:Filesize|Dateigr\u00f6\u00dfe|\u062d\u062c\u0645 \u0627\u0644\u0645\u0644\u0641|Tamanho|Boyut|Rozmiar Pliku)\\s*:\\s*</td>\\s*?<td(?:\\s*class=\"responsiveInfoTable\")?>\\s*([^<>\"]*?)\\s*<").getMatch(0);
            }
            try {
                if (StringUtils.isEmpty((String)fileInfo[0]) && tableData.length > 0) {
                    name = tableData[0];
                    String string5 = name = name != null ? Encoding.htmlOnlyDecode((String)name).trim() : null;
                    if (StringUtils.isNotEmpty((String)name) && !fileNameCandidates.contains(name)) {
                        fileNameCandidates.add(name);
                    }
                }
                if (StringUtils.isEmpty((String)fileInfo[1]) && tableData.length > 1) {
                    fileInfo[1] = tableData[1];
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            String bestName = null;
            for (String fileNameCandidate : fileNameCandidates) {
                if (StringUtils.isEmpty((String)fileNameCandidate)) continue;
                if (bestName == null) {
                    bestName = fileNameCandidate;
                    continue;
                }
                if (bestName.contains("...") && !fileNameCandidate.contains("...")) {
                    bestName = fileNameCandidate;
                    continue;
                }
                if (bestName.length() >= fileNameCandidate.length()) continue;
                bestName = fileNameCandidate;
            }
            fileInfo[0] = bestName;
        } else {
            Regex fInfo = this.br.getRegex("<strong>([^<>\"]*?) \\((\\d+(?:,\\d+)?(?:\\.\\d+)? (?:TB|GB|MB|KB|B))\\)<");
            if (StringUtils.isEmpty((String)fileInfo[0])) {
                fileInfo[0] = fInfo.getMatch(0);
            }
            if (this.supports_availablecheck_filesize_html()) {
                if (StringUtils.isEmpty((String)fileInfo[1])) {
                    fileInfo[1] = fInfo.getMatch(1);
                }
                if (StringUtils.isEmpty((String)fileInfo[1])) {
                    fileInfo[1] = this.br.getRegex("(?:>\\s*|\\(\\s*|\"\\s*|\\[\\s*|\\s+)([0-9\\.]+(?:\\s+|\\&nbsp;)?(bytes)(?!ps|/s|\\w|\\s*Storage|\\s*Disk|\\s*Space|\\s*traffic))").getMatch(0);
                    if (StringUtils.isEmpty((String)fileInfo[1])) {
                        fileInfo[1] = this.br.getRegex("(?:>\\s*|\\(\\s*|\"\\s*|\\[\\s*|\\s+)([0-9\\.]+(?:\\s+|\\&nbsp;)?(TB|GB|MB|KB)(?!ps|/s|\\w|\\s*Storage|\\s*Disk|\\s*Space|\\s*traffic))").getMatch(0);
                    }
                }
            }
        }
        return fileInfo;
    }

    @Override
    public void handleFree(DownloadLink link) throws Exception, PluginException {
        this.handleDownloadWebsite(link, null);
    }

    protected void handleDownloadWebsite(DownloadLink link, Account account) throws Exception, PluginException {
        this.checkDirectLink(link, account);
        if (this.dl == null) {
            this.prepBrowserWebsite(this.br);
            this.requestFileInformationWebsite(link, account, true);
            if (this.dl == null) {
                this.br.setFollowRedirects(true);
                this.handlePasswordProtection(link, account, this.br);
                if (this.dl == null) {
                    this.checkErrors(this.br, link, account);
                    String loopLog = null;
                    int maxPreDownloadPages = 8;
                    int maxCaptchaAttempts = 3;
                    int preDownloadPageCounter = 0;
                    int captchaAttemptCounter = 0;
                    int numberofCaptchasRequested = 0;
                    while (true) {
                        String continueLink;
                        boolean hasRequestedCaptcha = false;
                        this.logger.info("Handling pre-download page " + (preDownloadPageCounter + 1) + " of max " + 8 + " | Captcha attempts needed: " + captchaAttemptCounter + "/" + 3 + " | Captchas requested so far: " + numberofCaptchasRequested);
                        long timeBeforeCaptchaInput = Time.systemIndependentCurrentJVMTimeMillis();
                        String storedInternalFileID = this.getStoredInternalFileID(link);
                        String htmlFileID = this.regexInternalFileID(this.br);
                        if (htmlFileID != null || storedInternalFileID != null && this.allowDirectDownloadAlsoWhenOnlyStoredInternalFileIDIsAvailable(link, account)) {
                            if (storedInternalFileID == null) {
                                link.setProperty(PROPERTY_INTERNAL_FILE_ID, htmlFileID);
                            } else if (htmlFileID != null && !StringUtils.equals((String)storedInternalFileID, (String)htmlFileID)) {
                                this.logger.info("fileID changed!?:stored=" + storedInternalFileID + " | html=" + htmlFileID);
                                throw new PluginException(0x400000);
                            }
                            String fileID = this.getStoredInternalFileID(link);
                            boolean passwordSuccess = false;
                            int passwordcounter = 0;
                            do {
                                this.requestFileDetailsNewYetiShare(this.br, fileID);
                                Form pwForm = this.br.getFormbyProperty("id", "folderPasswordForm");
                                if (pwForm == null) {
                                    link.setPasswordProtected(false);
                                    break;
                                }
                                link.setPasswordProtected(true);
                                pwForm.setMethod(Form.MethodType.POST);
                                String passCode = link.getDownloadPassword();
                                if (passCode == null) {
                                    passCode = this.getUserInput("Password?", link);
                                }
                                pwForm.put("folderPassword", Encoding.urlEncode((String)passCode));
                                this.submitForm(this.br, pwForm);
                                Map pwresponse = (Map)this.restoreFromString(this.br.getRequest().getHtmlCode(), TypeRef.MAP);
                                if (Boolean.TRUE.equals(pwresponse.get("success"))) {
                                    this.logger.info("Password success: passCode= " + passCode);
                                    passwordSuccess = true;
                                    link.setDownloadPassword(passCode);
                                    this.requestFileDetailsNewYetiShare(this.br, fileID);
                                    break;
                                }
                                this.logger.info("Password failure: passCode= " + passCode);
                                link.setDownloadPassword(null);
                                passCode = null;
                            } while (!this.isAbort() && !passwordSuccess && ++passwordcounter < 3);
                            if (link.isPasswordProtected() && !passwordSuccess) {
                                throw new PluginException(4, "Wrong password entered");
                            }
                            continueLink = this.getContinueLink(this.br);
                            if (!StringUtils.isEmpty((String)continueLink)) {
                                this.logger.info("Found possible continueLink in html provided via json: " + continueLink);
                            } else {
                                if (this.br.containsHTML("triggerFileDownload\\(" + fileID)) {
                                    this.logger.info("Attempting direct_download");
                                    this.hookBeforeV2DirectDownload(link, account, this.br);
                                    this.dl = BrowserAdapter.openDownload(this.br, link, "/account/direct_download/" + fileID, this.isResumeable(link, account), this.getMaxChunks(account));
                                    break;
                                }
                                this.logger.warning("direct_download impossible for unknown reasons");
                            }
                        } else {
                            continueLink = this.getContinueLink(this.br);
                        }
                        Form continueform = this.getContinueForm(this.br, preDownloadPageCounter, continueLink);
                        if (continueform == null && StringUtils.isEmpty((String)continueLink)) {
                            this.logger.info("No continue_form/continue_link available, plugin broken --> Step: " + (preDownloadPageCounter + 1));
                            this.checkErrors(this.br, link, account);
                            this.checkErrorsLastResort(this.br, link, account);
                            throw new PluginException(0x400000);
                        }
                        loopLog = loopLog == null ? continueLink : loopLog + " --> " + continueLink;
                        if (this.isDownloadlink(continueLink)) {
                            this.waitTime(this.br, link, timeBeforeCaptchaInput);
                            this.dl = BrowserAdapter.openDownload(this.br, link, continueLink, this.isResumeable(link, account), this.getMaxChunks(account));
                            break;
                        }
                        if (continueform == null) {
                            this.waitTime(this.br, link, timeBeforeCaptchaInput);
                            this.dl = BrowserAdapter.openDownload(this.br, link, continueLink, this.isResumeable(link, account), this.getMaxChunks(account));
                        } else if (AbstractCloudflareTurnstileCaptcha.containsCloudflareTurnstileClass(this.br)) {
                            String cfTurnstileResponse = new CaptchaHelperHostPluginCloudflareTurnstile(this, this.br).getToken();
                            continueform.put("cf-turnstile-response", Encoding.urlEncode((String)cfTurnstileResponse));
                            continueform.put("cf-recaptcha-response", Encoding.urlEncode((String)cfTurnstileResponse));
                        } else if (this.containsRecaptchaV2Class(continueform) || this.br.containsHTML("data\\-sitekey\\s*=\\s*|g\\-recaptcha\\'")) {
                            loopLog = loopLog + " --> reCaptchaV2";
                            hasRequestedCaptcha = true;
                            String recaptchaV2Response = new CaptchaHelperHostPluginRecaptchaV2(this, this.br).getToken();
                            this.waitTime(this.br, link, timeBeforeCaptchaInput);
                            if (this.br.containsHTML("capcode")) {
                                continueform.put("capcode", "false");
                            }
                            continueform.put("g-recaptcha-response", Encoding.urlEncode((String)recaptchaV2Response));
                            continueform.setMethod(Form.MethodType.POST);
                            this.hookBeforeCaptchaFormSubmit(this.br, continueform);
                            this.dl = BrowserAdapter.openDownload(this.br, link, continueform, this.isResumeable(link, account), this.getMaxChunks(account));
                            ++numberofCaptchasRequested;
                        } else if (continueform != null && continueform.getMethod() == Form.MethodType.POST) {
                            loopLog = loopLog + " --> Form_POST";
                            this.waitTime(this.br, link, timeBeforeCaptchaInput);
                            this.hookBeforeCaptchaFormSubmit(this.br, continueform);
                            this.dl = BrowserAdapter.openDownload(this.br, link, continueform, this.isResumeable(link, account), this.getMaxChunks(account));
                        } else {
                            this.logger.warning("Unknown state");
                            break;
                        }
                        this.logger.info("loopLog: " + loopLog);
                        try {
                            this.checkResponseCodeErrors(this.dl.getConnection());
                        }
                        catch (PluginException e) {
                            try {
                                this.br.followConnection(true);
                            }
                            catch (IOException ioe) {
                                throw (PluginException)Exceptions.addSuppressed((Throwable)e, (Throwable)ioe);
                            }
                            throw e;
                        }
                        if (this.looksLikeDownloadableContent(this.dl.getConnection())) {
                            loopLog = loopLog + " --> DOWNLOAD!";
                            this.logger.info("Successfully initiated download");
                            break;
                        }
                        this.br.followConnection(true);
                        this.dl = null;
                        this.logger.info("Failed to find downloadurl in this round");
                        this.checkErrors(this.br, link, account);
                        if (preDownloadPageCounter >= 8) {
                            this.logger.info("Ending main loop because: Too many pre-download-pages");
                            break;
                        }
                        if (captchaAttemptCounter >= 3) {
                            this.logger.info("Ending main loop because: Too many wrong captchas");
                            throw new PluginException(8);
                        }
                        if (hasRequestedCaptcha) {
                            ++captchaAttemptCounter;
                            if (this.containsCaptcha(this.br)) {
                                this.invalidateLastChallengeResponse();
                                this.logger.info("Wrong captcha");
                            } else {
                                this.validateLastChallengeResponse();
                            }
                        } else {
                            ++preDownloadPageCounter;
                        }
                        this.logger.info("Continue to next round");
                    }
                    this.logger.info("Final loopLog: " + loopLog);
                }
            }
        }
        if (this.dl == null) {
            this.checkErrors(this.br, link, account);
            if (this.isOfflineWebsite(this.br, link)) {
                throw new PluginException(32);
            }
            this.checkErrorsLastResort(this.br, link, account);
            throw new PluginException(0x400000);
        }
        link.setProperty(YetiShareCore.getDownloadModeDirectlinkProperty(account), this.dl.getConnection().getURL().toExternalForm());
        try {
            this.checkResponseCodeErrors(this.dl.getConnection());
        }
        catch (PluginException e) {
            try {
                this.br.followConnection(true);
            }
            catch (IOException ioe) {
                throw (PluginException)Exceptions.addSuppressed((Throwable)e, (Throwable)ioe);
            }
            throw e;
        }
        if (!this.looksLikeDownloadableContent(this.dl.getConnection())) {
            this.br.followConnection(true);
            this.checkErrors(this.br, link, account);
            this.checkErrorsLastResort(this.br, link, account);
            throw new PluginException(0x400000);
        }
        this.dl.startDownload();
    }

    protected void requestFileDetailsNewYetiShare(Browser br, String fileID) throws Exception {
        this.postPage(br, "/account/ajax/file_details", "u=" + fileID + "&p=true");
        Map root = (Map)this.restoreFromString(br.getRequest().getHtmlCode(), TypeRef.MAP);
        String html = root.get("html").toString();
        br.getRequest().setHtmlCode(html);
    }

    protected void hookBeforeCaptchaFormSubmit(Browser br, Form captchaForm) {
    }

    protected String regexInternalFileID(Browser br) {
        return br.getRegex("showFileInformation\\((\\d+)").getMatch(0);
    }

    protected boolean containsCaptcha(Browser br) {
        return AbstractRecaptchaV2.containsRecaptchaV2Class(br) || br.containsHTML("(api\\.recaptcha\\.net|google\\.com/recaptcha/api/|solvemedia\\.com/papi/)") || AbstractHCaptcha.containsHCaptcha(br);
    }

    protected void hookBeforeV2DirectDownload(DownloadLink link, Account account, Browser br) throws Exception {
    }

    @Deprecated
    protected void handlePasswordProtection(DownloadLink link, Account account, Browser br) throws Exception {
        Form pwform = this.getPasswordProtectedForm(br);
        if (pwform == null) {
            link.setPasswordProtected(false);
            return;
        }
        link.setPasswordProtected(true);
        String passCode = link.getDownloadPassword();
        if (passCode == null) {
            passCode = this.getUserInput("Password?", link);
        }
        pwform.put("filePassword", Encoding.urlEncode((String)passCode));
        this.dl = BrowserAdapter.openDownload(br, link, pwform, this.isResumeable(link, account), this.getMaxChunks(account));
        if (this.looksLikeDownloadableContent(this.dl.getConnection())) {
            this.logger.info("User has entered correct password: " + passCode);
            link.setDownloadPassword(passCode);
        } else {
            br.followConnection();
            this.dl = null;
            if (this.getPasswordProtectedForm(br) != null) {
                this.logger.info("User has entered wrong password: " + passCode);
                link.setDownloadPassword(null);
                throw new PluginException(4, "Wrong password entered");
            }
            this.logger.info("User has entered correct password: " + passCode);
            link.setDownloadPassword(passCode);
        }
    }

    @Deprecated
    protected Form getPasswordProtectedForm(Browser br) {
        return br.getFormbyKey("filePassword");
    }

    protected String getStoredInternalFileID(DownloadLink link) {
        return link.getStringProperty(PROPERTY_INTERNAL_FILE_ID);
    }

    protected boolean allowDirectDownloadAlsoWhenOnlyStoredInternalFileIDIsAvailable(DownloadLink link, Account account) {
        return false;
    }

    protected Form getContinueForm(Browser br, int loop_counter, String continue_link) throws PluginException {
        Form continueform = br.getFormbyActionRegex(".+pt=.+");
        if (continueform == null && (continueform = br.getFormByInputFieldKeyValue("submitted", "1")) == null) {
            continueform = br.getFormbyKey("submitted");
        }
        if (continueform == null) {
            return null;
        }
        if (continue_link != null && continueform.containsHTML(Pattern.quote(continue_link))) {
            return continueform;
        }
        Form ret = new Form();
        ret.setMethod(continueform.getMethod());
        if (continue_link != null) {
            ret.setAction(continue_link);
        }
        for (InputField field : continueform.getInputFields()) {
            if (field.getKey() == null || ret.getInputField(field.getKey()) == null) continue;
            ret.addInputField(field);
        }
        ret.put("submit", "Submit");
        if (!ret.hasInputFieldByName("submitted")) {
            ret.put("submitted", "1");
        }
        if (!ret.hasInputFieldByName("d")) {
            ret.put("d", "1");
        }
        return ret;
    }

    protected String getContinueLink(Browser br) throws Exception {
        String continue_link = br.getRegex("\\$\\(\\'\\.download\\-timer\\'\\)\\.html\\(\"<a href=\\'(https?://[^<>\"]*?)\\'").getMatch(0);
        if (continue_link == null) {
            continue_link = br.getRegex("class=\\'btn btn\\-free\\'[^>]*href=\\'([^<>\"\\']*?)\\'>").getMatch(0);
        }
        if (continue_link == null) {
            continue_link = br.getRegex("<div class=\"captchaPageTable\">\\s*<form method=\"POST\" action=\"(https?://[^<>\"]*?)\"").getMatch(0);
        }
        if (continue_link == null) {
            continue_link = br.getRegex("(https?://[^/]+/[^<>\"\\':]*pt=[^<>\"\\']*)(?:\"|\\')").getMatch(0);
        }
        if (continue_link == null) {
            continue_link = this.getDllink(br);
        }
        if (continue_link != null) {
            return Encoding.htmlOnlyDecode((String)continue_link);
        }
        return continue_link;
    }

    protected String getDllink(Browser br) {
        String ret = br.getRegex("openUrl\\(\\s*(?:\"|\\')((?:https?:)?//[A-Za-z0-9\\.\\-]+\\.[^/]+/[^<>\"]*?(?:\\?|\\&)download_token=[A-Za-z0-9]+[^<>\"\\']*?)(?:\"|\\')").getMatch(0);
        if (StringUtils.isEmpty((String)ret) && StringUtils.isEmpty((String)(ret = br.getRegex("source\\s*:\\s*(?:\"|\\')((?:https?:)?//[A-Za-z0-9\\.\\-]+\\.[^/]+/[^<>\"]*?(?:\\?|\\&)download_token=[A-Za-z0-9]+[^<>\"\\']*?)(?:\"|\\')").getMatch(0))) && StringUtils.isEmpty((String)(ret = br.getRegex("(?:\"|\\')((?:https?:)?//[A-Za-z0-9\\.\\-]+\\.[^/]+/[^<>\"]*?(?:\\?|\\&)download_token=[A-Za-z0-9]+[^<>\"\\']*?)(?:\"|\\')").getMatch(0)))) {
            ret = br.getRegex("\"(https?://[^\"]+(?<!/themes)/files/[^\"]+)\"").getMatch(0);
        }
        if (this.isDownloadlink(ret)) {
            return ret;
        }
        if (ret != null) {
            this.logger.info("isDownloadlink false:" + ret);
            return null;
        }
        return null;
    }

    public boolean isDownloadlink(String url) {
        boolean ret = url != null && (url.contains("download_token=") || url.contains("/files/"));
        return ret;
    }

    protected String getFUID(DownloadLink link) {
        return link != null ? this.getFUIDFromURL(link.getPluginPatternMatcher()) : null;
    }

    public String getFUIDFromURL(String url) {
        try {
            if (url != null) {
                String result = new Regex(new URL(url).getPath(), "^/([A-Za-z0-9]+)").getMatch(0);
                return result;
            }
            return null;
        }
        catch (MalformedURLException ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    public String getFilenameFromURL(DownloadLink link) {
        String contentURL = this.getPluginContentURL(link);
        String result = contentURL != null ? YetiShareCore.getFilenameFromURL(contentURL) : YetiShareCore.getFilenameFromURL(link.getPluginPatternMatcher());
        return result;
    }

    public static String getFilenameFromURL(String url) {
        try {
            String result = new Regex(new URL(url).getPath(), "[^/]+/(.+)$").getMatch(0);
            return result;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFallbackFilename(DownloadLink dl) {
        String fallback_filename = this.getFilenameFromURL(dl);
        fallback_filename = fallback_filename != null ? Encoding.htmlDecode((String)fallback_filename) : this.getFUID(dl);
        return fallback_filename;
    }

    public String getFallbackFilename(String url) {
        String fallback_filename = YetiShareCore.getFilenameFromURL(url);
        if (fallback_filename != null) {
            return fallback_filename;
        }
        return this.getFUIDFromURL(url);
    }

    protected void waitTime(Browser br, DownloadLink link, long timeBefore) throws PluginException {
        int wait;
        String waitStr = this.regexWaittime(br);
        boolean extraWaitSeconds = true;
        if (waitStr != null && waitStr.matches("\\d+")) {
            int passedTime = (int)((Time.systemIndependentCurrentJVMTimeMillis() - timeBefore) / 1000L) - 1;
            this.logger.info("Found waittime [seconds]: " + waitStr);
            wait = Integer.parseInt(waitStr);
            wait -= passedTime;
            if (passedTime > 0) {
                this.logger.info("Total passed time during captcha: " + passedTime);
            }
        } else {
            wait = 0;
        }
        if (wait > 0) {
            this.logger.info("Waiting final waittime: " + wait);
            this.sleep((long)wait * 1000L, link);
        } else if (wait < -1) {
            this.logger.info("Congratulations: Time to solve captcha was higher than waittime --> No waittime left");
        } else {
            this.logger.info("Found no waittime");
        }
    }

    static String escapeSpecialRegexChars(String str) {
        return SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }

    private Map<String, Object> getErrorKeyFromErrorMessage(String errorStr) {
        if (StringUtils.isEmpty((String)errorStr)) {
            return null;
        }
        try {
            String language_keys_json = this.br.getRegex("l\\s*=\\s*(\\{.*?\\});\\s*?return").getMatch(0);
            if (language_keys_json == null) {
                return null;
            }
            Map<String, Object> language_keys_map = JavaScriptEngineFactory.jsonToJavaMap(language_keys_json);
            Iterator<Map.Entry<String, Object>> iterator = language_keys_map.entrySet().iterator();
            String found_key_for_errormessage = null;
            HashMap<String, String> errorProperties = new HashMap<String, String>();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                String langStr = (String)entry.getValue();
                String[] dynamicVarsNames = new Regex(langStr, "\\[\\[\\[([^\\]]+)\\]\\]\\]").getColumn(0);
                if (dynamicVarsNames.length > 0) {
                    String langStr2 = YetiShareCore.escapeSpecialRegexChars(langStr);
                    Regex langStrRegEx = new Regex(errorStr, langStr2 = langStr2.replaceAll("\\\\\\[\\\\\\[\\\\\\[[^\\]]+\\\\\\]\\\\\\]\\\\\\]", "(.*?)"));
                    if (!langStrRegEx.patternFind()) continue;
                    found_key_for_errormessage = key;
                    for (int index = 0; index < dynamicVarsNames.length; ++index) {
                        String dynamicVarName = dynamicVarsNames[index];
                        String dynamicVarValue = langStrRegEx.getMatch(index);
                        errorProperties.put(dynamicVarName, dynamicVarValue);
                    }
                    break;
                }
                if (!langStr.equalsIgnoreCase(errorStr)) continue;
                found_key_for_errormessage = key;
                break;
            }
            if (found_key_for_errormessage == null) {
                this.logger.info("Failed to find language key for errormessage: " + errorStr);
                return null;
            }
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("error_key", found_key_for_errormessage);
            if (!errorProperties.isEmpty()) {
                errorMap.put("error_properties", errorProperties);
            }
            return errorMap;
        }
        catch (Throwable e) {
            this.logger.log(e);
            return null;
        }
    }

    protected String getErrorMsgURL(Browser br) {
        String errorMsgURL = null;
        try {
            UrlQuery query = UrlQuery.parse((String)br.getURL());
            errorMsgURL = query.get("e");
            if (errorMsgURL != null) {
                errorMsgURL = URLDecoder.decode(errorMsgURL, "UTF-8");
            }
            return errorMsgURL;
        }
        catch (Throwable ignore) {
            this.logger.log(ignore);
            return null;
        }
    }

    protected void ipBlockedOrAccountLimit(DownloadLink link, Account account, String errorMsg, long waitMillis) throws PluginException {
        if (account != null) {
            throw new AccountUnavailableException(errorMsg, waitMillis);
        }
        throw new PluginException(16, errorMsg, waitMillis);
    }

    private long parseWaittime(String src) {
        String wait_hours = new Regex(src, "(?i)(\\d+)\\s*?hours?").getMatch(0);
        String wait_minutes = new Regex(src, "(?i)(\\d+)\\s*?minutes?").getMatch(0);
        String wait_seconds = new Regex(src, "(?i)(\\d+)\\s*?(?:seconds?|segundos)").getMatch(0);
        int minutes = 0;
        int seconds = 0;
        int hours = 0;
        if (wait_hours != null) {
            hours = Integer.parseInt(wait_hours);
        }
        if (wait_minutes != null) {
            minutes = Integer.parseInt(wait_minutes);
        }
        if (wait_seconds != null) {
            seconds = Integer.parseInt(wait_seconds);
        }
        boolean extraWaittimeSeconds = true;
        int waitmillis = (3600 * hours + 60 * minutes + seconds + 1) * 1000;
        if (waitmillis <= 0) {
            this.logger.info("Waittime RegExes seem to be broken or given String does not contain any waittime");
        }
        return waitmillis;
    }

    public void checkErrors(Browser br, DownloadLink link, Account account) throws PluginException {
        String errorMsgURL = this.getErrorMsgURL(br);
        if (!StringUtils.isEmpty((String)errorMsgURL)) {
            this.logger.info("Found errormessage in current URL: " + errorMsgURL);
            Map<String, Object> errorMap = this.getErrorKeyFromErrorMessage(errorMsgURL);
            if (errorMap != null) {
                String errorkey = (String)errorMap.get("error_key");
                this.logger.info("Found key to errormessage: " + errorkey);
                Map errorProperties = null;
                if (errorMap.containsKey("error_properties")) {
                    errorProperties = (Map)errorMap.get("error_properties");
                    Iterator dynVarsIterator = errorProperties.entrySet().iterator();
                    int counter = 0;
                    while (dynVarsIterator.hasNext()) {
                        Map.Entry entry = dynVarsIterator.next();
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        this.logger.info("Found ErrorProperty " + ++counter + " | " + key + " : " + value);
                    }
                }
                long default_waittime = 900000L;
                if (errorkey.equalsIgnoreCase("error_file_has_been_removed_by_admin") || errorkey.equalsIgnoreCase("error_file_has_been_removed_by_user") || errorkey.equalsIgnoreCase("error_file_has_been_removed_due_to_copyright") || errorkey.equalsIgnoreCase("error_file_has_expired")) {
                    throw new PluginException(32, errorMsgURL);
                }
                if (errorkey.equalsIgnoreCase(error_you_must_register_for_a_premium_account_for_filesize)) {
                    throw new AccountRequiredException(errorMsgURL);
                }
                if (errorkey.equalsIgnoreCase(error_you_must_be_a_x_user_to_download_this_file)) {
                    throw new AccountRequiredException(errorMsgURL);
                }
                if (errorkey.equalsIgnoreCase(error_file_is_not_publicly_shared)) {
                    this.logger.info("This file can only be downloaded by the initial uploader");
                    throw new AccountRequiredException(errorMsgURL);
                }
                if (errorkey.equalsIgnoreCase(error_you_have_reached_the_download_limit)) {
                    this.ipBlockedOrAccountLimit(link, account, errorMsgURL, 900000L);
                } else {
                    if (errorkey.equalsIgnoreCase(error_you_have_reached_the_download_limit_this_file)) {
                        throw new PluginException(2048, errorMsgURL, 900000L);
                    }
                    if (errorkey.equalsIgnoreCase(error_you_have_reached_the_maximum_daily_download_limit)) {
                        this.ipBlockedOrAccountLimit(link, account, errorMsgURL, 900000L);
                    } else if (errorkey.equalsIgnoreCase(error_you_have_reached_the_maximum_band_width_per_day_in_the_last_24_hours)) {
                        this.ipBlockedOrAccountLimit(link, account, errorMsgURL, 900000L);
                    } else {
                        if (errorkey.equalsIgnoreCase(error_you_have_reached_the_maximum_daily_download_limit_this_file)) {
                            throw new PluginException(2048, errorMsgURL, 900000L);
                        }
                        if (errorkey.equalsIgnoreCase(error_you_have_reached_the_maximum_permitted_downloads_in_the_last_24_hours)) {
                            this.ipBlockedOrAccountLimit(link, account, errorMsgURL, 900000L);
                        } else {
                            if (errorkey.equalsIgnoreCase(error_you_have_reached_the_max_permitted_downloads)) {
                                throw new PluginException(4096, errorMsgURL, 300000L);
                            }
                            if (errorkey.equalsIgnoreCase(error_you_must_wait_between_downloads)) {
                                String waitStr = (String)errorProperties.get("WAITING_TIME_LABEL");
                                long waittime = this.parseWaittime(waitStr);
                                if (waittime <= 0L) {
                                    waittime = 900000L;
                                }
                                if (waittime < 180000L) {
                                    throw new PluginException(4096, errorMsgURL, waittime);
                                }
                                this.ipBlockedOrAccountLimit(link, account, errorMsgURL, waittime);
                            } else {
                                this.logger.warning("Unknown errorkey: " + errorkey + " --> Checking errormessage py URL parameter");
                            }
                        }
                    }
                }
            }
            this.logger.info("Trying to identify errormessage by error parameter from URL");
            if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"You have reached the maximum concurrent downloads")) {
                throw new PluginException(4096, "Max. simultan downloads limit reached, wait to start more downloads", 60000L);
            }
            if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"Could not open file for reading")) {
                throw new PluginException(2048, "Server error 'Could not open file for reading'", 3600000L);
            }
            if (new Regex(errorMsgURL, "(?i).*File is not publicly available.*").patternFind()) {
                throw new AccountRequiredException(errorMsgURL);
            }
            if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"You have reached the maximum permitted downloads in")) {
                this.ipBlockedOrAccountLimit(link, account, errorMsgURL, 1800000L);
            } else if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"You have reached the maximum permitted download filesize")) {
                this.ipBlockedOrAccountLimit(link, account, errorMsgURL, 1800000L);
            } else {
                if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"File not found") || StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"File has been removed") || StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"Archivo se ha eliminado")) {
                    throw new PluginException(32);
                }
                if (errorMsgURL.matches("(?i).*(You must wait |Voc\u00ea deve esperar).*")) {
                    long extraWaittimeMilliseconds = 1000L;
                    long waittime = this.parseWaittime(errorMsgURL);
                    if (waittime <= 0L) {
                        this.logger.info("Waittime RegExes seem to be broken - using default waittime");
                    }
                    this.logger.info("Detected reconnect waittime (milliseconds): " + (waittime += 1000L));
                    if (waittime < 180000L) {
                        throw new PluginException(4096, "Wait until new downloads can be started", waittime);
                    }
                    this.ipBlockedOrAccountLimit(link, account, errorMsgURL, waittime);
                }
            }
            if (new Regex(errorMsgURL, "(?i).*Ten plik jest za du\u017cy do pobrania dla darmowego u\u017cytkownika.*").patternFind()) {
                throw new AccountRequiredException(errorMsgURL);
            }
            if (new Regex(errorMsgURL, "(?i).*Aby pobiera\u0107 pliki tego rozmiaru, musisz zarejestrowa\u0107 konto w naszym serwisie.*").patternFind()) {
                throw new AccountRequiredException(errorMsgURL);
            }
            if (new Regex(errorMsgURL, "(?i).*Osi\u0105gni\u0119to maksymaln\u0105 liczb\u0119 jednoczesnych pobra\u0144.*").patternFind()) {
                throw new PluginException(4096, errorMsgURL, 180000L);
            }
            if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"Plik nie jest publicznie")) {
                throw new PluginException(32, errorMsgURL);
            }
            if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"Nie znaleziono pliku")) {
                throw new PluginException(32, errorMsgURL);
            }
            if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"Plik zosta\u0142 usuni\u0119ty z powodu braku aktywno\u015bci")) {
                throw new PluginException(32, errorMsgURL);
            }
            if (StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"Dosya bulunamad\u0131") || StringUtils.containsIgnoreCase((String)errorMsgURL, (String)"Dosya kald\u0131r\u0131ld\u0131")) {
                throw new PluginException(32, errorMsgURL);
            }
            this.logger.info("Found unidentified errormessage inside URL: " + errorMsgURL);
            this.logger.info("checkErrorsURL did not do anything --> Throwing Exception ERROR_TEMPORARILY_UNAVAILABLE because of errorMsgURL: " + errorMsgURL);
            long waitMillis = 300000L;
            if (link == null) {
                throw new AccountUnavailableException(errorMsgURL, 300000L);
            }
            throw new PluginException(2048, errorMsgURL, 300000L);
        }
        if (br.getURL().matches("(?i)https?://[^/]+/register(\\.html)?\\?f=.+")) {
            throw new AccountRequiredException();
        }
        if (br.containsHTML("Error: Too many concurrent download requests")) {
            throw new PluginException(4096, "Wait before starting new downloads", 180000L);
        }
        if (br.containsHTML(">\\s*File is not publicly available")) {
            throw new PluginException(32);
        }
        if (br.getRequest().getHtmlCode().equalsIgnoreCase("unknown user")) {
            throw new PluginException(2048, "Server error 'Unknown user'", 1800000L);
        }
        if (br.getRequest().getHtmlCode().equalsIgnoreCase("ERROR: Wrong IP")) {
            throw new PluginException(2048, "Server error 'Wrong IP'", 300000L);
        }
        Regex waitBetweenDownloads = br.getRegex("(?i)>\\s*You must wait (\\d+) minutes? ((\\d+) (segundos|seconds))?[^<]*between downloads");
        if (waitBetweenDownloads.patternFind()) {
            long waitMillis = this.parseWaittime(waitBetweenDownloads.getMatch(-1));
            this.ipBlockedOrAccountLimit(link, account, "Wait between downloads", waitMillis);
        }
    }

    protected void loggedInOrException(Browser br, Account account) throws PluginException {
        if (account == null) {
            throw new PluginException(0x400000);
        }
        if (br.getHttpConnection().getResponseCode() == 200 && br.containsHTML("<html[^>]*>")) {
            if (!this.isLoggedin(br, account)) {
                throw new AccountUnavailableException("Session expired?", 300000L);
            }
            return;
        }
        this.logger.info("Cannot determine loggedIN state");
    }

    protected void checkErrorsLastResort(Browser br, DownloadLink link, Account account) throws PluginException {
        this.logger.info("Last resort errorhandling");
        String rcID = br.getRegex("recaptcha/api/noscript\\?k=([^<>\"]*?)\"").getMatch(0);
        if (account != null) {
            this.loggedInOrException(br, account);
        } else {
            if (new Regex(br.getURL(), "(?i)^https?://[^/]+/?$").matches()) {
                throw new AccountRequiredException();
            }
            if (rcID != null) {
                throw new PluginException(131072, "Website uses reCaptchaV1 which has been shut down by Google. Contact website owner!");
            }
        }
        this.logger.warning("Unknown error happened");
        throw new PluginException(0x400000);
    }

    protected void checkResponseCodeErrors(URLConnectionAdapter con) throws PluginException {
        if (con == null) {
            return;
        }
        long responsecode = con.getResponseCode();
        if (responsecode == 403L) {
            throw new PluginException(2048, "Server error 403", 300000L);
        }
        if (responsecode == 404L) {
            throw new PluginException(2048, "Server error 404", 300000L);
        }
        if (responsecode == 416L) {
            throw new PluginException(2048, "Server error 416", 120000L);
        }
        if (responsecode == 429L) {
            this.exception429TooManyConnections();
        } else if (responsecode == 503L) {
            throw new PluginException(2048, "Server error 503 too many connections", 60000L);
        }
    }

    private void exception429TooManyConnections() throws PluginException {
        throw new PluginException(4096, "Server error 429 too many requests", 300000L);
    }

    protected boolean isOfflineWebsite(Browser br, DownloadLink link) throws Exception {
        boolean isDownloadableOldWebsiteOrFreeMode = this.getContinueLink(br) != null;
        boolean isDownloadableNewWebsite = this.getStoredInternalFileID(link) != null || this.regexInternalFileID(br) != null;
        boolean isDownloadable = isDownloadableOldWebsiteOrFreeMode || isDownloadableNewWebsite;
        boolean isFileWebsite = br.containsHTML("class=\"downloadPageTable(V2)?\"") || br.containsHTML("class=\"download\\-timer\"");
        boolean isErrorPage = br.getURL().contains("/error.html") || br.getURL().contains("/index.html");
        boolean isOffline404 = br.getHttpConnection().getResponseCode() == 404;
        Form pwform = this.getPasswordProtectedForm(br);
        if (pwform != null) {
            return false;
        }
        return (!isFileWebsite || isErrorPage || isOffline404) && !isDownloadable;
    }

    public String regexWaittime(Browser br) {
        String waitSecondsStr = br.getRegex("\\$\\(\\'\\.download\\-timer\\-seconds\\'\\)\\.html\\((\\d+)\\);").getMatch(0);
        if (waitSecondsStr == null) {
            waitSecondsStr = br.getRegex("var\\s*?seconds\\s*=\\s*(\\d+);").getMatch(0);
        }
        return waitSecondsStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String checkDirectLink(DownloadLink link, Account account) throws Exception {
        String directlinkproperty = YetiShareCore.getDownloadModeDirectlinkProperty(account);
        String dllink = link.getStringProperty(directlinkproperty);
        if (dllink == null) {
            return null;
        }
        Browser br2 = this.br.cloneBrowser();
        br2.setFollowRedirects(true);
        boolean valid = false;
        boolean throwException = false;
        try {
            this.dl = BrowserAdapter.openDownload(br2, link, dllink, this.isResumeable(link, account), this.getMaxChunks(account));
            if (br2.getHttpConnection().getResponseCode() == 429) {
                this.logger.info("Stored directurl lead to 429 | too many connections");
                try {
                    this.dl.getConnection().disconnect();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throwException = true;
                this.exception429TooManyConnections();
                String string = null;
                return string;
            }
            if (this.looksLikeDownloadableContent(this.dl.getConnection())) {
                valid = true;
                String string = dllink;
                return string;
            }
            try {
                link.removeProperty(directlinkproperty);
                br2.followConnection(true);
                throw new IOException();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                if (throwException) {
                    throw e;
                }
                this.logger.log((Throwable)e);
                String string = null;
                return string;
            }
        }
        finally {
            if (!valid) {
                try {
                    this.dl.getConnection().disconnect();
                }
                catch (Throwable throwable) {}
                this.dl = null;
            }
        }
    }

    protected String getProtocol(String url) {
        if (StringUtils.startsWithCaseInsensitive((String)url, (String)"https://") && this.allowGetProtocolHttpsAutoHandling(url)) {
            return "https://";
        }
        if (this.supports_https()) {
            return "https://";
        }
        return "http://";
    }

    protected boolean allowGetProtocolHttpsAutoHandling(String url) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Browser prepBrowserWebsite(Browser br) {
        br.setAllowedResponseCodes(new int[]{416, 429});
        if (this.enableRandomUserAgent()) {
            String ua = null;
            Map<String, String> map = agent;
            synchronized (map) {
                ua = agent.get(this.getHost());
                if (ua == null) {
                    ua = UserAgents.stringUserAgent();
                    agent.put(this.getHost(), ua);
                }
            }
            br.getHeaders().put("User-Agent", ua);
        }
        return br;
    }

    protected String getAccountNameSpaceLogin(Account account) throws PluginException {
        if (account == null) {
            throw new PluginException(0x400000);
        }
        if (this.isNewYetiShareVersion(account)) {
            return "/account/login";
        }
        return "/login.html";
    }

    protected String getAccountNameSpaceHome(Account account) throws PluginException {
        if (account == null) {
            throw new PluginException(0x400000);
        }
        if (this.isNewYetiShareVersion(account)) {
            return "/account";
        }
        return "/account_home.html";
    }

    protected String getAccountNameSpaceUpgrade(Account account) throws PluginException {
        if (account == null) {
            throw new PluginException(0x400000);
        }
        if (this.isNewYetiShareVersion(account)) {
            return "/upgrade";
        }
        return "/upgrade.html";
    }

    protected String getAccountNameSpaceEditAccount(Account account) throws PluginException {
        if (account == null) {
            throw new PluginException(0x400000);
        }
        if (this.isNewYetiShareVersion(account)) {
            return "/account/edit";
        }
        return "/account_edit.html";
    }

    protected String getAccountNameSpaceLogout(Account account) throws PluginException {
        if (account == null) {
            throw new PluginException(0x400000);
        }
        if (this.isNewYetiShareVersion(account)) {
            return "/account/logout";
        }
        return "/logout.html";
    }

    protected boolean isNewYetiShareVersion(Account account) {
        if (account != null) {
            return account.getBooleanProperty(PROPERTY_IS_NEW_YETISHARE_VERSION, false);
        }
        return this.getPluginConfig().getBooleanProperty(PROPERTY_IS_NEW_YETISHARE_VERSION, false);
    }

    protected void parseAndSetYetiShareVersion(Browser br, Account account) {
        if (br.containsHTML("https?://[^/]+/(account|register|account/login|account/logout)\"")) {
            this.getPluginConfig().setProperty(PROPERTY_IS_NEW_YETISHARE_VERSION, true);
            if (account != null) {
                account.setProperty(PROPERTY_IS_NEW_YETISHARE_VERSION, true);
            }
        } else {
            this.getPluginConfig().removeProperty(PROPERTY_IS_NEW_YETISHARE_VERSION);
            if (account != null) {
                account.removeProperty(PROPERTY_IS_NEW_YETISHARE_VERSION);
            }
        }
    }

    protected void fillWebsiteLoginForm(Browser br, Form loginform, Account account) {
        String passwordFieldName;
        String userFieldName;
        int n;
        String[] userFieldNames;
        String user = Encoding.urlEncode((String)account.getUser());
        InputField userField = null;
        String[] stringArray = userFieldNames = new String[]{"username", "loginUsername", "email"};
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (userField = loginform.getInputFieldByName(userFieldName = stringArray[n])) == null; ++n) {
        }
        if (userField != null) {
            userField.setValue(user);
        } else {
            loginform.put(userFieldNames[0], user);
        }
        String password = Encoding.urlEncode((String)account.getPass());
        InputField passwordField = null;
        String[] passwordFieldNames = new String[]{"password", "loginPassword"};
        stringArray = passwordFieldNames;
        n2 = stringArray.length;
        for (n = 0; n < n2 && (passwordField = loginform.getInputFieldByName(passwordFieldName = stringArray[n])) == null; ++n) {
        }
        if (passwordField != null) {
            passwordField.setValue(password);
        } else {
            loginform.put(passwordFieldNames[0], password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginWebsite(Account account, boolean force) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            this.br.setCookiesExclusive(true);
            this.prepBrowser(this.br, account.getHoster());
            this.br.setFollowRedirects(true);
            Cookies cookies = account.loadCookies("");
            Cookies userCookies = account.loadUserCookies();
            if (userCookies != null) {
                this.br.setCookies(this.getHost(), userCookies);
                if (!force) {
                    return false;
                }
                if (this.verifyCookies(this.br, account, userCookies)) {
                    return true;
                }
                if (account.hasEverBeenValid()) {
                    throw new AccountInvalidException(_GUI.T.accountdialog_check_cookies_expired());
                }
                throw new AccountInvalidException(_GUI.T.accountdialog_check_cookies_invalid());
            }
            if (cookies != null) {
                this.br.setCookies(this.getHost(), cookies);
                if (!force) {
                    return false;
                }
                if (this.verifyCookies(this.br, account, cookies)) {
                    account.saveCookies(this.br.getCookies(this.br.getHost()), "");
                    return true;
                }
                this.br.clearCookies(null);
                account.clearCookies("");
            }
            this.logger.info("Performing full login");
            this.getPage(this.getProtocol(null) + this.getHost());
            this.parseAndSetYetiShareVersion(this.br, account);
            this.getPage(this.getAccountNameSpaceLogin(account));
            if (this.br.containsHTML("flow-login\\.js") && !this.enforce_old_login_method()) {
                String loginstart = new Regex(this.br.getURL(), "(https?://(www\\.)?)").getMatch(0);
                this.logger.info("Using new login method");
                this.br.getHeaders().put("X-Requested-With", "XMLHttpRequest");
                this.br.getHeaders().put("Accept", "application/json, text/javascript, */*; q=0.01");
                Form loginform = this.br.getFormbyProperty("id", "form_login");
                if (loginform == null) {
                    this.logger.info("Fallback to custom built loginform");
                    loginform = new Form();
                    loginform.put("submitme", "1");
                }
                this.fillWebsiteLoginForm(this.br, loginform, account);
                String action = loginstart + this.getHost() + "/ajax/_account_login.ajax.php";
                loginform.setAction(action);
                if (CaptchaHelperHostPluginRecaptchaV2.containsRecaptchaV2Class(loginform)) {
                    String recaptchaV2Response = new CaptchaHelperHostPluginRecaptchaV2(this, this.br).getToken();
                    loginform.put("g-recaptcha-response", Encoding.urlEncode((String)recaptchaV2Response));
                }
                this.submitForm(loginform);
                Map entries = (Map)this.restoreFromString(this.br.getRequest().getHtmlCode(), TypeRef.MAP);
                if (!entries.get("login_status").toString().equalsIgnoreCase("success")) {
                    throw new AccountInvalidException(entries.get("error").toString());
                }
            } else {
                this.logger.info("Using non-ajax login method");
                Form loginform = this.br.getFormbyProperty("id", "form_login");
                if (loginform == null) {
                    loginform = this.br.getFormbyKey("loginUsername");
                }
                if (loginform == null) {
                    this.logger.info("Fallback to custom built loginform");
                    loginform = new Form();
                    loginform.setMethod(Form.MethodType.POST);
                    loginform.put("submit", "Login");
                    loginform.put("submitme", "1");
                }
                this.fillWebsiteLoginForm(this.br, loginform, account);
                if (CaptchaHelperHostPluginRecaptchaV2.containsRecaptchaV2Class(loginform)) {
                    String recaptchaV2Response = new CaptchaHelperHostPluginRecaptchaV2(this, this.br).getToken();
                    loginform.put("g-recaptcha-response", Encoding.urlEncode((String)recaptchaV2Response));
                }
                this.submitForm(loginform);
                if (this.br.containsHTML(">\\s*Your username and password are invalid\\s*<") || !this.isLoggedin(this.br, account)) {
                    throw new AccountInvalidException();
                }
            }
            account.saveCookies(this.br.getCookies(this.br.getHost()), "");
            return true;
        }
    }

    protected boolean verifyCookies(Browser br, Account account, Cookies cookies) throws Exception {
        br.setCookies(this.getHost(), cookies);
        this.getPage(br, this.getProtocol(br.getURL()) + this.getHost());
        this.parseAndSetYetiShareVersion(br, account);
        this.getPage(br, this.getMainPage(br.getURL()) + this.getAccountNameSpaceUpgrade(account));
        if (this.isLoggedin(br, account)) {
            if (this.isPremiumAccount(account, br)) {
                this.setAccountLimitsByType(account, Account.AccountType.PREMIUM);
            } else {
                this.setAccountLimitsByType(account, Account.AccountType.FREE);
            }
            this.logger.info("Successfully logged in via cookies:" + (Object)((Object)account.getType()));
            return true;
        }
        this.logger.info("Failed to login via cookies");
        br.clearCookies(br.getHost());
        return false;
    }

    public boolean isLoggedin(Browser br, Account account) throws PluginException {
        if (br.containsHTML(Pattern.quote(this.getAccountNameSpaceLogout(account)) + "\"")) {
            return true;
        }
        return br.containsHTML(Pattern.quote(this.getAccountNameSpaceHome(account)) + "\"");
    }

    @Override
    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        if (this.enableAPIOnlyMode()) {
            return this.fetchAccountInfoAPI(this.br, account, account.getUser(), account.getPass());
        }
        return this.fetchAccountInfoWebsite(account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccountInfo fetchAccountInfoWebsite(Account account) throws Exception {
        AccountInfo ai = new AccountInfo();
        Account account2 = account;
        synchronized (account2) {
            this.loginWebsite(account, true);
            AccountInfo apiAccInfo = this.fetchAccountInfoWebsiteAPI(this.br.cloneBrowser(), account);
            if (apiAccInfo != null) {
                this.logger.info("Found AccountInfo via API --> Prefer this over account information from website");
                return apiAccInfo;
            }
            this.getPage(this.getAccountNameSpaceUpgrade(account));
            if (this.isPremiumAccount(account, this.br)) {
                String expireStr = this.regexExpireDate(this.br);
                if (expireStr != null) {
                    long expire_milliseconds = this.parseExpireTimeStamp(account, expireStr);
                    ai.setValidUntil(expire_milliseconds, this.br);
                }
                this.setAccountLimitsByType(account, Account.AccountType.PREMIUM);
            } else {
                this.setAccountLimitsByType(account, Account.AccountType.FREE);
            }
        }
        ai.setUnlimitedTraffic();
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            String accStatus = ai.getStatus() != null ? ai.getStatus() : account.getType().getLabel();
            if (this.isNewYetiShareVersion(account)) {
                ai.setStatus("[NewYetiShare] " + accStatus);
            } else {
                ai.setStatus("[OldYetiShare] " + accStatus);
            }
        }
        return ai;
    }

    protected boolean isPremiumAccount(Account account, Browser br) {
        boolean isPremiumType;
        String accountType = br.getRegex("(?i)>\\s*Account\\s*Type\\s*:?\\s*</[^>]*>\\s*<[^>]*>\\s*([^<]{3,})\\s*<").getMatch(0);
        if (StringUtils.isEmpty((String)accountType)) {
            accountType = br.getRegex(">\\s*Account\\s*Type\\s*</strong></td>\\s*<td>([^<]+)</td>").getMatch(0);
        }
        boolean bl = isPremiumType = StringUtils.containsIgnoreCase((String)accountType, (String)"Premium") || StringUtils.containsIgnoreCase((String)accountType, (String)"Paid User");
        if (isPremiumType) {
            return true;
        }
        String expireStr = this.regexExpireDate(br);
        return expireStr != null && this.parseExpireTimeStamp(account, expireStr) > System.currentTimeMillis();
    }

    protected String regexExpireDate(Browser br) {
        String expireStr = br.getRegex("Reverts\\s*To\\s*Free\\s*Account\\s*:\\s*</td>\\s*<td>\\s*(\\d{2}/\\d{2}/\\d{4} \\d{2}:\\d{2}:\\d{2})").getMatch(0);
        if (expireStr == null && (expireStr = br.getRegex("Reverts\\s*To\\s*Free\\s*Account\\s*:\\s*</span>\\s*<input[^>]*value\\s*=\\s*\"(\\d{2}/\\d{2}/\\d{4} \\d{2}:\\d{2}:\\d{2})").getMatch(0)) == null) {
            expireStr = br.getRegex(">\\s*(\\d{2}/\\d{2}/\\d{4} \\d{2}:\\d{2}:\\d{2})\\s*<").getMatch(0);
        }
        return expireStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccountInfo fetchAccountInfoWebsiteAPI(Browser brc, Account account) {
        try {
            Account account2 = account;
            synchronized (account2) {
                boolean foundValidLookingAPICredentialsOnWebsite;
                this.getPage(brc, this.getAccountNameSpaceEditAccount(account));
                String key1 = null;
                String key2 = null;
                Form[] forms = brc.getForms();
                Form generateAPIKeyForm = null;
                for (Form form : forms) {
                    InputField fieldKey1 = form.getInputField("key1");
                    InputField fieldKey2 = form.getInputField("key2");
                    if (fieldKey1 == null || fieldKey2 == null) continue;
                    key1 = fieldKey1.getValue();
                    key2 = fieldKey2.getValue();
                    generateAPIKeyForm = form;
                    break;
                }
                if (this.isAPICredential(key1) && this.isAPICredential(key2)) {
                    this.logger.info("Found pre-generated API credentials on website: " + key1 + ":" + key2);
                    foundValidLookingAPICredentialsOnWebsite = true;
                } else {
                    this.logger.info("Failed to find API credentials on website");
                    foundValidLookingAPICredentialsOnWebsite = false;
                }
                boolean devForceNewApikeyCreation = false;
                if (generateAPIKeyForm != null) {
                    this.logger.info("Found generateAPIKeyForm -> Looks like " + this.getHost() + " has enabled API usage in general");
                    if (!this.allowToAttemptAPIUsageInWebsiteModeDuringAccountCheck()) {
                        this.logger.info("Not attempting to generate API keys although it looks possible because that is disabled!");
                        return null;
                    }
                    if (foundValidLookingAPICredentialsOnWebsite || !this.allowToGenerateAPIKeyInWebsiteModeDuringAccountCheck()) {
                        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                            // empty if block
                        }
                    } else {
                        String[] keysToRemove;
                        String value;
                        this.logger.info("Generating API keys");
                        key1 = this.websiteGenerateRandomAPIKey();
                        key2 = this.websiteGenerateRandomAPIKey();
                        generateAPIKeyForm.put("key1", key1);
                        generateAPIKeyForm.put("key2", key2);
                        InputField emailAddr = generateAPIKeyForm.getInputField("emailAddress");
                        if (emailAddr != null && (value = emailAddr.getValue()) != null && Encoding.isUrlCoded((String)value)) {
                            emailAddr.setValue(URLEncode.decodeURIComponent((String)value));
                        }
                        for (String fieldKeyToRemove : keysToRemove = new String[]{"marketingEmails", "privateFileStatistics", "isPublic", "title", "password", "passwordConfirm", "fileReferrerWhitelist", "watermarkPosition", "watermarkPadding"}) {
                            generateAPIKeyForm.remove(fieldKeyToRemove);
                        }
                        this.submitForm(brc, generateAPIKeyForm);
                        if (brc.containsHTML(key1) && brc.containsHTML(key2)) {
                            this.logger.info("Looks like API key creation was successful");
                        } else {
                            this.logger.warning("Looks like API key creation has failed");
                        }
                    }
                }
                if (!this.allowToAttemptAPIUsageInWebsiteModeDuringAccountCheck()) {
                    if (foundValidLookingAPICredentialsOnWebsite) {
                        this.logger.info("Not using found API credentials because API usage in website mode during account check has been disabled by developer");
                    }
                    return null;
                }
                this.logger.info("Checking API login credentials | Trying API accountcheck...");
                try {
                    AccountInfo apiAccInfo = this.fetchAccountInfoAPI(brc, account, key1, key2);
                    this.logger.info("Successfully performed accountcheck via API using credentials " + key1 + ":" + key2);
                    account.setProperty(PROPERTY_API_KEY1, key1);
                    account.setProperty(PROPERTY_API_KEY2, key2);
                    return apiAccInfo;
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    this.logger.info("API handling inside website handling failed! In most of all cases this means that the website owner only enabled API usage for specific users and only for uploading files.");
                    this.logger.info("@@Developer: Consider disabling API usage in website mode completely via TODO");
                    if (!foundValidLookingAPICredentialsOnWebsite) {
                        this.logger.info("@@Developer: Consider disabling website API key generation for this website via allowToGenerateAPIKeyInWebsiteMode");
                    }
                }
            }
        }
        catch (Exception ignore) {
            this.logger.log((Throwable)ignore);
        }
        account.removeProperty(PROPERTY_API_KEY1);
        account.removeProperty(PROPERTY_API_KEY2);
        return null;
    }

    private String websiteGenerateRandomAPIKey() {
        String possibleChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            sb.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".charAt(new Random().nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".length() - 1)));
        }
        return sb.toString();
    }

    protected void setAccountLimitsByType(Account account, Account.AccountType type) {
        account.setType(type);
        switch (type) {
            case PREMIUM: {
                account.setConcurrentUsePossible(true);
                account.setMaxSimultanDownloads(this.getMaxSimultanPremiumDownloadNum());
                break;
            }
            case FREE: {
                account.setConcurrentUsePossible(false);
                account.setMaxSimultanDownloads(this.getMaxSimultaneousFreeAccountDownloads());
                break;
            }
            default: {
                account.setConcurrentUsePossible(false);
                account.setMaxSimultanDownloads(1);
            }
        }
    }

    protected long parseExpireTimeStamp(Account account, String expireString) {
        if (expireString == null) {
            return -1L;
        }
        String first = new Regex(expireString, "^(\\d+)/").getMatch(0);
        String second = new Regex(expireString, "^\\d+/(\\d+)").getMatch(0);
        int firstNumber = Integer.parseInt(first);
        int secondNumber = Integer.parseInt(second);
        long timestamp_daysfirst = 0L;
        long timestamp_dayssecond = 0L;
        if (secondNumber <= 12) {
            timestamp_daysfirst = TimeFormatter.getMilliSeconds((String)expireString, (String)"dd/MM/yyyy HH:mm:ss", (Locale)Locale.ENGLISH);
        }
        if (firstNumber <= 12) {
            timestamp_dayssecond = TimeFormatter.getMilliSeconds((String)expireString, (String)"MM/dd/yyyy HH:mm:ss", (Locale)Locale.ENGLISH);
        }
        if (timestamp_daysfirst > timestamp_dayssecond) {
            return timestamp_daysfirst;
        }
        return timestamp_dayssecond;
    }

    @Override
    public void handlePremium(DownloadLink link, Account account) throws Exception {
        if (this.enableAPIOnlyMode()) {
            this.handleDownloadAPI(link, account, account.getUser(), account.getPass());
        } else if (this.supportsAPIDownloads(link, account)) {
            this.handleDownloadAPI(link, account, account.getStringProperty(PROPERTY_API_KEY1), account.getStringProperty(PROPERTY_API_KEY2));
        } else {
            this.handleDownloadWebsite(link, account);
        }
    }

    @Override
    protected void sendRequest(Browser ibr, Request request) throws Exception {
        URL before = request.getURL();
        super.sendRequest(ibr, request);
        URL after = ibr._getURL();
        if (after != null && StringUtils.equalsIgnoreCase((String)Browser.getHost((URL)before, (boolean)false), (String)Browser.getHost((URL)after, (boolean)false))) {
            if (!StringUtils.equals((String)this.getProtocol(null), (String)(after.getProtocol() + "://"))) {
                this.logger.info("@Dev:check supports_https!before=" + before + "|after=" + after);
            }
            String beforeSub = Browser.getSubdomain((URL)before, (boolean)true);
            String afterSub = Browser.getSubdomain((URL)after, (boolean)true);
            if (beforeSub == null && StringUtils.equalsIgnoreCase((String)afterSub, (String)"www") || afterSub == null && StringUtils.equalsIgnoreCase((String)beforeSub, (String)"www")) {
                this.logger.info("@Dev:check requires_WWW!before=" + before + "|after=" + after);
            }
        }
    }

    @Deprecated
    protected String getMainPage(String url) {
        return this.getProtocol(url) + this.appendWWWIfRequired(this.getHost());
    }

    protected String getMainPage(DownloadLink link) {
        String urlHost = Browser.getHost((String)link.getPluginPatternMatcher(), (boolean)true);
        List<String> deadDomains = this.getDeadDomains();
        String domainToUse = deadDomains != null && deadDomains.contains(urlHost) ? this.getHost() : urlHost;
        String protocol = this.getProtocol(link.getPluginPatternMatcher());
        domainToUse = this.appendWWWIfRequired(domainToUse);
        return protocol + domainToUse;
    }

    protected void setWeakFilename(DownloadLink link) {
        String weak_fallback_filename = this.getFallbackFilename(link);
        if (weak_fallback_filename != null) {
            link.setName(weak_fallback_filename);
        }
    }

    @Override
    public SiteType.SiteTemplate siteTemplateType() {
        return SiteType.SiteTemplate.MFScripts_YetiShare;
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink link) {
    }

    protected boolean enableAPIOnlyMode() {
        return false;
    }

    protected boolean canUseAPI() {
        return this.findAccountWithAPICredentials() != null;
    }

    protected boolean allowToAttemptAPIUsageInWebsiteModeDuringAccountCheck() {
        return true;
    }

    protected boolean allowToGenerateAPIKeyInWebsiteModeDuringAccountCheck() {
        return true;
    }

    protected Account findAccountWithAPICredentials() {
        ArrayList<Account> accounts = AccountController.getInstance().getValidAccounts(this.getHost());
        if (accounts != null && accounts.size() > 0) {
            for (Account account : accounts) {
                if (!this.isWebsiteCrawledAPICredentialsAvailable(account)) continue;
                return account;
            }
            if (this.enableAPIOnlyMode()) {
                return accounts.get(0);
            }
        }
        return null;
    }

    protected boolean isWebsiteCrawledAPICredentialsAvailable(Account account) {
        if (account == null) {
            return false;
        }
        return account.hasProperty(PROPERTY_API_KEY1) && account.hasProperty(PROPERTY_API_KEY2);
    }

    protected boolean supportsAPIDownloads(DownloadLink link, Account account) {
        return false;
    }

    protected String getAPIBase() {
        return "https://" + this.getHost() + "/api/v2";
    }

    protected Browser prepBrowserAPI(Browser br) {
        br.getHeaders().put("User-Agent", "JDownloader");
        return br;
    }

    protected boolean isAPICredential(String str) {
        return str != null && str.matches("[A-Za-z0-9]{64}");
    }

    protected boolean supportsAPISingleAvailablecheck(DownloadLink link) {
        return false;
    }

    protected String getStoredAPIAccessToken(Account account, String key1, String key2) {
        return account.getStringProperty(PROPERTY_API_ACCESS_TOKEN + Hash.getSHA256((String)(key1 + ":" + key2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStoredAPIAccessToken(Account account) {
        Account account2 = account;
        synchronized (account2) {
            String key2;
            String key1;
            if (this.enableAPIOnlyMode()) {
                key1 = account.getUser();
                key2 = account.getPass();
            } else {
                key1 = account.getStringProperty(PROPERTY_API_KEY1);
                key2 = account.getStringProperty(PROPERTY_API_KEY2);
            }
            return this.getStoredAPIAccessToken(account, key1, key2);
        }
    }

    protected String getAPIAccountID(Account account, String key1, String key2) {
        return account.getStringProperty(PROPERTY_API_ACCOUNT_ID + Hash.getSHA256((String)(key1 + ":" + key2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAPIAccountID(Account account) {
        Account account2 = account;
        synchronized (account2) {
            String key2;
            String key1;
            if (this.enableAPIOnlyMode()) {
                key1 = account.getUser();
                key2 = account.getPass();
            } else {
                key1 = account.getStringProperty(PROPERTY_API_KEY1);
                key2 = account.getStringProperty(PROPERTY_API_KEY2);
            }
            return this.getAPIAccountID(account, key1, key2);
        }
    }

    protected AccountInfo fetchAccountInfoAPI(Browser br, Account account, String key1, String key2) throws Exception {
        long currentTime;
        Map jsonRoot;
        Map loginResp = this.loginAPI(br, account, key1, key2);
        UrlQuery query = new UrlQuery();
        query.add("access_token", this.getStoredAPIAccessToken(account, key1, key2));
        query.add("account_id", this.getAPIAccountID(account, key1, key2));
        if (br.getURL() != null && br.getURL().contains("/account/info")) {
            jsonRoot = loginResp;
        } else {
            this.getPage(br, this.getAPIBase() + "/account/info?access_token=" + this.getStoredAPIAccessToken(account, key1, key2) + "&account_id=" + this.getAPIAccountID(account, key1, key2));
            jsonRoot = (Map)this.checkErrorsAPI(br, null, account);
        }
        String server_timeStr = (String)jsonRoot.get("_datetime");
        Map data = (Map)jsonRoot.get("data");
        String datecreatedStr = (String)data.get("datecreated");
        String premiumExpireDateStr = (String)data.get("paidExpiryDate");
        long premiumExpireMilliseconds = 0L;
        if (server_timeStr != null && server_timeStr.matches("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            currentTime = TimeFormatter.getMilliSeconds((String)server_timeStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH);
        } else {
            this.logger.warning("Failed to find serverside _datetime field");
            currentTime = System.currentTimeMillis();
        }
        if (premiumExpireDateStr != null && premiumExpireDateStr.matches("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            premiumExpireMilliseconds = TimeFormatter.getMilliSeconds((String)premiumExpireDateStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH);
        }
        this.getPage(br, this.getAPIBase() + "/account/package?access_token=" + this.getStoredAPIAccessToken(account, key1, key2) + "&account_id=" + this.getAPIAccountID(account, key1, key2));
        Map packageInfoRoot = (Map)this.checkErrorsAPI(br, null, account);
        Map packageInfoData = (Map)packageInfoRoot.get("data");
        String accountType = (String)packageInfoData.get("label");
        String level_type = (String)packageInfoData.get("level_type");
        long premiumDurationMilliseconds = premiumExpireMilliseconds - currentTime;
        AccountInfo ai = new AccountInfo();
        if (premiumExpireMilliseconds > currentTime || StringUtils.equalsIgnoreCase((String)level_type, (String)"paid")) {
            account.setType(Account.AccountType.PREMIUM);
            if (premiumExpireMilliseconds > currentTime) {
                ai.setValidUntil(currentTime + premiumDurationMilliseconds);
            }
        } else {
            account.setType(Account.AccountType.FREE);
        }
        ai.setStatus(accountType);
        Object concurrent_downloadsO = packageInfoData.get("concurrent_downloads");
        if (concurrent_downloadsO != null && (concurrent_downloadsO instanceof Number || concurrent_downloadsO.toString().matches("\\d+"))) {
            int simultaneousDownloads = concurrent_downloadsO instanceof Number ? ((Number)concurrent_downloadsO).intValue() : Integer.parseInt(concurrent_downloadsO.toString());
            if (simultaneousDownloads == 0) {
                this.logger.info("Max. concurrent downloads for this account according to API: Unlimited");
                account.setMaxSimultanDownloads(-1);
            } else {
                this.logger.info("Max. concurrent downloads for this account according to API: " + simultaneousDownloads);
                account.setMaxSimultanDownloads(simultaneousDownloads);
            }
        }
        if (datecreatedStr != null && datecreatedStr.matches("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            ai.setCreateTime(TimeFormatter.getMilliSeconds((String)datecreatedStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH));
        } else {
            this.logger.warning("datecreated field invalid or not given via API");
        }
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            if (this.isNewYetiShareVersion(account)) {
                ai.setStatus("[NewYetiShare][API] " + ai.getStatus());
            } else {
                ai.setStatus("[OldYetiShare][API] " + ai.getStatus());
            }
        }
        return ai;
    }

    protected Map<String, Object> loginAPI(Browser br, Account account, String key1, String key2) throws Exception {
        String storedAccessToken = this.getStoredAPIAccessToken(account, key1, key2);
        String storedAccountID = this.getAPIAccountID(account, key1, key2);
        this.prepBrowserAPI(br);
        if (!StringUtils.isEmpty((String)storedAccessToken) && !StringUtils.isEmpty((String)storedAccountID)) {
            this.logger.info("Trying to re-use stored access_token");
            this.getPage(br, this.getAPIBase() + "/account/info?access_token=" + storedAccessToken + "&account_id=" + storedAccountID);
            try {
                String currentAccountID;
                Map jsonRoot = (Map)this.checkErrorsAPI(br, null, account);
                Map data = (Map)jsonRoot.get("data");
                String string = currentAccountID = data != null ? data.get("id").toString() : null;
                if (currentAccountID != null && StringUtils.equals((String)currentAccountID.toString(), (String)storedAccountID)) {
                    this.logger.info("Successfully re-used access_token");
                    return jsonRoot;
                }
                this.logger.info("Failed to re-use access_token");
            }
            catch (Exception ignore) {
                this.logger.log((Throwable)ignore);
                this.logger.info("Failed to re-use access_token due to Exception");
            }
        }
        this.logger.info("Performing full API login");
        if (!this.isAPICredential(key1) || !this.isAPICredential(key2)) {
            if (this.enableAPIOnlyMode()) {
                this.showAPILoginInformation(account);
            }
            throw new AccountInvalidException("Invalid API credentials");
        }
        this.postPage(br, this.getAPIBase() + "/authorize", "key1=" + Encoding.urlEncode((String)key1) + "&key2=" + Encoding.urlEncode((String)key2));
        Map authorizationResponse = (Map)this.checkErrorsAPI(br, null, account);
        Map authorizationData = (Map)authorizationResponse.get("data");
        String accessToken = authorizationData.get("access_token").toString();
        String accountIDStr = authorizationData.get("account_id").toString();
        if (StringUtils.isEmpty((String)accessToken) || StringUtils.isEmpty((String)accountIDStr) || !accountIDStr.matches("\\d+")) {
            throw new AccountInvalidException("Authorization API broken?");
        }
        account.setProperty(PROPERTY_API_ACCESS_TOKEN + Hash.getSHA256((String)(key1 + ":" + key2)), accessToken);
        account.setProperty(PROPERTY_API_ACCOUNT_ID + Hash.getSHA256((String)(key1 + ":" + key2)), accountIDStr);
        account.setProperty(API_LOGIN_HAS_BEEN_SUCCESSFUL_ONCE + Hash.getSHA256((String)(key1 + ":" + key2)), true);
        return authorizationResponse;
    }

    protected DownloadLink.AvailableStatus requestFileInformationAPI(Browser br, DownloadLink link, Account account) throws Exception {
        UrlQuery query = new UrlQuery();
        query.add("access_token", this.getStoredAPIAccessToken(account));
        query.add("account_id", this.getAPIAccountID(account));
        query.add("file_id", this.getStoredInternalFileID(link));
        this.prepBrowserAPI(br);
        this.getPage(br, this.getAPIBase() + "/file/info?" + query.toString());
        Map jsonRoot = (Map)this.checkErrorsAPI(br, link, account);
        Map data = (Map)jsonRoot.get("data");
        String filename = (String)data.get("filename");
        Number filesizeO = (Number)data.get("fileSize");
        String file_status = data.get("file_status").toString();
        String description = (String)data.get("description");
        if (!StringUtils.isEmpty((String)filename)) {
            link.setFinalFileName(filename);
        }
        if (filesizeO != null) {
            link.setVerifiedFileSize(filesizeO.longValue());
        }
        if (!StringUtils.isEmpty((String)description) && StringUtils.isEmpty((String)link.getComment())) {
            link.setComment(description);
        }
        if (!file_status.equalsIgnoreCase("active")) {
            throw new PluginException(32);
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    private Thread showAPILoginInformation(Account account) throws PluginException {
        final String host = this.getHost();
        final String editAccountURL = this.getAccountNameSpaceEditAccount(account);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String title;
                    String message = "";
                    if ("de".equalsIgnoreCase(System.getProperty("user.language"))) {
                        title = host + " - Login";
                        message = message + "Hallo liebe(r) " + host + " NutzerIn\r\n";
                        message = message + "Um deinen " + host + " Account in JDownloader verwenden zu k\u00f6nnen, musst du folgende Schritte beachten:\r\n";
                        message = message + "1. \u00d6ffne diesen Link im Browser falls das nicht automatisch geschieht und logge dich auf der Webseite ein:\r\n\t'" + editAccountURL + "'\t\r\n";
                        message = message + "2. Scrolle herunter bis du die Eingabefelder \"Key 1\" und \"Key 2\" siehst oder klicke rechts auf 'API Access'.\r\n";
                        message = message + "3. Klicke rechts in beiden Eingabefeldern auf \"Generate\".\r\n";
                        message = message + "4. Scrolle bis ans Ende der Webseite und klicke auf \"Update Account\".\r\n";
                        message = message + "5. Wechsle in JD, schlie\u00dfe diesen Dialog und \u00f6ffne erneut die Maske um einen Account f\u00fcr diesen Anbieter hinzuzuf\u00fcgen.\r\n";
                        message = message + "Gib den Wert von \"Key 1\" als Benutzername- und den Wert von \"Key 2\" als Passwort ein und best\u00e4tige deine Eingaben.\r\n";
                        message = message + "Dein Account sollte nach einigen Sekunden von JDownloader akzeptiert werden.\r\n";
                    } else {
                        title = host + " - Login";
                        message = message + "Hello dear " + host + " user\r\n";
                        message = message + "In order to use your account of this service in JDownloader, you need to follow these steps:\r\n";
                        message = message + "1. Open this URL in your browser if it is not opened automatically and login in your browser:\r\n\t'" + editAccountURL + "'\t\r\n";
                        message = message + "2. Scroll down until you see the fields \"Key 1\" and \"Key 2\" or click on the tab 'API Access' (right side).\r\n";
                        message = message + "3. For each of both fields there is a \"Generate\" button on the right side - click both of them.\r\n";
                        message = message + "4. Scroll down all the way and confirm your generated keys by clicking on \"Update Account\".\r\n";
                        message = message + "5. Now go back into JD, close this dialog and re-open the \"Add account\" dialog for this host.\r\n";
                        message = message + "Enter the values of \"Key 1\" an \"Key 2\" into the username & password fields and confirm.\r\n";
                        message = message + "Your account should be accepted in JDownloader within a few seconds.\r\n";
                    }
                    ConfirmDialog dialog = new ConfirmDialog(4, title, message);
                    dialog.setTimeout(180000);
                    if (CrossSystem.isOpenBrowserSupported() && !Application.isHeadless()) {
                        CrossSystem.openURL((String)editAccountURL);
                    }
                    ConfirmDialogInterface ret = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)dialog);
                    ret.throwCloseExceptions();
                }
                catch (Throwable e) {
                    YetiShareCore.this.getLogger().log(e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    protected void handleDownloadAPI(DownloadLink link, Account account, String apikey1, String apikey2) throws StorageException, Exception {
        String directlinkproperty = YetiShareCore.getDownloadModeDirectlinkProperty(account);
        if (this.checkDirectLink(link, account) == null) {
            this.prepBrowserAPI(this.br);
            UrlQuery query = new UrlQuery();
            query.add("access_token", this.getStoredAPIAccessToken(account, apikey1, apikey2));
            query.add("account_id", this.getAPIAccountID(account, apikey1, apikey2));
            query.add("file_id", this.getStoredInternalFileID(link));
            this.getPage(this.getAPIBase() + "/file/download?" + query.toString());
            Map jsonRoot = (Map)this.checkErrorsAPI(this.br, link, account);
            Map data = (Map)jsonRoot.get("data");
            String dllink = (String)data.get("download_url");
            if (StringUtils.isEmpty((String)dllink)) {
                throw new PluginException(2048, "Failed to find final downloadurl");
            }
            String filename = (String)data.get("filename");
            if (!StringUtils.isEmpty((String)filename)) {
                link.setFinalFileName(filename);
            }
            this.dl = BrowserAdapter.openDownload(this.br, link, dllink, this.isResumeable(link, account), this.getMaxChunks(account));
        }
        URLConnectionAdapter con = this.dl.getConnection();
        link.setProperty(directlinkproperty, con.getURL().toExternalForm());
        if (!this.looksLikeDownloadableContent(con)) {
            this.checkResponseCodeErrors(con);
            this.br.followConnection(true);
            this.checkErrors(this.br, link, account);
            throw new PluginException(2048, "Final downloadurl did not lead to downloadable content");
        }
        this.dl.startDownload();
    }

    protected Object checkErrorsAPI(Browser br, DownloadLink link, Account account) throws PluginException {
        Map entries = null;
        try {
            entries = (Map)this.restoreFromString(br.getRequest().getHtmlCode(), TypeRef.MAP);
        }
        catch (Exception e) {
            throw new AccountUnavailableException("Invalid API response (no json)", 60000L);
        }
        if (entries.containsKey("data")) {
            return entries;
        }
        Object statusO = entries.get("_status");
        if (statusO != null) {
            String status = statusO.toString();
            if (status.equalsIgnoreCase("error")) {
                String errorMsg = (String)entries.get("response");
                if (StringUtils.isEmpty((String)errorMsg)) {
                    throw new AccountUnavailableException("Unknown API error", 600000L);
                }
                if (errorMsg.equalsIgnoreCase("Could not find file based on file_id.")) {
                    throw new PluginException(32);
                }
                if (errorMsg.equalsIgnoreCase("Your account level does not have access to the file upload API. Please contact site support for more information.")) {
                    throw new AccountInvalidException("API cannot be used with this account");
                }
                this.logger.info("API returned errormessage: " + errorMsg);
                throw new AccountUnavailableException(errorMsg, 300000L);
            }
        } else {
            boolean result = true;
            String msg = null;
            try {
                result = (Boolean)entries.get("result");
                msg = (String)entries.get("message");
                if (StringUtils.isEmpty((String)msg)) {
                    msg = (String)entries.get("response");
                }
            }
            catch (Throwable e) {
                try {
                    result = (Boolean)entries.get("success");
                    msg = (String)entries.get("message");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!result) {
                if (StringUtils.isEmpty(msg)) {
                    msg = "Unknown error";
                }
                if (link != null) {
                    throw new PluginException(2048, msg);
                }
                throw new AccountUnavailableException(msg, 300000L);
            }
        }
        return entries;
    }

    @Override
    public String buildExternalDownloadURL(DownloadLink downloadLink, PluginForHost buildForThisPlugin) {
        return this.getContentURL(downloadLink);
    }
}

