/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jd.PluginWrapper;
import jd.controlling.ProgressController;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.nutils.JDHash;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.parser.html.HTMLParser;
import jd.parser.html.InputField;
import jd.plugins.CryptedLink;
import jd.plugins.DecrypterException;
import jd.plugins.DecrypterPlugin;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.components.PluginJSonUtils;
import jd.utils.JDUtilities;
import org.appwork.utils.StringUtils;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.CaptchaHelperCrawlerPluginRecaptchaV2;
import org.jdownloader.plugins.components.antiDDoSForDecrypt;
import org.jdownloader.scripting.JavaScriptEngineFactory;

@DecrypterPlugin(revision="$Revision: 50778 $", interfaceVersion=2, names={}, urls={})
public abstract class abstractSafeLinking
extends antiDDoSForDecrypt {
    protected String parameter = null;
    protected String cType = "notDetected";
    protected String uid = null;
    private Browser ajax = null;

    public abstractSafeLinking(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Override
    protected Browser prepBrowser(Browser prepBr, String host) {
        if (!this.browserPrepped.containsKey(prepBr) || this.browserPrepped.get(prepBr) != Boolean.TRUE) {
            super.prepBrowser(prepBr, host);
            prepBr.setAllowedResponseCodes(new int[]{422, 500});
            prepBr.setReadTimeout(120000);
            prepBr.setConnectTimeout(120000);
        }
        return prepBr;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ArrayList<DownloadLink> decryptIt(CryptedLink param, ProgressController progress) throws Exception {
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        this.parameter = param.toString();
        this.parameter = this.correctLink(this.parameter);
        this.uid = this.getUID(this.parameter);
        if (this.parameter.matches(this.regexLinkShort())) {
            this.getPage(this.parameter.replace("https://", "http://"));
            String newparameter = this.br.getRedirectLocation();
            if (newparameter == null) {
                this.logger.warning("Decrypter broken for link: " + this.parameter);
                throw new PluginException(0x400000);
            }
            if (!newparameter.matches(".+/(?:p|d)/[a-f0-9]{10}")) {
                ret.add(this.createDownloadlink(newparameter));
                return ret;
            }
            this.parameter = newparameter;
        }
        this.getPage(this.parameter);
        if (this.br.getHttpConnection().getResponseCode() == 404) {
            throw new PluginException(32);
        }
        if (this.parameter.matches(".*?/d/([a-f0-9]{10}|" + abstractSafeLinking.regexBase58() + ")")) {
            String link = this.br.getRedirectLocation();
            if (link != null) {
                ret.add(this.createDownloadlink(link));
            }
        } else {
            String linkss;
            String[] links;
            this.ajaxPostPageRaw("/v1/protected", PluginJSonUtils.ammendJson(null, "hash", this.uid));
            String message = PluginJSonUtils.getJsonValue(this.ajax, "message");
            if (message == null) {
                message = PluginJSonUtils.getJsonValue(this.ajax, "messsage");
            }
            if (StringUtils.containsIgnoreCase((String)message, (String)"not found") || StringUtils.containsIgnoreCase((String)message, (String)"not found")) {
                throw new PluginException(32);
            }
            String security = PluginJSonUtils.getJsonNested(this.ajax, "security");
            String useCaptcha = PluginJSonUtils.getJsonValue(security, "useCaptcha");
            String captchaType = PluginJSonUtils.getJsonValue(security, "captchaType");
            String usePassword = PluginJSonUtils.getJsonValue(security, "usePassword");
            if (!this.inValidate(security) && (PluginJSonUtils.parseBoolean(useCaptcha) || PluginJSonUtils.parseBoolean(usePassword))) {
                int tries = 4;
                block10: for (int i = 0; i < tries; ++i) {
                    String nextPost = null;
                    if (PluginJSonUtils.parseBoolean(usePassword)) {
                        String psw = null;
                        if (i <= 1) {
                            psw = param.getDecrypterPassword();
                        }
                        if ((psw == null || "".equals(psw)) && ((psw = this.getUserInput(this.parameter, param)) == null || "".equals(psw))) {
                            throw new DecrypterException(DecrypterException.PASSWORD);
                        }
                        nextPost = PluginJSonUtils.ammendJson(nextPost, "password", psw);
                        if (!PluginJSonUtils.parseBoolean(useCaptcha)) {
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "hash", this.uid);
                            this.ajaxPostPageRaw("/v1/captcha", nextPost);
                            if (this.ajax.getHttpConnection().getResponseCode() == 200) break;
                            if (this.ajax.getHttpConnection().getResponseCode() == 422) {
                                if (!"true".equalsIgnoreCase(PluginJSonUtils.getJsonValue(this.ajax, "passwordFail"))) {
                                    throw new PluginException(0x400000);
                                }
                                if (i + 1 <= tries) continue;
                                throw new DecrypterException(DecrypterException.PASSWORD);
                            }
                        }
                    }
                    if (!PluginJSonUtils.parseBoolean(useCaptcha)) continue;
                    Browser captchaBr = this.br.cloneBrowser();
                    switch (0) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            String code = new CaptchaHelperCrawlerPluginRecaptchaV2(this, this.br, "6Lf5bAITAAAAABDTzSsLdgMDY1jeK6qE6IKGxvqk").getToken();
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "answer", code);
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "challengeId", "6Lf5bAITAAAAABDTzSsLdgMDY1jeK6qE6IKGxvqk");
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "type", 1);
                            break;
                        }
                        case 2: {
                            String url = "";
                            String code = this.getCaptchaCode("", param);
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "securimage_response_field", code);
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "type", 2);
                            break;
                        }
                        case 3: {
                            String url = "";
                            String code = this.getCaptchaCode("", param);
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "3dcaptcha_response_field", code);
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "type", 3);
                            break;
                        }
                        case 4: {
                            this.getPage(captchaBr, "/includes/captcha_factory/fancycaptcha.php?hash=" + this.uid);
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "fancy-captcha", captchaBr.toString().trim());
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "type", 4);
                            break;
                        }
                        case 5: {
                            captchaBr.getHeaders().put("X-Requested-With", "XMLHttpRequest");
                            this.postPage(captchaBr, "/includes/captcha_factory/Qaptcha.jquery.php?hash=" + this.uid, "action=qaptcha");
                            if (!captchaBr.containsHTML("\"error\":false")) {
                                this.logger.warning("Decrypter broken for link: " + this.parameter + "\n");
                            }
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "iQapTcha", "");
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "type", 5);
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            this.sleep(2500L, param);
                            this.getPage(this.br.getURL());
                            continue block10;
                        }
                        case 12: {
                            String result = this.getCaptchaCode("/simplecaptcha/captcha.php", param);
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "captchatype", "Simple");
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "norobot", result);
                            nextPost = PluginJSonUtils.ammendJson(nextPost, "type", 12);
                        }
                    }
                    nextPost = PluginJSonUtils.ammendJson(nextPost, "hash", this.uid);
                    this.ajaxPostPageRaw("/v1/captcha", nextPost);
                    if (this.ajax.getHttpConnection().getResponseCode() == 200) break;
                    if (this.ajax.getHttpConnection().getResponseCode() != 422) continue;
                    if (PluginJSonUtils.parseBoolean(usePassword) && "true".equalsIgnoreCase(PluginJSonUtils.getJsonValue(this.ajax, "passwordFail"))) {
                        if (i + 1 <= tries) continue;
                        throw new DecrypterException(DecrypterException.PASSWORD);
                    }
                    if (!"true".equalsIgnoreCase(PluginJSonUtils.getJsonValue(this.ajax, "captchaFail"))) {
                        throw new PluginException(0x400000);
                    }
                    if (i + 1 <= tries) continue;
                    throw new PluginException(8);
                }
            }
            if ((links = PluginJSonUtils.getJsonResultsFromArray(linkss = PluginJSonUtils.getJsonArray(this.ajax, "links"))) != null) {
                for (String link : links) {
                    String url = PluginJSonUtils.getJsonValue(link, "url");
                    if (url == null) continue;
                    ret.add(this.createDownloadlink(url));
                }
            }
        }
        if (ret.isEmpty()) {
            this.logger.warning("Decrypter out of date for link: " + this.parameter);
            return null;
        }
        return ret;
    }

    protected final void ajaxPostPageRaw(String url, String post) throws Exception {
        this.setAjaxForPost();
        this.postPageRaw(this.ajax, url, post, true);
    }

    private void setAjaxForGet() {
        this.ajax = this.br.cloneBrowser();
        this.ajax.getHeaders().put("Accept", "application/json, text/plain, */*");
    }

    private void setAjaxForPost() {
        this.ajax = this.br.cloneBrowser();
        this.ajax.getHeaders().put("Accept", "application/json, text/plain, */*");
        this.ajax.getHeaders().put("Content-Type", "application/json;charset=UTF-8");
        this.ajax.getHeaders().put("Origin", new Regex(this.br.getURL(), "https?://[^/]+").getMatch(-1));
    }

    public ArrayList<DownloadLink> decryptIt_oldStyle(CryptedLink param, ProgressController progress) throws Exception {
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        this.parameter = this.correctLink(param.toString());
        this.uid = this.getUID(this.parameter);
        this.getPage(this.parameter);
        if (this.isOffline()) {
            throw new PluginException(32);
        }
        this.handleCaptcha_oldStyle(param);
        if (this.parameter.matches(this.regexLinkShort())) {
            String newparameter = this.br.getRedirectLocation();
            if (newparameter == null) {
                this.logger.warning("Decrypter broken for link: " + this.parameter);
                throw new PluginException(0x400000);
            }
            if (!newparameter.matches(this.regexLinkD() + "|" + this.regexLinkP())) {
                ret.add(this.createDownloadlink(newparameter));
                return ret;
            }
            this.parameter = this.correctLink(newparameter);
            this.getPage(this.parameter);
        }
        if (this.br.getRedirectLocation() != null && this.br.getRedirectLocation().matches("^.+" + this.regexSupportedDomains() + "/404$")) {
            throw new PluginException(32);
        }
        if (this.br.getHttpConnection().getResponseCode() == 404 || this.br.containsHTML("(?i)>\\s*This link does not exist")) {
            throw new PluginException(32);
        }
        this.br.setFollowRedirects(false);
        if (this.parameter.matches(this.regexLinkD())) {
            ret.add(this.decryptSingleLink(this.br));
        } else {
            ret.addAll(this.decryptMultipleLinks(param));
        }
        if (ret.isEmpty()) {
            this.logger.warning("Decrypter out of date for link: " + this.parameter);
            return null;
        }
        return ret;
    }

    protected String getUID(String parameter) {
        return new Regex(parameter, "/([A-Za-z0-9]+)$").getMatch(0);
    }

    protected boolean isOffline() {
        return this.br.getHttpConnection() != null && this.br.getHttpConnection().getResponseCode() == 404 || this.br.containsHTML(this.regexOffline());
    }

    private String regexOffline() {
        return ">404 Page/File not found<|>The page/file you've requested has been moved";
    }

    protected abstract boolean supportsHTTPS();

    protected abstract boolean enforcesHTTPS();

    @Override
    protected abstract boolean useRUA();

    protected String regexSupportedDomains() {
        return Pattern.quote(this.getHost());
    }

    protected String regexLinkShort() {
        return "https?://[^/]*" + this.getShortHost() + "/[a-zA-Z0-9]+";
    }

    protected static final String regexBase58() {
        return "[123456789abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNPQRSTUWXYZ]{7}";
    }

    protected String regexLinkBase58() {
        return "https?://[^/]*" + this.regexSupportedDomains() + "/" + abstractSafeLinking.regexBase58();
    }

    protected String getShortHost() {
        return "";
    }

    protected String regexLinkP() {
        return "https?://[^/]*" + this.regexSupportedDomains() + "/p/[a-z0-9]+";
    }

    protected String regexLinkD() {
        return "https?://[^/]*" + this.regexSupportedDomains() + "/d/[a-z0-9]+";
    }

    protected String correctLink(String string) {
        String s = string.replaceFirst("^https?://", this.enforcesHTTPS() || this.supportsHTTPS() ? "https://" : "http://");
        return s;
    }

    public int getCaptchaTypeNumber() {
        if ("solvemedia".equals(this.cType)) {
            return 1;
        }
        if ("recaptcha".equals(this.cType)) {
            return 2;
        }
        if ("basic".equals(this.cType)) {
            return 3;
        }
        if ("threeD".equals(this.cType)) {
            return 4;
        }
        if ("fancy".equals(this.cType)) {
            return 5;
        }
        if ("qaptcha".equals(this.cType)) {
            return 6;
        }
        if ("simple".equals(this.cType)) {
            return 7;
        }
        if ("dotty".equals(this.cType)) {
            return 8;
        }
        if ("cool".equals(this.cType)) {
            return 9;
        }
        if ("standard".equals(this.cType)) {
            return 10;
        }
        if ("cats".equals(this.cType)) {
            return 11;
        }
        if ("simplecaptcha".equals(this.cType)) {
            return 12;
        }
        return 0;
    }

    protected String regexCaptchaSolveMedia() {
        return "api(-secure)?\\.solvemedia\\.com/(papi)?";
    }

    protected String regexCaptchaRecaptcha() {
        return "(api\\.recaptcha\\.net|google\\.com/recaptcha/api/|class\\s*=\\s*\"g-recaptcha(?:-response)?\")";
    }

    protected String regexCaptchaBasic() {
        return "(https?://[^/]*" + this.regexSupportedDomains() + "/basiccaptcha/securimage_show[^<>\"]+)";
    }

    protected String regexCaptchaThreeD() {
        return "\"(https?://[^/]*" + this.regexSupportedDomains() + "/includes/captcha_factory/3dcaptcha/3DCaptcha\\.php)\"";
    }

    protected String regexCaptchaFancy() {
        return "id=\"captchatype\" value=\"Fancy\"";
    }

    protected String regexCaptchaQaptcha() {
        return "class=\"protected-captcha\"><div id=\"QapTcha\"";
    }

    protected String regexCaptchaSimplecaptcha() {
        return "\"(https?://[^/]*" + this.regexSupportedDomains() + "/simplecaptcha/captcha\\.php)\"";
    }

    protected String regexCaptchaCoolcaptcha() {
        return "\"(https?://[^/]*" + this.regexSupportedDomains() + "/coolcaptcha/captcha\\.php)\"";
    }

    protected String regexCaptchaCatAndDog() {
        return "\"https?://[^/]*" + this.regexSupportedDomains() + "/includes/captcha_factory/catsdogs/catdogcaptcha\\.php\\?";
    }

    protected void handleCaptcha_oldStyle(CryptedLink param) throws Exception {
        this.br.setFollowRedirects(true);
        Form preForm = this.formProtected();
        if ("Click+To+Proceed".equals(preForm.getInputFieldByType("button").getValue()) || preForm.containsHTML(">\\s*Click To Proceed\\s*</button>")) {
            this.logger.info("Found preForm");
            this.submitForm(preForm);
        } else {
            this.logger.info("No preForm available");
        }
        LinkedHashMap<String, String> captchaRegex = new LinkedHashMap<String, String>();
        captchaRegex.put("solvemedia", this.regexCaptchaSolveMedia());
        captchaRegex.put("recaptcha", this.regexCaptchaRecaptcha());
        captchaRegex.put("basic", this.regexCaptchaBasic());
        captchaRegex.put("threeD", this.regexCaptchaThreeD());
        captchaRegex.put("fancy", this.regexCaptchaFancy());
        captchaRegex.put("qaptcha", this.regexCaptchaQaptcha());
        captchaRegex.put("simplecaptcha", this.regexCaptchaSimplecaptcha());
        captchaRegex.put("cool", this.regexCaptchaCoolcaptcha());
        captchaRegex.put("cats", this.regexCaptchaCatAndDog());
        Form protectedForm = this.formProtected();
        if (protectedForm != null) {
            String psw = null;
            boolean password = false;
            this.prepareCaptchaAdress(protectedForm.getHtmlCode(), captchaRegex);
            int repeat = 5;
            int timesNoUserInput = 0;
            boolean timesNoCaptchaLimit = true;
            for (int i = 0; i < 5; ++i) {
                if (timesNoUserInput > 1) {
                    this.logger.info("Too many times no captcha with user interaction --> Stepping out of captcha loop --> Possible plugin failure");
                    break;
                }
                while (protectedForm.hasInputFieldByName("%5C")) {
                    protectedForm.remove("%5C");
                }
                password = this.formInputFieldContainsProperties(protectedForm, this.formPasswordInputProperties());
                if (password) {
                    timesNoUserInput = 0;
                    if (i <= 2 && this.isCaptchaSkipable() || i <= 1 && !this.isCaptchaSkipable()) {
                        psw = param.getDecrypterPassword();
                    }
                    if (StringUtils.isEmpty(psw) && StringUtils.isEmpty((String)(psw = this.getUserInput(this.parameter, param)))) {
                        throw new DecrypterException(DecrypterException.PASSWORD);
                    }
                    protectedForm.put("password", Encoding.urlEncode((String)psw));
                }
                Browser captchaBr = null;
                if (!"notDetected".equals(this.cType)) {
                    captchaBr = this.br.cloneBrowser();
                }
                switch (this.getCaptchaTypeNumber()) {
                    case 0: {
                        ++timesNoUserInput;
                        if (this.decryptMultipleLinks(param).size() > 0) break;
                        if (!password) {
                            throw new PluginException(0x400000);
                        }
                    }
                    case 1: {
                        boolean solvemediaNotUsedAnymore = true;
                        this.logger.info("Skippingcaptcha as it does not exist anymore --> False-positive");
                        break;
                    }
                    case 2: {
                        String recaptchaV2Response = new CaptchaHelperCrawlerPluginRecaptchaV2(this, this.br).getToken();
                        protectedForm.put("g-recaptcha-response", Encoding.urlEncode((String)recaptchaV2Response));
                        break;
                    }
                    case 3: {
                        String code = this.getCaptchaCode(this.br.getRegex(captchaRegex.get("basic")).getMatch(0), param);
                        protectedForm.put("ct_captcha", Encoding.urlEncode((String)code));
                        break;
                    }
                    case 4: {
                        String code = this.getCaptchaCode(this.br.getRegex(captchaRegex.get("threeD")).getMatch(0), param);
                        protectedForm.put("3dcaptcha_response_field", Encoding.urlEncode((String)code));
                        break;
                    }
                    case 5: {
                        captchaBr.getHeaders().put("X-Requested-With", "XMLHttpRequest");
                        String fancyCaptchaURL = "/fancycaptcha/captcha/captcha.php";
                        this.getPage(captchaBr, "/fancycaptcha/captcha/captcha.php");
                        protectedForm.put(this.getCaptchaFancyInputfieldName(), captchaBr.toString().trim());
                        break;
                    }
                    case 6: {
                        captchaBr.getHeaders().put("X-Requested-With", "XMLHttpRequest");
                        this.postPage(captchaBr, "/includes/captcha_factory/Qaptcha.jquery.php?hash=" + this.uid, "action=qaptcha");
                        if (!captchaBr.containsHTML("\"error\":false")) {
                            this.logger.warning("Decrypter broken for link: " + this.parameter + "\n");
                            this.logger.warning("Qaptcha handling broken");
                            if (password) {
                                throw new DecrypterException(DecrypterException.PASSWORD);
                            }
                        }
                        protectedForm.put("iQapTcha", "");
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        String captchaurl = this.br.getRegex(this.regexCaptchaCoolcaptcha()).getMatch(0);
                        String result = this.getCaptchaCode(captchaurl, param);
                        if (!protectedForm.hasInputFieldByName("captchatype")) {
                            protectedForm.put("captchatype", "Cool");
                        }
                        protectedForm.put("captcha_cool", Encoding.urlEncode((String)result));
                        break;
                    }
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 12: {
                        String captchaurl = this.br.getRegex(this.regexCaptchaSimplecaptcha()).getMatch(0);
                        String result = this.getCaptchaCode(captchaurl, param);
                        if (!protectedForm.hasInputFieldByName("captchatype")) {
                            protectedForm.put("captchatype", "Simple");
                        }
                        protectedForm.put("norobot", Encoding.urlEncode((String)result));
                        break;
                    }
                }
                if (captchaRegex.containsKey(this.cType) || password) {
                    timesNoUserInput = 0;
                    this.submitForm(protectedForm);
                    protectedForm = this.formProtected();
                    if (protectedForm == null) break;
                    if (i + 1 > 5) {
                        this.logger.info("Too many wrong captchas and/or passwords");
                        throw new PluginException(8);
                    }
                } else {
                    this.logger.info("Sending form without any captcha input -> Looks like neither captcha nor password is required");
                    this.submitForm(protectedForm);
                    break;
                }
                psw = null;
            }
        }
    }

    protected String getCaptchaFancyInputfieldName() {
        return "captcha";
    }

    protected boolean isCaptchaSkipable() {
        return false;
    }

    protected boolean confirmationCheck() {
        return false;
    }

    protected String[][] formPasswordInputProperties() {
        return new String[][]{{"type", "password"}, {"name", this.formPasswordInputKeyName()}};
    }

    protected String formPasswordInputKeyName() {
        return "link-password";
    }

    protected final boolean formInputFieldContainsProperties(Form form, String[][] inputProperties) {
        if (form == null || inputProperties == null) {
            return false;
        }
        for (InputField i : form.getInputFields()) {
            ArrayList<Boolean> v = new ArrayList<Boolean>(inputProperties.length);
            int d = -1;
            for (String[] fpip : inputProperties) {
                v.add(++d, null);
                if ("type".equalsIgnoreCase(fpip[0]) && fpip[1].equalsIgnoreCase(i.getElementType().type())) {
                    v.add(d, Boolean.TRUE);
                    continue;
                }
                if ("name".equalsIgnoreCase(fpip[0]) && fpip[1].equalsIgnoreCase(i.getKey())) {
                    v.add(d, Boolean.TRUE);
                    continue;
                }
                if ("value".equalsIgnoreCase(fpip[0]) && fpip[1].equalsIgnoreCase(i.getValue())) {
                    v.add(d, Boolean.TRUE);
                    continue;
                }
                String property = i.getProperty(fpip[0], null);
                if (!fpip[1].equalsIgnoreCase(property)) continue;
                v.add(d, Boolean.TRUE);
            }
            Boolean isMapAllTrue = null;
            for (int x = 0; x != inputProperties.length; ++x) {
                Boolean b = (Boolean)v.get(x);
                if (Boolean.FALSE.equals(b) || b == null) {
                    isMapAllTrue = Boolean.FALSE;
                    break;
                }
                if (!Boolean.TRUE.equals(b)) continue;
                isMapAllTrue = Boolean.TRUE;
            }
            if (!Boolean.TRUE.equals(isMapAllTrue)) continue;
            return isMapAllTrue;
        }
        return false;
    }

    protected Form formProtected() {
        Form f = this.br.getFormbyProperty("id", "protected-form");
        if (f == null) {
            f = this.br.getFormByInputFieldPropertyKeyValue("name", "frmprotect");
        }
        return f;
    }

    private void prepareCaptchaAdress(String captcha, LinkedHashMap<String, String> captchaRegex) {
        Object object;
        this.br.getRequest().setHtmlCode(captcha);
        this.cType = "notDetected";
        for (Map.Entry<String, String> entry : captchaRegex.entrySet()) {
            if (!this.br.containsHTML(entry.getValue())) continue;
            this.cType = entry.getKey();
            break;
        }
        this.logger.info("notDetected".equals(this.cType) ? "Captcha not detected." : "Detected captcha type \"" + this.cType + "\".");
        String javaScript = null;
        for (String js : this.br.getRegex("<script type=\"text/javascript\">(.*?)</script>").getColumn(0)) {
            if (!new Regex(js, captchaRegex.get(this.cType)).matches()) continue;
            javaScript = js;
        }
        if (javaScript == null) {
            return;
        }
        Object object2 = new Object();
        ScriptEngineManager manager = JavaScriptEngineFactory.getScriptEngineManager(this);
        ScriptEngine engine = manager.getEngineByName("javascript");
        try {
            engine.eval("var document = { loc : function() { var newObj = new Object(); function protocol() { return \"" + new Regex(this.br.getURL(), "https?://").getMatch(-1) + "\"; } newObj.protocol = protocol(); return newObj; }, write : function(a) { return a; }}");
            engine.eval("document.location = document.loc();");
            object = engine.eval(javaScript);
        }
        catch (Throwable e) {
            return;
        }
        String res = object != null ? object.toString() : null;
        this.br.getRequest().setHtmlCode(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<DownloadLink> loadcontainer(String format, CryptedLink param) throws IOException, PluginException {
        ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
        String containerLink = this.br.getRegex(this.regexContainer(format)).getMatch(0);
        if (containerLink == null) {
            return links;
        }
        Browser brc = this.br.cloneBrowser();
        String test = Encoding.htmlDecode((String)containerLink);
        File file = null;
        URLConnectionAdapter con = null;
        try {
            con = this.openAntiDDoSRequestConnection(brc, (Request)brc.createGetRequest(test));
            if (con.getResponseCode() == 200) {
                file = JDUtilities.getResourceFile("tmp/generalsafelinking/" + JDHash.getSHA1((String)test) + format);
                if (file == null) {
                    ArrayList<DownloadLink> arrayList = links;
                    return arrayList;
                }
                file.getParentFile().mkdirs();
                file.deleteOnExit();
                brc.downloadConnection(file, con);
                if (file != null && file.exists() && file.length() > 100L) {
                    links.addAll(this.loadContainerFile(file));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                con.disconnect();
            }
            catch (Throwable throwable) {}
            if (file.exists()) {
                file.delete();
            }
        }
        return links;
    }

    protected String regexContainer(String format) {
        return "\"(https?://[^/]*" + this.regexSupportedDomains() + "/c/[a-z0-9]+" + format + ")";
    }

    protected ArrayList<DownloadLink> decryptMultipleLinks(CryptedLink param) throws Exception {
        String[] urls;
        String plaintext;
        ArrayList<DownloadLink> decryptedLinks = new ArrayList<DownloadLink>();
        if (this.supportsContainers()) {
            decryptedLinks.addAll(this.loadcontainer(this.regexContainerDlc(), param));
            if (!decryptedLinks.isEmpty()) {
                return decryptedLinks;
            }
            decryptedLinks.addAll(this.loadcontainer(this.regexContainerRsdf(), param));
            if (!decryptedLinks.isEmpty()) {
                return decryptedLinks;
            }
            decryptedLinks.addAll(this.loadcontainer(this.regexContainerCcf(), param));
            if (!decryptedLinks.isEmpty()) {
                return decryptedLinks;
            }
        }
        if (this.br.getRedirectLocation() != null && this.br.getRedirectLocation().equals(this.parameter)) {
            this.getPage(this.parameter);
        }
        if ((plaintext = this.br.getRegex("<textarea class=\"link_textarea trurl form-control2\"(.*?)</textarea>").getMatch(0)) == null) {
            plaintext = this.br.getRegex("class=\"form_box_title\".*?</textarea>").getMatch(-1);
        }
        if (plaintext == null) {
            this.logger.info("Failed to find plaintext --> Use complete html as fallback");
            plaintext = this.br.toString();
        }
        for (String url : urls = HTMLParser.getHttpLinks(plaintext, "")) {
            String urlhost = Browser.getHost((String)url);
            if (new Regex((Object)url, this.getSupportedLinks()).matches() || urlhost.equals(this.getHost())) continue;
            decryptedLinks.add(this.createDownloadlink(url));
        }
        return decryptedLinks;
    }

    protected boolean supportsContainers() {
        return true;
    }

    protected String regexContainerCcf() {
        return "\\.ccf";
    }

    protected String regexContainerRsdf() {
        return "\\.rsdf";
    }

    protected String regexContainerDlc() {
        return "\\.dlc";
    }

    protected String regexLinks() {
        return "<div class=\"links-container result-form\">(.*?)</div>";
    }

    protected String regexSingleLinkLocation() {
        return "location=\"(https?://[^\"]+)";
    }

    protected DownloadLink decryptSingleLink(Browser br) {
        String finallink = br.getRedirectLocation();
        if (finallink == null) {
            finallink = br.getRegex(this.regexSingleLinkLocation()).getMatch(0);
        }
        if (finallink == null) {
            this.logger.warning("Sever issues? continuing...");
            this.logger.warning("Please confirm via browser, and report any bugs to JDownloader Developement Team. :" + this.parameter);
        }
        if (!this.parameter.equals(finallink)) {
            return this.createDownloadlink(finallink);
        }
        return null;
    }
}

