/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jd.PluginWrapper;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.GetRequest;
import jd.http.requests.HeadRequest;
import jd.http.requests.PostRequest;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.components.UserAgents;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.AbstractHCaptcha;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.AbstractRecaptchaV2;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.CaptchaHelperHostPluginRecaptchaV2;
import org.jdownloader.plugins.components.ConcurrentLockException;
import org.jdownloader.plugins.components.DDoSProtectionRu;
import org.jdownloader.plugins.components.RequestHistory;
import org.jdownloader.plugins.components.antiDDoSForDecrypt;
import org.jdownloader.scripting.JavaScriptEngineFactory;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

@HostPlugin(revision="$Revision: 50778 $", interfaceVersion=2, names={}, urls={})
public abstract class antiDDoSForHost
extends PluginForHost {
    private static final String cfRequiredCookies = "__cfduid|cf_clearance";
    private static final String icRequiredCookies = "visid_incap_\\d+|incap_ses_\\d+_\\d+";
    private static final String suRequiredCookies = "sucuri_cloudproxy_uuid_[a-f0-9]+";
    private static final String bfRequiredCookies = "rcksid|BLAZINGFAST-WEB-PROTECT|BlazingWebCookie|BlazingPuzzleCookie";
    protected static HashMap<String, Cookies> antiDDoSCookies = new HashMap();
    protected static Map<String, String> agent = new HashMap<String, String>();
    protected final WeakHashMap<Browser, Boolean> browserPrepped = new WeakHashMap();
    public static final String antiDDoSCookiePattern = "__cfduid|cf_clearance|visid_incap_\\d+|incap_ses_\\d+_\\d+|sucuri_cloudproxy_uuid_[a-f0-9]+|rcksid|BLAZINGFAST-WEB-PROTECT|BlazingWebCookie|BlazingPuzzleCookie";
    private int a_responseCode429 = 0;
    private int a_responseCode5xx = 0;
    private boolean a_captchaRequirement = false;
    protected final AtomicInteger antiDDosCaptcha = new AtomicInteger(0);
    private static Map<String, AtomicReference<Object>> concurrentLock = new HashMap<String, AtomicReference<Object>>();

    public antiDDoSForHost(PluginWrapper wrapper) {
        super(wrapper);
    }

    protected boolean useRUA() {
        return false;
    }

    protected UserAgents.BrowserName setBrowserName() {
        return null;
    }

    public static boolean replaceCloudFlareEmailProtection(Browser br) {
        Request request = br.getRequest();
        if (request != null) {
            String emailProtection;
            String html = request.getHtmlCode();
            while ((emailProtection = new Regex(html, "(<a\\s*href\\s*=\\s*\"/cdn-cgi/l/email-protection\".*?</a>)").getMatch(0)) != null) {
                String data_cfemail = new Regex(emailProtection, "data-cfemail\\s*=\\s*\"([a-fA-F0-9]+)\"").getMatch(0);
                int r = Integer.parseInt(data_cfemail.substring(0, 2), 16);
                String result = "";
                for (int n = 2; n < data_cfemail.length() - 1; n += 2) {
                    int i = Integer.parseInt(String.valueOf(new char[]{data_cfemail.charAt(n), data_cfemail.charAt(n + 1)}), 16) ^ r;
                    result = result + Character.toString((char)i);
                }
                html = html.replace(emailProtection, result);
            }
            if (!StringUtils.equals((String)html, (String)request.toString())) {
                request.setHtmlCode(html);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Browser prepBrowser(Browser prepBr, String host) {
        if (this.browserPrepped.containsKey(prepBr) && this.browserPrepped.get(prepBr) == Boolean.TRUE) {
            return prepBr;
        }
        prepBr.addAllowedResponseCodes(new int[]{429, 503, 504, 520, 521, 522, 523, 524, 525});
        this.loadAntiDDoSCookies(prepBr, host);
        UserAgents.BrowserName browserName = this.setBrowserName();
        if (this.useRUA()) {
            String ua = null;
            Map<String, String> map = agent;
            synchronized (map) {
                ua = agent.get(this.getHost());
                if (ua == null) {
                    ua = UserAgents.stringUserAgent(browserName);
                    agent.put(this.getHost(), ua);
                }
            }
            prepBr.getHeaders().put("User-Agent", ua);
        }
        prepBr.getHeaders().put("Accept-Language", "en-gb, en;q=0.8");
        prepBr.getHeaders().put("Accept-Charset", null);
        prepBr.getHeaders().put("Pragma", null);
        this.browserPrepped.put(prepBr, Boolean.TRUE);
        return prepBr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAntiDDoSCookies(Browser prepBr, String host) {
        HashMap<String, Cookies> hashMap = antiDDoSCookies;
        synchronized (hashMap) {
            if (!antiDDoSCookies.isEmpty()) {
                for (Map.Entry<String, Cookies> cookieEntry : antiDDoSCookies.entrySet()) {
                    String cookiesHost = cookieEntry.getKey();
                    if (cookiesHost == null || !cookiesHost.equals(host)) continue;
                    try {
                        prepBr.setCookies(cookiesHost, cookieEntry.getValue(), false);
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                }
            }
        }
    }

    protected void getPage(String page) throws Exception {
        this.getPage(this.br, page);
    }

    protected void getPage(Browser ibr, String page) throws Exception {
        if (ibr == null || page == null) {
            throw new PluginException(0x400000);
        }
        this.sendRequest(ibr, (Request)ibr.createGetRequest(page));
    }

    protected void postPage(Browser ibr, String page, String postData) throws Exception {
        if (ibr == null || page == null || postData == null) {
            throw new PluginException(0x400000);
        }
        this.sendRequest(ibr, (Request)ibr.createPostRequest(page, postData));
    }

    protected void postPage(String page, String postData) throws Exception {
        this.postPage(this.br, page, postData);
    }

    protected void postPage(Browser ibr, String page, LinkedHashMap<String, String> param) throws Exception {
        if (ibr == null || page == null || param == null) {
            throw new PluginException(0x400000);
        }
        this.sendRequest(ibr, (Request)ibr.createPostRequest(page, UrlQuery.get(param), null));
    }

    protected void postPage(String page, LinkedHashMap<String, String> param) throws Exception {
        this.postPage(this.br, page, param);
    }

    protected void postPageRaw(Browser ibr, String page, String post, String encoding) throws Exception {
        if (ibr == null || page == null || post == null) {
            throw new PluginException(0x400000);
        }
        PostRequest request = ibr.createPostRequest(page, new UrlQuery(), encoding);
        request.setPostDataString(post);
        this.sendRequest(ibr, (Request)request);
    }

    protected void postPageRaw(Browser ibr, String page, String post, boolean isJson) throws Exception {
        this.postPageRaw(ibr, page, post, isJson ? "application/json" : null);
    }

    protected void postPageRaw(String page, String post, boolean isJson) throws Exception {
        this.postPageRaw(this.br, page, post, isJson);
    }

    protected void postPageRaw(Browser ibr, String page, String post) throws Exception {
        this.postPageRaw(ibr, page, post, null);
    }

    protected void postPageRaw(String page, String post) throws Exception {
        this.postPageRaw(this.br, page, post);
    }

    protected void submitForm(Browser ibr, Form form) throws Exception {
        if (ibr == null || form == null) {
            throw new PluginException(0x400000);
        }
        this.sendRequest(ibr, ibr.createFormRequest(form));
    }

    protected void submitForm(Form form) throws Exception {
        this.submitForm(this.br, form);
    }

    protected void sendRequest(Request request) throws Exception {
        this.sendRequest(this.br, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest(Browser ibr, Request request) throws Exception {
        String host = Browser.getHost((String)request.getUrl());
        this.prepBrowser(ibr, host);
        int i = 0;
        while (true) {
            ++i;
            if (this.isLocked()) {
                Thread.sleep(this.getRandomWait());
                continue;
            }
            if (i > 1) {
                this.loadAntiDDoSCookies(ibr, host);
                request.resetConnection();
            }
            URLConnectionAdapter con = ibr.openRequestConnection(request);
            try {
                this.readConnection(con, ibr);
            }
            finally {
                con.disconnect();
            }
            RequestHistory history = RequestHistory.addToCurrentThread(ibr, request, RequestHistory.TYPE.FULL);
            try {
                this.antiDDoS(ibr);
                break;
            }
            catch (ConcurrentLockException cle) {}
            continue;
            finally {
                RequestHistory.removeFromCurrentThread(history);
                continue;
            }
            break;
        }
        this.runPostRequestTask(ibr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected URLConnectionAdapter openAntiDDoSRequestConnection(Browser ibr, Request request) throws Exception {
        RequestHistory history;
        String host = Browser.getHost((String)request.getUrl());
        this.prepBrowser(ibr, host);
        int i = 0;
        while (true) {
            ++i;
            if (this.isLocked()) {
                Thread.sleep(this.getRandomWait());
                continue;
            }
            if (i > 1) {
                this.loadAntiDDoSCookies(ibr, host);
                request.resetConnection();
            }
            history = RequestHistory.addToCurrentThread(ibr, request, RequestHistory.TYPE.OPEN);
            ibr.openRequestConnection(request);
            this.antiDDoS(ibr, request);
            break;
            {
                catch (ConcurrentLockException cle) {
                    RequestHistory.removeFromCurrentThread(history);
                    continue;
                    catch (Throwable throwable) {
                        RequestHistory.removeFromCurrentThread(history);
                        throw throwable;
                    }
                }
            }
            break;
        }
        RequestHistory.removeFromCurrentThread(history);
        return ibr.getHttpConnection();
    }

    protected void readConnection(URLConnectionAdapter con, Browser ibr) throws IOException, PluginException {
        Request request = con.getRequest() != null ? con.getRequest() : ibr.getRequest();
        if (con.getRequest() != null && con.getRequest().getHtmlCode() != null) {
            return;
        }
        if (con.getRequest() != null && !con.getRequest().isRequested()) {
            throw new PluginException(0x400000, "Request not sent yet!");
        }
        if (!con.isConnected()) {
            throw new PluginException(0x400000, "Connection is not connected!");
        }
        InputStream is = this.getInputStream(con, ibr);
        request.setReadLimit(ibr.getLoadLimit());
        byte[] responseBytes = Request.read((URLConnectionAdapter)con, (int)request.getReadLimit());
        request.setResponseBytes(responseBytes);
        LogInterface log = ibr.getLogger();
        if (log == null) {
            log = this.logger;
        }
        log.fine("\r\n" + request.getHtmlCode());
        if (request.isKeepByteArray() || ibr.isKeepResponseContentBytes()) {
            request.setKeepByteArray(true);
            request.setResponseBytes(responseBytes);
        }
    }

    protected void runPostRequestTask(Browser ibr) throws Exception {
    }

    protected InputStream getInputStream(URLConnectionAdapter con, Browser br) throws IOException {
        int responseCode = con.getResponseCode();
        switch (responseCode) {
            case 502: {
                break;
            }
            case 542: {
                break;
            }
            default: {
                con.setAllowedResponseCodes(new int[]{responseCode});
            }
        }
        return con.getInputStream();
    }

    protected final boolean hasAntiddosCaptchaRequirement() {
        return this.a_captchaRequirement;
    }

    protected final void antiDDoS(Browser ibr) throws Exception {
        this.antiDDoS(ibr, null);
    }

    @Override
    public void setHasCaptcha(DownloadLink link, Account acc, Boolean hasCaptcha) {
        if (this.antiDDosCaptcha.get() == 0) {
            super.setHasCaptcha(link, acc, hasCaptcha);
        }
    }

    @Override
    protected boolean isAccountLoginCaptchaChallenge(DownloadLink link, Challenge<?> c) {
        if (this.antiDDosCaptcha.get() == 0) {
            return super.isAccountLoginCaptchaChallenge(link, c);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void antiDDoS(Browser ibr, Request request) throws Exception {
        if (ibr == null) {
            throw new PluginException(0x400000);
        }
        Cookies cookies = new Cookies();
        if (ibr.getHttpConnection() != null) {
            Thread lockObject = Thread.currentThread();
            this.antiDDosCaptcha.incrementAndGet();
            try {
                if (this.containsCloudflareCookies(ibr)) {
                    this.processCloudflare(lockObject, ibr, request, cookies);
                } else if (this.containsIncapsulaCookies(ibr)) {
                    this.processIncapsula(lockObject, ibr, cookies);
                } else if (this.containsSucuri(ibr)) {
                    this.processSucuri(ibr, cookies);
                } else if (this.containsBlazingFast(ibr)) {
                    antiDDoSForDecrypt.processBlazingFast(this, ibr, cookies);
                } else if (this.containsDDoSProtectionRu(ibr)) {
                    this.processDDoSProtectionRu(lockObject, ibr, request, cookies);
                }
                HashMap<String, Cookies> hashMap = antiDDoSCookies;
                synchronized (hashMap) {
                    if (cookies.getCookies().size() > 0) {
                        antiDDoSCookies.put(ibr.getHost(), cookies);
                    }
                }
            }
            finally {
                this.releaseLock(lockObject);
                this.antiDDosCaptcha.decrementAndGet();
            }
        }
        ibr.checkForBlockedByAfterLoadConnection(ibr.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AtomicReference<Object> getConcurrentLock() {
        Map<String, AtomicReference<Object>> map = concurrentLock;
        synchronized (map) {
            AtomicReference<Object> lock = concurrentLock.get(this.getHost());
            if (lock == null) {
                lock = new AtomicReference<Object>(null);
                concurrentLock.put(this.getHost(), lock);
            }
            return lock;
        }
    }

    protected boolean isLocked() {
        Object lock = this.getConcurrentLock().get();
        return lock != null && Thread.currentThread() != lock;
    }

    protected boolean acquireLock(Object lockObject) {
        AtomicReference<Object> lock = this.getConcurrentLock();
        return lock.compareAndSet(null, lockObject) || Thread.currentThread() == lock.get();
    }

    protected void releaseLock(Object lockObject) {
        this.getConcurrentLock().compareAndSet(lockObject, null);
    }

    protected void followCloudflareRequest(Object lockObject, Browser br, Request request, Cookies cookies) throws IOException {
        br.followConnection(true);
    }

    protected boolean containsRecaptchaV2Class(Browser br) {
        return br != null && AbstractRecaptchaV2.containsRecaptchaV2Class(br);
    }

    protected boolean containsRecaptchaV2Class(String string) {
        return AbstractRecaptchaV2.containsRecaptchaV2Class(string);
    }

    protected boolean containsRecaptchaV2Class(Form form) {
        return form != null && AbstractRecaptchaV2.containsRecaptchaV2Class(form);
    }

    protected boolean containsHCaptcha(Browser br) {
        return br != null && AbstractHCaptcha.containsHCaptcha(br);
    }

    protected boolean containsHCaptcha(String string) {
        return AbstractHCaptcha.containsHCaptcha(string);
    }

    protected boolean containsHCaptcha(Form form) {
        return form != null && AbstractHCaptcha.containsHCaptcha(form);
    }

    private void processCloudflare(Object lockObject, Browser ibr, Request request, Cookies cookies) throws Exception {
    }

    private boolean isCloudFlareProtectionMode(int responseCode) {
        boolean result = responseCode == 403 || responseCode == 429 || responseCode == 503 || responseCode == 504 || responseCode >= 520 && responseCode <= 525;
        return result;
    }

    private String getRayID(Browser ibr) {
        String header;
        String rayID = ibr.getRegex("data-ray=\"([a-f0-9]{16})\"").getMatch(0);
        if (this.inValidate(rayID) && this.inValidate(rayID = ibr.getRegex("Cloudflare Ray ID:\\s*<strong>([a-f0-9]{16})</strong>").getMatch(0)) && (header = ibr.getRequest().getResponseHeader("CF-RAY")) != null) {
            rayID = new Regex(header, "^([a-f0-9]{16})").getMatch(0);
        }
        return rayID;
    }

    private Form getCloudflareChallengeForm(Browser ibr) {
        Form[] forms;
        for (Form form : forms = ibr.getForms()) {
            if (form.getStringProperty("id") == null || !form.getStringProperty("id").matches("challenge-form|ChallengeForm")) continue;
            return form;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processIncapsula(Object lockObject, Browser ibr, Cookies cookies) throws Exception {
        String b;
        String functionz = ibr.getRegex("function\\(\\)\\s*\\{\\s*var z\\s*=\\s*\"\";.*?\\}\\)\\(\\);").getMatch(-1);
        String[] crudeyes = ibr.toString().split("[\r\n]{1,2}");
        if (functionz != null && crudeyes != null && crudeyes.length < 15 && (b = new Regex(functionz, "var b\\s*=\\s*\"(.*?)\";").getMatch(0)) != null) {
            String z = "";
            for (int i = 0; i < b.length(); i += 2) {
                z = z + Integer.parseInt(b.substring(i, i + 2), 16) + ",";
            }
            z = z.substring(0, z.length() - 1);
            String a = "";
            for (String zz : z.split(",")) {
                int zzz = Integer.parseInt(zz);
                a = a + Character.toString((char)zzz);
            }
            String c = new Regex(a, "xhr\\.open\\(\"GET\",\"(/_Incapsula_Resource\\?.*?)\"").getMatch(0);
            if (c != null) {
                Browser ajax = ibr.cloneBrowser();
                ajax.getHeaders().put("Accept", "*/*");
                ajax.getHeaders().put("Cache-Control", null);
                ajax.getPage(c);
                if (ajax.containsHTML("window\\.location\\.reload\\(true\\);")) {
                    ibr.getPage(ibr.getURL());
                }
            }
        }
        if (crudeyes != null && crudeyes.length == 1) {
            String validateXinfo;
            String xinfo = ibr.getHttpConnection().getHeaderField("X-Iinfo");
            String azas = "<iframe[^<]*\\s+src=\"(/_Incapsula_Resource\\?(?:[^\"]+&|)xinfo=[^\"]*)\"";
            String iframe = ibr.getRegex("<iframe[^<]*\\s+src=\"(/_Incapsula_Resource\\?(?:[^\"]+&|)xinfo=[^\"]*)\"").getMatch(0);
            if (iframe != null && StringUtils.isNotEmpty((String)xinfo) && !StringUtils.equals((String)xinfo, (String)(validateXinfo = new Regex(iframe, "xinfo=(.*?)($|&)").getMatch(0))) && !StringUtils.equals((String)xinfo, (String)URLDecoder.decode(validateXinfo, "UTF-8"))) {
                iframe = null;
            }
            if (iframe != null) {
                Browser ifr = ibr.cloneBrowser();
                ifr.getPage(iframe);
                if (!this.acquireLock(lockObject)) throw new ConcurrentLockException();
                this.a_captchaRequirement = true;
                if (this.containsRecaptchaV2Class(ifr)) {
                    String recaptchaV2Response;
                    DownloadLink existingDownloadLink = this.getDownloadLink();
                    try {
                        DownloadLink dllink = new DownloadLink(this, (existingDownloadLink != null ? existingDownloadLink.getName() + " :: " : "") + "antiDDoS Provider 'Incapsula' requires Captcha", this.getHost(), "http://" + this.getHost(), true);
                        this.setDownloadLink(dllink);
                        recaptchaV2Response = new CaptchaHelperHostPluginRecaptchaV2(this, ifr).getToken();
                    }
                    finally {
                        this.setDownloadLink(existingDownloadLink);
                    }
                    ifr.postPage("/_Incapsula_Resource?SWCGHOEL=v2", "g-recaptcha-response=" + Encoding.urlEncode((String)recaptchaV2Response));
                    if (this.containsRecaptchaV2Class(ifr)) {
                        this.logger.warning("Wrong captcha");
                        throw new PluginException(8);
                    }
                    if (ifr.containsHTML(">window\\.parent\\.location\\.reload\\(true\\);<")) {
                        this.getPage(ibr.getURL());
                        this.a_captchaRequirement = false;
                        return;
                    }
                } else {
                    if (ifr.containsHTML("captcha-form")) {
                        throw new PluginException(0x400000);
                    }
                    String errorCode = ifr.getRegex("<h\\d+>\\s*Error\\s*code\\s*(\\d+)\\s*</h\\d+>").getMatch(0);
                    if (errorCode != null) {
                        int error = Integer.parseInt(errorCode);
                        switch (error) {
                            case 16: {
                                throw new PluginException(131072, "This request was blocked by the security rules");
                            }
                        }
                        throw new PluginException(131072, "ErrorCode:" + error);
                    }
                    if (!ifr.containsHTML("<p>\\s*This request was blocked by the security rules\\s*</p>")) throw new PluginException(0x400000);
                    throw new PluginException(131072, "This request was blocked by the security rules");
                }
            }
        }
        Cookies add = ibr.getCookies(ibr.getHost());
        for (Cookie c : add.getCookies()) {
            if (!new Regex(c.getKey(), icRequiredCookies).matches()) continue;
            cookies.add(c);
        }
    }

    private void processSucuri(Browser ibr, Cookies cookies) throws Exception {
        if (ibr.containsHTML("<title>You are being redirected\\.\\.\\.</title>")) {
            String base64 = ibr.getRegex("(?i-)S\\s*=\\s*'([^']+)';").getMatch(0);
            if (base64 == null) {
                throw new PluginException(0x400000);
            }
            String decode = Encoding.Base64Decode((String)base64);
            decode = decode.replace("location.reload();", "").replace("document.cookie", "y");
            Object result = new Object();
            if (base64 != null) {
                try {
                    ScriptEngineManager manager = JavaScriptEngineFactory.getScriptEngineManager(this);
                    ScriptEngine engine = manager.getEngineByName("javascript");
                    engine.eval("document = \"\";");
                    engine.eval(decode);
                    ConsString y = (ConsString)engine.get("y");
                    ibr.setCookie(ibr.getHost(), y.toString().split("=")[0], y.toString().split("=")[1]);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                ibr.getPage(ibr.getURL());
            }
        }
        Cookies add = ibr.getCookies(ibr.getHost());
        for (Cookie c : add.getCookies()) {
            if (!new Regex(c.getKey(), suRequiredCookies).matches()) continue;
            cookies.add(c);
        }
    }

    private void processDDoSProtectionRu(Object lockObject, Browser ibr, Request request, Cookies cookies) throws Exception {
        String[] jsRedirectScripts;
        if (request != null) {
            if (request instanceof HeadRequest) {
                this.openAntiDDoSRequestConnection(ibr, (Request)new GetRequest(request));
                return;
            }
            this.followCloudflareRequest(lockObject, ibr, request, cookies);
        }
        if ((jsRedirectScripts = ibr.getRegex("<script language=\"JavaScript\">(.*?)</script>").getColumn(0)) != null && jsRedirectScripts.length == 1) {
            int scriptLen;
            int jsFactor;
            int c = ibr.getRegex("\n").count();
            boolean isJsRedirect = ibr.getRegex("<html><head><meta http-equiv=\"Content-Type\" content=\"[\\w\\-/;=]{20,50}\"></head>").matches();
            if (c <= 1 && isJsRedirect && (jsFactor = Math.round((float)(scriptLen = jsRedirectScripts[0].length()) / (float)ibr.toString().length() * 100.0f)) > 75) {
                if (this.acquireLock(lockObject)) {
                    String windowLocation = DDoSProtectionRu.getWindowLocation(jsRedirectScripts[0]);
                    if (windowLocation == null) {
                        throw new PluginException(0x400000);
                    }
                    if (request != null) {
                        Request originalRequest = ibr.getRequest();
                        ibr.openGetConnection(windowLocation);
                        Thread.sleep(1250L);
                        originalRequest.resetConnection();
                        ibr.openRequestConnection(originalRequest);
                    } else {
                        Request originalRequest = ibr.getRequest();
                        ibr.getPage(windowLocation);
                        Thread.sleep(1250L);
                        originalRequest.resetConnection();
                        ibr.getPage(originalRequest);
                    }
                } else {
                    throw new ConcurrentLockException();
                }
            }
        }
    }

    protected boolean containsCloudflareCookies(Browser ibr) {
        Cookies add = ibr.getCookies(ibr.getHost());
        for (Cookie c : add.getCookies()) {
            if (!new Regex(c.getKey(), cfRequiredCookies).matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean containsIncapsulaCookies(Browser ibr) {
        Cookies add = ibr.getCookies(ibr.getHost());
        for (Cookie c : add.getCookies()) {
            if (!new Regex(c.getKey(), icRequiredCookies).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean containsSucuri(Browser ibr) {
        if (this.requestHeadersHasKeyNValueRegex(ibr, "X-Sucuri-ID", "^\\d+$")) {
            return true;
        }
        return this.requestHeadersHasKeyNValueContains(ibr, "server", "Sucuri/Cloudproxy");
    }

    protected boolean containsBlazingFast(Browser ibr) {
        boolean result = ibr.containsHTML("<title>Just a moment please\\.\\.\\.</title>") && ibr.containsHTML(">Verifying your browser, please wait\\.\\.\\.<br>DDoS Protection by</font> Blazingfast\\.io<");
        return result;
    }

    private boolean containsDDoSProtectionRu(Browser ibr) {
        try {
            String ip;
            if (StringUtils.startsWithCaseInsensitive((String)ibr.getHttpConnection().getContentType(), (String)"text/html") && new Regex(ip = ((InetSocketAddress)ibr.getRequest().getHttpConnection().getEndPointSocketAddress()).getAddress().getHostAddress(), "^195\\.211\\.22[0-3]\\.(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$").matches()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean requestHeadersHasKeyNValueStartsWith(Browser ibr, String k, String v) {
        if (k == null || v == null || ibr == null || ibr.getHttpConnection() == null) {
            return false;
        }
        return ibr.getHttpConnection().getHeaderField(k) != null && ibr.getHttpConnection().getHeaderField(k).toLowerCase(Locale.ENGLISH).startsWith(v.toLowerCase(Locale.ENGLISH));
    }

    private boolean requestHeadersHasKeyNValueContains(Browser ibr, String k, String v) {
        if (k == null || v == null || ibr == null || ibr.getHttpConnection() == null) {
            return false;
        }
        return ibr.getHttpConnection().getHeaderField(k) != null && ibr.getHttpConnection().getHeaderField(k).toLowerCase(Locale.ENGLISH).contains(v.toLowerCase(Locale.ENGLISH));
    }

    private boolean requestHeadersHasKeyNValueRegex(Browser ibr, String k, String v) {
        if (k == null || v == null || ibr == null || ibr.getHttpConnection() == null) {
            return false;
        }
        String value = ibr.getHttpConnection().getHeaderField(k);
        return value != null && new Regex(value, v).matches();
    }

    protected final HashMap<String, String> fetchCookies(String host) {
        return this.fetchCookies(this.br, host);
    }

    protected final HashMap<String, String> fetchCookies(Browser br, String host) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        Cookies add = br.getCookies(host);
        for (Cookie c : add.getCookies()) {
            if (c.getKey().matches(antiDDoSCookiePattern)) continue;
            cookies.put(c.getKey(), c.getValue());
        }
        return cookies;
    }

    protected boolean inValidate(String s) {
        return s == null || s.equals("") || s.matches("\\s+");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getStringFromCloudFlareEmailProtection(String input) {
        String a = new Regex(input, "data-cfemail\\s*=\\s*\"([a-f0-9]+)\"").getMatch(0);
        Object result = new Object();
        if (a != null) {
            Context cx = null;
            try {
                cx = ContextFactory.getGlobal().enterContext();
                ScriptableObject scope = cx.initStandardObjects();
                result = cx.evaluateString((Scriptable)scope, "var e, r, n, i, a = '" + a + "';if (a) { for (e = \"\", r = parseInt(a.substr(0, 2), 16), n = 2; a.length - n; n += 2) { i = parseInt(a.substr(n, 2), 16) ^ r; e += String.fromCharCode(i); } }", "<cmd>", 1, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                Context.exit();
            }
        }
        return result != null ? result.toString() : null;
    }

    public static final String cleanupCloudFlareEmailProtection(Browser export, String input) throws PluginException {
        String[] results;
        if (export == null && input == null) {
            throw new PluginException(0x400000, "Incorrect use of method");
        }
        if (input == null) {
            input = export.toString();
        }
        if ((results = new Regex(input, "<a(?:\\s+[^>]+)?\\s+href=\"/cdn-cgi/l/email-protection\"[^>]*>[^<]+</a>").getColumn(-1)) != null) {
            HashSet<String> dupe = new HashSet<String>();
            String messswithme = input;
            for (String result : results) {
                if (!dupe.add(result)) continue;
                messswithme = messswithme.replace(result, antiDDoSForHost.getStringFromCloudFlareEmailProtection(result));
            }
            if (export != null) {
                export.getRequest().setHtmlCode(messswithme);
            }
            return messswithme;
        }
        return input;
    }

    private long getRandomWait() {
        long wait = 0L;
        while ((wait = (long)(new Random().nextInt(150) * new Random().nextInt(100))) > 15000L && wait < 500L) {
        }
        return wait;
    }
}

