/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.archiveorg;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="archive.org", type=Type.CRAWLER)
public interface ArchiveOrgConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();
    public static final SingleFilePathNotFoundMode default_SingleFilePathNotFoundMode = SingleFilePathNotFoundMode.ADD_ALL;
    public static final SingleFileAdoptFolderStructureMode default_SingleFileAdoptFolderStructureMode = SingleFileAdoptFolderStructureMode.ENABLE;
    public static final PlaylistCrawlMode default_PlaylistCrawlMode = PlaylistCrawlMode.AUTO;

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @Order(value=10)
    public boolean isFileCrawlerCrawlOnlyOriginalVersions();

    public void setFileCrawlerCrawlOnlyOriginalVersions(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @Order(value=25)
    public boolean isFileCrawlerCrawlMetadataFiles();

    public void setFileCrawlerCrawlMetadataFiles(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Crawl thumbnails?")
    @Order(value=26)
    public boolean isFileCrawlerCrawlThumbnails();

    public void setFileCrawlerCrawlThumbnails(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=27)
    public SingleFilePathNotFoundMode getSingleFilePathNonFoundMode();

    public void setSingleFilePathNonFoundMode(SingleFilePathNotFoundMode var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=28)
    public SingleFileAdoptFolderStructureMode getSingleFileAdoptFolderStructureMode();

    public void setSingleFileAdoptFolderStructureMode(SingleFileAdoptFolderStructureMode var1);

    @AboutConfig
    @DefaultEnumValue(value="PLAYLIST_TITLE_WITH_TRACK_NUMBER")
    @Order(value=29)
    public PlaylistFilenameScheme getPlaylistFilenameScheme();

    public void setPlaylistFilenameScheme(PlaylistFilenameScheme var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=10L, step=1L)
    @DefaultIntValue(value=0)
    @Order(value=30)
    public int getBookImageQuality();

    public void setBookImageQuality(int var1);

    @AboutConfig
    @DefaultEnumValue(value="PREFER_ORIGINAL")
    @Order(value=40)
    public BookCrawlMode getBookCrawlMode();

    public void setBookCrawlMode(BookCrawlMode var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Order(value=41)
    public boolean isMarkNonViewableBookPagesAsOfflineIfNoAccountIsAvailable();

    public void setMarkNonViewableBookPagesAsOfflineIfNoAccountIsAvailable(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=50)
    @DescriptionForConfigEntry(value="Handling for audio/video playlists.")
    public PlaylistCrawlMode getPlaylistCrawlMode202404();

    public void setPlaylistCrawlMode202404(PlaylistCrawlMode var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=100000L, step=100L)
    @DefaultIntValue(value=100)
    @Order(value=60)
    public int getSearchTermCrawlerMaxResultsLimit();

    public void setSearchTermCrawlerMaxResultsLimit(int var1);

    public static enum PlaylistCrawlMode implements LabelInterface
    {
        PLAYLIST_ONLY{

            public String getLabel() {
                return "Playlist only";
            }
        }
        ,
        PLAYLIST_AND_FILES{

            public String getLabel() {
                return "Playlist and files";
            }
        }
        ,
        FILES_ONLY{

            public String getLabel() {
                return "Files only";
            }
        }
        ,
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        DEFAULT{

            public String getLabel() {
                return "Default: " + default_PlaylistCrawlMode.getLabel();
            }
        };

    }

    public static enum BookCrawlMode implements LabelInterface
    {
        PREFER_ORIGINAL{

            public String getLabel() {
                return "Original files if possible else loose book pages";
            }
        }
        ,
        ORIGINAL_AND_LOOSE_PAGES{

            public String getLabel() {
                return "Original files if possible and loose book pages";
            }
        }
        ,
        LOOSE_PAGES{

            public String getLabel() {
                return "Only loose book pages";
            }
        };

    }

    public static enum PlaylistFilenameScheme implements LabelInterface
    {
        PLAYLIST_TITLE_WITH_TRACK_NUMBER{

            public String getLabel() {
                return "Like in playlist: <TrackNumber>.<title> - <artist>.<fileExt>";
            }
        }
        ,
        ORIGINAL_FILENAME{

            public String getLabel() {
                return "Original / serverside filenames";
            }
        };

    }

    public static enum SingleFileAdoptFolderStructureMode implements LabelInterface
    {
        DEFAULT{

            public String getLabel() {
                return "Default: " + default_SingleFileAdoptFolderStructureMode.getLabel();
            }
        }
        ,
        ENABLE{

            public String getLabel() {
                return "Allow adopt folder structure";
            }
        }
        ,
        DISABLE{

            public String getLabel() {
                return "Do not allow adopt folder structure";
            }
        };

    }

    public static enum SingleFilePathNotFoundMode implements LabelInterface
    {
        ADD_ALL{

            public String getLabel() {
                return "Add all (other) items";
            }
        }
        ,
        ADD_NOTHING_AND_DISPLAY_ADDED_URL_AS_OFFLINE{

            public String getLabel() {
                return "Display added URL as offline";
            }
        }
        ,
        DEFAULT{

            public String getLabel() {
                return "Default: " + default_SingleFilePathNotFoundMode.getLabel();
            }
        };

    }

    public static class TRANSLATION {
        public String getFileCrawlerCrawlOnlyOriginalVersions_label() {
            return "File crawler: Add only original versions of files?";
        }

        public String getFileCrawlerCrawlMetadataFiles_label() {
            return "File crawler: Include metadata files (typically .xml & .sqlite files)?";
        }

        public String getFileCrawlerCrawlThumbnails_label() {
            return "File crawler: Crawl thumbnails?";
        }

        public String getSingleFilePathNonFoundMode_label() {
            return "File crawler: What to do when single file/folder-path is not found?";
        }

        public String getSingleFileAdoptFolderStructureMode_label() {
            return "File crawler: Single files: Adopt folder structure mode";
        }

        public String getPlaylistFilenameScheme_label() {
            return "Playlist filename scheme";
        }

        public String getBookImageQuality_label() {
            return "Book image quality (0 = highest, 10 = lowest)";
        }

        public String getBookCrawlMode_label() {
            return "Book crawl mode";
        }

        public String getMarkNonViewableBookPagesAsOfflineIfNoAccountIsAvailable_label() {
            return "Mark non viewable book pages as offline if no account is available?";
        }

        public String getPlaylistCrawlMode202404_label() {
            return "Audio/video playlist crawl mode";
        }

        public String getSearchTermCrawlerMaxResultsLimit_label() {
            return "Search term and profile crawler: Limit max results [0 = disable this crawler]";
        }
    }
}

