/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.TakeValueFromSubconfig;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="deviantart.com", type=Type.HOSTER)
public interface DeviantArtComConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="SKIP_FILESIZECHECK")
    @Order(value=10)
    public boolean isFastLinkcheckForSingleItems();

    public void setFastLinkcheckForSingleItems(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="SLOW_LOOK_FOR_MULTI_IMAGE_GALLERIES")
    @Order(value=20)
    @DescriptionForConfigEntry(value="Set this to fast if you already know that none of the items you add leads to a multi image gallery.")
    @DefaultOnNull
    public ArtCrawlMode getArtCrawlMode();

    public void setArtCrawlMode(ArtCrawlMode var1);

    @AboutConfig
    @DefaultEnumValue(value="OFFICIAL_DOWNLOAD_ELSE_PREVIEW")
    @Order(value=30)
    @DefaultOnNull
    public ImageDownloadMode getImageDownloadMode();

    public void setImageDownloadMode(ImageDownloadMode var1);

    public static enum ImageDownloadMode implements LabelInterface
    {
        OFFICIAL_DOWNLOAD_ELSE_PREVIEW{

            public String getLabel() {
                return "Prefer official download, download preview as fallback";
            }
        }
        ,
        OFFICIAL_DOWNLOAD_ONLY{

            public String getLabel() {
                return "Official download only (account required)";
            }
        }
        ,
        HTML{

            public String getLabel() {
                return "Download HTML of webpage instead of media";
            }
        };

    }

    public static enum ArtCrawlMode implements LabelInterface
    {
        SLOW_LOOK_FOR_MULTI_IMAGE_GALLERIES{

            public String getLabel() {
                return "Slow: Check for multi image galleries";
            }
        }
        ,
        FAST_CRAWL_IGNORE_MULTI_IMAGE_GALLERIES{

            public String getLabel() {
                return "Fast: Do not check for multi image galleries";
            }
        };

    }

    public static class TRANSLATION {
        public String getFastLinkcheckForSingleItems_label() {
            return "Fast linkcheck for single image files (filesize might not be shown until dl is started)?";
        }

        public String getDownloadMode_label() {
            return "Image download mode";
        }

        public String getArtCrawlMode_label() {
            return "Crawl mode for '/art/' links";
        }
    }
}

