/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="filecrypt.cc", type=Type.CRAWLER)
public interface FileCryptConfig
extends PluginConfigInterface {
    public static final String text_MaxCutCaptchaAvoidanceRetries = "Max number of retries used to try to avoid cutcaptcha";
    public static final String text_CrawlMode = "Crawl mode";
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultIntValue(value=0)
    @SpinnerValidator(min=0L, max=6L, step=1L)
    @Order(value=10)
    @DescriptionForConfigEntry(value="Max number of retries used to try to avoid cutcaptcha")
    public int getMaxCutCaptchaAvoidanceRetries();

    public void setMaxCutCaptchaAvoidanceRetries(int var1);

    @AboutConfig
    @DefaultEnumValue(value="CRAWL_ALL_AVAILABLE_MIRRORS")
    @Order(value=20)
    @DescriptionForConfigEntry(value="Crawl mode")
    public CrawlMode getCrawlMode();

    public void setCrawlMode(CrawlMode var1);

    public static enum CrawlMode implements LabelInterface
    {
        PREFER_GIVEN_MIRROR_ID{

            public String getLabel() {
                return "Crawl only pre-selected mirror if it contains available links";
            }
        }
        ,
        CRAWL_ALL_AVAILABLE_MIRRORS{

            public String getLabel() {
                return "Crawl all available mirrors";
            }
        };

    }

    public static class TRANSLATION {
        public String getMaxCutCaptchaAvoidanceRetries_label() {
            return FileCryptConfig.text_MaxCutCaptchaAvoidanceRetries;
        }

        public String getCrawlMode_label() {
            return FileCryptConfig.text_CrawlMode;
        }
    }
}

