/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="drive.google.com", type=Type.HOSTER)
public interface GoogleConfig
extends PluginConfigInterface {
    public static final String text_UserAgent = "User-Agent which will be used for all Google website http requests";
    public static final String text_PreferredVideoQuality = "Preferred video stream quality.\r\nIf the preferred stream quality is not found, best stream quality will be downloaded instead.";
    public static final String text_AllowStreamDownloadAsFallbackIfFileDownloadQuotaIsReached = "Allow stream download as fallback if original file is quota limited?";
    public static final String text_AllowStreamDownloadAsFallbackIfOfficialDownloadIsDisabled = "Allow stream download as fallback if original file download is disabled?";
    public static final String text_GoogleDriveAPIKey = "Google Drive API key see: developers.google.com/drive/api/v3/enable-drive-api\r\nIt will be used for GDrive folder crawling, linkchecking and downloading.";
    public static final String text_APIDownloadMode = "API download mode (only relevant if API Key is provided.)";
    public static final String text_AddStreamQualityIdentifierToFilename = "Add quality identifier to filename if audio/video stream is downloaded?";
    public static final String text_WaitOnQuotaReachedMinutes = "Wait time minutes on quota limit reached";
    public static final String text_DebugAccountLogin = "Debug: Website mode: Perform extended account check (enable = slower account check)?";
    public static final String text_DebugForceValidateLoginAlways = "Debug: Website mode: Force validate login on every linkcheck/download attempt (enable = slower linkcheck!)?";
    public static final String text_DebugWebsiteTrustQuickLinkcheckOfflineStatus = "Debug: Website mode: Trust quick linkcheck offline status (enable = can speed up linkcheck)?";
    public static final String text_DebugWebsiteAlwaysPerformExtendedLinkcheck = "Debug: Website mode: Always perform extended linkcheck? (enable = may slow down linkcheck)?";
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultStringValue(value="JDDEFAULT")
    @DescriptionForConfigEntry(value="User-Agent which will be used for all Google website http requests")
    @Order(value=10)
    public String getUserAgent();

    public void setUserAgent(String var1);

    @AboutConfig
    @DefaultEnumValue(value="ORIGINAL")
    @DescriptionForConfigEntry(value="Preferred video stream quality.\r\nIf the preferred stream quality is not found, best stream quality will be downloaded instead.")
    @Order(value=15)
    public PreferredVideoQuality getPreferredVideoQuality();

    public void setPreferredVideoQuality(PreferredVideoQuality var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Allow stream download as fallback if original file is quota limited?")
    @Order(value=16)
    public boolean isAllowStreamDownloadAsFallbackIfFileDownloadQuotaIsReached();

    public void setAllowStreamDownloadAsFallbackIfFileDownloadQuotaIsReached(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Allow stream download as fallback if original file download is disabled?")
    @Order(value=17)
    public boolean isAllowStreamDownloadAsFallbackIfOfficialDownloadIsDisabled();

    public void setAllowStreamDownloadAsFallbackIfOfficialDownloadIsDisabled(boolean var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Google Drive API key see: developers.google.com/drive/api/v3/enable-drive-api\r\nIt will be used for GDrive folder crawling, linkchecking and downloading.")
    @Order(value=20)
    public String getGoogleDriveAPIKey();

    public void setGoogleDriveAPIKey(String var1);

    @AboutConfig
    @DefaultEnumValue(value="WEBSITE_IF_ACCOUNT_AVAILABLE_AND_FILE_IS_QUOTA_LIMITED")
    @DescriptionForConfigEntry(value="API download mode (only relevant if API Key is provided.)")
    @Order(value=25)
    public APIDownloadMode getAPIDownloadMode();

    public void setAPIDownloadMode(APIDownloadMode var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Add quality identifier to filename if audio/video stream is downloaded?")
    @Order(value=50)
    public boolean isAddStreamQualityIdentifierToFilename();

    public void setAddStreamQualityIdentifierToFilename(boolean var1);

    @AboutConfig
    @SpinnerValidator(min=10L, max=360L, step=1L)
    @DefaultIntValue(value=60)
    @DescriptionForConfigEntry(value="Wait time minutes on quota limit reached")
    @Order(value=51)
    public int getWaitOnQuotaReachedMinutes();

    public void setWaitOnQuotaReachedMinutes(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Enable this to allow Google Drive links to be downloaded via multihoster accounts.")
    @Order(value=52)
    public boolean isAllowMultihosterDownload();

    public void setAllowMultihosterDownload(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Debug: Website mode: Perform extended account check (enable = slower account check)?")
    @Order(value=60)
    public boolean isDebugAccountLogin();

    public void setDebugAccountLogin(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Debug: Website mode: Force validate login on every linkcheck/download attempt (enable = slower linkcheck!)?")
    @Order(value=70)
    public boolean isDebugForceValidateLoginAlways();

    public void setDebugForceValidateLoginAlways(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Debug: Website mode: Trust quick linkcheck offline status (enable = can speed up linkcheck)?")
    @Order(value=80)
    public boolean isDebugWebsiteTrustQuickLinkcheckOfflineStatus();

    public void setDebugWebsiteTrustQuickLinkcheckOfflineStatus(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Debug: Website mode: Always perform extended linkcheck? (enable = may slow down linkcheck)?")
    @Order(value=90)
    public boolean isDebugWebsiteAlwaysPerformExtendedLinkcheck();

    public void setDebugWebsiteAlwaysPerformExtendedLinkcheck(boolean var1);

    public static enum APIDownloadMode implements LabelInterface
    {
        API_ONLY{

            public String getLabel() {
                return "API only (except for stream downloads)";
            }
        }
        ,
        WEBSITE_IF_ACCOUNT_AVAILABLE{

            public String getLabel() {
                return "Use website if account is available";
            }
        }
        ,
        WEBSITE_IF_ACCOUNT_AVAILABLE_AND_FILE_IS_QUOTA_LIMITED{

            public String getLabel() {
                return "Use website if account is available and file is quota limited";
            }
        };

    }

    public static enum PreferredVideoQuality implements LabelInterface
    {
        ORIGINAL{

            public String getLabel() {
                return "Original file";
            }
        }
        ,
        STREAM_BEST{

            public String getLabel() {
                return "Best stream";
            }
        }
        ,
        STREAM_360P{

            public String getLabel() {
                return "360p";
            }
        }
        ,
        STREAM_480P{

            public String getLabel() {
                return "480p";
            }
        }
        ,
        STREAM_720P{

            public String getLabel() {
                return "720p";
            }
        }
        ,
        STREAM_1080P{

            public String getLabel() {
                return "1080p";
            }
        };

    }

    public static class TRANSLATION {
        public String getUserAgent_label() {
            return GoogleConfig.text_UserAgent;
        }

        public String getPreferredVideoQuality_label() {
            return GoogleConfig.text_PreferredVideoQuality;
        }

        public String getAllowStreamDownloadAsFallbackIfFileDownloadQuotaIsReached_label() {
            return GoogleConfig.text_AllowStreamDownloadAsFallbackIfFileDownloadQuotaIsReached;
        }

        public String getAllowStreamDownloadAsFallbackIfOfficialDownloadIsDisabled_label() {
            return GoogleConfig.text_AllowStreamDownloadAsFallbackIfOfficialDownloadIsDisabled;
        }

        public String getGoogleDriveAPIKey_label() {
            return GoogleConfig.text_GoogleDriveAPIKey;
        }

        public String getAPIDownloadMode_label() {
            return GoogleConfig.text_APIDownloadMode;
        }

        public String getAddStreamQualityIdentifierToFilename_label() {
            return GoogleConfig.text_AddStreamQualityIdentifierToFilename;
        }

        public String getWaitOnQuotaReachedMinutes_label() {
            return GoogleConfig.text_WaitOnQuotaReachedMinutes;
        }

        public String getAllowMultihosterDownload_label() {
            return "Allow multihoster usage?";
        }

        public String getDebugAccountLogin_label() {
            return GoogleConfig.text_DebugAccountLogin;
        }

        public String getDebugForceValidateLoginAlways_label() {
            return GoogleConfig.text_DebugForceValidateLoginAlways;
        }

        public String getDebugWebsiteTrustQuickLinkcheckOfflineStatus_label() {
            return GoogleConfig.text_DebugWebsiteTrustQuickLinkcheckOfflineStatus;
        }

        public String getDebugWebsiteAlwaysPerformExtendedLinkcheck_label() {
            return GoogleConfig.text_DebugWebsiteAlwaysPerformExtendedLinkcheck;
        }
    }
}

