/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="kemono.su", type=Type.CRAWLER)
public interface KemonoPartyConfig
extends PluginConfigInterface {
    public static final String text_CrawlHttpLinksFromPostContent = "Crawl http links in post text?";
    public static final String text_TextCrawlMode = "When to add post text content as .txt file:";
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Crawl http links in post text?")
    @Order(value=10)
    public boolean isCrawlHttpLinksFromPostContent();

    public void setCrawlHttpLinksFromPostContent(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="ONLY_IF_NO_MEDIA_ITEMS_ARE_FOUND")
    @DescriptionForConfigEntry(value="When to add post text content as .txt file:")
    @Order(value=20)
    public TextCrawlMode getTextCrawlMode();

    public void setTextCrawlMode(TextCrawlMode var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Filters duplicates during crawl process via sha256 file-hashes.")
    @Order(value=30)
    public boolean isEnableProfileCrawlerAdvancedDupeFiltering();

    public void setEnableProfileCrawlerAdvancedDupeFiltering(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @Order(value=40)
    public boolean isPerPostURLPackageEnabled();

    public void setPerPostURLPackageEnabled(boolean var1);

    public static enum TextCrawlMode implements LabelInterface
    {
        ALWAYS{

            public String getLabel() {
                return "Always if text is available";
            }
        }
        ,
        ONLY_IF_NO_MEDIA_ITEMS_ARE_FOUND{

            public String getLabel() {
                return "Only if no media items are found and text is available";
            }
        }
        ,
        NEVER{

            public String getLabel() {
                return "Never";
            }
        };

    }

    public static class TRANSLATION {
        public String getCrawlHttpLinksFromPostContent_label() {
            return KemonoPartyConfig.text_CrawlHttpLinksFromPostContent;
        }

        public String getTextCrawlMode_label() {
            return KemonoPartyConfig.text_TextCrawlMode;
        }

        public String getEnableProfileCrawlerAdvancedDupeFiltering_label() {
            return "Profile crawler: Enable advanced filtering of duplicates via sha256 hash?";
        }

        public String getPerPostURLPackageEnabled_label() {
            return "Profile crawler: Place each post results into separate package?";
        }
    }
}

