/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import java.util.Set;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultEnumArrayValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="metart.com", type=Type.HOSTER)
public interface MetartConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @Order(value=110)
    @DefaultEnumArrayValue(value={"HIGH"})
    @DefaultOnNull
    public Set<PhotoQuality> getMediaQualitiesPhotosLoose();

    public void setMediaQualitiesPhotosLoose(Set<PhotoQuality> var1);

    @AboutConfig
    @Order(value=120)
    @DefaultEnumArrayValue(value={})
    @DefaultOnNull
    public Set<PhotoQuality> getMediaQualitiesPhotosZip();

    public void setMediaQualitiesPhotosZip(Set<PhotoQuality> var1);

    @AboutConfig
    @DefaultEnumValue(value="ALL")
    @Order(value=135)
    @DescriptionForConfigEntry(value="Customize video crawler behavior")
    public VideoCrawlMode getVideoCrawlMode();

    public void setVideoCrawlMode(VideoCrawlMode var1);

    @AboutConfig
    @Order(value=140)
    @DefaultOnNull
    public Set<VideoQuality> getMediaQualitiesVideos();

    public void setMediaQualitiesVideos(Set<VideoQuality> var1);

    public static enum VideoCrawlMode implements LabelInterface
    {
        BEST{

            public String getLabel() {
                return "Best quality only";
            }
        }
        ,
        ALL{

            public String getLabel() {
                return "All qualities";
            }
        }
        ,
        ALL_SELECTED{

            public String getLabel() {
                return "All selected qualities";
            }
        };

    }

    public static enum PhotoCrawlMode implements LabelInterface
    {
        ZIP_BEST{

            public String getLabel() {
                return ".zip BEST quality";
            }
        }
        ,
        PHOTOS_BEST{

            public String getLabel() {
                return "Loose photos BEST quality";
            }
        };

    }

    public static enum VideoQuality implements LabelInterface,
    VideoQualityDetails
    {
        Q2160P{

            public String getLabel() {
                return "4k UHD";
            }

            @Override
            public String getInternalValue() {
                return "4k";
            }
        }
        ,
        Q1080P{

            public String getLabel() {
                return "1080p HD";
            }

            @Override
            public String getInternalValue() {
                return "1080p";
            }
        }
        ,
        Q720P{

            public String getLabel() {
                return "720p HD";
            }

            @Override
            public String getInternalValue() {
                return "720p";
            }
        }
        ,
        Q360P{

            public String getLabel() {
                return "360p";
            }

            @Override
            public String getInternalValue() {
                return "360p";
            }
        }
        ,
        Q270P{

            public String getLabel() {
                return "270p";
            }

            @Override
            public String getInternalValue() {
                return "270p";
            }
        }
        ,
        QWMV{

            public String getLabel() {
                return "WMV";
            }

            @Override
            public String getInternalValue() {
                return "wmv";
            }
        }
        ,
        QDIVX{

            public String getLabel() {
                return "DivX AVI";
            }

            @Override
            public String getInternalValue() {
                return "avi";
            }
        };

    }

    public static interface VideoQualityDetails {
        public String getInternalValue();
    }

    public static enum PhotoQuality implements LabelInterface,
    MediaQualityDetails
    {
        HIGH{

            public String getLabel() {
                return "High";
            }

            @Override
            public String[] getInternalValues() {
                return new String[]{"high"};
            }
        }
        ,
        MEDIUM{

            public String getLabel() {
                return "Medium";
            }

            @Override
            public String[] getInternalValues() {
                return new String[]{"med", "medium"};
            }
        }
        ,
        LOW{

            public String getLabel() {
                return "Low";
            }

            @Override
            public String[] getInternalValues() {
                return new String[]{"low"};
            }
        };

    }

    public static interface MediaQualityDetails {
        public String[] getInternalValues();
    }

    public static class TRANSLATION {
        public String getVideoCrawlMode_label() {
            return "Video crawl mode";
        }

        public String getMediaQualitiesPhotosLoose_label() {
            return "Qualities for loose photos";
        }

        public String getMediaQualitiesPhotosZip_label() {
            return "Qualities for .zip photos";
        }

        public String getMediaQualitiesVideos_label() {
            return "Qualities for videos";
        }
    }
}

