/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="reddit.com", type=Type.HOSTER)
public interface RedditConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();
    public static final String text_PreferredCommentsPackagenameScheme = "Select preferred package name scheme for single comments";
    public static final String text_CustomCommentsPackagenameScheme = "Define custom packagename scheme";
    public static final String text_PreferredFilenameScheme = "Select preferred filename scheme";
    public static final String text_CrawlerTextDownloadMode = "Crawler: Text download mode";
    public static final String text_PreviewDownloadMode = "Crawler: Preview download mode";
    public static final String text_CrawlUrlsInsidePostText = "Crawl URLs inside post-text?";
    public static final String text_ProfileCrawlerMaxPages = "User crawler: Crawl max X pages (-1 = unlimited, 0 = disable user crawler)";
    public static final String text_SubredditCrawlerMaxPages = "Subreddit crawler: Crawl max X pages (-1 = unlimited, 0 = disable subreddit crawler)";
    public static final String text_VideoDownloadStreamType = "Preferred video download stream type";
    public static final String text_VideoUseDirecturlAsContentURL = "Videos: Use direct URL as content URL (URL you get when doing CTRL + C)?";

    @AboutConfig
    @DefaultEnumValue(value="DATE_SUBREDDIT_POSTID_SLUG")
    @Order(value=10)
    @DescriptionForConfigEntry(value="Select preferred package name scheme for single comments")
    public CommentsPackagenameScheme getPreferredCommentsPackagenameScheme();

    public void setPreferredCommentsPackagenameScheme(CommentsPackagenameScheme var1);

    @AboutConfig
    @DefaultStringValue(value="*date*_*date_timestamp*_*date_timedelta_formatted*_*subreddit_title*_*username*_*post_id*_*post_title*")
    @DescriptionForConfigEntry(value="Define custom packagename scheme")
    @Order(value=11)
    public String getCustomCommentsPackagenameScheme();

    public void setCustomCommentsPackagenameScheme(String var1);

    @AboutConfig
    @DefaultEnumValue(value="DATE_SUBREDDIT_POSTID_SLUG")
    @Order(value=15)
    @DescriptionForConfigEntry(value="Select preferred filename scheme")
    public FilenameScheme getPreferredFilenameScheme();

    public void setPreferredFilenameScheme(FilenameScheme var1);

    @AboutConfig
    @DefaultStringValue(value="*date*_*date_timestamp*_*date_timedelta_formatted*_*subreddit_title*_*username*_*post_id*_*post_title**original_filename_without_ext*_*index**ext*")
    @DescriptionForConfigEntry(value="Define custom packagename scheme")
    @Order(value=16)
    public String getCustomFilenameScheme();

    public void setCustomFilenameScheme(String var1);

    @AboutConfig
    @DefaultEnumValue(value="ALWAYS")
    @DefaultOnNull
    @Order(value=17)
    @DescriptionForConfigEntry(value="Crawler: Text download mode")
    public TextCrawlerMode getCrawlerTextDownloadMode();

    public void setCrawlerTextDownloadMode(TextCrawlerMode var1);

    @AboutConfig
    @DefaultEnumValue(value="ALWAYS")
    @DefaultOnNull
    @Order(value=18)
    @DescriptionForConfigEntry(value="Crawler: Preview download mode")
    public PreviewCrawlerMode getPreviewDownloadMode();

    public void setPreviewDownloadMode(PreviewCrawlerMode var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Crawl URLs inside post-text?")
    @Order(value=20)
    public boolean isCrawlUrlsInsidePostText();

    public void setCrawlUrlsInsidePostText(boolean var1);

    @AboutConfig
    @SpinnerValidator(min=-1L, max=2000L, step=1L)
    @DefaultIntValue(value=1)
    @DescriptionForConfigEntry(value="Subreddit crawler: Crawl max X pages (-1 = unlimited, 0 = disable subreddit crawler)")
    @Order(value=30)
    public int getProfileCrawlerMaxPages();

    public void setProfileCrawlerMaxPages(int var1);

    @AboutConfig
    @SpinnerValidator(min=-1L, max=2000L, step=1L)
    @DefaultIntValue(value=1)
    @DescriptionForConfigEntry(value="Subreddit crawler: Crawl max X pages (-1 = unlimited, 0 = disable subreddit crawler)")
    @Order(value=40)
    public int getSubredditCrawlerMaxPages();

    public void setSubredditCrawlerMaxPages(int var1);

    @AboutConfig
    @DefaultEnumValue(value="DASH")
    @Order(value=45)
    @DescriptionForConfigEntry(value="Preferred video download stream type")
    public VideoDownloadStreamType getVideoDownloadStreamType();

    public void setVideoDownloadStreamType(VideoDownloadStreamType var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Videos: Use direct URL as content URL (URL you get when doing CTRL + C)?")
    @Order(value=50)
    public boolean isVideoUseDirecturlAsContentURL();

    public void setVideoUseDirecturlAsContentURL(boolean var1);

    public static enum VideoDownloadStreamType implements LabelInterface
    {
        DASH{

            public String getLabel() {
                return "DASH (possibly higher max. quality)";
            }
        }
        ,
        HLS{

            public String getLabel() {
                return "HLS";
            }
        };

    }

    public static enum PreviewCrawlerMode implements LabelInterface
    {
        ALWAYS{

            public String getLabel() {
                return "Always";
            }
        }
        ,
        ONLY_IF_NO_MEDIA_SUPPORT_AVAILABLE{

            public String getLabel() {
                return "Only if no supported media is found";
            }
        }
        ,
        NEVER{

            public String getLabel() {
                return "Never";
            }
        };

    }

    public static enum TextCrawlerMode implements LabelInterface
    {
        ALWAYS{

            public String getLabel() {
                return "Always";
            }
        }
        ,
        ONLY_IF_NO_MEDIA_AVAILABLE{

            public String getLabel() {
                return "Only if no media is found";
            }
        }
        ,
        NEVER{

            public String getLabel() {
                return "Never";
            }
        };

    }

    public static enum CommentsPackagenameScheme implements LabelInterface
    {
        DATE_SUBREDDIT_POSTID_SLUG{

            public String getLabel() {
                return "Default: *date*_*subreddit_title*_*post_id*_*post_slug*";
            }
        }
        ,
        DATE_SUBREDDIT_POSTID_TITLE{

            public String getLabel() {
                return "*date*_*subreddit_title*_*post_id*_*post_title*";
            }
        }
        ,
        TITLE{

            public String getLabel() {
                return "*post_title*";
            }
        }
        ,
        CUSTOM{

            public String getLabel() {
                return "Custom";
            }
        };

    }

    public static enum FilenameScheme implements LabelInterface
    {
        DATE_SUBREDDIT_POSTID_SERVER_FILENAME{

            public String getLabel() {
                return "*date*_*subreddit_title*_*post_id*_*original_filename_without_ext**ext*";
            }
        }
        ,
        DATE_SUBREDDIT_POSTID_TITLE{

            public String getLabel() {
                return "*date*_*subreddit_title*_*post_id*_*post_title**ext*";
            }
        }
        ,
        DATE_SUBREDDIT_POSTID_SLUG{

            public String getLabel() {
                return "Default: *date*_*subreddit_title*_*post_id*_*post_slug**ext*";
            }
        }
        ,
        SERVER_FILENAME{

            public String getLabel() {
                return "*original_filename_without_ext**ext*";
            }
        }
        ,
        CUSTOM{

            public String getLabel() {
                return "Custom";
            }
        };

    }

    public static class TRANSLATION {
        public String getPreferredCommentsPackagenameScheme_label() {
            return RedditConfig.text_PreferredCommentsPackagenameScheme;
        }

        public String getPreferredFilenameScheme_label() {
            return RedditConfig.text_PreferredFilenameScheme;
        }

        public String getCustomCommentsPackagenameScheme_label() {
            return RedditConfig.text_CustomCommentsPackagenameScheme;
        }

        public String getCrawlerTextDownloadMode_label() {
            return RedditConfig.text_CrawlerTextDownloadMode;
        }

        public String getCrawlUrlsInsidePostText_label() {
            return RedditConfig.text_CrawlUrlsInsidePostText;
        }

        public String getProfileCrawlerMaxPages_label() {
            return RedditConfig.text_ProfileCrawlerMaxPages;
        }

        public String getSubredditCrawlerMaxPages_label() {
            return RedditConfig.text_SubredditCrawlerMaxPages;
        }

        public String getVideoDownloadStreamType_label() {
            return RedditConfig.text_VideoDownloadStreamType;
        }

        public String getVideoUseDirecturlAsContentURL_label() {
            return RedditConfig.text_VideoUseDirecturlAsContentURL;
        }
    }
}

