/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.hds;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import jd.http.Browser;
import jd.plugins.DownloadLink;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.XML;
import org.appwork.utils.formatter.SizeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HDSContainer {
    public static final String PROPERTY_FRAGMENTURL = "fragmentUrl";
    public static final String PROPERTY_STREAMID = "streamId";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_BITRATE = "bitrate";
    public static final String PROPERTY_DURATION = "duration";
    private int width = -1;
    private int height = -1;
    private int bitrate = -1;
    private String fragmentURL = null;
    private String streamId = null;
    private long duration = -1L;
    private String id = null;

    public static HDSContainer findBestVideoByResolution(List<HDSContainer> list) {
        if (list != null) {
            HDSContainer best = null;
            for (HDSContainer container : list) {
                if (best != null && container.getHeight() * container.getWidth() <= best.getHeight() * best.getWidth() && (container.getBitrate() <= best.getBitrate() || container.getHeight() * container.getWidth() != best.getHeight() * best.getWidth())) continue;
                best = container;
            }
            return best;
        }
        return null;
    }

    public static Node getNodeByName(NodeList nodes, String name) {
        if (nodes != null && nodes.getLength() > 0) {
            for (int index = 0; index < nodes.getLength(); ++index) {
                Node node = nodes.item(index);
                if (!StringUtils.equals((String)node.getNodeName(), (String)name)) continue;
                return node;
            }
        }
        return null;
    }

    public static String getAttByNamedItem(Node node, String item) {
        Node attribute;
        if (node != null && node.hasAttributes() && (attribute = node.getAttributes().getNamedItem(item)) != null) {
            String content = attribute.getTextContent();
            return content != null ? content.trim() : null;
        }
        return null;
    }

    public static long parseDuration(String duration) {
        int dotIndex = duration.indexOf(46);
        if (dotIndex != -1) {
            String msnsCheck = duration.substring(dotIndex + 1);
            if (msnsCheck.length() == 6) {
                return Long.parseLong(duration.replace(".", "")) / 1000L;
            }
            if (msnsCheck.length() == 3) {
                return Long.parseLong(duration.replace(".", ""));
            }
        }
        return -1L;
    }

    public static HDSContainer getBestMatchingContainer(List<HDSContainer> all, HDSContainer searchFor) {
        if (searchFor != null && all != null) {
            for (HDSContainer container : all) {
                if (searchFor.getFragmentURL().equals(container.getFragmentURL())) {
                    return container;
                }
                if (searchFor.getStreamId() != null && searchFor.getStreamId().equals(container.getStreamId())) {
                    return container;
                }
                if (searchFor.getBitrate() != container.getBitrate() || searchFor.getHeight() != container.getHeight() || searchFor.getWidth() != container.getWidth()) continue;
                return container;
            }
        }
        return null;
    }

    public void write(DownloadLink destination) {
        this.write(destination, null);
    }

    public void write(DownloadLink destination, String propertyPrefix) {
        if (destination != null) {
            String prefix = HDSContainer.handlePrefix(propertyPrefix);
            destination.setProperty(prefix + PROPERTY_FRAGMENTURL, this.getFragmentURL());
            destination.setProperty(prefix + PROPERTY_STREAMID, this.getStreamId());
            destination.setProperty(prefix + PROPERTY_WIDTH, this.getWidth());
            destination.setProperty(prefix + PROPERTY_HEIGHT, this.getHeight());
            destination.setProperty(prefix + PROPERTY_BITRATE, this.getBitrate());
            destination.setProperty(prefix + PROPERTY_DURATION, this.getDuration());
            destination.setProperty(prefix + PROPERTY_DURATION, this.getId());
        }
    }

    public static HDSContainer read(DownloadLink source) {
        return HDSContainer.read(source, null);
    }

    public static boolean clear(DownloadLink source) {
        return HDSContainer.clear(source, null);
    }

    public static boolean clear(DownloadLink source, String propertyPrefix) {
        if (source != null) {
            String prefix = HDSContainer.handlePrefix(propertyPrefix);
            boolean ret = source.removeProperty(prefix + PROPERTY_FRAGMENTURL);
            source.removeProperty(prefix + PROPERTY_STREAMID);
            source.removeProperty(prefix + PROPERTY_BITRATE);
            source.removeProperty(prefix + PROPERTY_HEIGHT);
            source.removeProperty(prefix + PROPERTY_WIDTH);
            source.removeProperty(prefix + PROPERTY_DURATION);
            source.removeProperty(prefix + PROPERTY_ID);
            return ret;
        }
        return false;
    }

    private static String handlePrefix(String propertyPrefix) {
        if (propertyPrefix != null) {
            return propertyPrefix + "_";
        }
        return "";
    }

    public static HDSContainer read(DownloadLink source, String propertyPrefix) {
        String prefix;
        String fragmentURL;
        if (source != null && (fragmentURL = source.getStringProperty((prefix = HDSContainer.handlePrefix(propertyPrefix)) + PROPERTY_FRAGMENTURL, null)) != null) {
            HDSContainer ret = new HDSContainer();
            ret.fragmentURL = fragmentURL;
            ret.streamId = source.getStringProperty(prefix + PROPERTY_STREAMID, null);
            ret.bitrate = source.getIntegerProperty(prefix + PROPERTY_BITRATE, -1);
            ret.height = source.getIntegerProperty(prefix + PROPERTY_HEIGHT, -1);
            ret.width = source.getIntegerProperty(prefix + PROPERTY_WIDTH, -1);
            ret.duration = source.getLongProperty(prefix + PROPERTY_DURATION, -1L);
            ret.id = source.getStringProperty(prefix + PROPERTY_ID, null);
            return ret;
        }
        return null;
    }

    public static List<HDSContainer> getHDSQualities(Browser br) throws Exception {
        DocumentBuilder parser = XML.newSecureFactory().newDocumentBuilder();
        Document d = parser.parse(new ByteArrayInputStream(br.getRequest().getHtmlCode().getBytes("UTF-8")));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList root = (NodeList)xPath.evaluate("/manifest", d, XPathConstants.NODESET);
        Node durationNode = HDSContainer.getNodeByName(root.item(0).getChildNodes(), PROPERTY_DURATION);
        Node id = HDSContainer.getNodeByName(root.item(0).getChildNodes(), PROPERTY_ID);
        long duration = durationNode != null ? HDSContainer.parseDuration(durationNode.getTextContent()) : -1L;
        NodeList mediaUrls = (NodeList)xPath.evaluate("/manifest/media", d, XPathConstants.NODESET);
        if (mediaUrls != null) {
            ArrayList<HDSContainer> ret = new ArrayList<HDSContainer>();
            for (int j = 0; j < mediaUrls.getLength(); ++j) {
                String bitrate;
                String height;
                Node media = mediaUrls.item(j);
                String fragmentUrl = HDSContainer.getAttByNamedItem(media, "url");
                if (fragmentUrl == null) continue;
                HDSContainer container = new HDSContainer();
                container.fragmentURL = fragmentUrl;
                String width = HDSContainer.getAttByNamedItem(media, PROPERTY_WIDTH);
                if (width != null && width.matches("^\\d+$")) {
                    container.width = Integer.parseInt(width);
                }
                if ((height = HDSContainer.getAttByNamedItem(media, PROPERTY_HEIGHT)) != null && height.matches("^\\d+$")) {
                    container.height = Integer.parseInt(height);
                }
                if ((bitrate = HDSContainer.getAttByNamedItem(media, PROPERTY_BITRATE)) != null && bitrate.matches("^\\d+$")) {
                    container.bitrate = Integer.parseInt(bitrate);
                }
                container.streamId = HDSContainer.getAttByNamedItem(media, PROPERTY_STREAMID);
                if (id != null) {
                    container.id = id.getTextContent();
                }
                container.duration = duration;
                ret.add(container);
            }
            if (ret.size() > 0) {
                return ret;
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getEstimatedFileSize() {
        if (this.duration > 0L && this.bitrate > 0) {
            return this.duration / 1000L * ((long)this.bitrate * 1000L / 8L);
        }
        return -1L;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getInternalID() {
        return Hash.getMD5((String)this.toString());
    }

    public String getFragmentURL() {
        return this.fragmentURL;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public String toString() {
        return "FragmentURL:" + this.getFragmentURL() + "|ID:" + this.getId() + "|StreamID:" + this.getStreamId() + "|Resolution:" + this.getWidth() + "x" + this.getHeight() + "|Est.FileSize:" + SizeFormatter.formatBytes((long)this.getEstimatedFileSize());
    }

    public String getResolution() {
        return this.getWidth() + "x" + this.getHeight();
    }
}

