/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.hls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.plugins.DownloadLink;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.jdownloader.downloader.hls.M3U8Playlist;

public class HlsContainer {
    private String codecs;
    private String streamURL;
    private String m3u8URL;
    private List<M3U8Playlist> m3u8List = null;
    private int width = -1;
    private int height = -1;
    private int bandwidth = -1;
    private int average_bandwidth = -1;
    private int programID = -1;
    private int framerate = -1;
    private String name = null;

    public static List<HlsContainer> findBestVideosByBandwidth(List<HlsContainer> media) {
        if (media == null || media.size() == 0) {
            return null;
        }
        HashMap<String, ArrayList<HlsContainer>> hlsContainer = new HashMap<String, ArrayList<HlsContainer>>();
        ArrayList<HlsContainer> ret = null;
        long bandwidth_highest = 0L;
        for (HlsContainer item : media) {
            String id = item.getExtXStreamInf();
            ArrayList<HlsContainer> list = (ArrayList<HlsContainer>)hlsContainer.get(id);
            if (list == null) {
                list = new ArrayList<HlsContainer>();
                hlsContainer.put(id, list);
            }
            list.add(item);
            long bandwidth_temp = item.getBandwidth();
            if (bandwidth_temp == -1L) {
                bandwidth_temp = item.getAverageBandwidth();
            }
            if (bandwidth_temp <= bandwidth_highest) continue;
            bandwidth_highest = bandwidth_temp;
            ret = list;
        }
        return ret;
    }

    public static HlsContainer findBestVideoByBandwidth(List<HlsContainer> media) {
        List<HlsContainer> ret = HlsContainer.findBestVideosByBandwidth(media);
        if (ret != null && ret.size() > 0) {
            return ret.get(0);
        }
        return null;
    }

    public static List<HlsContainer> getHlsQualities(Browser br, String m3u8) throws Exception {
        br.getHeaders().put("Accept", "*/*");
        br.getPage(m3u8);
        return HlsContainer.getHlsQualities(br);
    }

    public static List<HlsContainer> getHlsQualities(Browser br) throws Exception {
        return HlsContainer.parseHlsQualities(br.toString(), br);
    }

    public static List<HlsContainer> parseHlsQualities(String m3u8, Browser br) throws Exception {
        ArrayList<HlsContainer> hlsqualities = new ArrayList<HlsContainer>();
        String[][] streams = new Regex(m3u8, "#EXT-X-STREAM-INF:?([^\r\n]+)[\r\n]+([^\r\n]+)").getMatches();
        if (streams != null) {
            for (String[] stream : streams) {
                if (!StringUtils.isNotEmpty((String)stream[1])) continue;
                String streamInfo = stream[0];
                String programID = new Regex(streamInfo, "(?:,|^)\\s*PROGRAM-ID\\s*=\\s*(\\d+)").getMatch(0);
                String bandwidth = new Regex(streamInfo, "(?:,|^)\\s*BANDWIDTH\\s*=\\s*(\\d+)").getMatch(0);
                String average_bandwidth = new Regex(streamInfo, "(?:,|^)\\s*AVERAGE-BANDWIDTH\\s*=\\s*(\\d+)").getMatch(0);
                String resolution = new Regex(streamInfo, "(?:,|^)\\s*RESOLUTION\\s*=\\s*(\\d+x\\d+)").getMatch(0);
                String framerate = new Regex(streamInfo, "(?:,|^)\\s*FRAME-RATE\\s*=\\s*(\\d+)").getMatch(0);
                String codecs = new Regex(streamInfo, "(?:,|^)\\s*CODECS\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                String name = new Regex(streamInfo, "(?:,|^)\\s*NAME\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                String url = br.getURL(stream[1]).toString();
                HlsContainer hls = new HlsContainer();
                hls.programID = programID != null ? Integer.parseInt(programID) : -1;
                hls.bandwidth = bandwidth != null ? Integer.parseInt(bandwidth) : -1;
                if (name != null) {
                    hls.name = name.trim();
                }
                hls.average_bandwidth = average_bandwidth != null ? Integer.parseInt(average_bandwidth) : -1;
                if (codecs != null) {
                    hls.codecs = codecs.trim();
                }
                hls.streamURL = url;
                hls.m3u8URL = br.getURL();
                if (resolution != null) {
                    String[] resolution_info = resolution.split("x");
                    String width = resolution_info[0];
                    String height = resolution_info[1];
                    hls.width = Integer.parseInt(width);
                    hls.height = Integer.parseInt(height);
                }
                if (framerate != null) {
                    hls.framerate = Integer.parseInt(framerate);
                }
                hlsqualities.add(hls);
            }
        }
        return hlsqualities;
    }

    public String getM3U8URL() {
        return this.m3u8URL;
    }

    public void setAverageBandwidth(int average_bandwidth) {
        this.average_bandwidth = average_bandwidth;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setBandwidth(int bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setFramerate(int framerate) {
        this.framerate = framerate;
    }

    public String getName() {
        return this.name;
    }

    protected List<M3U8Playlist> loadM3U8(Browser br) throws IOException {
        Browser br2 = br.cloneBrowser();
        return M3U8Playlist.loadM3U8(this.getStreamURL(), br2);
    }

    public void setM3U8(List<M3U8Playlist> m3u8List) {
        this.m3u8List = m3u8List;
    }

    public String getExtXStreamInf() {
        StringBuilder sb = new StringBuilder();
        sb.append("#EXT-X-STREAM-INF:");
        boolean sep = false;
        if (this.getProgramID() != -1) {
            sb.append("PROGRAM-ID=" + this.getProgramID());
            sep = true;
        }
        if (this.getBandwidth() != -1) {
            if (sep) {
                sb.append(",");
            }
            sb.append("BANDWIDTH=" + this.getBandwidth());
            sep = true;
        }
        if (this.getAverageBandwidth() != -1) {
            if (sep) {
                sb.append(",");
            }
            sb.append("AVERAGE-BANDWIDTH=" + this.getAverageBandwidth());
            sep = true;
        }
        if (this.getCodecs() != null) {
            if (sep) {
                sb.append(",");
            }
            sb.append("CODECS=\"" + this.getCodecs() + "\"");
            sep = true;
        }
        if (this.getResolution() != null) {
            if (sep) {
                sb.append(",");
            }
            sb.append("RESOLUTION=" + this.getResolution());
            sep = true;
        }
        if (this.getFramerate() != -1) {
            if (sep) {
                sb.append(",");
            }
            sb.append("FRAME-RATE=" + this.getFramerate());
            sep = true;
        }
        if (this.getName() != null) {
            if (sep) {
                sb.append(",");
            }
            sb.append("NAME=\"" + this.getName() + "\"");
            sep = true;
        }
        return sb.toString();
    }

    public List<M3U8Playlist> getM3U8(Browser br) throws IOException {
        if (this.m3u8List == null) {
            this.setM3U8(this.loadM3U8(br));
            int bandwidth = this.getAverageBandwidth();
            if (bandwidth < 0) {
                bandwidth = this.getBandwidth();
            }
            if (this.m3u8List != null && bandwidth > 0) {
                for (M3U8Playlist m3u8 : this.m3u8List) {
                    m3u8.setAverageBandwidth(bandwidth);
                }
            }
        }
        return this.m3u8List;
    }

    public int getProgramID() {
        return this.programID;
    }

    public List<StreamCodec> getStreamCodecs() {
        return StreamCodec.parse(this.getCodecs());
    }

    public StreamCodec getCodecType(CODEC_TYPE type) {
        List<StreamCodec> ret = this.getStreamCodecs();
        if (ret != null) {
            for (StreamCodec streamCodec : ret) {
                if (!streamCodec.getCodec().getType().equals((Object)type)) continue;
                return streamCodec;
            }
        }
        return null;
    }

    public StreamCodec getCodec(CODEC codec) {
        List<StreamCodec> ret = this.getStreamCodecs();
        if (ret != null) {
            for (StreamCodec streamCodec : ret) {
                if (!streamCodec.getCodec().equals((Object)codec)) continue;
                return streamCodec;
            }
        }
        return null;
    }

    public String getCodecs() {
        return this.codecs;
    }

    public void setStreamURL(String url) {
        this.streamURL = url;
    }

    @Deprecated
    public String getDownloadurl() {
        return this.getStreamURL();
    }

    public String getStreamURL() {
        return this.streamURL;
    }

    public boolean isVideo() {
        if (this.getCodecType(CODEC_TYPE.VIDEO) != null) {
            return true;
        }
        return this.width != -1 || this.height != -1;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFramerate() {
        return this.framerate;
    }

    public int getFramerate(int fallback) {
        if (this.framerate == -1) {
            return fallback;
        }
        return this.framerate;
    }

    public String getResolution() {
        return this.getWidth() + "x" + this.getHeight();
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public int getAverageBandwidth() {
        return this.average_bandwidth;
    }

    public String toString() {
        return this.getExtXStreamInf();
    }

    public String getStandardFilename() {
        String filename = "";
        if (this.width != -1 && this.height != -1) {
            filename = filename + this.getResolution();
        }
        if (this.codecs != null) {
            filename = filename + "_" + this.codecs;
        }
        filename = filename + this.getFileExtension();
        return filename;
    }

    public String getFileExtension(String fallback) {
        StreamCodec video = this.getCodecType(CODEC_TYPE.VIDEO);
        StreamCodec audio = this.getCodecType(CODEC_TYPE.AUDIO);
        if (video != null) {
            return "." + video.getCodec().getDefaultExtension();
        }
        if (audio != null) {
            return "." + audio.getCodec().getDefaultExtension();
        }
        return fallback;
    }

    @Deprecated
    public String getFileExtension() {
        return this.getFileExtension(".mp4");
    }

    public void setPropertiesOnDownloadLink(DownloadLink link) {
        if (this.getWidth() > 0) {
            link.setProperty("width", this.getWidth());
        }
        if (this.getHeight() > 0) {
            link.setProperty("height", this.getHeight());
        }
        if (this.getFramerate() > 0) {
            link.setProperty("framerate", this.getFramerate());
        }
        if (this.getBandwidth() > 0) {
            link.setProperty("hlsBandwidth", this.getBandwidth());
        }
        if (this.getAverageBandwidth() > 0) {
            link.setProperty("hlsBandwidthAverage", this.getAverageBandwidth());
        }
        link.setProperty("m3u8_name", this.getName());
        link.setProperty("m3u8_codecs", this.getCodecs());
    }

    public static class StreamCodec {
        private final CODEC codec;
        private final String raw;

        public CODEC getCodec() {
            return this.codec;
        }

        public String getRaw() {
            return this.raw;
        }

        private StreamCodec(String raw) {
            this.raw = raw;
            this.codec = CODEC.parse(raw);
        }

        public static List<StreamCodec> parse(String raw) {
            String[] codecs;
            String[] stringArray = codecs = raw != null ? raw.split(",") : null;
            if (codecs != null) {
                ArrayList<StreamCodec> ret = new ArrayList<StreamCodec>();
                for (String codec : codecs) {
                    ret.add(new StreamCodec(codec));
                }
                return ret;
            }
            return null;
        }
    }

    public static enum CODEC {
        MP3(CODEC_TYPE.AUDIO, "mp3,", "mp3", "(mp4a\\.40\\.34|mp3)"),
        MP2(CODEC_TYPE.AUDIO, "mp2", "mp2", "mp2"),
        AAC(CODEC_TYPE.AUDIO, "aac", "m4a", "(mp4a\\.40|aac)"),
        AC3(CODEC_TYPE.AUDIO, "ac3", "ac3", "(ac-3|ac3)"),
        EC3(CODEC_TYPE.AUDIO, "ec3", "ec3", "(ec-3|ec3)"),
        FLAC(CODEC_TYPE.VIDEO, "flac", "flac", "fLaC"),
        AVC(CODEC_TYPE.VIDEO, "avc", "mp4", "(avc1|avc3|h264)"),
        HEVC(CODEC_TYPE.VIDEO, "hevc", "mp4", "(hev1|hvc1|h265)"),
        UNKNOWN(CODEC_TYPE.UNKNOWN, null, null, null);

        private final CODEC_TYPE type;
        private final String defaultExtension;
        private final Pattern pattern;
        private final String codecName;

        public CODEC_TYPE getType() {
            return this.type;
        }

        public String getDefaultExtension() {
            return this.defaultExtension;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getCodecName() {
            return this.codecName;
        }

        private CODEC(CODEC_TYPE type, String codecName, String defaultExtension, String pattern) {
            this.type = type;
            this.codecName = codecName;
            this.defaultExtension = defaultExtension;
            this.pattern = pattern != null ? Pattern.compile(pattern) : null;
        }

        public static CODEC parse(String raw) {
            if (StringUtils.isNotEmpty((String)raw)) {
                for (CODEC codec : CODEC.values()) {
                    if (codec.getPattern() == null || !new Regex(raw, codec.getPattern()).matches()) continue;
                    return codec;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum CODEC_TYPE {
        VIDEO,
        AUDIO,
        UNKNOWN;

    }
}

