/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jd.plugins.DownloadLink;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.components.youtube.Projection;
import org.jdownloader.plugins.components.youtube.StreamCollection;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;
import org.jdownloader.plugins.components.youtube.variants.DescriptionVariantInfo;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariantInfo;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.components.youtube.variants.VariantInfo;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;
import org.jdownloader.plugins.components.youtube.variants.YoutubeSubtitleStorable;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class YoutubeClipData {
    public String user = null;
    public String user_alternative = null;
    public long datePublished = -1L;
    public String error = null;
    public boolean ageCheck = false;
    public String title = null;
    public String title_alternative = null;
    public String description = null;
    public String description_alternative = null;
    public String channelTitle = null;
    public String channelTitle_alternative = null;
    public int channelSize = -1;
    public String videoID = null;
    public String atID = null;
    public String category = null;
    public int duration = -1;
    public String chapters = null;
    public String channelID = null;
    public long dateUploaded = -1L;
    public Boolean isLiveNow = null;
    public long dateLivestreamStart = -1L;
    public long dateLivestreamEnd = -1L;
    public String userGooglePlusID = null;
    public VideoVariant bestVideoItag = null;
    public Map<YoutubeITAG, StreamCollection> streams;
    public ArrayList<YoutubeSubtitleStorable> subtitles;
    public HashMap<String, String> keywords3D;
    public HashSet<String> keywords;
    public String approxThreedLayout = null;
    public String views = null;

    public boolean guessSBSorHOU3D() {
        if (this.keywords == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.keywords) {
            sb.append(" ").append(s.toLowerCase(Locale.ENGLISH));
        }
        if (this.title != null) {
            sb.append(" ").append(this.title.toLowerCase(Locale.ENGLISH));
        }
        if (this.description != null) {
            sb.append(" ").append(this.description.toLowerCase(Locale.ENGLISH));
        }
        String str = sb.toString();
        if (this.title == null || !this.title.contains("3d")) {
            return false;
        }
        if (str.contains("sbs")) {
            return true;
        }
        if (str.contains("side") && str.contains("by")) {
            return true;
        }
        if (str.contains("hou")) {
            return true;
        }
        return str.contains("cardboard");
    }

    public Projection getProjection() {
        int highestProjection = -1;
        for (Map.Entry<YoutubeITAG, StreamCollection> s : this.streams.entrySet()) {
            for (YoutubeStreamData stream : s.getValue()) {
                highestProjection = Math.max(highestProjection, stream.getProjectionType());
            }
        }
        int layout3D = -1;
        try {
            layout3D = this.approxThreedLayout == null ? -1 : Integer.parseInt(this.approxThreedLayout);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (highestProjection == 0) {
            return Projection.NORMAL;
        }
        if (highestProjection == 2 && layout3D != 3) {
            return Projection.SPHERICAL;
        }
        if (highestProjection == 2 && layout3D == 3 || highestProjection == 3) {
            return Projection.SPHERICAL_3D;
        }
        if (this.guessSBSorHOU3D() || this.is3D()) {
            return Projection.ANAGLYPH_3D;
        }
        return Projection.NORMAL;
    }

    private boolean is3D() {
        if ("1".equals(this.approxThreedLayout)) {
            return true;
        }
        if (this.keywords3D != null) {
            String enable = this.keywords3D.get("enable");
            if (enable == null) {
                return false;
            }
            if (StringUtils.equals((String)enable, (String)"true")) {
                return true;
            }
            if (StringUtils.equals((String)enable, (String)"LR")) {
                return true;
            }
            return StringUtils.equals((String)enable, (String)"RL");
        }
        return false;
    }

    public String toString() {
        return this.videoID + "/" + this.title;
    }

    public YoutubeClipData(String videoID) {
        this.videoID = videoID;
    }

    public boolean copyTo(YoutubeClipData dest) {
        if (dest.videoID == null || StringUtils.equals((String)this.videoID, (String)dest.videoID)) {
            dest.videoID = this.videoID;
            dest.title = this.title;
            dest.title_alternative = this.title_alternative;
            dest.category = this.category;
            dest.channelTitle = this.channelTitle;
            dest.chapters = this.chapters;
            dest.channelTitle_alternative = this.channelTitle_alternative;
            dest.channelSize = this.channelSize;
            dest.user = this.user;
            dest.atID = this.atID;
            dest.user_alternative = this.user_alternative;
            dest.bestVideoItag = this.bestVideoItag;
            dest.datePublished = this.datePublished;
            dest.dateLivestreamStart = this.dateLivestreamStart;
            dest.dateLivestreamEnd = this.dateLivestreamEnd;
            dest.userGooglePlusID = this.userGooglePlusID;
            dest.channelID = this.channelID;
            dest.duration = this.duration;
            dest.dateUploaded = this.dateUploaded;
            dest.views = this.views;
            dest.description = this.description;
            dest.description_alternative = this.description_alternative;
            dest.streams = this.streams;
            dest.subtitles = this.subtitles;
            dest.keywords = this.keywords;
            dest.keywords3D = this.keywords3D;
            dest.error = this.error;
            dest.ageCheck = this.ageCheck;
            dest.approxThreedLayout = this.approxThreedLayout;
            return true;
        }
        return false;
    }

    public void copyToDownloadLink(DownloadLink dest) {
        this.setValue(dest, "YT_TITLE", this.title);
        this.setValue(dest, "YT_TITLE_ALTERNATIVE", this.title_alternative);
        this.setValue(dest, "YT_CATEGORY", this.category);
        this.setValue(dest, "YT_3D", this.is3D());
        this.setValue(dest, "YT_CHANNEL", this.channelTitle);
        this.setValue(dest, "YT_CHANNEL_ALTERNATIVE", this.channelTitle_alternative);
        this.setValue(dest, "YT_CHANNEL_SIZE", this.channelSize);
        this.setValue(dest, "YT_USER_NAME", this.user);
        this.setValue(dest, "YT_USER_NAME_ALTERNATIVE", this.user_alternative);
        if (this.bestVideoItag != null) {
            this.setValue(dest, "YT_BEST_VIDEO", this.bestVideoItag.getBaseVariant().getiTagVideo().name());
            this.setValue(dest, "YT_BEST_VIDEO_HEIGHT", String.valueOf(this.bestVideoItag.getVideoHeight()));
        }
        this.setValue(dest, "YT_CHAPTERS", this.chapters);
        this.setValue(dest, "YT_DATE", this.datePublished);
        this.setValue(dest, "YT_GOOGLE_PLUS_ID", this.userGooglePlusID);
        this.setValue(dest, "YT_CHANNEL_ID", this.channelID);
        this.setValue(dest, "YT_@ID", this.atID);
        this.setValue(dest, "YT_DURATION", this.duration);
        this.setValue(dest, "YT_DATE_UPDATE", this.dateUploaded);
        this.setValue(dest, "YT_DATE_LIVESTREAM_START", this.dateLivestreamStart);
        this.setValue(dest, "YT_DATE_LIVESTREAM_END", this.dateLivestreamEnd);
        this.setValue(dest, "YT_VIEWS", this.views);
        dest.getTempProperties().setProperty("YT_DESCRIPTION", this.description);
        dest.getTempProperties().setProperty("YT_DESCRIPTION_ALTERNATIVE", this.description_alternative);
    }

    protected boolean setValue(DownloadLink dest, String key, Object value) {
        if (dest.hasProperty(key) || value == null) {
            return false;
        }
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                return false;
            }
            dest.setProperty(key, value);
            return true;
        }
        if (value instanceof Number) {
            if (((Number)value).longValue() == -1L) {
                return false;
            }
            dest.setProperty(key, value);
            return true;
        }
        dest.setProperty(key, value);
        return true;
    }

    public StreamCollection getStreams(YoutubeITAG itag, AbstractVariant variant) {
        List<YoutubeITAG> alternatives;
        if (itag == null) {
            return null;
        }
        StreamCollection ret = this.streams.get((Object)itag);
        if (ret == null && (alternatives = YoutubeITAG.getTagList(itag.getITAG())) != null) {
            YoutubeITAG tag;
            Iterator<YoutubeITAG> iterator = alternatives.iterator();
            while (iterator.hasNext() && (ret = this.streams.get((Object)(tag = iterator.next()))) == null) {
            }
        }
        if (ret != null && itag.getAudioCodec() != null && variant instanceof AudioInterface) {
            String audioId = ((AudioInterface)((Object)variant)).getAudioId();
            ret = this.splitByLngId(ret).get(audioId);
        }
        return ret;
    }

    public List<VariantInfo> findSubtitleVariants() {
        ArrayList<VariantInfo> allSubtitles = new ArrayList<VariantInfo>();
        for (YoutubeSubtitleStorable si : this.subtitles) {
            SubtitleVariantInfo vi = new SubtitleVariantInfo(new SubtitleVariant(si), this);
            allSubtitles.add(vi);
        }
        return allSubtitles;
    }

    public ArrayList<VariantInfo> findDescriptionVariant() {
        ArrayList<VariantInfo> descriptions = new ArrayList<VariantInfo>();
        String descText = this.description;
        if (StringUtils.isNotEmpty((String)descText)) {
            DescriptionVariantInfo vi = new DescriptionVariantInfo(descText, this);
            descriptions.add(vi);
        }
        return descriptions;
    }

    private Map<String, StreamCollection> splitByLngId(StreamCollection collection) {
        HashMap<String, StreamCollection> map = new HashMap<String, StreamCollection>();
        for (YoutubeStreamData stream : collection) {
            String lng = stream.getLngId();
            StreamCollection col = (StreamCollection)map.get(lng);
            if (col == null) {
                col = new StreamCollection();
                map.put(lng, col);
            }
            col.add(stream);
        }
        return map;
    }

    public List<VariantInfo> findVariants() {
        return this.findVariants(this.streams);
    }

    public List<VariantInfo> findVariants(Map<YoutubeITAG, StreamCollection> streams) {
        ArrayList<VariantInfo> ret = new ArrayList<VariantInfo>();
        for (VariantBase v : VariantBase.values()) {
            boolean valid;
            if (v.isVideoToolRequired() && !CFG_YOUTUBE.CFG.isExternMultimediaToolUsageEnabled() || !v.isValidFor(this)) continue;
            StreamCollection audios = null;
            StreamCollection video = null;
            StreamCollection data = null;
            boolean bl = valid = v.getiTagVideo() != null || v.getiTagAudio() != null || v.getiTagData() != null;
            if (v.getiTagVideo() != null && (video = streams.get((Object)v.getiTagVideo())) == null) {
                valid = false;
            }
            if (v.getiTagAudio() != null && (audios = streams.get((Object)v.getiTagAudio())) == null) {
                valid = false;
            }
            if (v.getiTagData() != null && (data = streams.get((Object)v.getiTagData())) == null) {
                valid = false;
            }
            if (!valid) continue;
            if (audios != null) {
                for (StreamCollection audio : this.splitByLngId(audios).values()) {
                    AbstractVariant abstractVariant = AbstractVariant.get(v, this, audio, video, data);
                    if (abstractVariant == null) continue;
                    VariantInfo vi = new VariantInfo(abstractVariant, audio, video, data);
                    ret.add(vi);
                }
                continue;
            }
            AbstractVariant abstractVariant = AbstractVariant.get(v, this, audios, video, data);
            if (abstractVariant == null) continue;
            VariantInfo vi = new VariantInfo(abstractVariant, audios, video, data);
            ret.add(vi);
        }
        return ret;
    }
}

