/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.components.youtube.YoutubeHelper;

public abstract class YoutubeReplacer {
    private final String[] tags;
    private DataOrigin[] dataOrigins = null;

    public String[] getTags() {
        return this.tags;
    }

    public abstract String getDescription();

    public YoutubeReplacer(String ... tags) {
        this.tags = tags;
    }

    public String toString() {
        return String.valueOf(Arrays.asList(this.tags));
    }

    public String replace(String name, YoutubeHelper helper, DownloadLink link) {
        for (String tag : this.tags) {
            String usedTag;
            while ((usedTag = new Regex(name, "\\*" + tag + "\\*").getMatch(-1)) != null || (usedTag = new Regex(name, "\\*" + tag + "\\[[^\\]]*\\]\\*").getMatch(-1)) != null) {
                String value;
                ArrayList<TagTasks> performTasks = new ArrayList<TagTasks>();
                String[] mods = new Regex(usedTag, "(?:\\[(.*?)\\])").getColumn(0);
                if (mods != null && mods.length > 0) {
                    value = null;
                    for (String mod : mods) {
                        if ("UC".equalsIgnoreCase(mod) && !performTasks.contains((Object)TagTasks.TO_LOWERCASE)) {
                            performTasks.add(TagTasks.TO_UPPERCASE);
                            continue;
                        }
                        if ("LC".equalsIgnoreCase(mod) && !performTasks.contains((Object)TagTasks.TO_UPPERCASE)) {
                            performTasks.add(TagTasks.TO_LOWERCASE);
                            continue;
                        }
                        if ("SU".equalsIgnoreCase(mod)) {
                            performTasks.add(TagTasks.WHITESPACE_TO_UNDERSCORE);
                            continue;
                        }
                        value = this.getValue(link, helper, mod);
                    }
                    if (value != null) {
                        if (performTasks.contains((Object)TagTasks.TO_LOWERCASE)) {
                            value = value.toLowerCase(Locale.ENGLISH);
                        } else if (performTasks.contains((Object)TagTasks.TO_UPPERCASE)) {
                            value = value.toUpperCase(Locale.ENGLISH);
                        }
                        if (performTasks.contains((Object)TagTasks.WHITESPACE_TO_UNDERSCORE)) {
                            value = value.replaceAll("\\s+", "_");
                        }
                        name = YoutubeReplacer.optimizedReduceSpacesReplace(name, usedTag, value);
                        continue;
                    }
                }
                if ((value = this.getValue(link, helper, null)) != null) {
                    if (value != null && performTasks.contains((Object)TagTasks.TO_LOWERCASE)) {
                        value = value.toLowerCase(Locale.ENGLISH);
                    } else if (performTasks.contains((Object)TagTasks.TO_UPPERCASE)) {
                        value = value.toUpperCase(Locale.ENGLISH);
                    }
                    if (performTasks.contains((Object)TagTasks.WHITESPACE_TO_UNDERSCORE)) {
                        value = value.replaceAll("\\s+", "_");
                    }
                }
                if (StringUtils.isEmpty((String)value)) {
                    name = YoutubeReplacer.optimizedReduceSpacesReplace(name, usedTag, null);
                    continue;
                }
                name = YoutubeReplacer.optimizedReduceSpacesReplace(name, usedTag, value);
            }
        }
        return name;
    }

    private static String optimizedReduceSpacesReplace(String input, String search, String replace) {
        if (replace != null) {
            return input.replace(search, replace);
        }
        String qSearch = Pattern.quote(search);
        String ret = input.replaceAll("\\s" + qSearch + "((p|fps|kbit)?(_|\\-)?)?\\s", " ");
        ret = ret.replaceAll("^" + qSearch + "((p|fps|kbit)?\\s*(_|\\-)?)?\\s*", "");
        ret = ret.replaceAll("\\s*\\." + qSearch + "$", "");
        ret = ret.replaceAll(qSearch + "((p|fps|kbit)?(_|\\-)?)?", "");
        return ret;
    }

    protected abstract String getValue(DownloadLink var1, YoutubeHelper var2, String var3);

    public boolean isExtendedRequired() {
        return false;
    }

    public DataSource getDataSource() {
        return DataSource.WEBSITE;
    }

    public DataOrigin[] getDataOrigins() {
        return this.dataOrigins;
    }

    public void setDataOrigins(DataOrigin ... dataOrigins) {
        this.dataOrigins = dataOrigins;
    }

    public boolean matches(String checkName) {
        for (String tag : this.tags) {
            if (!Pattern.compile("\\*" + tag + "[^\\*]*\\*", 2).matcher(checkName).find()) continue;
            return true;
        }
        return false;
    }

    public static enum DataOrigin {
        YT_CHANNEL,
        YT_PLAYLIST,
        YT_SINGLE_VIDEO;

    }

    public static enum DataSource {
        WEBSITE,
        API_VIDEOS,
        API_USERS;

    }

    public static enum TagTasks {
        TO_UPPERCASE,
        TO_LOWERCASE,
        WHITESPACE_TO_UNDERSCORE;

    }
}

