/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.itag;

import org.appwork.storage.config.annotations.IntegerInterface;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.components.youtube.YT_STATICS;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;

public enum AudioBitrate implements IntegerInterface,
LabelInterface
{
    KBIT_512(512),
    KBIT_384(384),
    KBIT_256(256),
    KBIT_192(192),
    KBIT_160(160),
    KBIT_152(152),
    KBIT_128(128),
    KBIT_96(96),
    KBIT_64(64),
    KBIT_48(48),
    KBIT_32(32),
    KBIT_32_ESTIMATED(31),
    KBIT_24(24),
    KBIT_12(12);

    private final int kbit;

    private AudioBitrate(int kbit) {
        this.kbit = kbit;
    }

    public final int getKbit() {
        return this.kbit;
    }

    public final String getLabel() {
        return this.kbit + " kbit/s";
    }

    public final int getInt() {
        return this.kbit;
    }

    public static AudioBitrate getByVariant(AbstractVariant o1) {
        if (o1 instanceof AudioInterface) {
            return ((AudioInterface)((Object)o1)).getAudioBitrate();
        }
        return null;
    }

    public static int getSortId(AbstractVariant v) {
        AudioBitrate res = AudioBitrate.getByVariant(v);
        if (res == null) {
            return -1;
        }
        Number intObj = YT_STATICS.SORTIDS_AUDIO_BITRATE.get((Object)res);
        if (intObj == null) {
            return -1;
        }
        return intObj.intValue();
    }

    public static AudioBitrate getByInt(int bitrate) {
        AudioBitrate best = null;
        double bucketPercentage = 0.1;
        AudioBitrate[] values = AudioBitrate.values();
        for (int index = values.length - 1; index >= 0; --index) {
            AudioBitrate rate = values[index];
            if (best == null) {
                best = rate;
                continue;
            }
            if (bitrate >= rate.getKbit() * 1000) {
                best = rate;
                continue;
            }
            if (!((double)bitrate >= (double)(rate.getKbit() * 1024) * 0.9)) continue;
            best = rate;
        }
        return best;
    }
}

