/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.itag;

import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.components.youtube.YT_STATICS;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;

public enum AudioType implements LabelInterface
{
    ORIGINAL("Original"),
    DUBBED("Dubbed"),
    DUBBED_AUTO("Dubbed Auto");

    private final String label;

    private AudioType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public static AudioType getAudioType(AudioInterface variant) {
        String lngId = variant.getAudioId();
        if (lngId == null) {
            return null;
        }
        if (lngId.endsWith(".10")) {
            return DUBBED_AUTO;
        }
        if (lngId.endsWith(".4")) {
            return ORIGINAL;
        }
        if (lngId.endsWith(".3")) {
            return DUBBED;
        }
        return null;
    }

    private static AudioType getByVariant(AbstractVariant o1) {
        if (o1 instanceof AudioInterface) {
            return AudioType.getAudioType((AudioInterface)((Object)o1));
        }
        return null;
    }

    public static int getSortId(AbstractVariant v) {
        AudioType res = AudioType.getByVariant(v);
        if (res == null) {
            return -1;
        }
        Number intObj = YT_STATICS.SORTIDS_AUDIO_TYPE.get((Object)res);
        if (intObj == null) {
            return -1;
        }
        return intObj.intValue();
    }
}

