/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import java.util.List;
import javax.swing.Icon;
import jd.plugins.DownloadLink;
import org.appwork.exceptions.WTFException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeConfig;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.components.youtube.variants.generics.ImageGenericInfo;
import org.jdownloader.plugins.config.PluginJsonConfig;

public class ImageVariant
extends AbstractVariant<ImageGenericInfo> {
    protected static final Icon IMAGE = new AbstractIcon("image", 16);

    public ImageVariant(VariantBase base) {
        super(base);
    }

    @Override
    public void setJson(String jsonString) {
        this.setGenericInfo(new ImageGenericInfo());
    }

    @Override
    protected void fill(YoutubeClipData vid, List<YoutubeStreamData> audio, List<YoutubeStreamData> video, List<YoutubeStreamData> data) {
    }

    @Override
    public String getFileNamePattern(DownloadLink downloadLink) {
        return PluginJsonConfig.get(YoutubeConfig.class).getImageFilenamePattern();
    }

    @Override
    public Icon _getIcon(Object caller) {
        return IMAGE;
    }

    @Override
    public String _getName(Object caller) {
        return _GUI.T.Youtube_imagevariant_name(this.getBaseVariant().getiTagData().getImageQuality().getLocaleName());
    }

    @Override
    public String getFileNameQualityTag() {
        return this.getBaseVariant().getiTagData().getImageQuality().getLocaleTag();
    }

    @Override
    public String getTypeId() {
        return this.getBaseVariant().name();
    }

    public int getWidth() {
        switch (this.getBaseVariant()) {
            case IMAGE_HQ: {
                return 480;
            }
            case IMAGE_LQ: {
                return 120;
            }
            case IMAGE_MAX: {
                return 1280;
            }
            case IMAGE_MQ: {
                return 320;
            }
        }
        throw new WTFException("Unsupported:" + (Object)((Object)this.getBaseVariant()));
    }

    public int getHeight() {
        switch (this.getBaseVariant()) {
            case IMAGE_HQ: {
                return 360;
            }
            case IMAGE_LQ: {
                return 90;
            }
            case IMAGE_MAX: {
                return 720;
            }
            case IMAGE_MQ: {
                return 180;
            }
        }
        throw new WTFException("Unsupported:" + (Object)((Object)this.getBaseVariant()));
    }
}

