/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.config;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import jd.config.SubConfiguration;
import jd.plugins.DecrypterPlugin;
import jd.plugins.HostPlugin;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.Storage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.InterfaceParseException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.annotations.CryptedStorage;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.TakeValueFromSubconfig;
import org.jdownloader.plugins.config.Type;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class PluginJsonConfig {
    private static final WeakHashMap<ClassLoader, HashMap<String, WeakReference<ConfigInterface>>> CONFIG_CACHE = new WeakHashMap();
    private static final HashMap<String, JsonKeyValueStorage> STORAGE_CACHE = new HashMap();
    protected static final DelayedRunnable SAVEDELAYER = new DelayedRunnable(5000L, 30000L){

        public void delayedrun() {
            PluginJsonConfig.saveAll();
            PluginJsonConfig.cleanup();
        }
    };
    private static final boolean DEBUG = false;

    private static synchronized void saveAll() {
        HashMap<String, JsonKeyValueStorage> storages = STORAGE_CACHE;
        Iterator<Map.Entry<String, JsonKeyValueStorage>> it = storages.entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().save();
        }
    }

    private static synchronized void cleanup() {
        CONFIG_CACHE.size();
    }

    public static synchronized <T extends PluginConfigInterface> T get(Class<T> configInterface) {
        return PluginJsonConfig.get(null, configInterface);
    }

    public static synchronized <T extends PluginConfigInterface> T get(LazyPlugin<?> lazyPlugin, Class<T> configInterface) {
        ClassLoader cl;
        Type type;
        String host = null;
        PluginHost hostAnnotation = configInterface.getAnnotation(PluginHost.class);
        if (hostAnnotation != null) {
            host = hostAnnotation.host();
            type = hostAnnotation.type();
        } else {
            LazyPlugin plugin;
            String[] names;
            Annotation anno;
            Class<?> enc = configInterface.getEnclosingClass();
            if (enc == null) {
                throw new WTFException("Bad Config Interface Definition. " + configInterface.getName() + ". @PluginHost(\"domain.de\") or    public Class<? extends UsenetConfigInterface> getConfigInterface() {... is missing");
            }
            if (PluginForHost.class.isAssignableFrom(enc)) {
                type = Type.HOSTER;
                anno = enc.getAnnotation(HostPlugin.class);
                names = anno.names();
                if (names.length == 0) {
                    plugin = null;
                    for (LazyHostPlugin lazyHostPlugin : HostPluginController.getInstance().list()) {
                        if (!StringUtils.equals((String)enc.getName(), (String)lazyHostPlugin.getClassName())) continue;
                        if (plugin == null) {
                            plugin = lazyHostPlugin;
                            continue;
                        }
                        plugin = null;
                        break;
                    }
                    if (plugin != null) {
                        host = plugin.getDisplayName();
                    }
                } else if (names.length == 1) {
                    host = names[0];
                }
                if (StringUtils.isEmpty((String)host)) {
                    throw new WTFException("Bad Config Interface Definition. " + enc + " defines " + names.length + " Hosts. you have to define an own config interface class for each one and use the @PluginHost(\"domain.de\") Annotation");
                }
            } else if (PluginForDecrypt.class.isAssignableFrom(enc)) {
                type = Type.CRAWLER;
                anno = enc.getAnnotation(DecrypterPlugin.class);
                names = anno.names();
                if (names.length == 0) {
                    plugin = null;
                    for (LazyCrawlerPlugin lazyCrawlerPlugin : CrawlerPluginController.getInstance().list()) {
                        if (!StringUtils.equals((String)enc.getName(), (String)lazyCrawlerPlugin.getClassName())) continue;
                        if (plugin == null) {
                            plugin = lazyCrawlerPlugin;
                            continue;
                        }
                        plugin = null;
                        break;
                    }
                    if (plugin != null) {
                        host = plugin.getDisplayName();
                    }
                } else if (names.length == 1) {
                    host = names[0];
                }
                if (StringUtils.isEmpty((String)host)) {
                    throw new WTFException("Bad Config Interface Definition. " + enc + " defines " + names.length + " Hosts. you have to define an own config interface class for each one and use the @PluginHost(\"domain.de\") Annotation");
                }
            } else {
                type = null;
            }
        }
        String ID2 = JsonConfig.getStorageName(configInterface);
        if (ID2.equals(configInterface.getName())) {
            ID2 = (Object)((Object)type) + "/" + host;
        }
        if (!((cl = configInterface.getClassLoader()) instanceof PluginClassLoader.PluginClassLoaderChild)) {
            File storageFile = Application.getResource((String)("cfg/plugins/" + ID2));
            return (T)((PluginConfigInterface)JsonConfig.create((File)storageFile, configInterface));
        }
        HashMap<String, WeakReference<Object>> classLoaderMap = CONFIG_CACHE.get(cl);
        if (classLoaderMap == null) {
            classLoaderMap = new HashMap();
            CONFIG_CACHE.put(cl, classLoaderMap);
        }
        WeakReference<ConfigInterface> ret = classLoaderMap.get(ID2);
        ConfigInterface intf = null;
        if (ret != null && (intf = (ConfigInterface)ret.get()) != null) {
            return (T)((PluginConfigInterface)intf);
        }
        JsonKeyValueStorage storage = STORAGE_CACHE.get(ID2);
        if (storage == null) {
            File storageFile = Application.getResource((String)("cfg/plugins/" + ID2));
            storage = StorageHandler.createPrimitiveStorage((File)storageFile, null, configInterface);
            storage.setEnumCacheEnabled(false);
            STORAGE_CACHE.put(ID2, storage);
        }
        StorageHandler storageHandler = new StorageHandler<T>((Storage)storage, configInterface){

            protected void error(final Throwable e) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    new Thread("ERROR THROWER"){

                        @Override
                        public void run() {
                            Dialog.getInstance().showExceptionDialog(e.getClass().getSimpleName(), e.getMessage(), e);
                        }
                    }.start();
                }
            }

            protected void requestSave() {
                SAVEDELAYER.resetAndStart();
            }

            protected void addStorageHandler(StorageHandler<? extends ConfigInterface> storageHandler, String interfaceName, String storage) {
            }

            protected void validateKeys(CryptedStorage crypted) {
                if (this.getPrimitiveStorage() != null && !Arrays.equals(this.getPrimitiveStorage().getCryptKey(), crypted == null ? JSonStorage.KEY : crypted.key())) {
                    throw new InterfaceParseException("Key Mismatch!");
                }
            }
        };
        intf = (PluginConfigInterface)Proxy.newProxyInstance(configInterface.getClassLoader(), new Class[]{configInterface}, (InvocationHandler)storageHandler);
        classLoaderMap.put(ID2, new WeakReference<ConfigInterface>(intf));
        SubConfiguration oldSub = SubConfiguration.getConfig(host);
        if (oldSub != null) {
            for (KeyHandler handler : storageHandler.getKeyHandler()) {
                TakeValueFromSubconfig takeFrom = (TakeValueFromSubconfig)handler.getAnnotation(TakeValueFromSubconfig.class);
                if (takeFrom == null || !oldSub.hasProperty(takeFrom.value())) continue;
                Object value = oldSub.getProperty(takeFrom.value());
                value = JSonStorage.convert((Object)value, (TypeRef)new TypeRef<Object>(handler.getRawType()){});
                handler.setValue(value);
                oldSub.removeProperty(takeFrom.value());
            }
        }
        return (T)((PluginConfigInterface)intf);
    }

    static {
        File pluginsFolder = Application.getResource((String)"cfg/plugins/");
        if (!pluginsFolder.exists()) {
            pluginsFolder.mkdirs();
        }
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public long getMaxDuration() {
                return 0L;
            }

            public int getHookPriority() {
                return 0;
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                PluginJsonConfig.saveAll();
            }

            public String toString() {
                return "ShutdownEvent: SaveAllPluginJsonConfig";
            }
        });
    }
}

