/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller;

import jd.plugins.DecrypterPlugin;
import jd.plugins.HostPlugin;
import jd.plugins.Plugin;
import org.appwork.utils.Application;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class PluginInfo<T extends Plugin> {
    private final Class<T> clazz;
    private final LazyPlugin<T> lazyPlugin;
    private final LazyPluginClass lazyPluginClass;
    private final String simpleName;
    private final String[] names;
    private final boolean valid;
    private static final boolean isJava16orOlder = Application.getJavaVersion() <= Application.JAVA16;
    private String[] patterns;
    private final String clazzName;

    public boolean isValid() {
        return this.valid;
    }

    public String[] getNames() {
        if (this.lazyPlugin != null) {
            return new String[]{this.lazyPlugin.getDisplayName()};
        }
        return this.names;
    }

    public String[] getPatterns() {
        if (this.lazyPlugin != null) {
            return new String[]{this.lazyPlugin.getPatternSource()};
        }
        return this.patterns;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public final LazyPluginClass getLazyPluginClass() {
        return this.lazyPluginClass;
    }

    public PluginInfo(LazyPluginClass lazyPluginClass, LazyPlugin<T> lazyPlugin) {
        this.lazyPluginClass = lazyPluginClass;
        this.lazyPlugin = lazyPlugin;
        boolean valid = false;
        this.simpleName = lazyPluginClass.getClassName();
        if (lazyPlugin != null) {
            this.clazzName = lazyPlugin.getClassName();
            if (lazyPlugin instanceof LazyHostPlugin) {
                valid = true;
            } else if (lazyPlugin instanceof LazyCrawlerPlugin) {
                valid = true;
            }
        } else {
            this.clazzName = null;
        }
        this.valid = valid;
        this.clazz = null;
        this.patterns = new String[0];
        this.names = new String[0];
    }

    public PluginInfo(LazyPluginClass lazyPluginClass, Class<T> clazz) {
        DecrypterPlugin decrypter;
        this.lazyPlugin = null;
        this.lazyPluginClass = lazyPluginClass;
        this.simpleName = new String(clazz.getSimpleName());
        this.clazzName = clazz.getName();
        String[] names = null;
        String[] patterns = null;
        boolean valid = false;
        if (this.clazzName.startsWith("jd.plugins.hoster")) {
            HostPlugin hoster = clazz.getAnnotation(HostPlugin.class);
            if (hoster != null) {
                valid = true;
                names = hoster.names();
                patterns = hoster.urls();
            }
        } else if (this.clazzName.startsWith("jd.plugins.decrypter") && (decrypter = clazz.getAnnotation(DecrypterPlugin.class)) != null) {
            valid = true;
            names = decrypter.names();
            patterns = decrypter.urls();
        }
        if (names == null) {
            names = new String[]{};
        }
        if (patterns == null) {
            patterns = new String[]{};
        }
        this.valid = valid;
        this.names = names;
        this.patterns = patterns;
        this.clazz = isJava16orOlder ? null : clazz;
    }

    public final Class<T> getClazz() {
        return this.clazz;
    }

    public LazyPlugin<T> getLazyPlugin() {
        return this.lazyPlugin;
    }
}

