/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.crawler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jd.nutils.Formatter;
import jd.plugins.DecrypterPlugin;
import jd.plugins.PluginForDecrypt;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.utils.Application;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.PluginController;
import org.jdownloader.plugins.controller.PluginInfo;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPluginCache;

public class CrawlerPluginController
extends PluginController<PluginForDecrypt> {
    private static final String PLUGIN_PATH = "jd/plugins/decrypter";
    private static final Object INSTANCELOCK = new Object();
    private static volatile MinTimeWeakReference<CrawlerPluginController> INSTANCE = null;
    private static final AtomicBoolean CACHE_INVALIDATED = new AtomicBoolean(false);
    private static final ModifyLock LOCK = new ModifyLock();
    private static final AtomicLong LATESTVERSION = new AtomicLong(0L);
    private volatile List<LazyCrawlerPlugin> list = null;
    private final long currentVersion = LATESTVERSION.incrementAndGet();
    private final AtomicLong lastModification = new AtomicLong(-1L);
    public static final ThreadLocal<Map<String, Object>> PLUGIN_UPDATE_CACHE = new ThreadLocal();

    public static boolean isCacheInvalidated() {
        return CACHE_INVALIDATED.get();
    }

    public static void invalidateCache() {
        CACHE_INVALIDATED.set(true);
    }

    protected static void validateCache() {
        CACHE_INVALIDATED.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrawlerPluginController getInstance() {
        CrawlerPluginController ret = null;
        MinTimeWeakReference<CrawlerPluginController> localInstance = INSTANCE;
        if (localInstance != null && (ret = (CrawlerPluginController)localInstance.get()) != null) {
            return ret;
        }
        Object object = INSTANCELOCK;
        synchronized (object) {
            localInstance = INSTANCE;
            if (localInstance != null && (ret = (CrawlerPluginController)localInstance.get()) != null) {
                return ret;
            }
            ret = new CrawlerPluginController();
            INSTANCE = new MinTimeWeakReference((Object)ret, 30000L, "CrawlerPlugin");
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        this.save(this.list, new AtomicLong(this.lastModification.get()));
    }

    private String getCache() {
        return "crawlerCache";
    }

    private CrawlerPluginController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LazyCrawlerPlugin> init() {
        Object object = INSTANCELOCK;
        synchronized (object) {
            final LogSource logger = LogController.CL(false);
            logger.info("CrawlerPluginController: init");
            logger.setAllowTimeoutFlush(false);
            logger.setAutoFlushOnThrowable(true);
            return (List)new NonInterruptibleRunnable<List<LazyCrawlerPlugin>, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<LazyCrawlerPlugin> run() throws RuntimeException, InterruptedException {
                    LogController.setRebirthLogger((LogInterface)logger);
                    long completeTimeStamp = System.currentTimeMillis();
                    try {
                        List updateCache = null;
                        long timeStamp = System.currentTimeMillis();
                        try {
                            updateCache = CrawlerPluginController.this.loadFromCache(CrawlerPluginController.this.lastModification);
                        }
                        catch (Throwable e) {
                            CrawlerPluginController.this.lastModification.set(-1L);
                            logger.log(e);
                            logger.severe("@CrawlerPluginController: cache failed!");
                        }
                        finally {
                            if (updateCache != null && updateCache.size() > 0) {
                                logger.info("@CrawlerPluginController: loadFromCache took " + (System.currentTimeMillis() - timeStamp) + "ms for " + updateCache.size() + "|LastModified:" + CrawlerPluginController.this.lastModification.get());
                            }
                        }
                        ArrayList plugins = null;
                        timeStamp = System.currentTimeMillis();
                        try {
                            PLUGIN_UPDATE_CACHE.set(new HashMap());
                            plugins = CrawlerPluginController.this.update(logger, updateCache, CrawlerPluginController.this.lastModification);
                        }
                        catch (Throwable e) {
                            CrawlerPluginController.this.lastModification.set(-1L);
                            logger.log(e);
                            logger.severe("@CrawlerPluginController: update failed!");
                        }
                        finally {
                            PLUGIN_UPDATE_CACHE.set(null);
                            if (plugins != null && plugins.size() > 0) {
                                logger.info("@CrawlerPluginController: update took " + (System.currentTimeMillis() - timeStamp) + "ms for " + plugins.size() + "|LastModified:" + CrawlerPluginController.this.lastModification.get());
                            }
                        }
                        if (plugins == null || plugins.size() == 0) {
                            if (plugins == null) {
                                plugins = new ArrayList();
                            }
                            logger.severe("@CrawlerPluginController: WTF, no plugins!");
                        }
                        for (LazyCrawlerPlugin plugin : plugins) {
                            plugin.setPluginClass(null);
                            plugin.setClassLoader(null);
                        }
                        CrawlerPluginController.this.list = plugins;
                    }
                    catch (Throwable throwable) {
                        CrawlerPluginController.validateCache();
                        LogController.setRebirthLogger(null);
                        List llist = CrawlerPluginController.this.list;
                        if (llist != null) {
                            logger.info("@CrawlerPluginController: init took " + (System.currentTimeMillis() - completeTimeStamp) + "ms for " + llist.size());
                        } else {
                            logger.info("@CrawlerPluginController: init took " + (System.currentTimeMillis() - completeTimeStamp));
                        }
                        logger.close();
                        if (llist != null) {
                            AtomicLong lastModification = new AtomicLong(CrawlerPluginController.this.lastModification.get());
                            Thread saveThread = new Thread("@CrawlerPluginController: save", llist, lastModification){
                                final /* synthetic */ List val$llist;
                                final /* synthetic */ AtomicLong val$lastModification;
                                {
                                    this.val$llist = list;
                                    this.val$lastModification = atomicLong;
                                    super(x0);
                                }

                                @Override
                                public void run() {
                                    CrawlerPluginController.this.save(this.val$llist, this.val$lastModification);
                                }
                            };
                            saveThread.setDaemon(true);
                            saveThread.start();
                        }
                        throw throwable;
                    }
                    CrawlerPluginController.validateCache();
                    LogController.setRebirthLogger(null);
                    List llist = CrawlerPluginController.this.list;
                    if (llist != null) {
                        logger.info("@CrawlerPluginController: init took " + (System.currentTimeMillis() - completeTimeStamp) + "ms for " + llist.size());
                    } else {
                        logger.info("@CrawlerPluginController: init took " + (System.currentTimeMillis() - completeTimeStamp));
                    }
                    logger.close();
                    if (llist != null) {
                        AtomicLong lastModification = new AtomicLong(CrawlerPluginController.this.lastModification.get());
                        Thread saveThread = new /* invalid duplicate definition of identical inner class */;
                        saveThread.setDaemon(true);
                        saveThread.start();
                    }
                    System.gc();
                    return CrawlerPluginController.this.list;
                }
            }.startAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LazyCrawlerPlugin> loadFromCache(AtomicLong lastFolderModification) throws IOException {
        boolean readL = LOCK.readLock();
        try {
            List<LazyCrawlerPlugin> list = LazyCrawlerPluginCache.read(Application.getTempResource((String)this.getCache()), lastFolderModification);
            return list;
        }
        finally {
            LOCK.readUnlock(readL);
        }
    }

    protected Map<String, LazyCrawlerPlugin> buildFastAccessCache(List<LazyCrawlerPlugin> updateCache) {
        if (updateCache != null && updateCache.size() > 0) {
            HashMap<String, LazyCrawlerPlugin> ret = new HashMap<String, LazyCrawlerPlugin>();
            for (LazyCrawlerPlugin cachedPlugin : updateCache) {
                ret.put(cachedPlugin.getID(), cachedPlugin);
            }
            return ret;
        }
        return null;
    }

    @Override
    protected String getPluginPath() {
        return PLUGIN_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LazyCrawlerPlugin> update(LogSource logger, List<LazyCrawlerPlugin> updateCache, AtomicLong lastFolderModification) throws Exception {
        ArrayList<LazyCrawlerPlugin> retList = new ArrayList<LazyCrawlerPlugin>();
        Map<String, LazyCrawlerPlugin> fastAccessCache = this.buildFastAccessCache(updateCache);
        for (PluginInfo pluginInfo : this.scan(logger, updateCache, lastFolderModification)) {
            if (pluginInfo.getLazyPlugin() != null) {
                LazyCrawlerPlugin plugin = (LazyCrawlerPlugin)pluginInfo.getLazyPlugin();
                retList.add(plugin);
                continue;
            }
            String simpleName = pluginInfo.getSimpleName();
            if (pluginInfo.isValid()) {
                try {
                    PluginClassLoader.PluginClassLoaderChild classLoader = Application.getJavaVersion() <= Application.JAVA16 || pluginInfo.getClazz() == null ? PluginClassLoader.getInstance().getChild() : (PluginClassLoader.PluginClassLoaderChild)pluginInfo.getClazz().getClassLoader();
                    long revision = pluginInfo.getLazyPluginClass().getRevision();
                    String[] names = pluginInfo.getNames();
                    String[] patterns = pluginInfo.getPatterns();
                    if (names.length == 0) {
                        Class<Object> clazz = pluginInfo.getClazz();
                        if (clazz == null) {
                            clazz = classLoader.loadClass(pluginInfo.getClazzName());
                        }
                        patterns = (String[])clazz.getDeclaredMethod("getAnnotationUrls", new Class[0]).invoke(null, new Object[0]);
                        names = (String[])clazz.getDeclaredMethod("getAnnotationNames", new Class[0]).invoke(null, new Object[0]);
                    }
                    if (patterns.length != names.length) {
                        throw new WTFException("Plugin: " + simpleName + "(" + revision + ")|Error:names.length(" + names.length + ") != patterns.length(" + patterns.length + ")");
                    }
                    if (names.length == 0) {
                        throw new WTFException("Plugin: " + simpleName + "(" + revision + ")|Error:names.length(0)");
                    }
                    classLoader.setCreateDummyLibs(false);
                    classLoader.setMapStaticFields(false);
                    for (int i = 0; i < names.length; ++i) {
                        LazyPlugin lazyCrawlerPlugin = null;
                        try {
                            LazyCrawlerPlugin previousLazyCrawlerPlugin;
                            lazyCrawlerPlugin = new LazyCrawlerPlugin(pluginInfo.getLazyPluginClass(), new String(patterns[i]), new String(names[i]), pluginInfo.getClazz(), classLoader);
                            if (fastAccessCache != null && (previousLazyCrawlerPlugin = fastAccessCache.get(lazyCrawlerPlugin.getID())) != null) {
                                ((LazyCrawlerPlugin)lazyCrawlerPlugin).setPluginUsage(previousLazyCrawlerPlugin.getPluginUsage());
                            }
                            try {
                                classLoader.setPluginClass(simpleName);
                                PluginForDecrypt plg = ((LazyCrawlerPlugin)lazyCrawlerPlugin).newInstance(classLoader);
                                Class<? extends PluginConfigInterface> configInterface = plg.getConfigInterface();
                                if (configInterface != null) {
                                    ((LazyCrawlerPlugin)lazyCrawlerPlugin).setConfigInterface(new String(configInterface.getName()));
                                } else {
                                    ((LazyCrawlerPlugin)lazyCrawlerPlugin).setConfigInterface(null);
                                }
                                try {
                                    ((LazyCrawlerPlugin)lazyCrawlerPlugin).setSitesSupported(plg.siteSupportedNames());
                                }
                                catch (Throwable e) {
                                    logger.log(e);
                                    ((LazyCrawlerPlugin)lazyCrawlerPlugin).setSitesSupported(null);
                                }
                                ((LazyCrawlerPlugin)lazyCrawlerPlugin).setMaxConcurrentInstances(plg.getMaxConcurrentProcessingInstances());
                                ((LazyCrawlerPlugin)lazyCrawlerPlugin).setHasConfig(plg.hasConfig());
                                ((LazyCrawlerPlugin)lazyCrawlerPlugin).setFeatures(plg.getFeatures());
                                retList.add((LazyCrawlerPlugin)lazyCrawlerPlugin);
                                continue;
                            }
                            catch (UpdateRequiredClassNotFoundException e) {
                                logger.finest("@CrawlerPlugin incomplete:" + simpleName + " " + new String(names[i]) + " " + e.getMessage() + " " + revision);
                                throw e;
                            }
                        }
                        catch (Throwable e) {
                            logger.log(e);
                            logger.severe("@CrawlerPlugin failed:" + simpleName + " " + new String(names[i]) + " " + revision);
                            continue;
                        }
                        finally {
                            if (lazyCrawlerPlugin != null) {
                                lazyCrawlerPlugin.setPluginClass(null);
                                lazyCrawlerPlugin.setClassLoader(null);
                            }
                        }
                    }
                    continue;
                }
                catch (Throwable e) {
                    logger.log(e);
                    logger.severe("@CrawlerPlugin failed:" + simpleName);
                    continue;
                }
            }
            logger.severe("@CrawlerPlugin missing:" + simpleName);
        }
        return retList;
    }

    private boolean isCurrentVersion() {
        return this.currentVersion == LATESTVERSION.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(List<LazyCrawlerPlugin> save, AtomicLong lastFolderModification) {
        if (save != null && this.isCurrentVersion()) {
            LOCK.writeLock();
            File cache = Application.getTempResource((String)this.getCache());
            try {
                LazyCrawlerPluginCache.write(save, cache, lastFolderModification);
            }
            catch (Throwable e) {
                LogSource log = LogController.CL(false);
                log.log(e);
                log.close();
                cache.delete();
            }
            finally {
                LOCK.writeUnlock();
            }
        }
    }

    public List<LazyCrawlerPlugin> list() {
        return this.ensureLoaded();
    }

    public static List<LazyCrawlerPlugin> list(boolean ensureLoaded) {
        CrawlerPluginController ret = null;
        MinTimeWeakReference<CrawlerPluginController> localInstance = INSTANCE;
        if (localInstance != null && (ret = (CrawlerPluginController)localInstance.get()) != null) {
            if (ensureLoaded) {
                ret.list();
            }
            return ret.list;
        }
        if (ensureLoaded) {
            return CrawlerPluginController.getInstance().ensureLoaded();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LazyCrawlerPlugin> ensureLoaded() {
        List<LazyCrawlerPlugin> localList = this.list;
        if (localList != null && !CrawlerPluginController.isCacheInvalidated()) {
            return localList;
        }
        Object object = INSTANCELOCK;
        synchronized (object) {
            localList = this.list;
            if (localList != null && !CrawlerPluginController.isCacheInvalidated()) {
                return localList;
            }
            return this.init();
        }
    }

    public LazyCrawlerPlugin get(String displayName) {
        List<LazyCrawlerPlugin> llist = this.ensureLoaded();
        for (LazyCrawlerPlugin plugin : llist) {
            if (!plugin.getDisplayName().equalsIgnoreCase(displayName)) continue;
            return plugin;
        }
        return null;
    }

    public List<LazyCrawlerPlugin> getAll(String displayName) {
        ArrayList<LazyCrawlerPlugin> ret = new ArrayList<LazyCrawlerPlugin>();
        List<LazyCrawlerPlugin> llist = this.ensureLoaded();
        for (LazyCrawlerPlugin plugin : llist) {
            if (!plugin.getDisplayName().equalsIgnoreCase(displayName)) continue;
            ret.add(plugin);
        }
        return ret;
    }

    @Override
    protected PluginController.PluginClassInfo<PluginForDecrypt> getPluginClassInfo(Map<Object, List<String>> dependenciesCache, Class<PluginForDecrypt> clazz) throws Exception {
        DecrypterPlugin decrypterPlugin = clazz.getAnnotation(DecrypterPlugin.class);
        if (decrypterPlugin != null) {
            PluginController.PluginClassInfo<PluginForDecrypt> pluginInfo = new PluginController.PluginClassInfo<PluginForDecrypt>();
            pluginInfo.interfaceVersion = decrypterPlugin.interfaceVersion();
            pluginInfo.revision = Formatter.getRevision((String)decrypterPlugin.revision());
            pluginInfo.clazz = clazz;
            List<String> dependencies = this.getClassDependencies(dependenciesCache, clazz);
            pluginInfo.dependencies = dependencies;
            return pluginInfo;
        }
        return null;
    }
}

