/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.crawler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.utils.awfc.AWFCUtils;
import org.appwork.utils.net.CountingInputStream;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPluginCache;

public class LazyCrawlerPluginCache {
    private static final long CACHEVERSION = 29042024001L + LazyPlugin.FEATURE.CACHEVERSION;

    public static List<LazyCrawlerPlugin> read(File file, AtomicLong lastModification) throws IOException {
        ArrayList<LazyCrawlerPlugin> ret = new ArrayList<LazyCrawlerPlugin>();
        if (file.exists()) {
            HashMap featureCache = new HashMap();
            HashMap<ArrayList<String>, ArrayList<String>> dependenciesCache = new HashMap<ArrayList<String>, ArrayList<String>>();
            ByteArrayOutputStream byteBuffer = LazyHostPluginCache.readFile(file);
            CountingInputStream bis = new CountingInputStream((InputStream)new ByteArrayInputStream(byteBuffer.toByteArray(), 0, byteBuffer.size()));
            try {
                AWFCUtils is = new AWFCUtils((InputStream)bis);
                long version = is.readLong();
                if (CACHEVERSION != version) {
                    throw new IOException("Outdated CacheVersion:" + version + "|" + CACHEVERSION);
                }
                long lastCacheModified = is.readLong();
                int lazyPluginClassSize = is.readShort();
                byte[] stringBuffer = new byte[Short.MAX_VALUE];
                for (int lazyPluginClassIndex = 0; lazyPluginClassIndex < lazyPluginClassSize; ++lazyPluginClassIndex) {
                    String className = is.readString(stringBuffer);
                    byte[] sha256 = is.ensureRead(32, null);
                    long lastModified = is.readLong();
                    int interfaceVersion = (int)is.readLong();
                    long revision = is.readLong();
                    int dependenciesCount = is.readShort();
                    List<String> dependencies = null;
                    if (dependenciesCount > 0) {
                        dependencies = new ArrayList<String>(dependenciesCount);
                        for (int index = 0; index < dependenciesCount; ++index) {
                            dependencies.add(is.readString(stringBuffer));
                        }
                        if (dependenciesCache.containsKey(dependencies)) {
                            dependencies = (List)dependenciesCache.get(dependencies);
                        } else {
                            dependenciesCache.put((ArrayList<String>)dependencies, (ArrayList<String>)dependencies);
                        }
                    }
                    LazyPluginClass lazyPluginClass = new LazyPluginClass(className, sha256, lastModified, interfaceVersion, revision, dependencies);
                    int lazyCrawlerPluginSize = is.readShort();
                    for (int lazyCrawlerPluginIndex = 0; lazyCrawlerPluginIndex < lazyCrawlerPluginSize; ++lazyCrawlerPluginIndex) {
                        int sitesSupportedNumber;
                        LazyCrawlerPlugin lazyCrawlerPlugin = new LazyCrawlerPlugin(lazyPluginClass, is.readString(stringBuffer), is.readString(stringBuffer), null, null);
                        lazyCrawlerPlugin.setPluginUsage(is.readLongOptimized());
                        lazyCrawlerPlugin.setMaxConcurrentInstances((int)is.readLongOptimized());
                        int flags = is.ensureRead();
                        lazyCrawlerPlugin.setHasConfig((flags & 2) != 0);
                        if ((flags & 0x10) != 0) {
                            lazyCrawlerPlugin.setConfigInterface(is.readString(stringBuffer));
                        }
                        if ((sitesSupportedNumber = is.readShort()) == 0) {
                            lazyCrawlerPlugin.setSitesSupported(null);
                        } else {
                            ArrayList<String> sitesSupportedNames = new ArrayList<String>();
                            for (int index = 0; index < sitesSupportedNumber; ++index) {
                                sitesSupportedNames.add(is.readString(stringBuffer));
                            }
                            lazyCrawlerPlugin.setSitesSupported(sitesSupportedNames.toArray(new String[0]));
                        }
                        if ((flags & 4) != 0) {
                            ArrayList<LazyPlugin.FEATURE> features = new ArrayList<LazyPlugin.FEATURE>(LazyPlugin.FEATURE.values().length);
                            for (LazyPlugin.FEATURE feature : LazyPlugin.FEATURE.values()) {
                                if (!is.readBoolean()) continue;
                                features.add(feature);
                            }
                            Object cached = (LazyPlugin.FEATURE[])featureCache.get(features);
                            if (cached == null && !featureCache.containsKey(features)) {
                                cached = features.size() == 0 ? null : features.toArray(new LazyPlugin.FEATURE[0]);
                                featureCache.put(features, (LazyPlugin.FEATURE[])cached);
                            }
                            lazyCrawlerPlugin.setFeatures((LazyPlugin.FEATURE[])cached);
                        }
                        ret.add(lazyCrawlerPlugin);
                    }
                }
                if (lastModification != null) {
                    lastModification.set(lastCacheModified);
                }
            }
            catch (IOException e) {
                throw new IOException(e.getMessage() + " (" + bis.transferedBytes() + "/" + bis.available() + ")", e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(List<LazyCrawlerPlugin> lazyPlugins, File file, AtomicLong lastModification) throws IOException {
        HashMap<LazyPluginClass, ArrayList<LazyCrawlerPlugin>> lazyPluginsMap = new HashMap<LazyPluginClass, ArrayList<LazyCrawlerPlugin>>();
        if (lazyPlugins != null) {
            for (LazyCrawlerPlugin lazyPlugin : lazyPlugins) {
                ArrayList<LazyCrawlerPlugin> lazyPluginClasses = (ArrayList<LazyCrawlerPlugin>)lazyPluginsMap.get(lazyPlugin.getLazyPluginClass());
                if (lazyPluginClasses == null) {
                    lazyPluginClasses = new ArrayList<LazyCrawlerPlugin>();
                    lazyPluginsMap.put(lazyPlugin.getLazyPluginClass(), lazyPluginClasses);
                }
                lazyPluginClasses.add(lazyPlugin);
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos, Short.MAX_VALUE);
            AWFCUtils os = new AWFCUtils((OutputStream)bos);
            os.writeLong(CACHEVERSION);
            long lastModified = lastModification != null ? lastModification.get() : 0L;
            os.writeLong(lastModified);
            os.writeShort(lazyPluginsMap.size());
            for (Map.Entry lazyPluginMapEntry : lazyPluginsMap.entrySet()) {
                LazyPluginClass lazyPluginClass = (LazyPluginClass)lazyPluginMapEntry.getKey();
                os.writeString(lazyPluginClass.getClassName());
                bos.write(lazyPluginClass.getSha256());
                os.writeLong(lazyPluginClass.getLastModified());
                os.writeLong((long)Math.max(0, lazyPluginClass.getInterfaceVersion()));
                os.writeLong(Math.max(0L, lazyPluginClass.getRevision()));
                if (lazyPluginClass.getDependencies() == null || lazyPluginClass.getDependencies().size() == 0) {
                    os.writeShort(0);
                } else {
                    os.writeShort(lazyPluginClass.getDependencies().size());
                    for (String dependency : lazyPluginClass.getDependencies()) {
                        os.writeString(dependency);
                    }
                }
                List plugins = (List)lazyPluginMapEntry.getValue();
                os.writeShort(plugins.size());
                for (LazyCrawlerPlugin plugin : plugins) {
                    String[] sitesSupported;
                    LazyPlugin.FEATURE[] features;
                    os.writeString(plugin.getPatternSource());
                    os.writeString(plugin.getDisplayName());
                    os.writeLongOptimized(plugin.getPluginUsage());
                    os.writeLongOptimized((long)plugin.getMaxConcurrentInstances());
                    int flags = 0;
                    if (plugin.isHasConfig()) {
                        flags = (byte)(flags | 2);
                    }
                    if ((features = plugin.getFeatures()) != null && features.length > 0) {
                        flags = (byte)(flags | 4);
                    }
                    if (plugin.isHasConfig() && plugin.getConfigInterface() != null) {
                        flags = (byte)(flags | 0x10);
                    }
                    bos.write(flags);
                    if (plugin.isHasConfig() && plugin.getConfigInterface() != null) {
                        os.writeString(plugin.getConfigInterface());
                    }
                    if ((sitesSupported = plugin.getSitesSupported()) != null && sitesSupported.length == 1 && plugin.getHost().equals(sitesSupported[0])) {
                        sitesSupported = null;
                    }
                    os.writeShort(sitesSupported == null ? 0 : sitesSupported.length);
                    if (sitesSupported != null) {
                        for (String string : sitesSupported) {
                            os.writeString(string);
                        }
                    }
                    if (features == null || features.length <= 0) continue;
                    for (LazyPlugin.FEATURE fEATURE : LazyPlugin.FEATURE.values()) {
                        os.writeBoolean(fEATURE.isSet(features));
                    }
                }
            }
            bos.flush();
            bos.close();
            fos.close();
            fos = null;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

