/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.host;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jd.SecondLevelLaunch;
import jd.controlling.AccountController;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.nutils.Formatter;
import jd.plugins.HostPlugin;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.utils.Application;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.hosterrule.HosterRuleController;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.PluginController;
import org.jdownloader.plugins.controller.PluginInfo;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPluginCache;

public class HostPluginController
extends PluginController<PluginForHost> {
    private static final HostPluginController INSTANCE = new HostPluginController();
    private volatile Map<String, LazyHostPlugin> list = null;
    private volatile List<LazyHostPlugin> lastKnownPlugins = null;
    private final AtomicLong lastModification = new AtomicLong(-1L);
    private volatile LazyHostPlugin fallBackPlugin = null;
    private static final ModifyLock LOCK = new ModifyLock();
    public static final ThreadLocal<Map<String, Object>> PLUGIN_UPDATE_CACHE = new ThreadLocal();
    private final AtomicBoolean cacheInvalidated = new AtomicBoolean(false);

    public static HostPluginController getInstance() {
        return INSTANCE;
    }

    public LazyHostPlugin getFallBackPlugin() {
        this.ensureLoaded();
        return this.fallBackPlugin;
    }

    private String getCache() {
        return "hosterCache";
    }

    public long getLastModification() {
        return this.lastModification.get();
    }

    private HostPluginController() {
        try {
            Class.forName("org.jdownloader.container.Config");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public long getMaxDuration() {
                return 0L;
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                HostPluginController.this.save(HostPluginController.this.lastKnownPlugins, new AtomicLong(HostPluginController.this.lastModification.get()));
            }
        });
    }

    public synchronized Map<String, LazyHostPlugin> init() {
        return (Map)new NonInterruptibleRunnable<Map<String, LazyHostPlugin>, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, LazyHostPlugin> run() throws RuntimeException, InterruptedException {
                LogSource logger = LogController.CL(false);
                logger.info("HostPluginController: init");
                logger.setAllowTimeoutFlush(false);
                logger.setAutoFlushOnThrowable(true);
                LogController.setRebirthLogger((LogInterface)logger);
                long completeTimeStamp = System.currentTimeMillis();
                try {
                    long timeStamp = System.currentTimeMillis();
                    if (HostPluginController.this.lastKnownPlugins == null || HostPluginController.this.lastModification.get() <= 0L) {
                        try {
                            HostPluginController.this.lastKnownPlugins = HostPluginController.this.loadFromCache(HostPluginController.this.lastModification);
                        }
                        catch (Throwable e) {
                            HostPluginController.this.lastModification.set(-1L);
                            logger.log(e);
                            logger.severe("@HostPluginController: cache failed!");
                        }
                        finally {
                            if (HostPluginController.this.lastKnownPlugins != null && HostPluginController.this.lastKnownPlugins.size() > 0) {
                                logger.info("@HostPluginController: loadFromCache took " + (System.currentTimeMillis() - timeStamp) + "ms for " + HostPluginController.this.lastKnownPlugins.size() + "|LastModified:" + HostPluginController.this.lastModification.get());
                            }
                        }
                    }
                    ArrayList plugins = null;
                    timeStamp = System.currentTimeMillis();
                    try {
                        PLUGIN_UPDATE_CACHE.set(new HashMap());
                        plugins = HostPluginController.this.update(logger, HostPluginController.this.lastKnownPlugins, HostPluginController.this.lastModification);
                    }
                    catch (Throwable e) {
                        HostPluginController.this.lastModification.set(-1L);
                        logger.log(e);
                        logger.severe("@HostPluginController: update failed!");
                    }
                    finally {
                        PLUGIN_UPDATE_CACHE.set(null);
                        if (plugins != null && plugins.size() > 0) {
                            logger.info("@HostPluginController: update took " + (System.currentTimeMillis() - timeStamp) + "ms for " + plugins.size() + "|LastModified:" + HostPluginController.this.lastModification.get());
                        }
                    }
                    if (plugins == null || plugins.size() == 0) {
                        if (plugins == null) {
                            plugins = new ArrayList();
                        }
                        logger.severe("@HostPluginController: WTF, no plugins!");
                    }
                    HostPluginController.this.lastKnownPlugins = new ArrayList(plugins);
                    timeStamp = System.currentTimeMillis();
                    try {
                        Collections.sort(plugins, new Comparator<LazyHostPlugin>(){

                            @Override
                            public int compare(LazyHostPlugin o1, LazyHostPlugin o2) {
                                return o1.getDisplayName().compareTo(o2.getDisplayName());
                            }
                        });
                    }
                    catch (Throwable e) {
                        logger.log(e);
                        logger.severe("@HostPluginController: sort failed!");
                    }
                    finally {
                        logger.info("@HostPluginController: sort took " + (System.currentTimeMillis() - timeStamp) + "ms for " + plugins.size());
                    }
                    timeStamp = System.currentTimeMillis();
                    LinkedHashMap<String, LazyHostPlugin> retMap = new LinkedHashMap<String, LazyHostPlugin>();
                    LazyHostPlugin fallBackPlugin = null;
                    for (LazyHostPlugin plugin : plugins) {
                        plugin.setPluginClass(null);
                        plugin.setClassLoader(null);
                        if (fallBackPlugin == null && "UpdateRequired".equalsIgnoreCase(plugin.getDisplayName())) {
                            fallBackPlugin = plugin;
                            HostPluginController.this.fallBackPlugin = plugin;
                            continue;
                        }
                        String pluginID = plugin.getDisplayName().toLowerCase(Locale.ENGLISH);
                        LazyHostPlugin existingPlugin = retMap.put(pluginID, plugin);
                        if (existingPlugin == null) continue;
                        if (existingPlugin.getLazyPluginClass().getInterfaceVersion() > plugin.getLazyPluginClass().getInterfaceVersion()) {
                            retMap.put(pluginID, existingPlugin);
                            logger.finest("@HostPlugin keep:" + existingPlugin.getLazyPluginClass() + ":" + existingPlugin.getVersion() + " instead " + plugin.getLazyPluginClass() + ":" + plugin.getVersion());
                            continue;
                        }
                        logger.finest("@HostPlugin replaced:" + existingPlugin.getLazyPluginClass() + ":" + existingPlugin.getVersion() + " with " + plugin.getLazyPluginClass() + ":" + plugin.getVersion());
                    }
                    logger.info("@HostPluginController: mapping took " + (System.currentTimeMillis() - timeStamp) + "ms for " + plugins.size());
                    HostPluginController.this.list = retMap;
                }
                catch (Throwable throwable) {
                    Map llist = HostPluginController.this.list;
                    if (llist != null) {
                        logger.info("@HostPluginController: init took " + (System.currentTimeMillis() - completeTimeStamp) + "ms for " + llist.size());
                    } else {
                        logger.info("@HostPluginController: init took " + (System.currentTimeMillis() - completeTimeStamp));
                    }
                    LogController.setRebirthLogger(null);
                    HostPluginController.this.validateCache();
                    List lLastKnownPlugins = HostPluginController.this.lastKnownPlugins;
                    if (lLastKnownPlugins != null) {
                        AtomicLong lastModification = new AtomicLong(HostPluginController.this.lastModification.get());
                        Thread saveThread = new Thread("@HostPluginController:save", lLastKnownPlugins, lastModification){
                            final /* synthetic */ List val$lLastKnownPlugins;
                            final /* synthetic */ AtomicLong val$lastModification;
                            {
                                this.val$lLastKnownPlugins = list;
                                this.val$lastModification = atomicLong;
                                super(x0);
                            }

                            @Override
                            public void run() {
                                HostPluginController.this.save(this.val$lLastKnownPlugins, this.val$lastModification);
                            }
                        };
                        saveThread.setDaemon(true);
                        saveThread.start();
                    }
                    logger.close();
                    System.gc();
                    throw throwable;
                }
                Map llist = HostPluginController.this.list;
                if (llist != null) {
                    logger.info("@HostPluginController: init took " + (System.currentTimeMillis() - completeTimeStamp) + "ms for " + llist.size());
                } else {
                    logger.info("@HostPluginController: init took " + (System.currentTimeMillis() - completeTimeStamp));
                }
                LogController.setRebirthLogger(null);
                HostPluginController.this.validateCache();
                List lLastKnownPlugins = HostPluginController.this.lastKnownPlugins;
                if (lLastKnownPlugins != null) {
                    AtomicLong lastModification = new AtomicLong(HostPluginController.this.lastModification.get());
                    Thread saveThread = new /* invalid duplicate definition of identical inner class */;
                    saveThread.setDaemon(true);
                    saveThread.start();
                }
                logger.close();
                System.gc();
                if (SecondLevelLaunch.HOST_PLUGINS_COMPLETE.isReached()) {
                    SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

                        @Override
                        public void run() {
                            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                                protected Void run() throws RuntimeException {
                                    LinkCollector.getInstance().checkPluginUpdates();
                                    DownloadController.getInstance().checkPluginUpdates();
                                    AccountController.getInstance().checkPluginUpdates();
                                    HosterRuleController.getInstance().checkPluginUpdates();
                                    return null;
                                }
                            });
                        }
                    });
                }
                return HostPluginController.this.list;
            }
        }.startAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LazyHostPlugin> loadFromCache(AtomicLong lastFolderModification) throws IOException {
        boolean readL = LOCK.readLock();
        try {
            List<LazyHostPlugin> list = LazyHostPluginCache.read(Application.getTempResource((String)this.getCache()), lastFolderModification);
            return list;
        }
        finally {
            LOCK.readUnlock(readL);
        }
    }

    @Override
    protected PluginController.PluginClassInfo<PluginForHost> getPluginClassInfo(Map<Object, List<String>> dependenciesCache, Class<PluginForHost> clazz) throws Exception {
        HostPlugin hostPlugin = clazz.getAnnotation(HostPlugin.class);
        if (hostPlugin != null) {
            PluginController.PluginClassInfo<PluginForHost> pluginInfo = new PluginController.PluginClassInfo<PluginForHost>();
            pluginInfo.interfaceVersion = hostPlugin.interfaceVersion();
            pluginInfo.revision = Formatter.getRevision((String)hostPlugin.revision());
            pluginInfo.clazz = clazz;
            List<String> dependencies = this.getClassDependencies(dependenciesCache, clazz);
            pluginInfo.dependencies = dependencies;
            return pluginInfo;
        }
        return null;
    }

    @Override
    protected String getPluginPath() {
        return "jd/plugins/hoster";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LazyHostPlugin> update(LogSource logger, List<LazyHostPlugin> updateCache, AtomicLong lastFolderModification) throws Exception {
        ArrayList<LazyHostPlugin> retList = new ArrayList<LazyHostPlugin>();
        for (PluginInfo pluginInfo : this.scan(logger, updateCache, lastFolderModification)) {
            if (pluginInfo.getLazyPlugin() != null) {
                LazyHostPlugin plugin = (LazyHostPlugin)pluginInfo.getLazyPlugin();
                retList.add(plugin);
                continue;
            }
            String simpleName = pluginInfo.getSimpleName();
            if (pluginInfo.isValid()) {
                try {
                    PluginClassLoader.PluginClassLoaderChild classLoader = Application.getJavaVersion() <= Application.JAVA16 || pluginInfo.getClazz() == null ? PluginClassLoader.getInstance().getChild() : (PluginClassLoader.PluginClassLoaderChild)pluginInfo.getClazz().getClassLoader();
                    long revision = pluginInfo.getLazyPluginClass().getRevision();
                    String[] names = pluginInfo.getNames();
                    String[] patterns = pluginInfo.getPatterns();
                    if (names.length == 0) {
                        Class<Object> clazz = pluginInfo.getClazz();
                        if (clazz == null) {
                            clazz = classLoader.loadClass(pluginInfo.getClazzName());
                        }
                        patterns = (String[])clazz.getDeclaredMethod("getAnnotationUrls", new Class[0]).invoke(null, new Object[0]);
                        names = (String[])clazz.getDeclaredMethod("getAnnotationNames", new Class[0]).invoke(null, new Object[0]);
                    }
                    if (patterns.length != names.length) {
                        throw new WTFException("Plugin: " + simpleName + "(" + revision + ")|Error:names.length(" + names.length + ") != patterns.length(" + patterns.length + ")");
                    }
                    if (names.length == 0) {
                        throw new WTFException("Plugin: " + simpleName + "(" + revision + ")|Error:names.length(0)");
                    }
                    classLoader.setCreateDummyLibs(false);
                    classLoader.setMapStaticFields(false);
                    for (int i = 0; i < names.length; ++i) {
                        LazyPlugin lazyHostPlugin = null;
                        try {
                            LazyHostPlugin previousLazyHostPlugin;
                            lazyHostPlugin = new LazyHostPlugin(pluginInfo.getLazyPluginClass(), new String(patterns[i]), new String(names[i]), pluginInfo.getClazz(), classLoader);
                            if (this.list != null && (previousLazyHostPlugin = this.list.get(lazyHostPlugin.getDisplayName())) != null) {
                                ((LazyHostPlugin)lazyHostPlugin).setPluginUsage(previousLazyHostPlugin.getPluginUsage());
                            }
                            try {
                                classLoader.setPluginClass(simpleName);
                                PluginForHost plg = ((LazyHostPlugin)lazyHostPlugin).newInstance(classLoader);
                                Class<? extends PluginConfigInterface> configInterface = plg.getConfigInterface();
                                if (configInterface != null) {
                                    ((LazyHostPlugin)lazyHostPlugin).setConfigInterface(new String(configInterface.getName()));
                                } else {
                                    ((LazyHostPlugin)lazyHostPlugin).setConfigInterface(null);
                                }
                                if (plg.isPremiumEnabled()) {
                                    ((LazyHostPlugin)lazyHostPlugin).setPremium(true);
                                    String purl = plg.getBuyPremiumUrl();
                                    if (purl != null) {
                                        ((LazyHostPlugin)lazyHostPlugin).setPremiumUrl(new String(purl));
                                    }
                                    ((LazyHostPlugin)lazyHostPlugin).setHasPremiumConfig(plg.getAccountConfigInterface(null) != null);
                                } else {
                                    ((LazyHostPlugin)lazyHostPlugin).setPremium(false);
                                    ((LazyHostPlugin)lazyHostPlugin).setHasPremiumConfig(false);
                                }
                                ((LazyHostPlugin)lazyHostPlugin).setHasConfig(plg.hasConfig());
                                try {
                                    ((LazyHostPlugin)lazyHostPlugin).setHasAllowHandle(PluginForHost.implementsAllowHandle(plg));
                                }
                                catch (Throwable e) {
                                    logger.log(e);
                                    ((LazyHostPlugin)lazyHostPlugin).setHasAllowHandle(false);
                                }
                                try {
                                    ((LazyHostPlugin)lazyHostPlugin).setHasRewrite(PluginForHost.implementsRewriteHost(plg));
                                }
                                catch (Throwable e) {
                                    logger.log(e);
                                    ((LazyHostPlugin)lazyHostPlugin).setHasRewrite(false);
                                }
                                try {
                                    ((LazyHostPlugin)lazyHostPlugin).setSitesSupported(plg.siteSupportedNames());
                                }
                                catch (Throwable e) {
                                    logger.log(e);
                                    ((LazyHostPlugin)lazyHostPlugin).setSitesSupported(null);
                                }
                                ((LazyHostPlugin)lazyHostPlugin).setFeatures(plg.getFeatures());
                            }
                            catch (Throwable e) {
                                if (e instanceof UpdateRequiredClassNotFoundException) {
                                    logger.log(e);
                                    logger.finest("@HostPlugin incomplete:" + simpleName + " " + new String(names[i]) + " " + e.getMessage() + " " + revision);
                                }
                                throw e;
                            }
                            if (lazyHostPlugin == null) continue;
                            retList.add((LazyHostPlugin)lazyHostPlugin);
                            continue;
                        }
                        catch (Throwable e) {
                            logger.log(e);
                            logger.severe("@HostPlugin failed:" + simpleName + " " + new String(names[i]) + " " + revision);
                            continue;
                        }
                        finally {
                            if (lazyHostPlugin != null) {
                                lazyHostPlugin.setClassLoader(null);
                                lazyHostPlugin.setPluginClass(null);
                            }
                        }
                    }
                    continue;
                }
                catch (Throwable e) {
                    logger.severe("@HostPlugin failed:" + simpleName);
                    logger.log(e);
                    continue;
                }
            }
            logger.severe("@HostPlugin missing:" + simpleName);
        }
        return retList;
    }

    public boolean isCacheInvalidated() {
        return this.cacheInvalidated.get();
    }

    public void invalidateCache() {
        this.cacheInvalidated.set(true);
    }

    protected void validateCache() {
        this.cacheInvalidated.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(List<LazyHostPlugin> save, AtomicLong lastFolderModification) {
        if (save != null) {
            LOCK.writeLock();
            File cache = Application.getTempResource((String)this.getCache());
            try {
                LazyHostPluginCache.write(save, cache, lastFolderModification);
            }
            catch (Throwable e) {
                LogSource log = LogController.CL(false);
                log.log(e);
                log.close();
                cache.delete();
            }
            finally {
                LOCK.writeUnlock();
            }
        }
    }

    public Collection<LazyHostPlugin> list() {
        return this.ensureLoaded().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, LazyHostPlugin> ensureLoaded() {
        Map<String, LazyHostPlugin> localList = this.list;
        if (localList != null && !this.isCacheInvalidated()) {
            return localList;
        }
        HostPluginController hostPluginController = this;
        synchronized (hostPluginController) {
            localList = this.list;
            if (localList != null && !this.isCacheInvalidated()) {
                return localList;
            }
            return this.init();
        }
    }

    public LazyHostPlugin get(String displayName) {
        if (displayName != null) {
            LazyHostPlugin ret = this.ensureLoaded().get(displayName.toLowerCase(Locale.ENGLISH));
            if (ret != null) {
                return ret;
            }
            if ("UpdateRequired".equalsIgnoreCase(displayName)) {
                return this.fallBackPlugin;
            }
        }
        return null;
    }
}

