/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.host;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.utils.IO;
import org.appwork.utils.awfc.AWFCUtils;
import org.appwork.utils.net.CountingInputStream;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class LazyHostPluginCache {
    private static final long CACHEVERSION = 13012025001L + LazyPlugin.FEATURE.CACHEVERSION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream readFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(524288){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            IO.readStream((int)((int)file.length()), (InputStream)fis, (ByteArrayOutputStream)byteBuffer, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = byteBuffer;
            return byteArrayOutputStream;
        }
        finally {
            fis.close();
        }
    }

    public static List<LazyHostPlugin> read(File file, AtomicLong lastModification) throws IOException {
        ArrayList<LazyHostPlugin> ret = new ArrayList<LazyHostPlugin>(4096);
        if (file.exists()) {
            HashMap featureCache = new HashMap();
            HashMap<ArrayList<String>, ArrayList<String>> dependenciesCache = new HashMap<ArrayList<String>, ArrayList<String>>();
            ByteArrayOutputStream byteBuffer = LazyHostPluginCache.readFile(file);
            CountingInputStream bis = new CountingInputStream((InputStream)new ByteArrayInputStream(byteBuffer.toByteArray(), 0, byteBuffer.size()));
            try {
                AWFCUtils is = new AWFCUtils((InputStream)bis);
                long version = is.readLong();
                if (CACHEVERSION != version) {
                    throw new IOException("Outdated CacheVersion:" + version + "|" + CACHEVERSION);
                }
                long cacheLastModified = is.readLong();
                int lazyPluginClassSize = is.readShort();
                byte[] stringBuffer = new byte[Short.MAX_VALUE];
                for (int lazyPluginClassIndex = 0; lazyPluginClassIndex < lazyPluginClassSize; ++lazyPluginClassIndex) {
                    String className = is.readString(stringBuffer);
                    byte[] sha256 = is.ensureRead(32, null);
                    long lastModified = is.readLong();
                    int interfaceVersion = (int)is.readLong();
                    long revision = is.readLong();
                    int dependenciesCount = is.readShort();
                    List<String> dependencies = null;
                    if (dependenciesCount > 0) {
                        dependencies = new ArrayList<String>(dependenciesCount);
                        for (int index = 0; index < dependenciesCount; ++index) {
                            dependencies.add(is.readString(stringBuffer));
                        }
                        if (dependenciesCache.containsKey(dependencies)) {
                            dependencies = (List)dependenciesCache.get(dependencies);
                        } else {
                            dependenciesCache.put((ArrayList<String>)dependencies, (ArrayList<String>)dependencies);
                        }
                    }
                    LazyPluginClass lazyPluginClass = new LazyPluginClass(className, sha256, lastModified, interfaceVersion, revision, dependencies);
                    int lazyHostPluginSize = is.readShort();
                    for (int lazyHostPluginIndex = 0; lazyHostPluginIndex < lazyHostPluginSize; ++lazyHostPluginIndex) {
                        int sitesSupportedNumber;
                        LazyHostPlugin lazyHostPlugin = new LazyHostPlugin(lazyPluginClass, is.readString(stringBuffer), is.readString(stringBuffer), null, null);
                        lazyHostPlugin.setPluginUsage(is.readLongOptimized());
                        int flags = is.ensureRead();
                        lazyHostPlugin.setPremium((flags & 1) != 0);
                        if (lazyHostPlugin.isPremium()) {
                            lazyHostPlugin.setHasPremiumConfig((flags & 2) != 0);
                        }
                        lazyHostPlugin.setHasConfig((flags & 4) != 0);
                        if ((flags & 0x20) != 0) {
                            lazyHostPlugin.setPremiumUrl(is.readString(stringBuffer));
                        }
                        if ((flags & 0x40) != 0) {
                            lazyHostPlugin.setHasRewrite(true);
                        }
                        if ((flags & 0x80) != 0) {
                            lazyHostPlugin.setHasAllowHandle(true);
                        }
                        if ((flags & 0x10) != 0) {
                            lazyHostPlugin.setConfigInterface(is.readString(stringBuffer));
                        }
                        if ((sitesSupportedNumber = is.readShort()) == 0) {
                            lazyHostPlugin.setSitesSupported(null);
                        } else {
                            ArrayList<String> sitesSupportedNames = new ArrayList<String>();
                            for (int index = 0; index < sitesSupportedNumber; ++index) {
                                sitesSupportedNames.add(is.readString(stringBuffer));
                            }
                            lazyHostPlugin.setSitesSupported(sitesSupportedNames.toArray(new String[0]));
                        }
                        if ((flags & 8) != 0) {
                            ArrayList<LazyPlugin.FEATURE> features = new ArrayList<LazyPlugin.FEATURE>(LazyPlugin.FEATURE.values().length);
                            for (LazyPlugin.FEATURE feature : LazyPlugin.FEATURE.values()) {
                                if (!is.readBoolean()) continue;
                                features.add(feature);
                            }
                            Object cached = (LazyPlugin.FEATURE[])featureCache.get(features);
                            if (cached == null && !featureCache.containsKey(features)) {
                                cached = features.size() == 0 ? null : features.toArray(new LazyPlugin.FEATURE[0]);
                                featureCache.put(features, (LazyPlugin.FEATURE[])cached);
                            }
                            lazyHostPlugin.setFeatures((LazyPlugin.FEATURE[])cached);
                        }
                        ret.add(lazyHostPlugin);
                    }
                }
                if (lastModification != null) {
                    lastModification.set(cacheLastModified);
                }
            }
            catch (IOException e) {
                throw new IOException(e.getMessage() + " (" + bis.transferedBytes() + "/" + bis.available() + ")", e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(List<LazyHostPlugin> lazyPlugins, File file, AtomicLong lastModification) throws IOException {
        HashMap<LazyPluginClass, ArrayList<LazyHostPlugin>> lazyPluginsMap = new HashMap<LazyPluginClass, ArrayList<LazyHostPlugin>>();
        if (lazyPlugins != null) {
            for (LazyHostPlugin lazyPlugin : lazyPlugins) {
                ArrayList<LazyHostPlugin> lazyPluginClasses = (ArrayList<LazyHostPlugin>)lazyPluginsMap.get(lazyPlugin.getLazyPluginClass());
                if (lazyPluginClasses == null) {
                    lazyPluginClasses = new ArrayList<LazyHostPlugin>();
                    lazyPluginsMap.put(lazyPlugin.getLazyPluginClass(), lazyPluginClasses);
                }
                lazyPluginClasses.add(lazyPlugin);
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos, Short.MAX_VALUE);
            AWFCUtils os = new AWFCUtils((OutputStream)bos);
            os.writeLong(CACHEVERSION);
            long lastModified = lastModification != null ? lastModification.get() : 0L;
            os.writeLong(lastModified);
            os.writeShort(lazyPluginsMap.size());
            for (Map.Entry lazyPluginMapEntry : lazyPluginsMap.entrySet()) {
                LazyPluginClass lazyPluginClass = (LazyPluginClass)lazyPluginMapEntry.getKey();
                os.writeString(lazyPluginClass.getClassName());
                bos.write(lazyPluginClass.getSha256());
                os.writeLong(lazyPluginClass.getLastModified());
                os.writeLong((long)Math.max(0, lazyPluginClass.getInterfaceVersion()));
                os.writeLong(Math.max(0L, lazyPluginClass.getRevision()));
                if (lazyPluginClass.getDependencies() == null || lazyPluginClass.getDependencies().size() == 0) {
                    os.writeShort(0);
                } else {
                    os.writeShort(lazyPluginClass.getDependencies().size());
                    for (String dependency : lazyPluginClass.getDependencies()) {
                        os.writeString(dependency);
                    }
                }
                List plugins = (List)lazyPluginMapEntry.getValue();
                os.writeShort(plugins.size());
                for (LazyHostPlugin plugin : plugins) {
                    String[] sitesSupported;
                    LazyPlugin.FEATURE[] features;
                    os.writeString(plugin.getPatternSource());
                    os.writeString(plugin.getDisplayName());
                    os.writeLongOptimized(plugin.getPluginUsage());
                    byte flags = 0;
                    if (plugin.isPremium()) {
                        flags = (byte)(flags | 1);
                        if (plugin.isHasPremiumConfig()) {
                            flags = (byte)(flags | 2);
                        }
                    }
                    if (plugin.isHasConfig()) {
                        flags = (byte)(flags | 4);
                    }
                    if ((features = plugin.getFeatures()) != null && features.length > 0) {
                        flags = (byte)(flags | 8);
                    }
                    if (plugin.isHasConfig() && plugin.getConfigInterface() != null) {
                        flags = (byte)(flags | 0x10);
                    }
                    if (plugin.isPremium() && plugin.getPremiumUrl() != null) {
                        flags = (byte)(flags | 0x20);
                    }
                    if (plugin.isHasRewrite()) {
                        flags = (byte)(flags | 0x40);
                    }
                    if (plugin.isHasAllowHandle()) {
                        flags = (byte)(flags | 0x80);
                    }
                    bos.write(flags);
                    if (plugin.isPremium() && plugin.getPremiumUrl() != null) {
                        os.writeString(plugin.getPremiumUrl());
                    }
                    if (plugin.isHasConfig() && plugin.getConfigInterface() != null) {
                        os.writeString(plugin.getConfigInterface());
                    }
                    if ((sitesSupported = plugin.getSitesSupported()) != null && sitesSupported.length == 1 && plugin.getHost().equals(sitesSupported[0])) {
                        sitesSupported = null;
                    }
                    os.writeShort(sitesSupported == null ? 0 : sitesSupported.length);
                    if (sitesSupported != null) {
                        for (String string : sitesSupported) {
                            os.writeString(string);
                        }
                    }
                    if (features == null || features.length <= 0) continue;
                    for (LazyPlugin.FEATURE fEATURE : LazyPlugin.FEATURE.values()) {
                        os.writeBoolean(fEATURE.isSet(features));
                    }
                }
            }
            bos.flush();
            bos.close();
            fos.close();
            fos = null;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

