/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.scripting;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.ClassShutter;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.EcmaError;
import net.sourceforge.htmlunit.corejs.javascript.ErrorReporter;
import net.sourceforge.htmlunit.corejs.javascript.Evaluator;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeJavaClass;
import net.sourceforge.htmlunit.corejs.javascript.NativeJavaObject;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.WrapFactory;
import net.sourceforge.htmlunit.corejs.javascript.tools.shell.Global;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.scripting.ContextCallback;
import org.jdownloader.scripting.JSShutterDelegate;

public class JSHtmlUnitPermissionRestricter {
    private static CopyOnWriteArraySet<String> LOADED = new CopyOnWriteArraySet();
    private static SandboxContextFactory CONTEXT_FACTORY;
    public static final ConcurrentHashMap<Thread, Boolean> TRUSTED_THREAD;
    public static final ConcurrentHashMap<Thread, JSShutterDelegate> THREAD_JSSHUTTER;

    public static List<String> getLoaded() {
        ArrayList<String> ret = new ArrayList<String>(LOADED);
        Collections.sort(ret, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return ret;
    }

    public static synchronized void init() {
        if (CONTEXT_FACTORY != null) {
            throw new IllegalStateException("Init already done earlier");
        }
        SandboxContextFactory synch = new SandboxContextFactory();
        ContextFactory.initGlobal((ContextFactory)synch);
        CONTEXT_FACTORY = synch;
    }

    public static SandboxContextFactory getCONTEXT_FACTORY() {
        return CONTEXT_FACTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateTrustedString(Context cx, Global scope, String source, String sourceName, int lineno, Object securityDomain) {
        Thread thread = Thread.currentThread();
        try {
            TRUSTED_THREAD.put(thread, true);
            Object object = cx.evaluateString((Scriptable)scope, source, sourceName, lineno, securityDomain);
            return object;
        }
        finally {
            TRUSTED_THREAD.remove(thread);
        }
    }

    public static Context makeContext(ContextCallback contextCallback) {
        return CONTEXT_FACTORY.makeContext(contextCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script compileTrustedString(Context cx, Global scope, String source, String sourceName, int lineno, Object securityDomain) {
        Thread thread = Thread.currentThread();
        try {
            TRUSTED_THREAD.put(thread, true);
            Script script = cx.compileString(source, sourceName, lineno, securityDomain);
            return script;
        }
        finally {
            TRUSTED_THREAD.remove(thread);
        }
    }

    static {
        TRUSTED_THREAD = new ConcurrentHashMap();
        THREAD_JSSHUTTER = new ConcurrentHashMap();
    }

    public static class SandboxNativeJavaObject
    extends NativeJavaObject {
        private static final long serialVersionUID = -2783084485265910840L;

        public SandboxNativeJavaObject(Scriptable scope, Object javaObject, Class<?> staticType) {
            super(scope, javaObject, staticType);
        }

        public Object get(String name, Scriptable start) {
            if (name.equals("getClass")) {
                LoggerFactory.getDefaultLogger().severe("JS Security Exception");
                return NOT_FOUND;
            }
            Object ret = super.get(name, start);
            return ret;
        }
    }

    public static class SandboxWrapFactory
    extends WrapFactory {
        public Scriptable wrapJavaClass(Context cx, Scriptable scope, Class javaClass) {
            NativeJavaClass ret = new NativeJavaClass(scope, javaClass){

                public Object unwrap() {
                    return super.unwrap();
                }

                public Object get(String name, Scriptable start) {
                    Object ret = super.get(name, start);
                    return ret;
                }

                public Object get(int index, Scriptable start) {
                    return super.get(index, start);
                }
            };
            return ret;
        }

        public Scriptable wrapNewObject(Context cx, Scriptable scope, Object obj) {
            return super.wrapNewObject(cx, scope, obj);
        }

        public Object wrap(Context cx, Scriptable scope, Object obj, Class<?> staticType) {
            Object ret = super.wrap(cx, scope, obj, staticType);
            if (obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                return obj;
            }
            if (obj instanceof Character) {
                char[] a = new char[]{((Character)obj).charValue()};
                return new String(a);
            }
            return ret;
        }

        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            String str;
            if (javaObject instanceof EcmaError) {
                // empty if block
            }
            if ((str = (javaObject + "").replaceAll("[\r\n]+", " ")).length() > 100) {
                str = str.substring(0, 100) + "...";
            }
            return new SandboxNativeJavaObject(scope, javaObject, staticType);
        }
    }

    public static class SandboxContextFactory
    extends ContextFactory {
        protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            return super.doTopCall(callable, cx, scope, thisObj, args);
        }

        public Context makeContext() {
            return this.makeContext(null);
        }

        protected Context makeContext(final ContextCallback contextCallback) {
            Context cx = new Context(){

                protected Script compileString(String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
                    if (contextCallback != null) {
                        source = contextCallback.onBeforeSourceCompiling(source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
                    }
                    Script ret = super.compileString(source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
                    if (contextCallback != null) {
                        ret = contextCallback.onAfterSourceCompiling(ret, source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
                    }
                    return ret;
                }

                protected Function compileFunction(Scriptable scope, String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
                    return super.compileFunction(scope, source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
                }
            };
            try {
                Field field = Context.class.getDeclaredField("factory");
                field.setAccessible(true);
                field.set(cx, (Object)this);
                field.setAccessible(false);
            }
            catch (Throwable e) {
                throw new WTFException(e);
            }
            cx.setWrapFactory((WrapFactory)new SandboxWrapFactory());
            cx.setClassShutter(new ClassShutter(){

                public boolean visibleToScripts(String className) {
                    JSShutterDelegate jsShutter;
                    if (className == null) {
                        return false;
                    }
                    Thread thread = Thread.currentThread();
                    boolean threadTrusted = TRUSTED_THREAD.containsKey(thread);
                    Boolean jsShutterResult = null;
                    if (thread instanceof JSShutterDelegate) {
                        jsShutterResult = ((JSShutterDelegate)((Object)thread)).isClassVisibleToScript(threadTrusted, className) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if ((jsShutter = THREAD_JSSHUTTER.get(thread)) != null) {
                        jsShutterResult = jsShutter.isClassVisibleToScript(threadTrusted, className) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (jsShutterResult != null) {
                        if (jsShutterResult.booleanValue()) {
                            LOADED.add(className);
                        }
                        return jsShutterResult;
                    }
                    if (threadTrusted) {
                        LOADED.add(className);
                        return true;
                    }
                    if (className.startsWith("adapter")) {
                        LOADED.add(className);
                        return true;
                    }
                    if (className.equals("net.sourceforge.htmlunit.corejs.javascript.EcmaError")) {
                        LoggerFactory.getDefaultLogger().severe("Javascript error occured");
                        LOADED.add(className);
                        return true;
                    }
                    if (className.equals("net.sourceforge.htmlunit.corejs.javascript.ConsString")) {
                        LoggerFactory.getDefaultLogger().severe("Javascript error occured");
                        LOADED.add(className);
                        return true;
                    }
                    if (className.equals("net.sourceforge.htmlunit.corejs.javascript.JavaScriptException")) {
                        LoggerFactory.getDefaultLogger().severe("Javascript error occured");
                        LOADED.add(className);
                        return true;
                    }
                    if (className.equals("net.sourceforge.htmlunit.corejs.javascript.EvaluatorException")) {
                        LoggerFactory.getDefaultLogger().severe("Javascript error occured");
                        LOADED.add(className);
                        return true;
                    }
                    EcmaError ret = ScriptRuntime.constructError((String)"Security Violation", (String)("Security Violation " + className));
                    throw ret;
                }
            });
            this.onContextCreated(cx);
            return cx;
        }
    }
}

