/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.scripting.envjs;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import jd.http.Browser;
import jd.http.Cookies;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.GetRequest;
import jd.parser.Regex;
import jd.parser.html.Form;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.EcmaError;
import net.sourceforge.htmlunit.corejs.javascript.ErrorReporter;
import net.sourceforge.htmlunit.corejs.javascript.Evaluator;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.IdFunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.NativeFunction;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.debug.DebugFrame;
import net.sourceforge.htmlunit.corejs.javascript.debug.DebuggableScript;
import net.sourceforge.htmlunit.corejs.javascript.debug.Debugger;
import net.sourceforge.htmlunit.corejs.javascript.tools.debugger.Main;
import net.sourceforge.htmlunit.corejs.javascript.tools.debugger.SourceProvider;
import net.sourceforge.htmlunit.corejs.javascript.tools.shell.Global;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.MinimalMemoryMap;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;
import org.jdownloader.scripting.ContextCallback;
import org.jdownloader.scripting.JSHtmlUnitPermissionRestricter;
import org.jdownloader.scripting.envjs.PermissionFilter;
import org.jdownloader.scripting.envjs.XHRResponse;

public class EnvJSBrowser
implements ContextCallback {
    private Global scope;
    private long id;
    private Browser br;
    private LogSource logger;
    private static AtomicLong CCOUNTER;
    private static ConcurrentHashMap<Long, WeakReference<EnvJSBrowser>> INSTANCES;
    private PermissionFilter permissionFilter = null;
    private DebugLevel debugLevel = DebugLevel.DEBUG;
    private Context cx;
    private Script tick;
    private boolean initDone;
    private LinkedList<String> scriptStack = new LinkedList();
    private Object globals;

    public static EnvJSBrowser get(long id) {
        return (EnvJSBrowser)INSTANCES.get(id).get();
    }

    public String getCookieStringByUrl(String url) {
        try {
            return Request.getCookieString((Cookies)this.br.getCookies(url), (URL)new URL(url));
        }
        catch (MalformedURLException e) {
            throw new WTFException((Throwable)e);
        }
    }

    public void logToConsole(String message) {
        this.logger.info("console.log >" + message);
    }

    public void setCookie(String url, String cookie) {
        String date = this.br.getRequest().getHttpConnection().getHeaderField("Date");
        String host = Browser.getHost((URL)this.br.getRequest().getURL());
        Cookies cookies = Cookies.parseCookies((String)cookie, (String)host, (String)date);
        this.br.getCookies(host).add(cookies);
    }

    public String readFromFile(String url) {
        return url;
    }

    public String modifyInlineScript(String type, String js) throws IOException {
        if (this.permissionFilter != null) {
            return this.permissionFilter.onBeforeExecutingInlineJavaScript(type, js);
        }
        return js;
    }

    protected URLConnectionAdapter openRequestConnection(Browser br, Request request) throws Exception {
        return br.openRequestConnection(request);
    }

    public String loadExternalScript(String type, String src, String url, Object window) {
        try {
            Browser xbr = this.br.cloneBrowser();
            GetRequest request = xbr.createGetRequest(url);
            if (this.permissionFilter != null) {
                request = this.permissionFilter.onBeforeLoadingExternalJavaScript(type, src, (Request)request);
            }
            if (request != null) {
                try {
                    xbr.loadConnection(this.openRequestConnection(xbr, (Request)request));
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                String ret = request.getHtmlCode();
                if (this.permissionFilter != null) {
                    return this.permissionFilter.onAfterLoadingExternalJavaScript(type, src, ret, (Request)request);
                }
                return ret;
            }
            return "console.log(\"Script Blocked: " + url + "\");";
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            return "console.log(\"Script Loading Error: " + e + "\");";
        }
    }

    private HashMap<Object, Object> toMap(NativeObject obj, HashMap<Object, HashMap<Object, Object>> refMap) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (refMap == null) {
            refMap = new HashMap();
        }
        if (refMap.containsKey(obj)) {
            return null;
        }
        refMap.put(obj, ret);
        for (Map.Entry e : obj.entrySet()) {
            Object v = e.getValue();
            if (v instanceof NativeObject) {
                ret.put(e.getKey().toString(), this.toMap((NativeObject)v, refMap));
                continue;
            }
            ret.put(e.getKey().toString(), v == null ? null : v.toString());
        }
        return ret;
    }

    public String xhrRequest(String url, String method, String data, String requestHeaders) throws IOException {
        GetRequest request;
        HashMap headers = (HashMap)JSonStorage.restoreFromString((String)requestHeaders, (TypeRef)new TypeRef<HashMap<String, String>>(){});
        if (headers != null) {
            headers.remove("User-Agent");
            if (headers.get("Referer") != null && "about:blank".equals(headers.get("Referer"))) {
                headers.remove("Referer");
            }
            this.br.getHeaders().putAll((Map)headers);
        }
        if ("get".equalsIgnoreCase(method)) {
            request = this.br.createGetRequest(url);
        } else if ("post".equalsIgnoreCase(method)) {
            request = this.br.createPostRequest(url, data);
        } else {
            throw new WTFException("Not Supported");
        }
        if (this.permissionFilter != null) {
            request = this.permissionFilter.onBeforeXHRRequest((Request)request);
        }
        if (request != null) {
            try {
                this.br.loadConnection(this.openRequestConnection(this.br, (Request)request));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            XHRResponse ret = new XHRResponse();
            ret.setReponseMessage(HTTPConstants.ResponseCode.ERROR_NOT_FOUND.getDescription());
            ret.setResponseCode(HTTPConstants.ResponseCode.ERROR_NOT_FOUND.getCode());
            ret.setResponseText("Blocked by EnvJS");
            return JSonStorage.serializeToJson((Object)ret);
        }
        XHRResponse ret = new XHRResponse();
        for (Map.Entry s : this.br.getRequest().getResponseHeaders().entrySet()) {
            ret.getResponseHeader().put((String)s.getKey(), (String)((List)s.getValue()).get(0));
        }
        ret.setEncoding(this.br.getRequest().getHttpConnection().getHeaderField("Content-Encoding"));
        ret.setReponseMessage(this.br.getRequest().getHttpConnection().getResponseMessage());
        ret.setResponseCode(this.br.getRequest().getHttpConnection().getResponseCode());
        ret.setResponseText(this.br.getRequest().getHtmlCode());
        if (this.permissionFilter != null) {
            this.permissionFilter.onAfterXHRRequest((Request)request, ret);
        }
        return JSonStorage.serializeToJson((Object)ret);
    }

    public PermissionFilter getPermissionFilter() {
        return this.permissionFilter;
    }

    public void setPermissionFilter(PermissionFilter scriptFilter) {
        this.permissionFilter = scriptFilter;
    }

    public EnvJSBrowser() {
        this.id = CCOUNTER.incrementAndGet();
        this.br = this.createBrowserInstance();
        INSTANCES.put(this.id, new WeakReference<EnvJSBrowser>(this));
        this.logger = LogController.getInstance().getLogger(EnvJSBrowser.class.getName());
    }

    public EnvJSBrowser(Browser br2) {
        this();
        this.br = br2;
    }

    @Override
    public String onBeforeSourceCompiling(String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
        return source;
    }

    @Override
    public Script onAfterSourceCompiling(Script ret, String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
        return ret;
    }

    public void breakIt() {
        this.printStacktrace();
        System.out.println("Break");
    }

    public void exit() {
    }

    public String readRequire(String path) throws IOException {
        if (path.startsWith("envjs/")) {
            path = path.substring(6);
        }
        this.logger.info("Require: " + path);
        if ("platform/rhino".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("platform/core".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("console".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("init".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("timer".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("local_settings".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("window".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("dom".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("html".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("event".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("parser".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("xhr".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("css".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        if ("base64".equals(path)) {
            return IO.readURLToString((URL)EnvJSBrowser.class.getResource(path + ".js"));
        }
        throw new WTFException("Unknown Resource required: " + path);
    }

    public boolean isInitDone() {
        return this.initDone;
    }

    public DebugLevel getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(DebugLevel debugLevel) {
        this.debugLevel = debugLevel;
    }

    public boolean logger(String level, String category, String message) {
        try {
            DebugLevel debugLevel = DebugLevel.valueOf(level);
            if (debugLevel.ordinal() >= this.getDebugLevel().ordinal()) {
                switch (debugLevel) {
                    case DEBUG: {
                        this.logger.finest(category + "> " + message);
                        break;
                    }
                    case ERROR: {
                        this.logger.severe(category + "> " + message);
                        break;
                    }
                    case INFO: {
                        this.logger.info(category + "> " + message);
                        break;
                    }
                    case WARN: {
                        this.logger.warning(category + "> " + message);
                        break;
                    }
                }
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            this.logger.log(e);
            return false;
        }
    }

    public void init() {
        this.scope = new Global();
        if (this.getDebugLevel() == DebugLevel.DEBUG) {
            this.initGuiDebugger();
        }
        this.cx = Context.enter((Context)JSHtmlUnitPermissionRestricter.makeContext(this));
        this.cx.setOptimizationLevel(-1);
        this.scope.init(this.cx);
        this.cx.setOptimizationLevel(-1);
        this.cx.setLanguageVersion(150);
        this.tick = this.cx.compileString("var e=envjsglobals.Envjs;delete envjsglobals;  e.tick();  ", "ticker", 1, null);
        if (this.br == null) {
            throw new NullPointerException("browser is null");
        }
        try {
            Class[] classes;
            String preloadClasses = "";
            for (Class c : classes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, String.class, Double.class, Float.class, ArrayList.class, List.class, LinkedList.class, Map.class, HashMap.class, Set.class, HashSet.class, MinimalMemoryMap.class, EcmaError.class, WTFException.class}) {
                preloadClasses = preloadClasses + "load=" + c.getName() + ";\r\n";
            }
            preloadClasses = preloadClasses + "delete load;";
            this.evalTrusted(preloadClasses);
            String initSource = this.readRequire("envjs/init");
            initSource = initSource.replace("%EnvJSinstanceID%", this.id + "");
            this.evaluateTrustedString(this.cx, this.scope, initSource, "setInstance", 1, null);
            this.evalTrusted("       var javaInstance=Packages.org.jdownloader.scripting.envjs.EnvJSBrowser.get(" + this.id + ");stacktrace=function(){javaInstance.printStacktrace();};");
            List<String> list = JSHtmlUnitPermissionRestricter.getLoaded();
            this.eval("delete Packages;");
            block7: for (String s : list) {
                while (true) {
                    int index;
                    System.out.println("Delete " + s);
                    try {
                        this.eval("delete " + s + ";");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if ((index = s.lastIndexOf(".")) <= 0) continue block7;
                    s = s.substring(0, index);
                }
            }
            this.eval("delete spawn;");
            this.eval("delete window.spawn;");
            this.initDone = true;
        }
        catch (Throwable e) {
            throw new WTFException(e);
        }
    }

    public void initGuiDebugger() {
        try {
            final ContextFactory factory = ContextFactory.getGlobal();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JSHtmlUnitPermissionRestricter.TRUSTED_THREAD.put(Thread.currentThread(), true);
                    Main main = new Main("JS Debugger");
                    main.doBreak();
                    main.attachTo(factory);
                    if (EnvJSBrowser.this.scope instanceof Global) {
                        Global global = EnvJSBrowser.this.scope;
                        global.setIn(main.getIn());
                        global.setOut(main.getOut());
                        global.setErr(main.getErr());
                    }
                    main.setScope((Scriptable)EnvJSBrowser.this.scope);
                    main.pack();
                    main.setSize(600, 460);
                    main.setVisible(true);
                    main.setSourceProvider(new SourceProvider(){

                        public String getSource(DebuggableScript paramDebuggableScript) {
                            return null;
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public void close() {
        this.scope = null;
        this.cx = null;
        Context.exit();
    }

    public Browser createBrowserInstance() {
        return new Browser();
    }

    public Object eval(String js) {
        return this.cx.evaluateString((Scriptable)this.scope, js, "eval:" + js, 1, null);
    }

    public void setDocument(String url, String html) {
        String js = " document.async=true; document.baseURI = '" + url + "';HTMLParser.parseDocument(\"" + html.replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n") + "\", document);Envjs.wait();";
        this.evaluateTrustedString(this.cx, this.scope, js, "setDoc", 1, null);
    }

    public Object evalTrusted(String js) {
        return this.evaluateTrustedString(this.cx, this.scope, js, "evaltrusted:" + js, 1, null);
    }

    private Object evaluateTrustedString(Context cx2, Global scope2, String js, String string, int i, Object object) {
        this.scriptStack.add(string);
        try {
            Object object2 = JSHtmlUnitPermissionRestricter.evaluateTrustedString(cx2, this.scope, js, string, i, object);
            return object2;
        }
        catch (EcmaError e) {
            this.logger.log((Throwable)e);
            throw e;
        }
        finally {
            if (string != this.scriptStack.removeLast()) {
                throw new WTFException("Stack problem");
            }
        }
    }

    public void setGlobals(Object o) {
        this.globals = o;
    }

    public String getDocument() {
        Object result = this.evalTrusted("var f=function(){return document.innerHTML;}; f();");
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public Browser getBrowser() {
        return this.br;
    }

    public void require(Object string) throws IOException {
        JSHtmlUnitPermissionRestricter.evaluateTrustedString(this.cx, this.scope, this.readRequire(string + ""), "require_" + string, 1, null);
    }

    public void tick() {
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"envjsglobals", (Object)this.globals);
        this.tick.exec(this.cx, (Scriptable)this.scope);
    }

    public Global getScope() {
        return this.scope;
    }

    public void doBreak(int i) {
        System.out.println("Break " + i);
    }

    public void setUserAgent(String ua) {
        this.br.getHeaders().put("User-Agent", ua);
    }

    public void getPage(String parameter) {
        this.getPage(parameter, 300000);
    }

    public void getPage(String parameter, int timeout) {
        this.ensureInit();
        this.eval("var loading=true");
        this.eval("window.addEventListener(\"load\",function(){loading=false})");
        this.eval("document.location = '" + parameter + "';");
        Script script = this.cx.compileString("loading", "loading", 1, null);
        long until = timeout > 0 ? System.currentTimeMillis() + (long)timeout : -1L;
        while (until == -1L || System.currentTimeMillis() < until) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            this.tick();
            if (!Boolean.FALSE.equals(script.exec(this.cx, (Scriptable)this.scope))) continue;
            break;
        }
    }

    private void ensureInit() {
        if (this.scope == null) {
            this.init();
        }
    }

    public Regex getRegex(String regex) {
        return new Regex(this.getDocument(), regex);
    }

    public Form[] getForms() {
        Form[] forms = Form.getForms(this);
        return forms;
    }

    public void printStacktrace() {
        this.logger.log((Throwable)ScriptRuntime.constructError((String)"Stacktrace", null));
    }

    public Object getGlobals() {
        return this.globals;
    }

    public void setVariable(String property, String c) {
        ScriptableObject.putProperty((Scriptable)this.scope, (String)property, (Object)c);
    }

    static {
        try {
            JSHtmlUnitPermissionRestricter.init();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CCOUNTER = new AtomicLong(0L);
        INSTANCES = new ConcurrentHashMap();
    }

    public static enum DebugLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        NONE;

    }

    public static final class JsDebugger
    implements Debugger {
        private int max = 0;

        public void handleCompilationDone(Context paramContext, DebuggableScript paramDebuggableScript, String paramString) {
        }

        public DebugFrame getFrame(Context paramContext, final DebuggableScript paramDebuggableScript) {
            return new DebugFrame(){
                private static final String KEY_LAST_LINE = "DebugFrameImpl#line";
                private static final String KEY_LAST_SOURCE = "DebugFrameImpl#source";

                public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
                    StringBuilder sb = new StringBuilder();
                    String line = this.getFirstLine(cx);
                    String source = this.getSourceName(cx);
                    if (source.startsWith("envjs/parser")) {
                        return;
                    }
                    if (source.startsWith("envjs/console")) {
                        return;
                    }
                    sb.append(source).append(":").append(line);
                    JsDebugger.this.max = Math.max(sb.length(), JsDebugger.this.max);
                    while (sb.length() < JsDebugger.this.max + 3) {
                        sb.append(" ");
                    }
                    for (Scriptable parent = activation.getParentScope(); parent != null; parent = parent.getParentScope()) {
                        sb.append(" ->");
                    }
                    String functionName = this.getFunctionName(thisObj);
                    if ("envjs/platform/core".equals(source) && "toLoggerString".equals(functionName)) {
                        return;
                    }
                    if ("envjs/platform/core".equals(source) && "append".equals(functionName)) {
                        return;
                    }
                    if ("envjs/platform/core".equals(source) && "format".equals(functionName)) {
                        return;
                    }
                    if ("envjs/platform/core".equals(source) && "getDateString".equals(functionName)) {
                        return;
                    }
                    if ("envjs/platform/core".equals(source) && "log".equals(functionName)) {
                        return;
                    }
                    if (functionName == null) {
                        return;
                    }
                    sb.append(functionName).append("(");
                    int nbParams = paramDebuggableScript.getParamCount();
                    for (int i = 0; i < nbParams; ++i) {
                        String argAsString = i < args.length ? this.stringValue(args[i]) : "undefined";
                        sb.append(this.getParamName(i)).append(": ").append(argAsString);
                        if (i >= nbParams - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(")");
                    System.out.println(sb);
                }

                private String stringValue(Object arg) {
                    if (arg instanceof NativeFunction) {
                        String name = ((NativeFunction)arg).getFunctionName();
                        return "[function " + name + "]";
                    }
                    if (arg instanceof IdFunctionObject) {
                        return "[function " + ((IdFunctionObject)arg).getFunctionName() + "]";
                    }
                    if (arg instanceof Function) {
                        return "[function anonymous]";
                    }
                    String asString = null;
                    try {
                        asString = Context.toString((Object)arg);
                    }
                    catch (Throwable e) {
                        asString = String.valueOf(arg);
                    }
                    return asString;
                }

                public void onExceptionThrown(Context cx, Throwable t) {
                    ScriptRuntime.constructError((String)"Stacktrace", (String)t.getMessage()).printStackTrace();
                    if (t instanceof JavaScriptException) {
                        JavaScriptException e = (JavaScriptException)t;
                        System.out.println(this.getSourceName(cx) + ":" + this.getFirstLine(cx) + " Exception thrown: " + Context.toString((Object)e.getValue()));
                    } else {
                        System.out.println(this.getSourceName(cx) + ":" + this.getFirstLine(cx) + " Exception thrown: " + t.getCause());
                    }
                }

                public void onLineChange(Context cx, int lineNumber) {
                    cx.putThreadLocal((Object)KEY_LAST_LINE, (Object)lineNumber);
                    cx.putThreadLocal((Object)KEY_LAST_SOURCE, (Object)paramDebuggableScript.getSourceName());
                }

                private String getFunctionName(Scriptable thisObj) {
                    if (paramDebuggableScript.isFunction()) {
                        String name = paramDebuggableScript.getFunctionName();
                        if (name != null && name.length() > 0) {
                            return name;
                        }
                        if (thisObj instanceof ScriptableObject) {
                            // empty if block
                        }
                        for (Scriptable obj = thisObj; obj != null; obj = obj.getPrototype()) {
                            for (Object id : obj.getIds()) {
                                NativeFunction f;
                                Object o;
                                if (!(id instanceof String)) continue;
                                String s = (String)id;
                                if (obj instanceof ScriptableObject) {
                                    o = ((ScriptableObject)obj).getGetterOrSetter(s, 0, false);
                                    if (o == null) {
                                        o = ((ScriptableObject)obj).getGetterOrSetter(s, 0, true);
                                        if (o != null && o instanceof Callable) {
                                            return "__defineSetter__ " + s;
                                        }
                                    } else if (o instanceof Callable) {
                                        return null;
                                    }
                                }
                                if (!((o = obj.get(s, obj)) instanceof NativeFunction) || (f = (NativeFunction)o).getDebuggableView() != paramDebuggableScript) continue;
                                if ("debug".equals(s)) {
                                    return null;
                                }
                                return s;
                            }
                        }
                        return null;
                    }
                    return "[script]";
                }

                private String getParamName(int index) {
                    if (index >= 0 && paramDebuggableScript.getParamCount() > index) {
                        return paramDebuggableScript.getParamOrVarName(index);
                    }
                    return "???";
                }

                private String getSourceName(Context cx) {
                    String source = (String)cx.getThreadLocal((Object)KEY_LAST_SOURCE);
                    if (source == null) {
                        return "unknown";
                    }
                    return source;
                }

                private String getFirstLine(Context cx) {
                    Object line = cx.getThreadLocal((Object)KEY_LAST_LINE);
                    if (line == null) {
                        return "unknown";
                    }
                    return String.valueOf(line);
                }

                public void onExit(Context paramContext, boolean paramBoolean, Object paramObject) {
                }

                public void onDebuggerStatement(Context paramContext) {
                }
            };
        }
    }
}

