/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings;

import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.MultiHostHost;
import jd.plugins.MultiHostHostData;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.Storable;
import org.appwork.utils.StringUtils;

public class AccountData
implements Storable {
    private Map<String, Object> properties;
    private Map<String, Object> infoProperties;
    private String hoster;
    private String password;
    private String user;
    private String errorType;
    private String errorString;
    private String statusString;
    private List<String> hosterHistory = null;
    private List<MultiHostHostData> infoSupportedhostlist = null;
    private int maxSimultanDownloads;
    private long createTime;
    private long trafficLeft;
    private long trafficMax;
    private long validUntil;
    private long id = -1L;
    private volatile long tmpDisabledTimeout = -1L;
    private boolean active;
    private boolean enabled;
    private boolean trafficUnlimited;
    private boolean specialtraffic;
    private boolean concurrentUsePossible = true;
    private boolean trafficRefill = true;
    private double accountBalance;
    private String accountBalanceCurrency;

    public String getAccountBalanceCurrency() {
        return this.accountBalanceCurrency;
    }

    public void setAccountBalanceCurrency(String accountBalanceCurrency) {
        this.accountBalanceCurrency = accountBalanceCurrency;
    }

    @AllowNonStorableObjects
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getHoster() {
        return this.hoster;
    }

    public void setHoster(String hoster) {
        this.hoster = hoster;
    }

    public int getMaxSimultanDownloads() {
        return this.maxSimultanDownloads;
    }

    public void setMaxSimultanDownloads(int maxSimultanDownloads) {
        this.maxSimultanDownloads = maxSimultanDownloads;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getTmpDisabledTimeout() {
        return this.tmpDisabledTimeout;
    }

    public void setTmpDisabledTimeout(long tmpDisabledTimeout) {
        this.tmpDisabledTimeout = tmpDisabledTimeout;
    }

    public boolean isTrafficRefill() {
        return this.trafficRefill;
    }

    public void setTrafficRefill(boolean account_trafficRefill) {
        this.trafficRefill = account_trafficRefill;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isConcurrentUsePossible() {
        return this.concurrentUsePossible;
    }

    public void setConcurrentUsePossible(boolean concurrentUsePossible) {
        this.concurrentUsePossible = concurrentUsePossible;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    @AllowNonStorableObjects
    public Map<String, Object> getInfoProperties() {
        return this.infoProperties;
    }

    public void setInfoProperties(Map<String, Object> infoProperties) {
        this.infoProperties = infoProperties;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getTrafficLeft() {
        return this.trafficLeft;
    }

    public void setTrafficLeft(long trafficLeft) {
        this.trafficLeft = trafficLeft;
    }

    public long getTrafficMax() {
        return this.trafficMax;
    }

    public void setTrafficMax(long trafficMax) {
        this.trafficMax = trafficMax;
    }

    public long getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(long validUntil) {
        this.validUntil = validUntil;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isTrafficUnlimited() {
        return this.trafficUnlimited;
    }

    public void setTrafficUnlimited(boolean trafficUnlimited) {
        this.trafficUnlimited = trafficUnlimited;
    }

    public boolean isSpecialtraffic() {
        return this.specialtraffic;
    }

    public void setSpecialtraffic(boolean specialtraffic) {
        this.specialtraffic = specialtraffic;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public double getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(double accountBalance) {
        this.accountBalance = accountBalance;
    }

    public List<String> getHosterHistory() {
        return this.hosterHistory;
    }

    public void setHosterHistory(List<String> hosterHistory) {
        this.hosterHistory = hosterHistory;
    }

    public List<MultiHostHostData> getSupportedhostlist() {
        return this.infoSupportedhostlist;
    }

    public void setSupportedhostlist(List<MultiHostHostData> supportedhostlist) {
        this.infoSupportedhostlist = supportedhostlist;
    }

    private static String enumToString(Account.AccountError error) {
        return error == null ? null : error.name();
    }

    public static AccountData create(Account a) {
        AccountData ret = new AccountData();
        ret.properties = a.getProperties();
        ret.id = a.getId().getID();
        ret.errorType = AccountData.enumToString(a.getError());
        ret.tmpDisabledTimeout = a.getTmpDisabledTimeout();
        ret.errorString = a.getErrorString();
        ret.hosterHistory = a.getHosterHistory();
        AccountInfo ai = a.getAccountInfo();
        if (ai != null) {
            ret.infoProperties = ai.getProperties();
            if (ret.infoProperties == null) {
                ret.infoProperties = new HashMap<String, Object>();
            }
            ret.trafficRefill = ai.isTrafficRefill();
            ret.createTime = ai.getCreateTime();
            ret.trafficLeft = ai.getTrafficLeft();
            ret.trafficMax = ai.getTrafficMax();
            ret.validUntil = ai.getValidUntil();
            ret.trafficUnlimited = ai.isUnlimitedTraffic();
            ret.specialtraffic = ai.isSpecialTraffic();
            ret.statusString = ai.getStatus();
            ret.accountBalance = ai.getAccountBalance();
            Currency currency = ai.getCurrency();
            ret.accountBalanceCurrency = currency != null ? currency.getCurrencyCode() : null;
            ret.infoSupportedhostlist = MultiHostHostData.createFromMultiHostHostList(ai.getMultiHostSupportV2());
        }
        ret.concurrentUsePossible = a.isConcurrentUsePossible();
        ret.enabled = a.isEnabled();
        ret.hoster = a.getHoster();
        ret.maxSimultanDownloads = a.getMaxSimultanDownloads();
        ret.password = a.getPass();
        ret.user = a.getUser();
        return ret;
    }

    private Currency _getCurrency() {
        String currencyCode = this.getAccountBalanceCurrency();
        if (currencyCode == null) {
            return null;
        }
        try {
            return Currency.getInstance(currencyCode);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Account toAccount() {
        Account ret = new Account(this.user, this.password);
        ret.setProperties(this.properties);
        if (this.infoProperties != null) {
            AccountInfo ai = new AccountInfo();
            ret.setAccountInfo(ai);
            ai.setProperties(this.infoProperties);
            ai.setCreateTime(this.createTime);
            ai.setTrafficLeft(this.trafficLeft);
            ai.setTrafficMax(this.trafficMax);
            ai.setValidUntil(this.validUntil);
            ai.setStatus(this.statusString);
            ai.setTrafficRefill(this.trafficRefill);
            ai.setAccountBalance(this.accountBalance, this._getCurrency());
            if (this.trafficUnlimited) {
                ai.setUnlimitedTraffic();
            }
            ai.setSpecialTraffic(this.specialtraffic);
            if (this.infoSupportedhostlist != null) {
                ArrayList<MultiHostHost> supportedhosts = new ArrayList<MultiHostHost>();
                for (MultiHostHostData mhostdata : this.infoSupportedhostlist) {
                    supportedhosts.add(mhostdata.toMultiHostHost());
                }
                ai.setMultiHostSupportV2(supportedhosts);
            }
        }
        ret.setHosterHistory(this.getHosterHistory());
        ret.setId(this.getId());
        ret.setConcurrentUsePossible(this.concurrentUsePossible);
        ret.setEnabled(this.enabled);
        ret.setHoster(this.hoster);
        ret.setMaxSimultanDownloads(this.maxSimultanDownloads);
        ret.setPass(this.password);
        ret.setUser(this.user);
        if (StringUtils.isNotEmpty((String)this.errorType)) {
            try {
                ret.setError(Account.AccountError.valueOf(this.errorType), this.getTmpDisabledTimeout(), this.errorString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ret.setTmpDisabledTimeout(this.getTmpDisabledTimeout());
        return ret;
    }
}

