/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.appwork.storage.Storable;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.AbstractCustomValueGetter;
import org.appwork.storage.config.annotations.ConfigEntryKeywords;
import org.appwork.storage.config.annotations.CustomValueGetter;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultIntArrayValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultLongValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.annotations.ValidatorFactory;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.validators.DefaultSimpleDateValidator;
import org.appwork.utils.Application;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.View;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.LinktablesSearchCategory;
import org.jdownloader.settings.FrameStatus;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.gui.LookAndFeelType;

public interface GraphicalUserInterfaceSettings
extends ConfigInterface {
    @DefaultEnumValue(value="AUTO")
    @AboutConfig
    public DownloadFolderChooserDialogSubfolder getDownloadFolderChooserDialogSubfolder();

    public void setDownloadFolderChooserDialogSubfolder(DownloadFolderChooserDialogSubfolder var1);

    @AboutConfig
    @DefaultIntValue(value=30000)
    public int getSpeedMeterTimeFrame();

    public void setSpeedMeterTimeFrame(int var1);

    @AboutConfig
    @DefaultIntValue(value=4)
    @SpinnerValidator(min=1L, max=10L, step=1L)
    public int getSpeedMeterFramesPerSecond();

    public void setSpeedMeterFramesPerSecond(int var1);

    public String getActivePluginConfigPanel();

    public String getActiveConfigPanel();

    public String getActiveMyJDownloaderPanel();

    @AboutConfig
    @DescriptionForConfigEntry(value="Captcha Dialog Image scale Faktor in %")
    @DefaultIntValue(value=100)
    @SpinnerValidator(min=50L, max=500L, step=10L)
    public int getCaptchaScaleFactor();

    @DefaultIntValue(value=20000)
    @AboutConfig
    public int getDialogDefaultTimeoutInMS();

    @DefaultEnumValue(value="ALL")
    public org.jdownloader.gui.views.downloads.View getDownloadView();

    @AboutConfig
    @DescriptionForConfigEntry(value="Refreshrate in ms for the DownloadView")
    @DefaultLongValue(value=500L)
    @SpinnerValidator(min=50L, max=5000L, step=25L)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public long getDownloadViewRefresh();

    public FrameStatus getLastFrameStatus();

    @DefaultEnumValue(value="SKIP_FILE")
    public IfFileExistsAction getLastIfFileExists();

    @AboutConfig
    public String getPassword();

    public LinktablesSearchCategory getSelectedDownloadSearchCategory();

    public LinktablesSearchCategory getSelectedLinkgrabberSearchCategory();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isBalloonNotificationEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="Enable/disable Clipboard monitoring")
    @DefaultBooleanValue(value=true)
    public boolean isClipboardMonitored();

    @AboutConfig
    @DefaultEnumValue(value="ON_STARTUP")
    @DescriptionForConfigEntry(value="ON_STARTUP: Skip the first clipboard content on startup. ON_ENABLE: Skip the first clipboard content when enabling clipboard observation. NEVER: Always process clipboard content immediately, both on startup and when clipboard observation is enabled.")
    public CLIPBOARD_SKIP_MODE getClipboardSkipMode();

    public void setClipboardSkipMode(CLIPBOARD_SKIP_MODE var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Enable/disable HTML-Flavor(Browser selection) Clipboard monitoring")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isClipboardMonitorProcessHTMLFlavor();

    public void setClipboardMonitorProcessHTMLFlavor(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Blacklist(regex) of processes to ignore Clipboard monitoring")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public String[] getClipboardProcessBlacklist();

    public void setClipboardProcessBlacklist(String[] var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If disabled, The Hostercolumn will show gray disabled icons if the link is disabled")
    public boolean isColoredIconsForDisabledHosterColumnEnabled();

    @DefaultBooleanValue(value=false)
    @CustomValueGetter(value=CustomIsConfigViewVisible.class)
    public boolean isConfigViewVisible();

    @DefaultBooleanValue(value=false)
    public boolean isMyJDownloaderViewVisible();

    @AboutConfig
    @DescriptionForConfigEntry(value="Highlight Table in Downloadview if table is filtered")
    @DefaultBooleanValue(value=true)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isFilterHighlightEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="Enable/Disable the DownloadPanel Overview panel ")
    @DefaultBooleanValue(value=true)
    public boolean isDownloadTabOverviewVisible();

    public void setDownloadTabOverviewVisible(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Enable/Disable the Linkgrabber Overview panel ")
    @DefaultBooleanValue(value=true)
    public boolean isLinkgrabberTabOverviewVisible();

    public void setLinkgrabberTabOverviewVisible(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Enable/Disable the Linkgrabber properties panel ")
    @DefaultBooleanValue(value=true)
    public boolean isLinkgrabberTabPropertiesPanelVisible();

    public void setLinkgrabberTabPropertiesPanelVisible(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Enable/Disable the Downloads properties panel ")
    @DefaultBooleanValue(value=true)
    public boolean isDownloadsTabPropertiesPanelVisible();

    public void setDownloadsTabPropertiesPanelVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelTotalInfoVisible();

    public void setOverviewPanelTotalInfoVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelVisibleOnlyInfoVisible();

    public void setOverviewPanelVisibleOnlyInfoVisible(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Include disabled links in the size calculation")
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelLinkgrabberIncludeDisabledLinks();

    public void setOverviewPanelLinkgrabberIncludeDisabledLinks(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Include disabled links in the totalbytes and loadedbytes calculation")
    public boolean isOverviewPanelDownloadPanelIncludeDisabledLinks();

    public void setOverviewPanelDownloadPanelIncludeDisabledLinks(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isDownloadPanelOverviewSettingsVisible();

    public void setDownloadPanelOverviewSettingsVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelSelectedInfoVisible();

    public void setOverviewPanelSelectedInfoVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelSmartInfoVisible();

    public void setOverviewPanelSmartInfoVisible(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isLinkgrabberSidebarVisible();

    @DefaultBooleanValue(value=false)
    @AboutConfig
    @DescriptionForConfigEntry(value="If true, you can easily delete selected/matching filter with delete hotkey")
    public boolean isLinkgrabberSidebarDeleteHotkeyEnabled();

    public void setLinkgrabberSidebarDeleteHotkeyEnabled(boolean var1);

    @DefaultBooleanValue(value=false)
    @AboutConfig
    public boolean isPasswordProtectionEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, ETAColumn will show Premium Alerts in Free Download mode if JD thinks Premium would be better currently.")
    public boolean isPremiumAlertETAColumnEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, SpeedColumn will show Premium Alerts in Free Download mode if JD thinks Premium would be better currently.")
    public boolean isPremiumAlertSpeedColumnEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, TaskColumn will show Premium Alerts in Free Download mode if JD thinks Premium would be better currently.")
    public boolean isPremiumAlertTaskColumnEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="Set to true of you want jd to remember the latest selected download view")
    @DefaultBooleanValue(value=false)
    public boolean isSaveDownloadViewCrossSessionEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="Highlight Column in Downloadview if table is not in downloadsortorder")
    @DefaultBooleanValue(value=true)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isSortColumnHighlightEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="If false, Most of the Tooltips will be disabled")
    @DefaultBooleanValue(value=true)
    public boolean isTooltipEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="If true, hostcolumn will also show full hostname")
    @DefaultBooleanValue(value=false)
    public boolean isShowFullHostname();

    @AboutConfig
    @DescriptionForConfigEntry(value="If true, java will try to use D3D for graphics")
    @DefaultBooleanValue(value=false)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isUseD3D();

    public void setUseD3D(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isSpeedMeterVisible();

    public void setSpeedMeterVisible(boolean var1);

    public void setShowFullHostname(boolean var1);

    public void setActiveConfigPanel(String var1);

    public void setActiveMyJDownloaderPanel(String var1);

    public void setActivePluginConfigPanel(String var1);

    public void setBalloonNotificationEnabled(boolean var1);

    public void setCaptchaScaleFactor(int var1);

    public void setClipboardMonitored(boolean var1);

    public void setColoredIconsForDisabledHosterColumnEnabled(boolean var1);

    public void setMyJDownloaderViewVisible(boolean var1);

    public void setConfigViewVisible(boolean var1);

    public void setDialogDefaultTimeoutInMS(int var1);

    public void setDownloadView(org.jdownloader.gui.views.downloads.View var1);

    public void setDownloadViewRefresh(long var1);

    public void setFilterHighlightEnabled(boolean var1);

    public void setLastFrameStatus(FrameStatus var1);

    public void setLastIfFileExists(IfFileExistsAction var1);

    public void setLinkgrabberSidebarVisible(boolean var1);

    public void setPassword(String var1);

    public void setPasswordProtectionEnabled(boolean var1);

    public void setPremiumAlertSpeedColumnEnabled(boolean var1);

    public void setPremiumAlertETAColumnEnabled(boolean var1);

    public void setPremiumAlertTaskColumnEnabled(boolean var1);

    public void setSaveDownloadViewCrossSessionEnabled(boolean var1);

    @DefaultEnumValue(value="FILENAME")
    public void setSelectedDownloadSearchCategory(LinktablesSearchCategory var1);

    @DefaultEnumValue(value="FILENAME")
    public void setSelectedLinkgrabberSearchCategory(LinktablesSearchCategory var1);

    public void setSortColumnHighlightEnabled(boolean var1);

    public void setPresentationModeEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Presentation mode peforms tasks like: account username obstruction throughout GUI")
    public boolean isPresentationModeEnabled();

    public void setTooltipEnabled(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=2000)
    @SpinnerValidator(min=0L, max=5000L, step=50L)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public int getTooltipDelay();

    public void setTooltipDelay(int var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isCaptchaDialogUniquePositionByHosterEnabled();

    public void setCaptchaDialogUniquePositionByHosterEnabled(boolean var1);

    @DefaultEnumValue(value="DETAILS")
    @AboutConfig
    public void setFileChooserView(View var1);

    public View getFileChooserView();

    @DefaultBooleanValue(value=false)
    @AboutConfig
    @DescriptionForConfigEntry(value="Hide the package in case it only contains one child")
    public boolean isHideSingleChildPackages();

    public void setHideSingleChildPackages(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isFileCountInSizeColumnVisible();

    public void setFileCountInSizeColumnVisible(boolean var1);

    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    public SIZEUNIT getMaxSizeUnit();

    public void setMaxSizeUnit(SIZEUNIT var1);

    @DefaultEnumValue(value="TOTAL_PROGRESS")
    @AboutConfig
    public MacDockProgressDisplay getMacDockProgressDisplay();

    public void setMacDockProgressDisplay(MacDockProgressDisplay var1);

    @DefaultEnumValue(value="TOTAL_PROGRESS")
    @AboutConfig
    public WindowsTaskBarProgressDisplay getWindowsTaskbarProgressDisplay();

    public void setWindowsTaskbarProgressDisplay(WindowsTaskBarProgressDisplay var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isTaskBarFlashEnabled();

    public void setTaskBarFlashEnabled(boolean var1);

    @DefaultBooleanValue(value=false)
    @AboutConfig
    public boolean isCaptchaDebugModeEnabled();

    public void setCaptchaDebugModeEnabled(boolean var1);

    @DefaultEnumValue(value="ADD_ALL_LINKS_AND_START_DOWNLOADS")
    @DescriptionForConfigEntry(value="Choose what should happen when you click on the [Start Downloads] Button when you are in the Linkgrabber Tab")
    @AboutConfig
    public StartButtonAction getStartButtonActionInLinkgrabberContext();

    public void setStartButtonActionInLinkgrabberContext(StartButtonAction var1);

    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Use horizontal Scrollbars in DownloadTable")
    @AboutConfig
    public boolean isHorizontalScrollbarsInDownloadTableEnabled();

    public void setHorizontalScrollbarsInDownloadTableEnabled(boolean var1);

    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Use horizontal Scrollbars in Linkgrabber")
    @AboutConfig
    public boolean isHorizontalScrollbarsInLinkgrabberTableEnabled();

    public void setHorizontalScrollbarsInLinkgrabberTableEnabled(boolean var1);

    @RequiresRestart(value="A JDownloader Restart is Required")
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="The row that is 'touched' by the mouse cursor gets a darker shadow")
    @AboutConfig
    public boolean isTableMouseOverHighlightEnabled();

    public void setTableMouseOverHighlightEnabled(boolean var1);

    @RequiresRestart(value="A JDownloader Restart is Required")
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Packages get a different background color if enabled")
    @AboutConfig
    public boolean isPackagesBackgroundHighlightEnabled();

    public void setPackagesBackgroundHighlightEnabled(boolean var1);

    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DefaultFactory(value=DefaultLookAndFeelTheme.class)
    public LookAndFeelType getLookAndFeelTheme();

    public void setLookAndFeelTheme(LookAndFeelType var1);

    @AboutConfig
    @DefaultEnumValue(value="TO_FRONT")
    public WindowManager.FrameState getNewDialogFrameState();

    public void setNewDialogFrameState(WindowManager.FrameState var1);

    @AboutConfig
    @DefaultEnumValue(value="SWITCH")
    public NewLinksInLinkgrabberAction getNewLinksActionV2();

    public void setNewLinksActionV2(NewLinksInLinkgrabberAction var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="JDownloader uses a workaround to bring it's window or dialogs to focused to front. It simulates an ALT key shortcut. \r\nIf disabled, you will get focus problems")
    @DefaultBooleanValue(value=true)
    public boolean isWindowsWindowManagerAltKeyWorkaroundEnabled();

    public void setWindowsWindowManagerAltKeyWorkaroundEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="JDownloader uses a workaround to bring it's window or dialogs to focused to front. It simulates an ALT key shortcut. \r\nIf disabled, you will get focus problems")
    @DefaultIntArrayValue(value={17, 18, 16})
    public int[] getWindowsWindowManagerAltKeyCombi();

    public void setWindowsWindowManagerAltKeyCombi(int[] var1);

    @AboutConfig
    @RequiresRestart(value="A Windows Reboot is Required")
    @DescriptionForConfigEntry(value="This value is read from the windows registry. if you set it, JDownloader will write it back to the registry.")
    public void setWindowsWindowManagerForegroundLockTimeout(int var1);

    public int getWindowsWindowManagerForegroundLockTimeout();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isUpdateButtonFlashingEnabled();

    public void setUpdateButtonFlashingEnabled(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="WHEN_WINDOW_IS_MINIMIZED")
    public ShowSpeedInWindowTitleTrigger getSpeedInWindowTitle();

    public void setSpeedInWindowTitle(ShowSpeedInWindowTitleTrigger var1);

    @AboutConfig
    @DefaultIntValue(value=14)
    @DescriptionForConfigEntry(value="Days to keep disabled accounts displayed in PremiumBar and AccountToolTip overviews.")
    public int getPremiumStatusBarDisabledAccountExpire();

    public void setPremiumStatusBarDisabledAccountExpire(int var1);

    @AboutConfig
    @DefaultEnumValue(value="GROUP_BY_ACCOUNT_TYPE")
    public PremiumStatusBarDisplay getPremiumStatusBarDisplay();

    public void setPremiumStatusBarDisplay(PremiumStatusBarDisplay var1);

    @AboutConfig
    @DefaultEnumValue(value="OPEN_FOLDER")
    public PackageDoubleClickAction getPackageDoubleClickAction();

    public void setPackageDoubleClickAction(PackageDoubleClickAction var1);

    @AboutConfig
    @DefaultEnumValue(value="OPEN_FILE")
    public LinkDoubleClickAction getLinkDoubleClickAction();

    public void setLinkDoubleClickAction(LinkDoubleClickAction var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkPropertiesPanelCommentVisible();

    public void setLinkPropertiesPanelCommentVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkPropertiesPanelFilenameVisible();

    public void setLinkPropertiesPanelFilenameVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkPropertiesPanelPackagenameVisible();

    public void setLinkPropertiesPanelPackagenameVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkPropertiesPanelDownloadPasswordVisible();

    public void setLinkPropertiesPanelDownloadPasswordVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkPropertiesPanelChecksumVisible();

    public void setLinkPropertiesPanelChecksumVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkPropertiesPanelArchivepasswordVisible();

    public void setLinkPropertiesPanelArchivepasswordVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkPropertiesPanelSaveToVisible();

    public void setLinkPropertiesPanelSaveToVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isLinkPropertiesPanelDownloadFromVisible();

    public void setLinkPropertiesPanelDownloadFromVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadsPropertiesPanelCommentVisible();

    public void setDownloadsPropertiesPanelCommentVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isDownloadsPropertiesPanelFilenameVisible();

    public void setDownloadsPropertiesPanelFilenameVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadsPropertiesPanelPackagenameVisible();

    public void setDownloadsPropertiesPanelPackagenameVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadsPropertiesPanelDownloadPasswordVisible();

    public void setDownloadsPropertiesPanelDownloadPasswordVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadsPropertiesPanelChecksumVisible();

    public void setDownloadsPropertiesPanelChecksumVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadsPropertiesPanelArchivepasswordVisible();

    public void setDownloadsPropertiesPanelArchivepasswordVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadsPropertiesPanelSaveToVisible();

    public void setDownloadsPropertiesPanelSaveToVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isDownloadsPropertiesPanelDownloadFromVisible();

    public void setDownloadsPropertiesPanelDownloadFromVisible(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Choose how many 'Are you sure?' warnings you want to see (Bug me not).")
    @DefaultEnumValue(value="NORMAL")
    public RlyWarnLevel getRlyWarnLevel();

    public void setRlyWarnLevel(RlyWarnLevel var1);

    @DescriptionForConfigEntry(value="Placeholders: |#TITLE|, | - #SPEED/s|, | - #UPDATENOTIFY|, | - #AVGSPEED|, | - #RUNNING_DOWNLOADS|")
    @DefaultStringValue(value="|#TITLE|| - #SPEED/s|| - #UPDATENOTIFY|")
    @AboutConfig
    public String getTitlePattern();

    public void setTitlePattern(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isBypassAllRlyDeleteDialogsEnabled();

    public void setBypassAllRlyDeleteDialogsEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isHelpDialogsEnabled();

    public void setHelpDialogsEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isHateCaptchasTextInCaptchaDialogVisible();

    public void setHateCaptchasTextInCaptchaDialogVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isPropertiesPanelHeightNormalized();

    public void setPropertiesPanelHeightNormalized(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isSpecialDealsEnabled();

    public void setSpecialDealsEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isBannerEnabled();

    public void setBannerEnabled(boolean var1);

    public long getBannerChangeTimestamp();

    public void setBannerChangeTimestamp(long var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadPackageCountVisible();

    public void setOverviewPanelDownloadPackageCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelLinkgrabberHosterCountVisible();

    public void setOverviewPanelLinkgrabberHosterCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadLinkCountVisible();

    public void setOverviewPanelDownloadLinkCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadTotalBytesVisible();

    public void setOverviewPanelDownloadTotalBytesVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isOverviewPanelDownloadLinksFailedCountVisible();

    public void setOverviewPanelDownloadLinksFailedCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isOverviewPanelDownloadLinksFinishedCountVisible();

    public void setOverviewPanelDownloadLinksFinishedCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isOverviewPanelDownloadLinksSkippedCountVisible();

    public void setOverviewPanelDownloadLinksSkippedCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadRunningDownloadsCountVisible();

    public void setOverviewPanelDownloadRunningDownloadsCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadSpeedVisible();

    public void setOverviewPanelDownloadSpeedVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadETAVisible();

    public void setOverviewPanelDownloadETAVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadConnectionsVisible();

    public void setOverviewPanelDownloadConnectionsVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadBytesLoadedVisible();

    public void setOverviewPanelDownloadBytesLoadedVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelDownloadBytesRemainingVisible();

    public void setOverviewPanelDownloadBytesRemainingVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelLinkgrabberPackageCountVisible();

    public void setOverviewPanelLinkgrabberPackageCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelLinkgrabberLinksCountVisible();

    public void setOverviewPanelLinkgrabberLinksCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelLinkgrabberTotalBytesVisible();

    public void setOverviewPanelLinkgrabberTotalBytesVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelLinkgrabberStatusUnknownVisible();

    public void setOverviewPanelLinkgrabberStatusUnknownVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelLinkgrabberStatusOnlineVisible();

    public void setOverviewPanelLinkgrabberStatusOnlineVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isOverviewPanelLinkgrabberStatusOfflineVisible();

    public void setOverviewPanelLinkgrabberStatusOfflineVisible(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="ASK")
    public ConfirmIncompleteArchiveAction getConfirmIncompleteArchiveAction();

    public void setConfirmIncompleteArchiveAction(ConfirmIncompleteArchiveAction var1);

    @AboutConfig
    @RequiresRestart(value="Restart is Required")
    public String getCustomLookAndFeelClass();

    public void setCustomLookAndFeelClass(String var1);

    @AboutConfig
    @ValidatorFactory(value=DefaultSimpleDateValidator.class)
    @RequiresRestart(value="Restart is Required")
    public String getDateTimeFormatAccountManagerExpireDateColumn();

    public void setDateTimeFormatAccountManagerExpireDateColumn(String var1);

    @AboutConfig
    @ValidatorFactory(value=DefaultSimpleDateValidator.class)
    @RequiresRestart(value="Restart is Required")
    public String getDateTimeFormatDownloadListAddedDateColumn();

    public void setDateTimeFormatDownloadListAddedDateColumn(String var1);

    @AboutConfig
    @ValidatorFactory(value=DefaultSimpleDateValidator.class)
    @RequiresRestart(value="Restart is Required")
    public String getDateTimeFormatDownloadListModifiedDateColumn();

    public void setDateTimeFormatDownloadListModifiedDateColumn(String var1);

    @AboutConfig
    @ValidatorFactory(value=DefaultSimpleDateValidator.class)
    @RequiresRestart(value="Restart is Required")
    public String getDateTimeFormatDownloadListFinishedDateColumn();

    public void setDateTimeFormatDownloadListFinishedDateColumn(String var1);

    @AboutConfig
    @RequiresRestart(value="Restart is Required")
    @DefaultBooleanValue(value=true)
    public boolean isSpecialDealOboomDialogVisibleOnStartup();

    public void setSpecialDealOboomDialogVisibleOnStartup(boolean var1);

    @RequiresRestart(value="Restart is Required")
    @AboutConfig
    public Map<String, Long> getPremiumExpireWarningMapV2();

    public void setPremiumExpireWarningMapV2(Map<String, Long> var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isPremiumExpireWarningEnabled();

    public void setPremiumExpireWarningEnabled(boolean var1);

    @AboutConfig
    @RequiresRestart(value="Restart is Required")
    @DefaultBooleanValue(value=true)
    public boolean isStatusBarAddPremiumButtonVisible();

    public void setStatusBarAddPremiumButtonVisible(boolean var1);

    @AboutConfig
    @RequiresRestart(value="Restart is Required")
    @DescriptionForConfigEntry(value="Table wrap enabled? Cursor/Selection will jump to the begin/end of the table when reaching bottom/top position")
    @DefaultBooleanValue(value=true)
    public boolean isTableWrapAroundEnabled();

    public void setTableWrapAroundEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="The last used the Regex option for 'Rename Filename/Packagename' Dialog")
    @DefaultBooleanValue(value=false)
    public boolean isRenameActionRegexEnabled();

    public void setRenameActionRegexEnabled(boolean var1);

    @DescriptionForConfigEntry(value="If enabled ctrl+A first of all selects all children in all current packages, and in a second step all packages")
    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isTwoStepCtrlASelectionEnabled();

    public void setTwoStepCtrlASelectionEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadControlColumnAutoShowEnabled();

    public void setDownloadControlColumnAutoShowEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isPriorityColumnAutoShowEnabled();

    public void setPriorityColumnAutoShowEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Shortcut for the  Refresh Button in the captcha dialog")
    @DefaultStringValue(value="pressed F5")
    public String getShortcutForCaptchaDialogRefresh();

    public void setShortcutForCaptchaDialogRefresh(String var1);

    @AboutConfig
    @RequiresRestart(value="Restart JDownloader if you changed this value")
    @DescriptionForConfigEntry(value="Interval of the Downloads Table Refresher. Default 1000ms (once per second). Decreasing this value will cost CPU Power")
    @DefaultLongValue(value=1000L)
    public long getDownloadsTableRefreshInterval();

    public void setDownloadsTableRefreshInterval(long var1);

    @AboutConfig
    @RequiresRestart(value="Restart JDownloader if you changed this value")
    @DescriptionForConfigEntry(value="Customize the order of the Overview Panel Entries in x and y position")
    public HashMap<String, Position> getOverviewPositions();

    public void setOverviewPositions(HashMap<String, Position> var1);

    @DefaultEnumValue(value="SOUTH")
    @AboutConfig
    public DockingPosition getLinkgrabberBottombarPosition();

    public void setLinkgrabberBottombarPosition(DockingPosition var1);

    @AboutConfig
    @DefaultEnumValue(value="CURRENT_PATH")
    public DownloadFolderChooserDialogDefaultPath getDownloadFolderChooserDefaultPath();

    public void setDownloadFolderChooserDefaultPath(DownloadFolderChooserDialogDefaultPath var1);

    @AboutConfig
    @DefaultEnumValue(value="AUTO_VISIBLE")
    @ConfigEntryKeywords(value={"donat", "contribut"})
    public DonateButtonState getDonateButtonState();

    public void setDonateButtonState(DonateButtonState var1);

    public void setDonateButtonLatestAutoChange(long var1);

    public long getDonateButtonLatestAutoChange();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If disabled, the captcha has no border painted, and the dialog looks like in jd09")
    public boolean isCaptchaDialogBorderAroundImageEnabled();

    public void setCaptchaDialogBorderAroundImageEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isAvailableColumnTextVisible();

    public void setAvailableColumnTextVisible(boolean var1);

    @AboutConfig
    public String getDonationNotifyID();

    public void setDonationNotifyID(String var1);

    public void setDownloadListScrollPosition(int[] var1);

    public int[] getDownloadListScrollPosition();

    public void setLinkgrabberListScrollPosition(int[] var1);

    public int[] getLinkgrabberListScrollPosition();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Set to false to invert the sort Order for the Download & Linkgrabber Tables.")
    public boolean isPrimaryTableSorterDesc();

    public void setPrimaryTableSorterDesc(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isPremiumDisabledWarningFlashEnabled();

    public void setPremiumDisabledWarningFlashEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isClipboardDisabledWarningFlashEnabled();

    public void setClipboardDisabledWarningFlashEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="If Enabled, JDownloader will try to be always on top of all other windows")
    public boolean isMainWindowAlwaysOnTop();

    public void setMainWindowAlwaysOnTop(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If Enabled, JDownloader will open the explorer window after container(eg DLC) export")
    public boolean isContainerExportOpenExplorer();

    public void setContainerExportOpenExplorer(boolean var1);

    public static enum DonateButtonState implements LabelInterface
    {
        AUTO_HIDDEN{

            public String getLabel() {
                return _JDT.T.DonateButtonState_AUTO_HIDDEN();
            }
        }
        ,
        AUTO_VISIBLE{

            public String getLabel() {
                return _JDT.T.DonateButtonState_AUTO_VISIBLE();
            }
        }
        ,
        CUSTOM_VISIBLE{

            public String getLabel() {
                return _JDT.T.DonateButtonState_CUSTOM_VISIBLE();
            }
        }
        ,
        CUSTOM_HIDDEN{

            public String getLabel() {
                return _JDT.T.DonateButtonState_CUSTOM_HIDDEN();
            }
        };

    }

    public static enum DownloadFolderChooserDialogDefaultPath implements LabelInterface
    {
        CURRENT_PATH{

            public String getLabel() {
                return _JDT.T.DownloadFolderChooserDialogDefaultPath_CURRENT_PATH();
            }
        }
        ,
        GLOBAL_DOWNLOAD_DIRECTORY{

            public String getLabel() {
                return _JDT.T.DownloadFolderChooserDialogDefaultPath_GLOBAL_DOWNLOAD_DIRECTORY(CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue());
            }
        }
        ,
        LAST_USED_PATH{

            public String getLabel() {
                return _JDT.T.DownloadFolderChooserDialogDefaultPath_LAST_USED_PATH();
            }
        };

    }

    public static enum DockingPosition implements LabelInterface
    {
        NORTH{

            public String getLabel() {
                return _GUI.T.setOverviewPositions_north();
            }
        }
        ,
        SOUTH{

            public String getLabel() {
                return _GUI.T.setOverviewPositions_south();
            }
        };

    }

    public static class Position
    implements Storable {
        private int x = -1;
        private int y = -1;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }

    public static enum ConfirmIncompleteArchiveAction implements LabelInterface
    {
        ASK{

            public String getLabel() {
                return _GUI.T.GraphicalUserInterfaceSettings_getLabel_ask_();
            }
        }
        ,
        KEEP_IN_LINKGRABBER{

            public String getLabel() {
                return _GUI.T.GraphicalUserInterfaceSettings_getLabel_do_not_move();
            }
        }
        ,
        MOVE_TO_DOWNLOADLIST{

            public String getLabel() {
                return _GUI.T.GraphicalUserInterfaceSettings_getLabel_move_anyway();
            }
        }
        ,
        DELETE{

            public String getLabel() {
                return _GUI.T.GraphicalUserInterfaceSettings_getLabel_delete();
            }
        };

    }

    public static enum DeleteFileOptions implements LabelInterface
    {
        REMOVE_LINKS_ONLY{

            @Override
            public String getLabel() {
                return _GUI.T.ConfirmDeleteLinksDialog_layoutDialogContent_no_filedelete2();
            }
        }
        ,
        REMOVE_LINKS_AND_RECYCLE_FILES{

            @Override
            public String getLabel() {
                return _GUI.T.ConfirmDeleteLinksDialog_layoutDialogContent_Recycle_2();
            }
        }
        ,
        REMOVE_LINKS_AND_DELETE_FILES{

            @Override
            public String getLabel() {
                return _GUI.T.ConfirmDeleteLinksDialog_layoutDialogContent_delete_2();
            }
        };


        public String getLabel() {
            return null;
        }
    }

    public static enum RlyWarnLevel {
        HIGH,
        NORMAL,
        LOW,
        DISABLED;

    }

    public static enum LinkDoubleClickAction {
        OPEN_FOLDER,
        OPEN_FILE,
        RENAME,
        OPEN_PROPERTIES_PANEL,
        NOTHING;

    }

    public static enum PackageDoubleClickAction {
        EXPAND_COLLAPSE_TOGGLE,
        OPEN_FOLDER,
        RENAME,
        OPEN_PROPERTIES_PANEL,
        NOTHING;

    }

    public static enum PremiumStatusBarDisplay {
        GROUP_BY_ACCOUNT_TYPE,
        GROUP_BY_SUPPORTED_HOSTS,
        DONT_GROUP,
        GROUP_BY_SUPPORTED_ACCOUNTS;

    }

    public static enum ShowSpeedInWindowTitleTrigger {
        NEVER,
        WHEN_WINDOW_IS_MINIMIZED,
        ALWAYS;

    }

    public static enum NewLinksInLinkgrabberAction {
        SWITCH,
        NOTHING,
        TO_FRONT,
        FOCUS;

    }

    public static class DefaultLookAndFeelTheme
    extends AbstractDefaultFactory<LookAndFeelType> {
        public LookAndFeelType getDefaultValue(KeyHandler<LookAndFeelType> keyHandler) {
            if (Application.isHeadless()) {
                return LookAndFeelType.JAVA_SYSTEM;
            }
            if (Application.getRessourceURL((String)"cfg/synthetica-license.key") != null && LookAndFeelType.DEFAULT.isAvailable()) {
                return LookAndFeelType.DEFAULT;
            }
            if (LookAndFeelType.FLATLAF_LIGHT.isAvailable()) {
                return LookAndFeelType.FLATLAF_LIGHT;
            }
            return LookAndFeelType.JAVA_SYSTEM;
        }
    }

    public static enum StartButtonAction {
        ADD_ALL_LINKS_AND_START_DOWNLOADS,
        START_DOWNLOADS_ONLY,
        DISABLED;

    }

    public static enum WindowsTaskBarProgressDisplay implements LabelInterface
    {
        TOTAL_PROGRESS{

            public String getLabel() {
                return _GUI.T.DockProgressDisplay_total_progress();
            }
        }
        ,
        NOTHING{

            public String getLabel() {
                return _GUI.T.DockProgressDisplay_nothing();
            }
        }
        ,
        TOTAL_PROGRESS_AND_CONNECTIONS{

            public String getLabel() {
                return _GUI.T.DockProgressDisplay_connections_and_progress();
            }
        };

    }

    public static enum MacDockProgressDisplay implements LabelInterface
    {
        TOTAL_PROGRESS{

            public String getLabel() {
                return _GUI.T.DockProgressDisplay_total_progress();
            }
        }
        ,
        NOTHING{

            public String getLabel() {
                return _GUI.T.DockProgressDisplay_nothing();
            }
        };

    }

    public static enum SIZEUNIT {
        TiB(0x10000000000L, true),
        TB(1000000000000L),
        GiB(0x40000000L, true),
        GB(1000000000L),
        MiB(0x100000L, true),
        MB(1000000L),
        KiB(1024L, true),
        KB(1000L),
        B(1L);

        private final long divider;
        private final boolean iecPrefix;

        public final boolean isIECPrefix() {
            return this.iecPrefix;
        }

        public final long getDivider() {
            return this.divider;
        }

        private SIZEUNIT(long divider, boolean isIECPrefix) {
            this.divider = divider;
            this.iecPrefix = isIECPrefix;
        }

        private SIZEUNIT(long divider) {
            this(divider, false);
        }

        public long to(SIZEUNIT dest, long value) {
            long ret = value * this.getDivider() / dest.getDivider();
            return ret;
        }

        public static final String formatValue(SIZEUNIT maxSizeUnit, long fileSize) {
            return SIZEUNIT.formatValue(maxSizeUnit, new DecimalFormat(), fileSize);
        }

        public static final String formatValue(SIZEUNIT maxSizeUnit, DecimalFormat formatter, long fileSize) {
            return SIZEUNIT.formatValue(maxSizeUnit, (NumberFormat)formatter, fileSize);
        }

        public static final String formatValue(SIZEUNIT maxSizeUnit, NumberFormat formatter, long fileSize) {
            boolean isIECPrefix = maxSizeUnit.isIECPrefix();
            switch (maxSizeUnit) {
                case TiB: {
                    if (fileSize >= TiB.getDivider()) {
                        return _AWU.T.literally_tebibyte(formatter.format((double)fileSize / (double)TiB.getDivider()));
                    }
                }
                case TB: {
                    if (!isIECPrefix && fileSize >= TB.getDivider()) {
                        return formatter.format((double)fileSize / (double)TB.getDivider()).concat(" TB");
                    }
                }
                case GiB: {
                    if (isIECPrefix && fileSize >= GiB.getDivider()) {
                        return _AWU.T.literally_gibibyte(formatter.format((double)fileSize / (double)GiB.getDivider()));
                    }
                }
                case GB: {
                    if (!isIECPrefix && fileSize >= GB.getDivider()) {
                        return formatter.format((double)fileSize / (double)GB.getDivider()).concat(" GB");
                    }
                }
                case MiB: {
                    if (isIECPrefix && fileSize >= MiB.getDivider()) {
                        return _AWU.T.literally_mebibyte(formatter.format((double)fileSize / (double)MiB.getDivider()));
                    }
                }
                case MB: {
                    if (!isIECPrefix && fileSize >= MB.getDivider()) {
                        return formatter.format((double)fileSize / (double)MB.getDivider()).concat(" MB");
                    }
                }
                case KiB: {
                    if (isIECPrefix && fileSize >= KiB.getDivider()) {
                        return _AWU.T.literally_kibibyte(formatter.format((double)fileSize / (double)KiB.getDivider()));
                    }
                }
                case KB: {
                    if (isIECPrefix || fileSize < KB.getDivider()) break;
                    return formatter.format((double)fileSize / (double)KB.getDivider()).concat(" KB");
                }
            }
            if (fileSize == 0L) {
                return _AWU.T.literally_byte(0L);
            }
            if (fileSize < 0L) {
                return "~";
            }
            return _AWU.T.literally_byte(fileSize);
        }
    }

    public static enum CLIPBOARD_SKIP_MODE {
        ON_STARTUP,
        ON_ENABLE,
        NEVER;

    }

    public static class CustomIsConfigViewVisible
    extends AbstractCustomValueGetter<Boolean> {
        public Boolean getValue(KeyHandler<Boolean> keyHandler, Boolean value) {
            if (CrossSystem.isMac() && !JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7)) {
                return Boolean.TRUE;
            }
            return value;
        }
    }

    public static enum DownloadFolderChooserDialogSubfolder {
        AUTO,
        ENABLED,
        DISABLED;

    }
}

