/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.webcache;

import java.lang.reflect.Type;
import java.util.ArrayList;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Regex;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.jdownloader.webcache.CachedHeader;

public class CachedRequest
implements Storable {
    public static final TypeRef<CachedRequest> TYPE_REF = new TypeRef<CachedRequest>(){

        public Type getType() {
            return CachedRequest.class;
        }
    };
    private HTTPConnection.RequestMethod method;
    private String key;
    private String url;
    private byte[] _bytes;
    private ArrayList<CachedHeader> headers;
    private long maxAge;
    private long createTime;
    private int responseCode;
    private String responseMessage;

    public CachedRequest() {
    }

    public HTTPConnection.RequestMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPConnection.RequestMethod method) {
        this.method = method;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public byte[] _getBytes() {
        return this._bytes;
    }

    public void _setBytes(byte[] bytes) {
        this._bytes = bytes;
    }

    public ArrayList<CachedHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(ArrayList<CachedHeader> headers) {
        this.headers = headers;
    }

    public String getBytes64() {
        return Base64.encodeToString((byte[])this._bytes, (boolean)false);
    }

    public void setBytes64(String bytes64) {
        this._bytes = Base64.decode((String)bytes64);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public CachedRequest(HTTPConnection.RequestMethod method, String lookupKey, String url, int responseCode, String responseMessage, byte[] bytes, ArrayList<CachedHeader> headers) {
        String maxAge;
        this.method = method;
        this.key = lookupKey;
        this.url = url;
        this._bytes = bytes;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.headers = headers;
        String expires = null;
        String cacheControl = null;
        String date = null;
        block0: for (CachedHeader header : headers) {
            for (String v : header.getValues()) {
                if ("Cache-Control".equalsIgnoreCase(header.getKey())) {
                    cacheControl = v;
                    continue block0;
                }
                if ("Expires".equalsIgnoreCase(header.getKey())) {
                    expires = v;
                    continue block0;
                }
                if (!"Date".equalsIgnoreCase(header.getKey())) continue;
                date = v;
                continue block0;
            }
        }
        this.createTime = System.currentTimeMillis();
        if (cacheControl != null && (maxAge = new Regex(cacheControl, "max-age=(\\d+)").getMatch(0)) != null) {
            this.maxAge = Integer.parseInt(maxAge) * 1000;
        }
        if (this.maxAge < 0L && expires != null) {
            long now = System.currentTimeMillis();
            long expiresLong = TimeFormatter.parseDateString(expires).getTime();
            if (date != null) {
                now = TimeFormatter.parseDateString(date).getTime();
            }
            this.maxAge = expiresLong - now;
            System.out.println("Max Age " + this.maxAge);
        }
        if (!this._isExpired()) {
            System.out.println("Write Cache " + url);
            System.out.println(JSonStorage.serializeToJson((Object)this));
        }
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public boolean _isExpired() {
        return this.getMaxAge() >= 0L && this.getCreateTime() + this.getMaxAge() <= System.currentTimeMillis();
    }
}

