/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.parser.Regex;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.LogInterface;

public class Cookies {
    private final CopyOnWriteArrayList<Cookie> cookies = new CopyOnWriteArrayList();
    private String userAgent = null;
    public static String NOTDELETEDPATTERN = "^(?i)((?!^deleted$).)*$";

    public static Cookies parseSetCookies(Request request) throws IOException {
        URLConnectionAdapter httpConnection = request.getHttpConnection();
        String date = httpConnection.getHeaderField("Date");
        List setCookies = httpConnection.getHeaderFields("Set-Cookie");
        Cookies ret = new Cookies();
        if (setCookies == null || setCookies.size() == 0) {
            return ret;
        }
        String host = Browser.getHost(request.getURL());
        for (int i = 0; i < setCookies.size(); ++i) {
            String setCookie = (String)setCookies.get(i);
            Cookie cookie = new Cookie();
            cookie.setHost(host);
            cookie.setHostTime(date);
            StringTokenizer st = new StringTokenizer(setCookie, ";");
            while (st.hasMoreTokens()) {
                String value;
                String key;
                String cookieKeyValueString = st.nextToken().trim();
                String[] keyValuePair = new Regex(cookieKeyValueString, "(.*?)=(.*)").getRow(0);
                if (keyValuePair == null || keyValuePair.length == 0) {
                    if (!StringUtils.isNotEmpty((String)cookieKeyValueString)) continue;
                    key = cookieKeyValueString.trim();
                    value = null;
                } else if (keyValuePair.length == 1) {
                    key = keyValuePair[0].trim();
                    value = null;
                } else {
                    if (keyValuePair.length != 2) continue;
                    key = keyValuePair[0].trim();
                    value = keyValuePair[1].trim();
                }
                if (key == null) continue;
                if ("path".equalsIgnoreCase(key)) {
                    cookie.setPath(value);
                    continue;
                }
                if ("expires".equalsIgnoreCase(key)) {
                    cookie.setExpires(value);
                    continue;
                }
                if ("domain".equalsIgnoreCase(key)) {
                    cookie.setDomain(value);
                    continue;
                }
                if ("secure".equalsIgnoreCase(key)) {
                    cookie.setSecure(true);
                    continue;
                }
                if ("HttpOnly".equalsIgnoreCase(key)) continue;
                if ("Max-Age".equalsIgnoreCase(key)) {
                    try {
                        long maxAge = Long.parseLong(value);
                        if (maxAge <= 0L) {
                            cookie.setExpireDate(1L);
                            continue;
                        }
                        if (cookie.getHostTime() <= 0L) continue;
                        cookie.setExpireDate(cookie.getHostTime() + maxAge * 1000L);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (cookie.getKey() != null) continue;
                cookie.setKey(key);
                cookie.setValue(value);
            }
            if (cookie.getKey() == null) continue;
            ret.add(cookie);
        }
        return ret;
    }

    public static Cookies parseCookies(String cookieString, String host, String serverTime, boolean isSetCookie) {
        String header = cookieString;
        String path = null;
        String expires = null;
        String domain = null;
        boolean secure = false;
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        StringTokenizer st = new StringTokenizer(header, ";");
        while (st.hasMoreTokens()) {
            String value;
            String key;
            String cookieKeyValueString = st.nextToken().trim();
            String[] keyValuePair = new Regex(cookieKeyValueString, "(.*?)=(.*)").getRow(0);
            if (keyValuePair == null || keyValuePair.length == 0) {
                if (!StringUtils.isNotEmpty((String)cookieKeyValueString)) continue;
                key = cookieKeyValueString.trim();
                value = null;
            } else if (keyValuePair.length == 1) {
                key = keyValuePair[0].trim();
                value = null;
            } else {
                if (keyValuePair.length != 2) continue;
                key = keyValuePair[0].trim();
                value = keyValuePair[1].trim();
            }
            if (key == null) continue;
            if ("path".equalsIgnoreCase(key)) {
                path = value;
                continue;
            }
            if ("expires".equalsIgnoreCase(key)) {
                expires = value;
                continue;
            }
            if ("domain".equalsIgnoreCase(key)) {
                domain = value;
                continue;
            }
            if ("secure".equalsIgnoreCase(key)) {
                secure = true;
                continue;
            }
            if ("HttpOnly".equalsIgnoreCase(key) || "Max-Age".equalsIgnoreCase(key) || isSetCookie && tmp.size() != 0) continue;
            tmp.put(key, value);
        }
        Cookies cookies = new Cookies();
        for (Map.Entry next : tmp.entrySet()) {
            if (next.getValue() == null) continue;
            Cookie cookie = new Cookie();
            cookies.add(cookie);
            cookie.setHost(host);
            cookie.setPath(path);
            cookie.setDomain(domain);
            cookie.setExpires(expires);
            cookie.setValue((String)next.getValue());
            cookie.setKey((String)next.getKey());
            cookie.setHostTime(serverTime);
            cookie.setSecure(secure);
        }
        return cookies;
    }

    public static Cookies parseCookiesFromString(String str) {
        return Cookies.parseCookiesFromJsonString(str, null);
    }

    private static Long parseTimestamp(Object timeStamp) {
        Object ret;
        Object object = ret = timeStamp != null ? ReflectionUtils.cast((Object)timeStamp, Number.class) : null;
        if (ret != null && ret instanceof Number) {
            long ts = ((Number)ret).longValue();
            return ts * 1000L;
        }
        return null;
    }

    public static Cookies parseCookiesFromJsonString(String str, LogInterface logger) {
        return Cookies.parseCookiesFromObject(str, logger);
    }

    public static Cookies parseCookiesFromObject(Object input, LogInterface logger) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            String jsonStr = input.toString();
            if (jsonStr == null || !jsonStr.matches("(?s)^\\s*\\{.*\\}\\s*$") && !jsonStr.matches("(?s)^\\s*\\[.*\\]\\s*$")) {
                return null;
            }
            try {
                input = JSonStorage.restoreFromString((String)jsonStr, (TypeRef)TypeRef.OBJECT);
            }
            catch (JSonMapperException jme) {
                if (logger != null) {
                    logger.exception(HexFormatter.byteArrayToHex((byte[])String.valueOf(jsonStr).getBytes()), (Throwable)jme);
                    logger.info("Failed to parse cookie json");
                }
                return null;
            }
        }
        try {
            long timeStamp = Time.timestamp();
            List entries = ReflectionUtils.wrapList((Object)input, (boolean)false, Object.class);
            if (entries != null) {
                Cookies ret = new Cookies();
                for (Object entry : entries) {
                    Cookie cookie = new Cookie();
                    List cookiesList = ReflectionUtils.wrapList(entry, (boolean)false, String.class);
                    if (cookiesList != null) {
                        int listSize = cookiesList.size();
                        if (listSize == 1) {
                            cookie.setKey((String)cookiesList.get(0));
                        } else if (listSize == 2) {
                            cookie.setKey((String)cookiesList.get(0));
                            cookie.setValue((String)cookiesList.get(1));
                        } else {
                            if (listSize != 3) continue;
                            cookie.setKey((String)cookiesList.get(0));
                            cookie.setValue((String)cookiesList.get(1));
                            cookie.setHost((String)cookiesList.get(2));
                        }
                    } else {
                        if (!(entry instanceof Map)) continue;
                        Map cookieInfo = (Map)entry;
                        String domain = (String)cookieInfo.get("domain");
                        String key = (String)cookieInfo.get("name");
                        String value = (String)cookieInfo.get("value");
                        String path = (String)cookieInfo.get("path");
                        boolean secure = (Boolean)cookieInfo.get("secure");
                        if (StringUtils.isEmpty((String)domain) || StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)path)) continue;
                        cookie.setHost(domain);
                        cookie.setPath(path);
                        cookie.setDomain(domain);
                        Long expirationDate = Cookies.parseTimestamp(cookieInfo.get("expirationDate"));
                        if (expirationDate != null) {
                            cookie.setExpireDate(expirationDate);
                        } else {
                            cookie.setExpireDate(-1L);
                        }
                        cookie.setKey(key);
                        cookie.setValue(value);
                        cookie.setSecure(secure);
                    }
                    ret.add(cookie);
                }
                if (ret.isEmpty()) {
                    throw new Exception("no parsed cookies!?");
                }
                return ret;
            }
            if (input instanceof Map) {
                Cookies ret = new Cookies();
                Map cookieMap = (Map)input;
                String userAgent = (String)cookieMap.get("userAgent");
                ret.setUserAgent(userAgent);
                for (Map.Entry entryOuter : cookieMap.entrySet()) {
                    if (!(entryOuter.getValue() instanceof Map)) continue;
                    for (Map.Entry entryDomain : ((Map)entryOuter.getValue()).entrySet()) {
                        for (Map.Entry entryCookie : ((Map)entryDomain.getValue()).entrySet()) {
                            Map cookieInfo = (Map)entryCookie.getValue();
                            String domain = (String)cookieInfo.get("domain");
                            String key = (String)cookieInfo.get("name");
                            String value = (String)cookieInfo.get("value");
                            String path = (String)cookieInfo.get("path");
                            boolean secure = (Boolean)cookieInfo.get("secure");
                            if (StringUtils.isEmpty((String)domain) || StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)path)) continue;
                            Cookie cookie = new Cookie();
                            cookie.setHost(domain);
                            cookie.setPath(path);
                            cookie.setDomain(domain);
                            Long expirationDate = Cookies.parseTimestamp(cookieInfo.get("expirationDate"));
                            if (expirationDate != null) {
                                cookie.setExpireDate(expirationDate);
                            } else {
                                cookie.setExpireDate(-1L);
                            }
                            cookie.setKey(key);
                            cookie.setValue(value);
                            cookie.setSecure(secure);
                            ret.add(cookie);
                        }
                    }
                }
                if (ret.isEmpty()) {
                    throw new Exception("no parsed cookies!?");
                }
                return ret;
            }
            throw new WTFException("unknown/unsupported format");
        }
        catch (Exception e) {
            if (logger != null) {
                logger.log((Throwable)e);
                logger.info("Failed to process cookie object: Invalid/unsupported format?");
            }
            return null;
        }
    }

    public static Cookies parseCookies(String cookieString, String host, String serverTime) {
        return Cookies.parseCookies(cookieString, host, serverTime, false);
    }

    public Cookies() {
    }

    public Cookies(Cookies cookies) {
        this.add(cookies);
    }

    public synchronized void add(Cookie cookie) {
        for (Cookie cookie2 : this.cookies) {
            if (!cookie2.equals(cookie)) continue;
            cookie2.update(cookie);
            return;
        }
        this.cookies.add(cookie);
    }

    public void add(Cookies newcookies) {
        if (newcookies != null) {
            for (Cookie cookie : newcookies.getCookies()) {
                this.add(cookie);
            }
        }
    }

    public boolean setUserAgent(String useragent) {
        if (StringUtils.isEmpty((String)useragent)) {
            this.userAgent = null;
            return false;
        }
        this.userAgent = useragent;
        return true;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void clear() {
        this.cookies.clear();
    }

    public Cookie get(String key, String valuePattern) {
        Cookie cookie = this.get(key);
        if (cookie != null) {
            if (valuePattern == null) {
                return cookie;
            }
            String cookieValue = cookie.getValue();
            if (cookieValue != null && Pattern.compile(valuePattern).matcher(cookieValue).matches()) {
                return cookie;
            }
            return null;
        }
        return null;
    }

    public Cookie get(String key) {
        if (key == null) {
            return null;
        }
        for (Cookie cookie : this.cookies) {
            if (!cookie.getKey().equals(key)) continue;
            return cookie;
        }
        for (Cookie cookie : this.cookies) {
            if (!cookie.getKey().equalsIgnoreCase(key)) continue;
            return cookie;
        }
        return null;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public boolean isEmpty() {
        return this.cookies.isEmpty();
    }

    public void remove(Cookie cookie) {
        this.cookies.remove(cookie);
    }

    public void remove(String keyName) {
        Cookie ckie;
        if (keyName != null && (ckie = this.get(keyName)) != null) {
            this.cookies.remove(ckie);
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (Cookie el : this.cookies) {
            if (ret.length() > 0) {
                ret.append("\r\n");
            }
            ret.append(el.toString());
        }
        return ret.toString();
    }
}

