/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.util.concurrent.atomic.AtomicLong;
import jd.http.Authentication;
import jd.http.Browser;
import jd.http.Request;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Hash;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;

public class DigestAuthentication
extends Authentication {
    protected final String nonce;
    protected final String algorithm;
    protected final String qop;
    protected final String cnonce = Hash.getMD5((String)Long.toString(System.nanoTime()));
    protected final String opaque;
    protected final AtomicLong nc = new AtomicLong(1L);

    public String getNonce() {
        return this.nonce;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getQop() {
        return this.qop;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public long getNc() {
        return this.nc.get();
    }

    public DigestAuthentication(String host, String username, String password, String realm, String nonce, String algorithm, String qop, String opaque) {
        super(false, host, username, password, realm);
        this.nonce = nonce;
        this.qop = qop;
        this.algorithm = algorithm;
        this.opaque = opaque;
    }

    protected String getNextNc() {
        String ret = Long.toHexString(this.nc.incrementAndGet());
        if (ret.length() < 8) {
            return String.format("%0" + (8 - ret.length()) + "d", 0) + ret;
        }
        return ret;
    }

    protected String hashWithAlgorithm(String value) {
        if (StringUtils.equalsIgnoreCase((String)this.getAlgorithm(), (String)"MD5")) {
            return Hash.getMD5((String)value);
        }
        if (StringUtils.equalsIgnoreCase((String)this.getAlgorithm(), (String)"SHA-256")) {
            return Hash.getSHA256((String)value);
        }
        throw new WTFException("Unsupported algorithm:" + this.getAlgorithm());
    }

    public static DigestAuthentication build(Browser browser, Request request, String realm, String username, String password) {
        String wwwAuthenticate;
        String qop;
        if ((StringUtils.isNotEmpty((String)username) || StringUtils.isNotEmpty((String)password)) && StringUtils.equalsIgnoreCase((String)(qop = new Regex(wwwAuthenticate = request.getResponseHeader("WWW-Authenticate"), "qop\\s*=\\s*\"(.*?)\"").getMatch(0)), (String)"auth")) {
            String nonce = new Regex(wwwAuthenticate, "nonce\\s*=\\s*\"(.*?)\"").getMatch(0);
            String algorithm = new Regex(wwwAuthenticate, "algorithm\\s*=\\s*(MD5|SHA-256)").getMatch(0);
            if (algorithm == null) {
                algorithm = new Regex(wwwAuthenticate, "algorithm\\s*=\\s*\"(MD5|SHA-256)\"").getMatch(0);
            }
            if (nonce != null && algorithm != null) {
                String opaque = new Regex(wwwAuthenticate, "opaque\\s*=\\s*\"(.*?)\"").getMatch(0);
                return new DigestAuthentication(request.getURL().getHost(), username, password, realm, nonce, algorithm, qop, opaque);
            }
        }
        return null;
    }

    @Override
    public boolean authorize(Browser browser, Request request) {
        if (StringUtils.endsWithCaseInsensitive((String)request.getURL().getHost(), (String)this.getHost()) && !this.isProxyAuthentication()) {
            String HA1 = this.hashWithAlgorithm(StringUtils.valueOrEmpty((String)this.getUsername()) + ":" + StringUtils.valueOrEmpty((String)this.getRealm()) + ":" + StringUtils.valueOrEmpty((String)this.getPassword()));
            String HA2 = this.hashWithAlgorithm(request.getRequestMethod() + ":" + request.getURL().getPath());
            String nextNc = this.getNextNc();
            String response = this.hashWithAlgorithm(HA1 + ":" + this.getNonce() + ":" + nextNc + ":" + this.getCnonce() + ":" + this.getQop() + ":" + HA2);
            String auth = "username=\"" + StringUtils.valueOrEmpty((String)this.getUsername()) + "\", realm=\"" + StringUtils.valueOrEmpty((String)this.getRealm()) + "\", nonce=\"" + this.getNonce() + "\", uri=\"" + request.getURL().getPath() + "\", algorithm=" + this.getAlgorithm() + ", response=\"" + response + "\", qop=\"" + this.getQop() + "\", nc=" + nextNc + ", cnonce=\"" + this.getCnonce() + "\"";
            if (this.getOpaque() != null) {
                auth = auth + ", opaque=\"" + this.getOpaque() + "\"";
            }
            request.getHeaders().put("Authorization", "Digest " + auth);
            return true;
        }
        return false;
    }

    @Override
    public boolean retry(Browser browser, Request request) {
        return false;
    }
}

