/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.net.URL;
import jd.http.URLConnectionAdapter;
import jd.http.URLConnectionAdapterDirectImpl;
import jd.http.URLConnectionAdapterHTTPProxyImpl;
import jd.http.URLConnectionAdapterNative;
import jd.http.URLConnectionAdapterSocks4Impl;
import jd.http.URLConnectionAdapterSocks5Impl;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public class HTTPConnectionFactory {
    public static URLConnectionAdapter createHTTPConnection(URL url, HTTPProxy proxy) {
        if (proxy == null) {
            return new URLConnectionAdapterDirectImpl(url);
        }
        if (proxy.isPreferNativeImplementation()) {
            return new URLConnectionAdapterNative(url, proxy);
        }
        switch (proxy.getType()) {
            case NONE: 
            case DIRECT: {
                return new URLConnectionAdapterDirectImpl(url, proxy);
            }
            case HTTP: 
            case HTTPS: {
                return new URLConnectionAdapterHTTPProxyImpl(url, proxy);
            }
            case SOCKS4: 
            case SOCKS4A: {
                return new URLConnectionAdapterSocks4Impl(url, proxy);
            }
            case SOCKS5: {
                return new URLConnectionAdapterSocks5Impl(url, proxy);
            }
        }
        throw new RuntimeException("unsupported proxy type: " + proxy.getType().name());
    }
}

