/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.URL;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.URLConnectionAdapterDirectImpl;
import jd.http.WrappedBrotliInputStream;
import jd.http.requests.PostFormDataRequest;
import jd.http.requests.PostRequest;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.SSLSocketStreamInterface;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.httpconnection.Socks5HTTPConnectionImpl;
import org.appwork.utils.net.socketconnection.SocketConnection;

public class URLConnectionAdapterSocks5Impl
extends Socks5HTTPConnectionImpl
implements URLConnectionAdapter {
    private Request request;
    private boolean allResponseCodesAllowed = false;
    protected SocketAddress endPointSocketAddress;

    public URLConnectionAdapterSocks5Impl(URL url, HTTPProxy proxy) {
        super(url, proxy);
    }

    @Override
    public InputStream getErrorStream() {
        try {
            return super.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected SSLSocketStreamOptions getSSLSocketStreamOptions(SSLSocketStreamOptions options) {
        Request request = this.getRequest();
        if (request != null) {
            return request.getSSLSocketStreamOptions(options, this);
        }
        return options;
    }

    @Override
    public void setAllResponseCodesAllowed(boolean b) {
        this.allResponseCodesAllowed = b;
    }

    @Override
    public boolean isAllResponseCodesAllowed() {
        return this.allResponseCodesAllowed;
    }

    @Override
    public String getCipherSuite() {
        SocketStreamInterface socket = this.getConnectionSocket();
        if (socket != null && socket instanceof SSLSocketStreamInterface) {
            return ((SSLSocketStreamInterface)socket).getCipherSuite();
        }
        return null;
    }

    protected boolean isResponseCodeAllowed(int code) {
        return this.isAllResponseCodesAllowed() || super.isResponseCodeAllowed(code);
    }

    public long[] getRange() {
        long[] ret = super.getRange();
        if (ret == null && this.getResponseCode() == 206) {
            this.ranges = URLConnectionAdapterDirectImpl.buildFakeContentRange(this);
            return this.ranges;
        }
        return ret;
    }

    @Override
    public long getLongContentLength() {
        return this.getContentLength();
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(Request request) {
        InetAddress customInetAddress;
        this.request = request;
        if (request != null && (customInetAddress = request.getCustomInetAddress()) != null) {
            this.setCustomEndPointInetAddress(customInetAddress);
        }
    }

    protected boolean isRequiresOutputStream() {
        return super.isRequiresOutputStream() || this.request != null && this.request.requireOutputStream();
    }

    @Override
    public byte[] peek(int numBytes) throws IOException {
        return URLConnectionAdapterDirectImpl.peek(this, numBytes);
    }

    public InputStream getInputStream() throws IOException {
        if (this.convertedInputStream == null && !HTTPConnection.RequestMethod.HEAD.equals((Object)this.getRequestMethod())) {
            String encoding;
            super.getInputStream();
            if (!this.isContentDecoded() && "br".equalsIgnoreCase(encoding = this.getHeaderField("Content-Encoding"))) {
                this.convertedInputStream = new WrappedBrotliInputStream(this.convertedInputStream);
                this.contentDecoded = true;
            }
        }
        return super.getInputStream();
    }

    @Override
    public InputStream setInputStream(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        InputStream ret = this.convertedInputStream;
        if (ret == null) {
            ret = this.getInputStream();
        }
        if (is == ret) {
            return is;
        }
        this.convertedInputStream = is;
        return ret;
    }

    public boolean isLegacyConnectEnabled() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(300);
        Request req = this.getRequest();
        if (req != null) {
            sb.append("Caller: " + req.getCaller());
            sb.append("\r\n");
            sb.append("BrowserID:" + req.getBrowserID() + "|BrowserParentID:" + req.getBrowserParentID() + "|RequestID:" + req.getRequestID() + "|URL:" + req.getURL());
            sb.append("\r\n");
        }
        sb.append(this.getRequestInfo());
        if (req != null) {
            String postDataString;
            if (req instanceof PostRequest) {
                String log = ((PostRequest)req).log();
                if (log != null) {
                    sb.append("\r\n");
                    sb.append(log);
                }
            } else if (req instanceof PostFormDataRequest && (postDataString = ((PostFormDataRequest)req).getPostDataString()) != null) {
                sb.append("\r\n");
                sb.append(postDataString);
            }
            sb.append("\r\n");
        }
        sb.append(this.getResponseInfo());
        return sb.toString();
    }

    public void disconnect() {
        try {
            this.getEndPointSocketAddress();
        }
        finally {
            super.disconnect();
        }
    }

    @Override
    public SocketAddress getEndPointSocketAddress() {
        if (this.endPointSocketAddress == null) {
            this.endPointSocketAddress = SocketConnection.getRootEndPointSocketAddress((SocketStreamInterface)this.getConnectionSocket());
        }
        return this.endPointSocketAddress;
    }
}

