/*
 * Decompiled with CFR 0.152.
 */
package jd.http.test;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import jd.http.Browser;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.extmanager.LoggerFactory;

public class IntervalTest {
    static int interval = 50;
    static int threads = 6;
    static int loop = 100;

    public static void main(String[] args) throws Exception {
        Application.setApplication((String)".awutests");
        Browser br = new Browser();
        br.setLogger(LoggerFactory.getDefaultLogger());
        Browser.setRequestIntervalLimitGlobal("jdownloader.org", true, 1000);
        Browser.setBurstRequestIntervalLimitGlobal("ipcheck0.jdownloader.org", true, 1000, 10, 5000);
        br.getPage("http://jdownloader.org");
        for (int i = 0; i < 1000; ++i) {
            System.out.println(i);
            br.getPage("http://ipcheck0.jdownloader.org");
            if (i > 60) {
                Browser.setBurstRequestIntervalLimitGlobal("ipcheck0.jdownloader.org", true, 1000, 100, 5000);
                continue;
            }
            if (i > 50) {
                Browser.setBurstRequestIntervalLimitGlobal("ipcheck0.jdownloader.org", true, 1000, 0, 0);
                continue;
            }
            if (i <= 20) continue;
            Browser.setRequestIntervalLimitGlobal("ipcheck0.jdownloader.org", true, 0);
        }
        Browser.setRequestIntervalLimitGlobal("ipcheck1.jdownloader.org", true, interval);
        Browser.setRequestIntervalLimitGlobal("ipcheck2.jdownloader.org", true, interval);
        br.getPage("http://ipcheck0.jdownloader.org");
        final AtomicLong wait = new AtomicLong(0L);
        ArrayList<1> threadList = new ArrayList<1>();
        for (int thread = 0; thread < threads; ++thread) {
            final Browser browser = br.cloneBrowser();
            Thread t = new Thread("Thread:" + thread){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    try {
                        long last = -1L;
                        int endPoint = 0;
                        for (int loop = IntervalTest.loop; loop >= 0; --loop) {
                            switch (endPoint) {
                                case 0: {
                                    browser.getPage("http://ipcheck0.jdownloader.org");
                                    break;
                                }
                                case 1: {
                                    browser.getPage("http://ipcheck1.jdownloader.org");
                                    break;
                                }
                                case 2: {
                                    browser.getPage("http://ipcheck2.jdownloader.org");
                                }
                            }
                            endPoint = (endPoint + 1) % 3;
                            long now = System.currentTimeMillis();
                            long dif = now - last;
                            last = now;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    finally {
                        long took = System.currentTimeMillis() - start;
                        System.out.println(Thread.currentThread().getName() + " took:" + took);
                        wait.addAndGet(took);
                    }
                }
            };
            threadList.add(t);
            t.start();
        }
        for (Thread thread : threadList) {
            thread.join();
        }
        System.out.println("Took:" + wait.get() + " for " + loop * threads + " = " + wait.get() / (long)(loop * threads));
    }
}

