/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.codec.ico;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sf.image4j.codec.bmp.BMPDecoder;
import net.sf.image4j.codec.bmp.ColorEntry;
import net.sf.image4j.codec.bmp.InfoHeader;
import net.sf.image4j.codec.ico.ICOImage;
import net.sf.image4j.codec.ico.IconEntry;
import net.sf.image4j.io.LittleEndianInputStream;

public class ICODecoder {
    private static final int PNG_MAGIC = -1991225785;
    private static final int PNG_MAGIC_LE = 1196314761;
    private static final int PNG_MAGIC2 = 218765834;
    private static final int PNG_MAGIC2_LE = 169478669;

    private ICODecoder() {
    }

    public static List<BufferedImage> read(File file) throws IOException {
        return ICODecoder.read(new FileInputStream(file));
    }

    public static List<ICOImage> readExt(File file) throws IOException {
        return ICODecoder.readExt(new FileInputStream(file));
    }

    public static List<BufferedImage> read(InputStream inputStream) throws IOException {
        List<ICOImage> list = ICODecoder.readExt(inputStream);
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ICOImage iCOImage = list.get(i);
            BufferedImage bufferedImage = iCOImage.getImage();
            arrayList.add(bufferedImage);
        }
        return arrayList;
    }

    public static List<ICOImage> readExt(InputStream inputStream) throws IOException {
        int n;
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(inputStream);
        short s = littleEndianInputStream.readShortLE();
        short s2 = littleEndianInputStream.readShortLE();
        int n2 = littleEndianInputStream.readShortLE();
        IconEntry[] iconEntryArray = new IconEntry[n2];
        for (n = 0; n < n2; n = (short)(n + 1)) {
            iconEntryArray[n] = new IconEntry(littleEndianInputStream);
        }
        n = 0;
        ArrayList<ICOImage> arrayList = new ArrayList<ICOImage>(n2);
        try {
            for (n = 0; n < n2; ++n) {
                Object object;
                Object object2;
                ColorEntry[] colorEntryArray;
                Object object3;
                Object object4;
                Object object5;
                int n3 = littleEndianInputStream.readIntLE();
                if (n3 == 40) {
                    int n4;
                    int n5;
                    int n6;
                    InfoHeader infoHeader = BMPDecoder.readInfoHeader(littleEndianInputStream, n3);
                    object5 = new InfoHeader(infoHeader);
                    ((InfoHeader)object5).iHeight = infoHeader.iHeight / 2;
                    object4 = new InfoHeader(infoHeader);
                    object4.iHeight = ((InfoHeader)object5).iHeight;
                    ((InfoHeader)object5).sBitCount = 1;
                    ((InfoHeader)object5).iNumColors = 2;
                    BufferedImage bufferedImage = BMPDecoder.read((InfoHeader)object4, littleEndianInputStream);
                    object3 = new BufferedImage(object4.iWidth, object4.iHeight, 2);
                    colorEntryArray = new ColorEntry[]{new ColorEntry(255, 255, 255, 255), new ColorEntry(0, 0, 0, 0)};
                    if (infoHeader.sBitCount == 32) {
                        int n7 = iconEntryArray[n].iSizeInBytes;
                        int n8 = infoHeader.iSize;
                        int n9 = object4.iWidth * object4.iHeight * 4;
                        int n10 = n7 - n8 - n9;
                        int n11 = littleEndianInputStream.skipBytes(n10);
                        n6 = n10;
                        while (n11 < n6) {
                            if (n11 < 0) {
                                if (n == n2 - 1) break;
                                throw new IOException("Failed to read [skip]");
                            }
                            n6 = n10 - n11;
                            int n12 = littleEndianInputStream.read();
                            if (n12 == -1) {
                                n11 = -1;
                                continue;
                            }
                            n11 = 1;
                        }
                        WritableRaster writableRaster = bufferedImage.getRaster();
                        WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
                        WritableRaster writableRaster3 = ((BufferedImage)object3).getRaster();
                        WritableRaster writableRaster4 = ((BufferedImage)object3).getAlphaRaster();
                        for (n5 = object4.iHeight - 1; n5 >= 0; --n5) {
                            for (n4 = 0; n4 < object4.iWidth; ++n4) {
                                int n13 = writableRaster.getSample(n4, n5, 0);
                                int n14 = writableRaster.getSample(n4, n5, 1);
                                int n15 = writableRaster.getSample(n4, n5, 2);
                                int n16 = writableRaster2.getSample(n4, n5, 0);
                                writableRaster3.setSample(n4, n5, 0, n13);
                                writableRaster3.setSample(n4, n5, 1, n14);
                                writableRaster3.setSample(n4, n5, 2, n15);
                                writableRaster4.setSample(n4, n5, 0, n16);
                            }
                        }
                    } else {
                        object2 = BMPDecoder.read((InfoHeader)object5, littleEndianInputStream, colorEntryArray);
                        object = bufferedImage.getRaster();
                        WritableRaster writableRaster = ((BufferedImage)object3).getRaster();
                        WritableRaster writableRaster5 = ((BufferedImage)object3).getAlphaRaster();
                        WritableRaster writableRaster6 = ((BufferedImage)object2).getRaster();
                        for (n6 = 0; n6 < object4.iHeight; ++n6) {
                            for (int i = 0; i < object4.iWidth; ++i) {
                                n5 = bufferedImage.getRGB(i, n6);
                                int n17 = n5 >> 16 & 0xFF;
                                int n18 = n5 >> 8 & 0xFF;
                                int n19 = n5 & 0xFF;
                                writableRaster.setSample(i, n6, 0, n17);
                                writableRaster.setSample(i, n6, 1, n18);
                                writableRaster.setSample(i, n6, 2, n19);
                                n4 = ((BufferedImage)object2).getRGB(i, n6);
                                writableRaster5.setSample(i, n6, 0, n4);
                            }
                        }
                    }
                    object2 = iconEntryArray[n];
                    object = new ICOImage((BufferedImage)object3, infoHeader, (IconEntry)object2);
                    ((ICOImage)object).setPngCompressed(false);
                    ((ICOImage)object).setIconIndex(n);
                    arrayList.add((ICOImage)object);
                    continue;
                }
                if (n3 == 1196314761) {
                    int n20 = littleEndianInputStream.readIntLE();
                    if (n20 != 169478669) {
                        throw new IOException("Unrecognized icon format for image #" + n);
                    }
                    object5 = iconEntryArray[n];
                    object4 = new byte[((IconEntry)object5).iSizeInBytes - 8];
                    int n21 = littleEndianInputStream.read((byte[])object4);
                    if (n21 != ((byte[])object4).length) {
                        throw new IOException("Unable to read image #" + n + " - incomplete PNG compressed data");
                    }
                    object3 = new ByteArrayOutputStream();
                    colorEntryArray = new DataOutputStream((OutputStream)object3);
                    colorEntryArray.writeInt(-1991225785);
                    colorEntryArray.writeInt(218765834);
                    colorEntryArray.write((byte[])object4);
                    object2 = ((ByteArrayOutputStream)object3).toByteArray();
                    object = new ByteArrayInputStream((byte[])object2);
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(object);
                    ImageReader imageReader = ICODecoder.getPNGImageReader();
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0);
                    IconEntry iconEntry = iconEntryArray[n];
                    ICOImage iCOImage = new ICOImage(bufferedImage, null, iconEntry);
                    iCOImage.setPngCompressed(true);
                    iCOImage.setIconIndex(n);
                    arrayList.add(iCOImage);
                    continue;
                }
                throw new IOException("Unrecognized icon format for image #" + n);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read image # " + n);
        }
        return arrayList;
    }

    private static ImageReader getPNGImageReader() {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("png");
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        return imageReader;
    }
}

