/*
 * Decompiled with CFR 0.152.
 */
package jd.gui;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import jd.nutils.JDFlags;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.ComboBoxDialogInterface;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.InputDialogInterface;
import org.appwork.uio.MultiSelectionDialog;
import org.appwork.uio.MultiSelectionDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ComboBoxDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;
import org.appwork.utils.swing.dialog.InputDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class UserIO {
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int NO_COUNTDOWN = 4;
    public static final int NO_OK_OPTION = 8;
    public static final int NO_CANCEL_OPTION = 16;
    public static final int DONT_SHOW_AGAIN = 32;
    public static final int STYLE_LARGE = 64;
    public static final int STYLE_HTML = 128;
    public static final int NO_ICON = 256;
    public static final int DONT_SHOW_AGAIN_IGNORES_CANCEL = 512;
    public static final int DONT_SHOW_AGAIN_IGNORES_OK = 1024;
    public static final int STYLE_PASSWORD = 2048;
    public static final int RETURN_OK = 2;
    public static final int RETURN_CANCEL = 4;
    public static final int RETURN_DONT_SHOW_AGAIN = 8;
    public static final int RETURN_SKIPPED_BY_DONT_SHOW = 16;
    public static final int RETURN_COUNTDOWN_TIMEOUT = 32;
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    public static final int ICON_QUESTION = 3;
    protected static UserIO INSTANCE = new UserIO();

    public UserIO() {
        UserIO.setCountdownTime(UserIO.getUserCountdownTime());
    }

    @Deprecated
    public static void setCountdownTime(int countdownTime) {
        if (countdownTime < 0) {
            Dialog.getInstance().setDefaultTimeout(UserIO.getUserCountdownTime() * 1000);
        } else {
            Dialog.getInstance().setDefaultTimeout(countdownTime * 1000);
        }
    }

    @Deprecated
    private static int getUserCountdownTime() {
        return Math.max(2, ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getDialogDefaultTimeoutInMS() / 1000);
    }

    public static UserIO getInstance() {
        return INSTANCE;
    }

    public static void setInstance(UserIO userIO) {
        if (userIO == null) {
            throw new RuntimeException("userIO must not be null");
        }
        INSTANCE = userIO;
    }

    public static boolean isOK(int answer) {
        return JDFlags.hasSomeFlags((int)answer, (int[])new int[]{2});
    }

    private int convertAWAnswer(int ret) {
        int response = 0;
        if (BinaryLogic.containsAll((int)ret, (int[])new int[]{4})) {
            response |= 4;
        }
        if (BinaryLogic.containsAll((int)ret, (int[])new int[]{2})) {
            response |= 2;
        }
        if (BinaryLogic.containsAll((int)ret, (int[])new int[]{64})) {
            response |= 4;
        }
        if (BinaryLogic.containsAll((int)ret, (int[])new int[]{8})) {
            response |= 8;
        }
        if (BinaryLogic.containsAll((int)ret, (int[])new int[]{16})) {
            response |= 0x10;
        }
        if (BinaryLogic.containsAll((int)ret, (int[])new int[]{32})) {
            response |= 0x20;
        }
        return response;
    }

    private int convertFlagToAWDialog(int flag) {
        int ret = 0;
        if (BinaryLogic.containsNone((int)flag, (int[])new int[]{4})) {
            ret |= 4;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{8})) {
            ret |= 8;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{16})) {
            ret |= 0x10;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{32})) {
            ret |= 0x20;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{64})) {
            ret |= 0x40;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{128})) {
            ret |= 0x80;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{256})) {
            ret |= 0x100;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{512})) {
            ret |= 0x200;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{1024})) {
            ret |= 0x400;
        }
        if (BinaryLogic.containsAll((int)flag, (int[])new int[]{2048})) {
            ret |= 0x200;
        }
        return ret;
    }

    public static Icon getDefaultIcon(String text) {
        if (text.contains("?")) {
            return UserIO.getIcon(3);
        }
        if (text.matches(_GUI.T.userio_errorregex())) {
            return UserIO.getIcon(2);
        }
        if (text.contains("!")) {
            return UserIO.getIcon(1);
        }
        return UserIO.getIcon(0);
    }

    public static Icon getIcon(int iconInfo) {
        switch (iconInfo) {
            case 2: {
                return new AbstractIcon("stop", 32);
            }
            case 1: {
                return new AbstractIcon("warning", 32);
            }
            case 3: {
                return new AbstractIcon("help", 32);
            }
        }
        return new AbstractIcon("info", 32);
    }

    public int requestComboDialog(int flag, String title, String question, Object[] options, int defaultSelection, Icon icon, String okText, String cancelText, ListCellRenderer renderer) {
        flag = this.convertFlagToAWDialog(flag);
        ComboBoxDialog d = new ComboBoxDialog(flag, title, question, options, defaultSelection, icon, okText, cancelText, renderer){

            protected boolean isResizable() {
                return true;
            }

            public boolean isRemoteAPIEnabled() {
                return true;
            }
        };
        return ((ComboBoxDialogInterface)UIOManager.I().show(ComboBoxDialogInterface.class, (UserIODefinition)d)).getSelectedIndex();
    }

    public int requestConfirmDialog(int flag, String question) {
        return this.requestConfirmDialog(flag, _GUI.T.jd_gui_userio_defaulttitle_confirm(), question, UserIO.getDefaultIcon(question), null, null);
    }

    public int requestConfirmDialog(int flag, String title, String question) {
        return this.requestConfirmDialog(flag, title, question, UserIO.getDefaultIcon(title + question), null, null);
    }

    public int requestConfirmDialog(int flag, String title, String message, Icon icon, String okOption, String cancelOption) {
        return this.requestUIOManagerDialog(ConfirmDialogInterface.class, new ConfirmDialog(this.convertFlagToAWDialog(flag), title, message, icon, okOption, cancelOption));
    }

    <T extends UserIODefinition> int requestUIOManagerDialog(Class<T> class1, T impl) {
        int response;
        block12: {
            response = 0;
            try {
                UserIODefinition d = UIOManager.I().show(class1, impl);
                switch (d.getCloseReason()) {
                    case CANCEL: 
                    case CLOSE: 
                    case INTERRUPT: {
                        response |= 4;
                        break;
                    }
                    case OK: {
                        response |= 2;
                        break;
                    }
                    case TIMEOUT: {
                        response |= 0x20;
                    }
                }
                if (d.isDontShowAgainSelected()) {
                    response |= 8;
                }
                d.throwCloseExceptions();
            }
            catch (DialogClosedException e) {
                response |= 4;
                if (e.isCausedByDontShowAgain()) {
                    response |= 0x10;
                }
                if (e.isCausedByTimeout()) {
                    response |= 0x20;
                }
            }
            catch (DialogCanceledException e) {
                response |= 4;
                if (e.isCausedByDontShowAgain()) {
                    response |= 0x10;
                }
                if (!e.isCausedByTimeout()) break block12;
                response |= 0x20;
            }
        }
        return response;
    }

    @Deprecated
    public File[] requestFileChooser(String id, String title, Integer fileSelectionMode, FileFilter fileFilter, Boolean multiSelection) {
        if (fileFilter == null) {
            return this.requestFileChooser(id, title, fileSelectionMode, multiSelection, (File)null, (Integer)null, new FileFilter[0]);
        }
        return this.requestFileChooser(id, title, fileSelectionMode, multiSelection, (File)null, (Integer)null, fileFilter);
    }

    public File[] requestFileChooser(String id, String title, Integer fileSelectionMode, Boolean multiSelection, FileFilter ... fileFilter) {
        return this.requestFileChooser(id, title, fileSelectionMode, multiSelection, (File)null, (Integer)null, fileFilter);
    }

    @Deprecated
    public File[] requestFileChooser(String id, String title, Integer fileSelectionMode, FileFilter fileFilter, Boolean multiSelection, File startDirectory, Integer dialogType) {
        if (fileFilter == null) {
            return this.requestFileChooser(id, title, fileSelectionMode, multiSelection, startDirectory, dialogType, new FileFilter[0]);
        }
        return this.requestFileChooser(id, title, fileSelectionMode, multiSelection, startDirectory, dialogType, fileFilter);
    }

    public File[] requestFileChooser(String id, String title, Integer fileSelectionMode, Boolean multiSelection, File startDirectory, Integer dialogType, FileFilter ... fileFilter) {
        FileChooserSelectionMode fsm = FileChooserSelectionMode.FILES_AND_DIRECTORIES;
        for (FileChooserSelectionMode f : FileChooserSelectionMode.values()) {
            if (f.getId() != fileSelectionMode.intValue()) continue;
            fsm = f;
            break;
        }
        FileChooserType fct = FileChooserType.OPEN_DIALOG;
        if (dialogType != null) {
            for (FileChooserType f : FileChooserType.values()) {
                if (f.getId() != dialogType.intValue()) continue;
                fct = f;
                break;
            }
        }
        ExtFileChooserDialog d = new ExtFileChooserDialog(0, title, null, null);
        d.setStorageID(id);
        d.setFileSelectionMode(fsm);
        d.setFileFilter(fileFilter);
        d.setType(fct);
        d.setMultiSelection(multiSelection != null && multiSelection != false);
        d.setPreSelection(startDirectory);
        try {
            Dialog.I().showDialog((AbstractDialog)d);
            return d.getSelection();
        }
        catch (DialogNoAnswerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String requestInputDialog(int flag, String question, String defaultvalue) {
        return this.requestInputDialog(flag, _GUI.T.jd_gui_userio_defaulttitle_input(), question, defaultvalue, UserIO.getDefaultIcon(question), null, null);
    }

    public String requestInputDialog(int flag, String title, String message, String defaultMessage, Icon icon, String okOption, String cancelOption) {
        try {
            InputDialogInterface d = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)new InputDialog(this.convertFlagToAWDialog(flag), title, message, defaultMessage, icon, okOption, cancelOption));
            switch (d.getCloseReason()) {
                case OK: {
                    return d.getText();
                }
            }
            d.throwCloseExceptions();
        }
        catch (DialogClosedException dialogClosedException) {
        }
        catch (DialogCanceledException dialogCanceledException) {
            // empty catch block
        }
        return null;
    }

    public String requestInputDialog(String message) {
        return this.requestInputDialog(0, message, null);
    }

    public void requestMessageDialog(int flag, String message) {
        this.requestMessageDialog(flag, _GUI.T.gui_dialogs_message_title(), message);
    }

    public void requestMessageDialog(int flag, String title, String message) {
        this.requestConfirmDialog(0x10 | flag, title, message, UserIO.getIcon(0), null, null);
    }

    public void requestMessageDialog(String message) {
        this.requestMessageDialog(0, _GUI.T.gui_dialogs_message_title(), message);
    }

    public void requestMessageDialog(String title, String message) {
        this.requestMessageDialog(0, title, message);
    }

    public int[] requestMultiSelectionDialog(int flag, String title, String question, Object[] options, Icon icon, String okText, String cancelText, ListCellRenderer renderer) {
        try {
            MultiSelectionDialogInterface d = (MultiSelectionDialogInterface)UIOManager.I().show(MultiSelectionDialogInterface.class, (UserIODefinition)new MultiSelectionDialog(flag, title, question, options, icon, okText, cancelText, renderer){

                public boolean isRemoteAPIEnabled() {
                    return true;
                }
            });
            d.throwCloseExceptions();
            return d.getSelectedIndices();
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException e) {
            e.printStackTrace();
        }
        return null;
    }
}

