/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing;

import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jd.config.ConfigGroup;
import jd.gui.swing.components.JDUnderlinedText;
import net.miginfocom.swing.MigLayout;

public final class Factory {
    private Factory() {
    }

    public static JPanel createHeader(ConfigGroup group) {
        return Factory.createHeader(group.getName(), group.getIcon());
    }

    public static JPanel createHeader(String name, Icon icon) {
        JLabel label = new JLabel("<html><u><b>" + name + "</b></u></html>");
        label.setIcon(icon);
        label.setIconTextGap(5);
        label.setBorder(null);
        JPanel ret = new JPanel((LayoutManager)new MigLayout("ins 0", "[]10[grow,fill]"));
        ret.add(label);
        ret.add(new JSeparator());
        ret.setOpaque(false);
        return ret;
    }

    public static JButton createButton(String string, Icon i) {
        return Factory.createButton(string, i, null);
    }

    public static JButton createButton(String string, Icon i, ActionListener listener) {
        JButton bt = new JButton(string);
        if (i != null) {
            bt.setIcon(i);
        }
        bt.setContentAreaFilled(false);
        bt.setCursor(Cursor.getPredefinedCursor(12));
        bt.setFocusPainted(false);
        bt.setBorderPainted(false);
        bt.setHorizontalAlignment(2);
        bt.setIconTextGap(5);
        if (listener != null) {
            bt.addActionListener(listener);
        }
        bt.addMouseListener(new JDUnderlinedText(bt));
        return bt;
    }
}

