/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jd.gui.UserIO;
import net.miginfocom.swing.MigLayout;
import org.jdownloader.gui.translate._GUI;

public class BrowseFile
extends JPanel
implements ActionListener {
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private static final long serialVersionUID = 1L;
    private JButton btnBrowse;
    private File currentPath;
    private boolean editable = false;
    private int fileSelectionMode = 0;
    private JTextField txtInput;

    public BrowseFile() {
        this(null);
    }

    public BrowseFile(LayoutManager layout) {
        super(layout != null ? layout : new MigLayout("ins 0", "[fill,grow]5[]", "[fill]"));
        this.initGUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File newPath;
        ActionEvent event = new ActionEvent(this, 1001, "");
        if (e.getSource() == this.txtInput) {
            File newPath2 = new File(this.txtInput.getText());
            this.setCurrentPath(newPath2);
            this.dispatchEvent(event);
        } else if (e.getSource() == this.btnBrowse && (newPath = this.getPath()) != null) {
            this.setCurrentPath(newPath);
            this.dispatchEvent(event);
        }
    }

    public File getCurrentPath() {
        return this.currentPath;
    }

    private File getDirectoryFromTxtInput() {
        File directory = null;
        String stringPath = this.txtInput.getText();
        if (null != stringPath) {
            directory = new File(this.txtInput.getText());
            if (directory.exists()) {
                if (directory.isFile()) {
                    directory = directory.getParentFile();
                }
            } else {
                directory = null;
            }
        }
        return directory;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    private File getPath() {
        File[] files = UserIO.getInstance().requestFileChooser(null, null, (Integer)this.fileSelectionMode, null, null, this.getDirectoryFromTxtInput(), null);
        if (files == null) {
            return null;
        }
        return files[0];
    }

    public String getText() {
        return this.txtInput.getText();
    }

    private void initGUI() {
        this.txtInput = new JTextField();
        this.txtInput.setEditable(this.editable);
        this.txtInput.addActionListener(this);
        this.btnBrowse = new JButton(_GUI.T.gui_btn_select());
        this.btnBrowse.addActionListener(this);
        this.add((Component)this.txtInput, "grow");
        this.add(this.btnBrowse);
    }

    public void setButtonText(String text) {
        this.btnBrowse.setText(text);
    }

    public void setCurrentPath(File currentPath) {
        if (currentPath != null) {
            this.currentPath = currentPath;
            this.txtInput.setText(currentPath.getAbsolutePath());
        }
    }

    public void setEditable(boolean value) {
        this.txtInput.setEditable(value);
        this.editable = value;
    }

    @Override
    public void setToolTipText(String text) {
        this.txtInput.setToolTipText(text);
        this.btnBrowse.setToolTipText(text);
        super.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean value) {
        this.txtInput.setEnabled(value);
        this.btnBrowse.setEnabled(value);
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setText(String text) {
        this.setCurrentPath(new File(text == null ? "" : text));
    }

    public JTextField getTextField() {
        return this.txtInput;
    }
}

