/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import jd.config.SubConfiguration;
import jd.gui.UserIO;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.gui.translate._GUI;

public class ComboBrowseFile
extends JPanel
implements ActionListener {
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private static final long serialVersionUID = -3852915099917640687L;
    private Object LOCK = new Object();
    private List<ActionListener> listenerList = new ArrayList<ActionListener>();
    private JButton btnBrowse;
    private JComboBox cmboInput;
    private File currentPath;
    private Vector<String> files = null;
    private int fileSelectionMode = 0;
    private FileFilter fileFilter;
    private boolean dispatchingDisabled = false;
    private Integer dialogType = null;
    private String ID;

    public Integer getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(Integer dialogType) {
        this.dialogType = dialogType;
    }

    public ComboBrowseFile(String string) {
        this.setName(string);
        this.ID = "combo" + string;
        Object list = SubConfiguration.getConfig((String)"GUI").getProperty(this.ID);
        if (list != null && list instanceof List) {
            try {
                this.setFiles(new Vector<String>((List)list));
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
        if (this.files == null) {
            this.setFiles(new Vector<String>());
        }
        this.initGUI();
    }

    public ComboBrowseFile(Vector<String> files) {
        this.ID = null;
        this.setFiles(files == null ? new Vector() : files);
        this.initGUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmboInput) {
            if ("comboBoxChanged".equals(e.getActionCommand())) {
                Object sel = this.cmboInput.getSelectedItem();
                if (sel != null) {
                    this.setCurrentPath(new File(sel.toString()), false);
                }
                if (!this.dispatchingDisabled) {
                    for (ActionListener l : this.listenerList) {
                        l.actionPerformed(new ActionEvent(this, e.getID(), e.getActionCommand()));
                    }
                }
            }
        } else if (e.getSource() == this.btnBrowse) {
            this.setCurrentPath(this.getPath(), true);
        }
    }

    public File getCurrentPath() {
        return this.currentPath;
    }

    private File getDirectoryFromTxtInput() {
        File directory = null;
        Object sel = this.cmboInput.getSelectedItem();
        if (sel != null) {
            directory = new File(sel.toString());
            if (directory.exists()) {
                if (directory.isFile()) {
                    directory = directory.getParentFile();
                }
            } else {
                directory = null;
            }
        }
        return directory;
    }

    public boolean getEditable() {
        return this.cmboInput.isEditable();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    private File getPath() {
        File[] files = UserIO.getInstance().requestFileChooser(null, null, (Integer)this.fileSelectionMode, this.fileFilter, null, this.getDirectoryFromTxtInput(), this.dialogType);
        if (files == null) {
            return null;
        }
        return files[0];
    }

    public String getText() {
        if (this.cmboInput.getSelectedItem() == null) {
            return "";
        }
        return this.cmboInput.getSelectedItem().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGUI() {
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[fill,grow]5[]", ""));
        this.cmboInput = new JComboBox(this.files){
            private static final long serialVersionUID = 5288948184335860046L;

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(20, 20);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(20, 20);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }
        };
        this.cmboInput.setEditable(false);
        this.cmboInput.addActionListener(this);
        if (this.cmboInput.getItemCount() > 0) {
            Object object = this.LOCK;
            synchronized (object) {
                this.dispatchingDisabled = true;
                this.cmboInput.setSelectedIndex(0);
                this.dispatchingDisabled = false;
            }
        }
        this.btnBrowse = new JButton(_GUI.T.gui_btn_select());
        this.btnBrowse.addActionListener(this);
        this.add((Component)this.cmboInput, "grow");
        this.add(this.btnBrowse);
    }

    public JButton getButton() {
        return this.btnBrowse;
    }

    public JComboBox getInput() {
        return this.cmboInput;
    }

    public void setButtonText(String text) {
        this.btnBrowse.setText(text);
    }

    public void setCurrentPath(File currentFile) {
        this.setCurrentPath(currentFile, false);
    }

    private void setCurrentPath(File currentPath, boolean updateCombo) {
        if (updateCombo && currentPath != null) {
            this.cmboInput.setSelectedItem(currentPath.toString());
        }
        if (currentPath != null && !currentPath.equals(this.currentPath)) {
            this.currentPath = currentPath;
            String item = currentPath.toString();
            if (!this.files.contains(item)) {
                this.cmboInput.insertItemAt(item, 0);
            }
            if (this.ID != null) {
                SubConfiguration guiConfig = SubConfiguration.getConfig((String)"GUI");
                guiConfig.setProperty(this.ID, new ArrayList<String>(this.createSortedVector(this.files, item, 20)));
            }
        }
    }

    private Vector<String> createSortedVector(Vector<String> files, String item, int count) {
        if (!item.equals(files.firstElement())) {
            files = new Vector<String>(files);
            while (files.remove(item)) {
            }
            files.add(0, item);
        }
        return new Vector<String>(files.subList(0, Math.min(files.size(), count)));
    }

    public void setEditable(final boolean value) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBrowseFile.this.cmboInput.setEditable(value);
            }
        });
    }

    @Override
    public void setEnabled(final boolean value) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBrowseFile.this.cmboInput.setEnabled(value);
                ComboBrowseFile.this.btnBrowse.setEnabled(value);
            }
        });
    }

    @Override
    public void setToolTipText(final String text) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBrowseFile.this.cmboInput.setToolTipText(text);
                ComboBrowseFile.this.btnBrowse.setToolTipText(text);
            }
        });
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        for (int i = this.files.size() - 1; i >= 0; --i) {
            if (fileFilter.accept(new File(this.files.get(i)))) continue;
            this.files.remove(i);
        }
    }

    private void setFiles(Vector<String> files) {
        for (int i = files.size() - 1; i >= 0; --i) {
            if (new File(files.get(i)).exists()) continue;
            files.remove(i);
        }
        this.files = files;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        block3: {
            block2: {
                this.fileSelectionMode = fileSelectionMode;
                if (fileSelectionMode != 1) break block2;
                for (int i = this.files.size() - 1; i >= 0; --i) {
                    if (new File(this.files.get(i)).isDirectory()) continue;
                    this.files.remove(i);
                }
                break block3;
            }
            if (fileSelectionMode != 0) break block3;
            for (int i = this.files.size() - 1; i >= 0; --i) {
                if (new File(this.files.get(i)).isFile()) continue;
                this.files.remove(i);
            }
        }
    }

    public void setText(final String text) {
        new EDTHelper<Object>(){

            public Object edtRun() {
                if (text == null) {
                    ComboBrowseFile.this.setCurrentPath(new File(""), true);
                } else {
                    ComboBrowseFile.this.setCurrentPath(new File(text), true);
                }
                return null;
            }
        }.start();
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(l);
    }
}

