/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JWindow;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.windowmanager.WindowManager;

public abstract class JWindowTooltip
extends JWindow {
    private static final long serialVersionUID = -7191050140766206744L;
    protected NullsafeAtomicReference<Thread> updater = new NullsafeAtomicReference(null);
    private Point point;

    public JWindowTooltip() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0", "[fill, grow]", "[fill, grow]"));
        panel.setOpaque(true);
        panel.setBackground(new Color(12177129));
        panel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, panel.getBackground().darker()));
        this.addContent(panel);
        WindowManager.getInstance().setVisible((Window)this, false, WindowManager.FrameState.OS_DEFAULT);
        this.setAlwaysOnTop(true);
        this.add(panel);
        this.pack();
    }

    public void showTooltip(Point point) {
        this.point = point;
        TooltipUpdater thread = new TooltipUpdater();
        Thread oldThread = (Thread)this.updater.getAndSet((Object)thread);
        if (oldThread != null) {
            oldThread.interrupt();
        }
        thread.start();
    }

    public void hideTooltip() {
        Thread thread = (Thread)this.updater.getAndSet(null);
        if (thread != null) {
            thread.interrupt();
        }
        new EDTHelper<Object>(){

            public Object edtRun() {
                if (JWindowTooltip.this.isVisible()) {
                    WindowManager.getInstance().setVisible((Window)JWindowTooltip.this, false, WindowManager.FrameState.OS_DEFAULT);
                }
                return null;
            }
        }.start();
    }

    private void setLocation() {
        new EDTHelper<Object>(){

            public Object edtRun() {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int limitX = (int)screenSize.getWidth() / 2;
                int limitY = (int)screenSize.getHeight() / 2;
                Point pp = JWindowTooltip.this.point;
                if (pp.x <= limitX) {
                    if (pp.y <= limitY) {
                        JWindowTooltip.this.setLocation(pp.x, pp.y);
                    } else {
                        JWindowTooltip.this.setLocation(pp.x, pp.y - JWindowTooltip.this.getHeight());
                    }
                } else if (pp.y <= limitY) {
                    JWindowTooltip.this.setLocation(pp.x - JWindowTooltip.this.getWidth(), pp.y);
                } else {
                    JWindowTooltip.this.setLocation(pp.x - JWindowTooltip.this.getWidth(), pp.y - JWindowTooltip.this.getHeight());
                }
                return null;
            }
        }.waitForEDT();
    }

    protected abstract void addContent(JPanel var1);

    protected abstract void updateContent();

    private class TooltipUpdater
    extends Thread
    implements Runnable {
        private TooltipUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                boolean updatedFlag = false;
                JWindowTooltip.this.pack();
                JWindowTooltip.this.setLocation();
                JWindowTooltip.this.setVisible(true);
                JWindowTooltip.this.toFront();
                Thread thread = Thread.currentThread();
                while (thread == JWindowTooltip.this.updater.get()) {
                    try {
                        JWindowTooltip.this.updateContent();
                        if (!updatedFlag) {
                            JWindowTooltip.this.pack();
                            updatedFlag = true;
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        JWindowTooltip.this.hideTooltip();
                        return;
                    }
                }
            }
            finally {
                JWindowTooltip.this.hideTooltip();
            }
        }
    }
}

