/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import jd.captcha.utils.GifDecoder;
import jd.gui.swing.dialog.DialogType;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.URLStream;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.Interpolation;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.DomainInfo;
import org.jdownloader.captcha.v2.AbstractCaptchaDialog;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class AbstractImageCaptchaDialog<T>
extends AbstractCaptchaDialog<T> {
    int fps;
    protected Image[] images;
    protected Point offset;
    private int frame = 0;
    Timer paintTimer;
    protected Rectangle bounds;
    protected double scaleFaktor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image[] getGifImages(InputStream openStream) {
        try {
            GifDecoder decoder = new GifDecoder();
            decoder.read(openStream);
            Image[] ret = new BufferedImage[decoder.getFrameCount()];
            for (int i = 0; i < decoder.getFrameCount(); ++i) {
                ret[i] = decoder.getFrame(i);
            }
            Image[] imageArray = ret;
            return imageArray;
        }
        finally {
            try {
                openStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image[] getGifImages(URL url) {
        InputStream stream = null;
        try {
            stream = URLStream.openStream((URL)url);
            Image[] imageArray = AbstractImageCaptchaDialog.getGifImages(stream);
            return imageArray;
        }
        catch (IOException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public AbstractImageCaptchaDialog(ImageCaptchaChallenge<T> challenge, int flags, String title, DialogType type, DomainInfo domainInfo, String explain, Image ... images) {
        super(challenge, flags, title, type, domainInfo, explain);
        ArrayList<Image> ret = new ArrayList<Image>();
        if (images != null) {
            for (int i = 0; i < images.length; ++i) {
                if (images[i] instanceof BufferedImage && ((BufferedImage)images[i]).getColorModel() instanceof IndexColorModel) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        Image[] subImages;
                        ImageProvider.writeImage((RenderedImage)((BufferedImage)images[i]), (String)"gif", (OutputStream)os);
                        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                        for (Image ii : subImages = AbstractImageCaptchaDialog.getGifImages(is)) {
                            ret.add(ii);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        challenge.getPlugin().getLogger().log((Throwable)e);
                    }
                }
                ret.add(images[i]);
            }
        }
        this.images = ret.toArray(new Image[0]);
        this.fps = 24;
    }

    protected MigLayout getDialogLayout() {
        return new MigLayout("ins 0,wrap 1", "[fill,grow]", "[grow,fill]10[]");
    }

    protected JPanel createCaptchaPanel() {
        JPanel iconPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow]", "[grow]")){
            private static final long serialVersionUID = 1L;
            private Color col;
            {
                this.col = LAFOptions.getInstance().getColorForPanelBackground();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintChildren(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                Composite comp = g2.getComposite();
                try {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.85f));
                    super.paintChildren(g);
                }
                finally {
                    g2.setComposite(comp);
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int insets = CFG_GUI.CFG.isCaptchaDialogBorderAroundImageEnabled() ? 10 : 0;
                Image scaled = IconIO.getScaledInstance((Image)AbstractImageCaptchaDialog.this.images[AbstractImageCaptchaDialog.this.frame], (int)(this.getWidth() - insets), (int)(this.getHeight() - insets), (Interpolation)Interpolation.BICUBIC, (boolean)true);
                AbstractImageCaptchaDialog.this.scaleFaktor = (double)AbstractImageCaptchaDialog.this.images[AbstractImageCaptchaDialog.this.frame].getWidth(null) / (double)scaled.getWidth(null);
                AbstractImageCaptchaDialog.this.offset = new Point((this.getWidth() - scaled.getWidth(null)) / 2, (this.getHeight() - scaled.getHeight(null)) / 2);
                AbstractImageCaptchaDialog.this.bounds = new Rectangle((this.getWidth() - scaled.getWidth(null)) / 2, (this.getHeight() - scaled.getHeight(null)) / 2, scaled.getWidth(null), scaled.getHeight(null));
                g.setClip(AbstractImageCaptchaDialog.this.bounds);
                g.drawImage(scaled, (this.getWidth() - scaled.getWidth(null)) / 2, (this.getHeight() - scaled.getHeight(null)) / 2, this.col, null);
                AbstractImageCaptchaDialog.this.paintIconComponent(g, this.getWidth(), this.getHeight(), (this.getWidth() - scaled.getWidth(null)) / 2, (this.getHeight() - scaled.getHeight(null)) / 2, scaled);
            }
        };
        int size = (Integer)CFG_GUI.CAPTCHA_SCALE_FACTOR.getValue();
        if (size != 100) {
            iconPanel.setPreferredSize(new Dimension((int)((float)(this.images[0].getWidth(null) * size) / 100.0f), (int)((float)(this.images[0].getHeight(null) * size) / 100.0f)));
        } else {
            iconPanel.setPreferredSize(new Dimension(this.images[0].getWidth(null), this.images[0].getHeight(null)));
        }
        return iconPanel;
    }

    protected void paintIconComponent(Graphics g, int width, int height, int xOsset, int yOffset, Image scaled) {
    }

    public void dispose() {
        if (this.paintTimer != null) {
            this.paintTimer.stop();
        }
        super.dispose();
    }

    protected abstract JComponent createInputComponent();

    public JComponent layoutDialogContent() {
        JComponent inputComponent;
        final JComponent ret = super.layoutDialogContent();
        if (this.images.length > 1) {
            this.paintTimer = new Timer(1000 / this.fps, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractImageCaptchaDialog.this.frame = (AbstractImageCaptchaDialog.this.frame + 1) % AbstractImageCaptchaDialog.this.images.length;
                    ret.repaint();
                }
            });
            this.paintTimer.setRepeats(true);
            this.paintTimer.start();
        }
        if ((inputComponent = this.createInputComponent()) != null) {
            if (this.mouseListener != null) {
                inputComponent.addMouseListener(this.mouseListener);
            }
            if (this.mouseMotionListener != null) {
                inputComponent.addMouseMotionListener(this.mouseMotionListener);
            }
            ret.add(inputComponent);
        }
        return ret;
    }

    public Image[] getImages() {
        return this.images;
    }

    public Point getOffset() {
        return this.offset;
    }

    public double getScaleFaktor() {
        return this.scaleFaktor;
    }

    protected boolean isResizable() {
        return true;
    }
}

