/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jd.controlling.TaskQueue;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.PacProxySelectorImpl;
import jd.controlling.proxy.SingleBasicProxySelectorImpl;
import jd.controlling.proxy.SingleDirectGatewaySelector;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.PseudoCombo;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.InternetConnectionSettings;

public class ProxyDialog
extends AbstractDialog<AbstractProxySelectorImpl>
implements CaretListener {
    private JComboBox cmbType;
    private PseudoCombo cmbNetIf;
    private ExtTextField txtHost;
    private JTextField txtPort;
    private JTextField txtUser;
    private JTextField txtPass;
    private JLabel lblUser;
    private JLabel lblPass;
    private JLabel lblPort;
    private JLabel lblHost;
    private JLabel lblNetIf;
    private DelayedRunnable delayer;

    public ProxyDialog() {
        super(0, _GUI.T.jd_gui_swing_dialog_ProxyDialog_title(), (Icon)new AbstractIcon("proxy_rotate", 32), null, null);
    }

    protected int getPreferredWidth() {
        return super.getPreferredWidth();
    }

    public JComponent layoutDialogContent() {
        this.panel = new MigPanel("ins 0, wrap 4", "[][grow,fill,n:300:n][][grow,fill,n:50:n]", "[]");
        String[] types = null;
        types = ((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).isProxyVoleAutodetectionEnabled() ? new String[]{_GUI.T.jd_gui_swing_dialog_ProxyDialog_http(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_https(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_socks5(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_socks4(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_socks4a(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_direct(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_pac()} : new String[]{_GUI.T.jd_gui_swing_dialog_ProxyDialog_http(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_https(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_socks5(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_socks4(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_socks4a(), _GUI.T.jd_gui_swing_dialog_ProxyDialog_direct()};
        this.cmbType = new JComboBox<String>(types);
        this.cmbType.addActionListener((ActionListener)((Object)this));
        this.lblHost = new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_hostport());
        this.txtHost = new ExtTextField(){

            public void onChanged() {
                ProxyDialog.this.delayer.resetAndStart();
            }
        };
        this.txtHost.addCaretListener((CaretListener)this);
        this.lblPort = new JLabel(":");
        this.txtPort = new JTextField();
        this.txtPort.setText("8080");
        this.txtPort.addCaretListener(this);
        this.lblUser = new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_username());
        this.txtUser = new JTextField();
        this.lblPass = new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_password());
        this.txtPass = new JTextField();
        this.lblNetIf = new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_netif());
        this.cmbNetIf = new PseudoCombo<NetIfSelection>(new NetIfSelection[]{new NetIfSelection("-", "")}){

            protected Icon getPopIcon(boolean closed) {
                if (closed) {
                    return NewTheme.I().getIcon("popDownLarge", -1);
                }
                return NewTheme.I().getIcon("popUpLarge", -1);
            }
        };
        this.cmbNetIf.setPopDown(true);
        this.cmbNetIf.addActionListener((ActionListener)((Object)this));
        this.delayer = new DelayedRunnable(ToolTipController.EXECUTER, 2000L){

            public String getID() {
                return "ProxyDialog";
            }

            public void delayedrun() {
                new EDTRunner(){

                    protected void runInEDT() {
                        ProxyDialog.this.set(ProxyDialog.this.txtHost.getText());
                    }
                };
            }
        };
        this.relayout();
        this.okButton.setEnabled(false);
        this.set(null);
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                try {
                    Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                    final HashSet<NetIfSelection> netIfs = new HashSet<NetIfSelection>();
                    final NetIfSelection first = new NetIfSelection("-", "");
                    netIfs.add(first);
                    for (NetworkInterface netint : Collections.list(nets)) {
                        if (!netint.isUp() || netint.isLoopback()) continue;
                        netIfs.add(new NetIfSelection(netint.getName(), netint.getDisplayName()));
                    }
                    new EDTRunner(){

                        protected void runInEDT() {
                            ProxyDialog.this.cmbNetIf.setValues((Object[])netIfs.toArray(new NetIfSelection[0]));
                            ProxyDialog.this.cmbNetIf.setSelectedItem((Object)first);
                        }
                    };
                }
                catch (IOException e) {
                    LoggerFactory.getDefaultLogger().log((Throwable)e);
                }
                return null;
            }
        });
        return this.panel;
    }

    public void dispose() {
        super.dispose();
        this.delayer.stop();
    }

    protected void set(String text) {
        int carPos = this.txtHost.getCaretPosition();
        String myText = text;
        if (myText == null) {
            myText = "";
        }
        if (myText.endsWith(":")) {
            return;
        }
        if (((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).isProxyVoleAutodetectionEnabled() && myText.startsWith("pac://") && this.cmbType.getSelectedIndex() == 6) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            try {
                String userInfo;
                URL url = new URL(myText);
                if (this.cmbType.getSelectedIndex() == 6) {
                    this.txtHost.setText(url + "");
                } else {
                    this.txtHost.setText(url.getHost());
                }
                if (url.getPort() > 0) {
                    this.txtPort.setText(url.getPort() + "");
                }
                if ((userInfo = url.getUserInfo()) != null) {
                    int in = userInfo.indexOf(":");
                    if (in >= 0) {
                        this.txtUser.setText(userInfo.substring(0, in));
                        this.txtPass.setText(userInfo.substring(in + 1));
                    } else {
                        this.txtUser.setText(userInfo);
                    }
                }
                return;
            }
            catch (MalformedURLException e) {
                if (text == null || !text.contains(":")) continue;
                myText = "http://" + myText;
                continue;
            }
        }
        this.txtHost.setCaretPosition(carPos);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmbNetIf && this.cmbType.getSelectedIndex() == 5) {
            Object selection = this.cmbNetIf.getSelectedItem();
            if (selection instanceof NetIfSelection) {
                NetIfSelection netIfSelection = (NetIfSelection)selection;
                if ("-".equals(netIfSelection.getName())) {
                    this.txtHost.setText("");
                } else {
                    this.txtHost.setText(netIfSelection.getName());
                }
            }
        } else if (e.getSource() == this.cmbType) {
            this.relayout();
            this.panel.revalidate();
            this.panel.repaint();
        } else {
            super.actionPerformed(e);
        }
    }

    private void relayout() {
        this.panel.removeAll();
        switch (this.cmbType.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.panel.setLayout((LayoutManager)new MigLayout("ins 0, wrap 4", "[][grow,fill,n:300:n][][grow,fill,n:50:n]", "[]"));
                this.panel.add(new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_type()));
                this.panel.add((Component)this.cmbType, "spanx");
                this.panel.add(this.lblHost);
                this.panel.add((Component)this.txtHost);
                this.panel.add((Component)this.lblPort, "hidemode 3");
                this.panel.add((Component)this.txtPort, "hidemode 3,gapleft 0");
                this.panel.add(this.lblUser);
                this.panel.add((Component)this.txtUser, "spanx");
                this.panel.add(this.lblPass);
                this.panel.add((Component)this.txtPass, "spanx");
                this.lblHost.setText(_GUI.T.jd_gui_swing_dialog_ProxyDialog_hostport());
                if (!StringUtils.isEmpty((String)this.txtPort.getText())) break;
                this.txtPort.setText("8080");
                break;
            }
            case 2: {
                this.panel.setLayout((LayoutManager)new MigLayout("ins 0, wrap 4", "[][grow,fill,n:300:n][][grow,fill,n:50:n]", "[]"));
                this.panel.add(new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_type()));
                this.panel.add((Component)this.cmbType, "spanx");
                this.panel.add(this.lblHost);
                this.panel.add((Component)this.txtHost);
                this.panel.add((Component)this.lblPort, "hidemode 3");
                this.panel.add((Component)this.txtPort, "hidemode 3,gapleft 0");
                this.panel.add(this.lblUser);
                this.panel.add((Component)this.txtUser, "spanx");
                this.panel.add(this.lblPass);
                this.panel.add((Component)this.txtPass, "spanx");
                this.lblHost.setText(_GUI.T.jd_gui_swing_dialog_ProxyDialog_hostport());
                if (!StringUtils.isEmpty((String)this.txtPort.getText())) break;
                this.txtPort.setText("1080");
                break;
            }
            case 3: 
            case 4: {
                this.panel.setLayout((LayoutManager)new MigLayout("ins 0, wrap 4", "[][grow,fill,n:300:n][][grow,fill,n:50:n]", "[]"));
                this.panel.add(new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_type()));
                this.panel.add((Component)this.cmbType, "spanx");
                this.panel.add(this.lblHost);
                this.panel.add((Component)this.txtHost);
                this.panel.add((Component)this.lblPort, "hidemode 3");
                this.panel.add((Component)this.txtPort, "hidemode 3,gapleft 0");
                this.panel.add(this.lblUser);
                this.panel.add((Component)this.txtUser, "spanx");
                this.lblHost.setText(_GUI.T.jd_gui_swing_dialog_ProxyDialog_hostport());
                if (!StringUtils.isEmpty((String)this.txtPort.getText())) break;
                this.txtPort.setText("1080");
                break;
            }
            case 5: {
                this.panel.setLayout((LayoutManager)new MigLayout("ins 0, wrap 2", "[][grow,fill]", "[]"));
                this.panel.add(new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_type()));
                this.panel.add((Component)this.cmbType, "spanx");
                this.panel.add(this.lblHost);
                this.panel.add((Component)this.txtHost);
                this.panel.add(this.lblNetIf);
                this.panel.add((Component)this.cmbNetIf);
                this.lblHost.setText(_GUI.T.jd_gui_swing_dialog_ProxyDialog_local());
                break;
            }
            case 6: {
                if (!((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).isProxyVoleAutodetectionEnabled()) {
                    throw new WTFException("Not possible");
                }
                this.panel.setLayout((LayoutManager)new MigLayout("ins 0, wrap 2", "[][grow,fill]", "[]"));
                this.panel.add(new JLabel(_GUI.T.jd_gui_swing_dialog_ProxyDialog_type()));
                this.panel.add((Component)this.cmbType, "spanx");
                this.panel.add(this.lblHost);
                this.panel.add((Component)this.txtHost);
                this.panel.add(this.lblUser);
                this.panel.add((Component)this.txtUser, "spanx");
                this.panel.add(this.lblPass);
                this.panel.add((Component)this.txtPass, "spanx");
                this.lblHost.setText(_GUI.T.jd_gui_swing_dialog_ProxyDialog_pac_url());
                break;
            }
            default: {
                throw new WTFException("Not Possible:" + this.cmbType.getSelectedIndex());
            }
        }
        this.txtHost.requestFocus();
    }

    protected void packed() {
        super.packed();
    }

    protected void initFocus(JComponent focus) {
        super.initFocus(focus);
        this.txtHost.requestFocus();
    }

    protected AbstractProxySelectorImpl createReturnValue() {
        int mask = this.getReturnmask();
        if (BinaryLogic.containsSome((int)mask, (int[])new int[]{64})) {
            return null;
        }
        if (BinaryLogic.containsSome((int)mask, (int[])new int[]{4})) {
            return null;
        }
        try {
            HTTPProxy.TYPE type;
            int index = this.cmbType.getSelectedIndex();
            if (index == 0) {
                type = HTTPProxy.TYPE.HTTP;
            } else if (index == 1) {
                type = HTTPProxy.TYPE.HTTPS;
            } else if (index == 2) {
                type = HTTPProxy.TYPE.SOCKS5;
            } else if (index == 3) {
                type = HTTPProxy.TYPE.SOCKS4;
            } else if (index == 4) {
                type = HTTPProxy.TYPE.SOCKS4A;
            } else {
                if (index == 5) {
                    HTTPProxy.TYPE type2 = HTTPProxy.TYPE.DIRECT;
                    return new SingleDirectGatewaySelector(HTTPProxy.parseHTTPProxy((String)("direct://" + this.txtHost.getText())));
                }
                if (index == 6) {
                    return new PacProxySelectorImpl(this.txtHost.getText(), this.txtUser.getText(), this.txtPass.getText());
                }
                return null;
            }
            HTTPProxy ret = new HTTPProxy(type, this.txtHost.getText(), Integer.parseInt(this.txtPort.getText().trim()));
            ret.setPass(this.txtPass.getText());
            ret.setUser(this.txtUser.getText());
            return new SingleBasicProxySelectorImpl(ret);
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent e) {
        block8: {
            boolean enable = false;
            try {
                if (this.cmbType.getSelectedIndex() != 2) {
                    if (this.txtHost.getDocument().getLength() <= 0 || this.txtPort.getDocument().getLength() <= 0) break block8;
                    try {
                        int port = Integer.parseInt(this.txtPort.getText().trim());
                        if (port > 0 && port <= 65535) {
                            enable = true;
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {}
                    break block8;
                }
                if (this.txtHost.getDocument().getLength() > 0) {
                    enable = true;
                }
            }
            finally {
                this.okButton.setEnabled(enable);
            }
        }
    }

    private static class NetIfSelection {
        private final String name;
        private final String displayName;

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        private NetIfSelection(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String toString() {
            if (StringUtils.isNotEmpty((String)this.getDisplayName())) {
                return this.getName() + "|(" + this.getDisplayName() + ")";
            }
            return this.getName();
        }
    }
}

