/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.Timer;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.PromotionTabHeader;
import jd.gui.swing.jdgui.interfaces.JDMouseAdapter;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.maintab.TabHeader;
import org.appwork.utils.images.TransparentIcon;
import org.jdownloader.donate.DONATE_EVENT;
import org.jdownloader.gui.mainmenu.DonateAction;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class DonateTabHeader
extends TabHeader
implements PromotionTabHeader {
    private static final long serialVersionUID = 1L;
    private final AtomicReference<DONATE_EVENT> event = new AtomicReference<Object>(null);
    private final AtomicBoolean flashFlag = new AtomicBoolean(false);

    public DonateTabHeader(View view) {
        super(view);
        this.updateEvent();
        Timer updateTimer = new Timer(3600000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DonateTabHeader.this.updateEvent();
            }
        });
        updateTimer.setRepeats(true);
        updateTimer.start();
    }

    private void updateEvent() {
        final DONATE_EVENT now = DONATE_EVENT.getNow();
        if (this.event.getAndSet(now) != now) {
            final Icon icon = now.getIcon();
            this.labelIcon.setIcon(icon);
            this.setToolTipText(now.getToolTipText());
            this.flashFlag.set(!now.matchesID(CFG_GUI.CFG.getDonationNotifyID()));
            if (this.isFlashing()) {
                Timer blinker = new Timer(1500, new ActionListener(){
                    private long i = 0L;
                    private final Icon iconTransparent = new TransparentIcon(icon, 0.5f);

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!DonateTabHeader.this.isFlashing() || DonateTabHeader.this.event.get() != now) {
                            DONATE_EVENT donate = (DONATE_EVENT)DonateTabHeader.this.event.get();
                            DonateTabHeader.this.labelIcon.setIcon(donate.getIcon());
                            DonateTabHeader.this.setToolTipText(donate.getToolTipText());
                            ((Timer)e.getSource()).stop();
                        } else if (this.i++ % 2L == 0L) {
                            DonateTabHeader.this.labelIcon.setIcon(icon);
                        } else {
                            DonateTabHeader.this.labelIcon.setIcon(this.iconTransparent);
                        }
                    }
                });
                blinker.setRepeats(true);
                blinker.start();
            }
        }
    }

    private boolean isFlashing() {
        return this.flashFlag.get();
    }

    @Override
    protected void initMouseForwarder() {
        this.addMouseListener(new JDMouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                new DonateAction((DONATE_EVENT)DonateTabHeader.this.event.get()).actionPerformed(new ActionEvent(me.getSource(), me.getID(), me.paramString()));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mousePressed(MouseEvent me) {
                DonateTabHeader.this.flashFlag.set(false);
                DONATE_EVENT donate = (DONATE_EVENT)DonateTabHeader.this.event.get();
                CFG_GUI.CFG.setDonationNotifyID(donate.getID());
                new DonateAction(donate).actionPerformed(new ActionEvent(me.getSource(), me.getID(), me.paramString()));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public void onClick() {
    }
}

