/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jd.gui.swing.jdgui.Flashable;
import org.appwork.exceptions.WTFException;

public class FlashController
implements ActionListener {
    private final ArrayList<Flashable> list = new ArrayList();
    private Timer timer;
    private long counter = 0L;

    public void register(Flashable button) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new WTFException("This has to be done in the EDT");
        }
        if (!this.list.contains(button)) {
            this.list.add(button);
            button.onFlashRegister(this.counter);
            if (this.timer == null) {
                this.timer = new Timer(1000, this);
                this.timer.setRepeats(true);
                this.timer.setInitialDelay(1000);
                this.timer.start();
            }
        }
    }

    public void unregister(Flashable button) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new WTFException("This has to be done in the EDT");
        }
        if (this.list.remove(button)) {
            if (this.list.size() == 0 && this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            button.onFlashUnRegister(this.counter);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ++this.counter;
        Iterator<Flashable> it = this.list.iterator();
        while (it.hasNext()) {
            Flashable cur = it.next();
            if (cur.onFlash(this.counter)) continue;
            it.remove();
        }
        if (this.list.size() == 0 && this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public boolean isRegistered(Flashable button) {
        return this.list.contains(button);
    }
}

