/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jd.controlling.captcha.SkipRequest;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import jd.gui.swing.jdgui.components.StatusBarImpl;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.DomainInfo;
import org.jdownloader.actions.AppAction;
import org.jdownloader.captcha.event.ChallengeResponseListener;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.images.NewTheme;

public class CaptchaIndicator
extends IconedProcessIndicator
implements ChallengeResponseListener {
    private static final long serialVersionUID = -7267364376253248300L;
    private final SolverJob<?> job;
    private final StatusBarImpl statusBar;
    private static final AbstractIcon ocr = new AbstractIcon("ocr", 16);

    public CaptchaIndicator(StatusBarImpl statusBar, SolverJob<?> job) {
        super((Icon)ocr);
        this.job = job;
        this.statusBar = statusBar;
        this.setTitle(_GUI.T.StatusBarImpl_initGUI_captcha());
        ExtMergedIcon icon = new ExtMergedIcon((Icon)this.getDomainInfo()).add((Icon)ocr, 6, 6);
        this.updatePainter((Icon)icon, Color.WHITE, Color.GRAY, Color.WHITE, Color.GREEN, Color.LIGHT_GRAY, Color.GREEN);
        this.setDescription(_GUI.T.gui_captchaWindow_waitForInput(job.getChallenge().getHost()));
        this.setEnabled(true);
        ChallengeResponseController.getInstance().getEventSender().addListener((EventListener)this, true);
        if (job.isAlive()) {
            this.setIndeterminate(true);
            statusBar.addProcessIndicator((JComponent)((Object)this));
        }
    }

    protected String getHost() {
        return this.job.getChallenge().getHost();
    }

    protected DomainInfo getDomainInfo() {
        return this.job.getChallenge().getDomainInfo();
    }

    protected String getPackageName() {
        DownloadLink link;
        Plugin plugin = this.job.getChallenge().getPlugin();
        if (plugin instanceof PluginForHost && (link = ((PluginForHost)plugin).getDownloadLink()) != null) {
            return link.getFilePackage().getName();
        }
        return null;
    }

    protected JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add((Action)new AppAction(){
            private static final long serialVersionUID = -968768342263254431L;
            {
                this.setIconKey("cancel");
                this.setName(_GUI.T.AbstractCaptchaDialog_AbstractCaptchaDialog_cancel());
            }

            public void actionPerformed(ActionEvent e) {
                CaptchaIndicator.this.job.setSkipRequest(SkipRequest.SINGLE);
            }
        });
        Plugin plugin = this.job.getChallenge().getPlugin();
        if (plugin instanceof PluginForHost) {
            popup.add((Action)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_skip_and_disable_all_downloads_from(CaptchaIndicator.this.getHost()));
                    try {
                        this.setSmallIcon(CaptchaIndicator.this.getDomainInfo().getIcon(16));
                    }
                    catch (Throwable e) {
                        this.setIconKey("cancel");
                    }
                }

                public void actionPerformed(ActionEvent e) {
                    CaptchaIndicator.this.job.setSkipRequest(SkipRequest.BLOCK_HOSTER);
                }
            });
            popup.add((Action)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_skip_and_disable_package(CaptchaIndicator.this.getPackageName()));
                    this.setSmallIcon((Icon)new BadgeIcon("package_open", "skipped", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    CaptchaIndicator.this.job.setSkipRequest(SkipRequest.BLOCK_PACKAGE);
                }
            });
            popup.add((Action)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_skip_and_hide_all_captchas_download());
                    this.setSmallIcon(NewTheme.I().getIcon("clear", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    CaptchaIndicator.this.job.setSkipRequest(SkipRequest.BLOCK_ALL_CAPTCHAS);
                }
            });
            popup.add((Action)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_skip_and_stop_all_downloads());
                    this.setSmallIcon((Icon)new AbstractIcon("stop", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    CaptchaIndicator.this.job.setSkipRequest(SkipRequest.STOP_CURRENT_ACTION);
                }
            });
        } else {
            popup.add((Action)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_cancel_linkgrabbing());
                    this.setSmallIcon((Icon)new AbstractIcon("stop", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    CaptchaIndicator.this.job.setSkipRequest(SkipRequest.STOP_CURRENT_ACTION);
                }
            });
            popup.add((Action)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_cancel_stop_showing_crawlercaptchs());
                    this.setSmallIcon((Icon)new AbstractIcon("find", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    CaptchaIndicator.this.job.setSkipRequest(SkipRequest.BLOCK_ALL_CAPTCHAS);
                }
            });
        }
        return popup;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            JPopupMenu popup = this.createPopup();
            popup.show((Component)((Object)this), e.getPoint().x, 0 - popup.getPreferredSize().height);
        }
    }

    public void onNewJobAnswer(SolverJob<?> job, AbstractResponse<?> response) {
    }

    public void onJobDone(SolverJob<?> job) {
        if (job == this.job) {
            new EDTRunner(){

                protected void runInEDT() {
                    CaptchaIndicator.this.setIndeterminate(false);
                    CaptchaIndicator.this.statusBar.removeProcessIndicator((JComponent)((Object)CaptchaIndicator.this));
                }
            };
        }
    }

    public void onNewJob(SolverJob<?> job) {
    }

    public void onJobSolverEnd(ChallengeSolver<?> solver, SolverJob<?> job) {
    }

    public void onJobSolverStart(ChallengeSolver<?> solver, SolverJob<?> job) {
    }
}

