/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.toolbar.actions;

import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.TransferHandler;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.linkcollector.LinkOrigin;
import jd.gui.swing.jdgui.Flashable;
import jd.gui.swing.jdgui.JDGui;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.ExtJToggleButton;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.toolbar.action.AbstractToolbarToggleAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class ClipBoardToggleAction
extends AbstractToolbarToggleAction
implements Flashable {
    private final Icon iconNormal;
    private final Icon iconHighlight;
    private final Icon iconSelected;
    private JToggleButton bt;

    public ClipBoardToggleAction() {
        super(CFG_GUI.CLIPBOARD_MONITORED);
        this.setIconKey("clipboard");
        this.iconNormal = NewTheme.I().getCheckBoxImage(this.getIconKey(), false, 24);
        this.iconHighlight = NewTheme.I().getCheckBoxImage(this.getIconKey(), false, 24, new Color(0xFF9393));
        this.iconSelected = NewTheme.I().getCheckBoxImage(this.getIconKey(), true, 24);
        CFG_GUI.CLIPBOARD_DISABLED_WARNING_FLASH_ENABLED.getEventSender().addListener((EventListener)((Object)this), true);
        if (!this.getKeyHandler().isEnabled() && CFG_GUI.CLIPBOARD_DISABLED_WARNING_FLASH_ENABLED.isEnabled()) {
            JDGui.getInstance().getFlashController().register(this);
        } else {
            JDGui.getInstance().getFlashController().unregister(this);
        }
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        super.onConfigValueModified(keyHandler, newValue);
        new EDTRunner(){

            protected void runInEDT() {
                boolean isClipboardEnabled = ClipBoardToggleAction.this.getKeyHandler().isEnabled();
                if (!isClipboardEnabled && CFG_GUI.CLIPBOARD_DISABLED_WARNING_FLASH_ENABLED.isEnabled()) {
                    JDGui.getInstance().getFlashController().register(ClipBoardToggleAction.this);
                } else {
                    JDGui.getInstance().getFlashController().unregister(ClipBoardToggleAction.this);
                }
            }
        };
    }

    public AbstractButton createButton() {
        if (this.bt != null) {
            return this.bt;
        }
        this.bt = new ExtJToggleButton((AbstractAction)((Object)this));
        this.bt.setIcon(this.iconNormal);
        this.bt.setRolloverIcon(this.iconNormal);
        this.bt.setSelectedIcon(this.iconSelected);
        this.bt.setRolloverSelectedIcon(this.iconSelected);
        this.bt.setHideActionText(true);
        this.bt.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return ClipboardMonitoring.hasSupportedTransferData((Transferable)support.getTransferable());
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return true;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                return this.importTransferable(support.getTransferable());
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                return this.importTransferable(t);
            }

            private final boolean importTransferable(Transferable t) {
                try {
                    ClipboardMonitoring.processSupportedTransferData((Transferable)t, (LinkOrigin)LinkOrigin.DRAG_DROP_ACTION);
                    return true;
                }
                catch (Exception e) {
                    LogController.CL().log((Throwable)e);
                    return false;
                }
            }
        });
        return this.bt;
    }

    @Override
    public void onFlashRegister(long c) {
        this.onFlash(c);
    }

    @Override
    public void onFlashUnRegister(long c) {
        if (this.bt != null) {
            this.bt.setIcon(this.iconNormal);
            this.bt.setRolloverIcon(this.iconNormal);
        }
    }

    @Override
    public boolean onFlash(long l) {
        if (!(this.bt != null && this.bt.isVisible() && this.bt.isDisplayable() && CFG_GUI.CLIPBOARD_DISABLED_WARNING_FLASH_ENABLED.isEnabled())) {
            return false;
        }
        if (l % 2L != 0L) {
            this.bt.setIcon(this.iconHighlight);
            this.bt.setRolloverIcon(this.iconHighlight);
        } else {
            this.bt.setIcon(this.iconNormal);
            this.bt.setRolloverIcon(this.iconNormal);
        }
        return true;
    }

    protected String createTooltip() {
        return _GUI.T.action_clipboard_observer_tooltip();
    }

    protected String getNameWhenDisabled() {
        return _GUI.T.ClipBoardToggleAction_getNameWhenDisabled_();
    }

    protected String getNameWhenEnabled() {
        return _GUI.T.ClipBoardToggleAction_getNameWhenEnabled_();
    }
}

