/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.toolbar.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.translate._JDT;

public class PauseDownloadsAction
extends AbstractToolBarAction
implements DownloadWatchdogListener,
GenericConfigEventListener<Integer>,
ActionContext {
    private boolean hideIfDownloadsAreStopped = false;
    public static final String HIDE_IF_DOWNLOADS_ARE_STOPPED = "HideIfDownloadsAreStopped";

    public PauseDownloadsAction() {
        this.setIconKey("media-playback-pause");
        this.setSelected(false);
        this.setEnabled(false);
        this.setTooltipText(_GUI.T.gui_menu_action_break2_desc((Object)((Integer)CFG_GENERAL.PAUSE_SPEED.getValue() / 1024)));
        DownloadWatchDog.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        CFG_GENERAL.PAUSE_SPEED.getEventSender().addListener((EventListener)((Object)this), true);
        DownloadWatchDog.getInstance().notifyCurrentState((DownloadWatchdogListener)this);
    }

    protected void initContextDefaults(ActionContext actionContext) {
        if (actionContext == this) {
            this.setHideIfDownloadsAreStopped(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        DownloadWatchDog.getInstance().pauseDownloadWatchDog(!DownloadWatchDog.getInstance().isPaused());
    }

    public String createTooltip() {
        return _GUI.T.gui_menu_action_break2_desc((Object)((Integer)CFG_GENERAL.PAUSE_SPEED.getValue() / 1024));
    }

    public void onDownloadWatchdogDataUpdate() {
    }

    public static String getHideIfDownloadsAreStoppedTranslation() {
        return _JDT.T.PauseDownloadsAction_getHideIfDownloadsAreStoppedTranslation();
    }

    @Customizer(link="#getHideIfDownloadsAreStoppedTranslation")
    public boolean isHideIfDownloadsAreStopped() {
        return this.hideIfDownloadsAreStopped;
    }

    public void setHideIfDownloadsAreStopped(boolean showIfDownloadsAreRunning) {
        this.hideIfDownloadsAreStopped = showIfDownloadsAreRunning;
        if (this.isHideIfDownloadsAreStopped() && !DownloadWatchDog.getInstance().isRunning()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    public void onDownloadWatchdogStateIsIdle() {
        new EDTRunner(){

            protected void runInEDT() {
                PauseDownloadsAction.this.setEnabled(false);
                PauseDownloadsAction.this.setSelected(false);
            }
        };
    }

    public void onDownloadWatchdogStateIsPause() {
        new EDTRunner(){

            protected void runInEDT() {
                PauseDownloadsAction.this.setEnabled(true);
                PauseDownloadsAction.this.setSelected(true);
            }
        };
    }

    public void onDownloadWatchdogStateIsRunning() {
        new EDTRunner(){

            protected void runInEDT() {
                PauseDownloadsAction.this.setEnabled(true);
                PauseDownloadsAction.this.setSelected(false);
                PauseDownloadsAction.this.setVisible(true);
            }
        };
    }

    public void onDownloadWatchdogStateIsStopped() {
        new EDTRunner(){

            protected void runInEDT() {
                PauseDownloadsAction.this.setEnabled(false);
                PauseDownloadsAction.this.setSelected(false);
                if (PauseDownloadsAction.this.isHideIfDownloadsAreStopped()) {
                    PauseDownloadsAction.this.setVisible(false);
                }
            }
        };
    }

    public void onDownloadWatchdogStateIsStopping() {
    }

    public void onConfigValidatorError(KeyHandler<Integer> keyHandler, Integer invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Integer> keyHandler, Integer newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                PauseDownloadsAction.this.setTooltipText(_GUI.T.gui_menu_action_break2_desc((Object)((Integer)CFG_GENERAL.PAUSE_SPEED.getValue() / 1024)));
            }
        };
    }

    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
    }

    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
    }

    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }
}

