/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jd.gui.swing.components.SetIconInterface;
import jd.gui.swing.components.SetLabelInterface;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.components.tooltips.TooltipTextDelegateFactory;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.gui.AfterLayerUpdateInterface;
import org.jdownloader.updatev2.gui.LAFOptions;

public class MenuEditor
extends MigPanel
implements ToolTipHandler,
SetIconInterface,
SetLabelInterface,
AfterLayerUpdateInterface {
    private static final long serialVersionUID = -1702338721344188944L;
    private boolean shrink;
    private TooltipTextDelegateFactory tooltipFactory;
    private JLabel label;

    public boolean isShrink() {
        return this.shrink;
    }

    public void setShrink(boolean shrink) {
        this.shrink = shrink;
    }

    public MenuEditor(boolean b) {
        this.setLayout((LayoutManager)new MigLayout("ins " + this.getInsetsString(), "6[grow,fill][fill]", "[fill," + this.getComponentHeight() + "!]"));
        this.shrink = b;
        this.tooltipFactory = new TooltipTextDelegateFactory((JComponent)((Object)this));
        this.setOpaque(false);
    }

    protected String getInsetsString() {
        return "1";
    }

    protected int getComponentHeight() {
        return 22;
    }

    protected JLabel getLbl(String name, Icon icon) {
        this.label = new JLabel(this.shrink ? "" : name, icon, 10);
        this.setToolTipText(name);
        ToolTipController.getInstance().register((ToolTipHandler)this);
        this.label.setIconTextGap(this.getIconTextGap());
        return this.label;
    }

    protected int getIconTextGap() {
        return 7;
    }

    public void addLbl(String chunksEditor_ChunksEditor_, Icon icon) {
        this.add(this.getLbl(chunksEditor_ChunksEditor_, icon));
    }

    public ExtTooltip createExtTooltip(Point mousePosition) {
        return this.tooltipFactory.createTooltip();
    }

    public boolean isTooltipDisabledUntilNextRefocus() {
        return false;
    }

    protected int getEditorWidth() {
        return new JLabel((String)"500.00 KB/s").getPreferredSize().width + 30;
    }

    public int getTooltipDelay(Point mousePositionOnScreen) {
        mousePositionOnScreen = new Point(mousePositionOnScreen);
        SwingUtilities.convertPointFromScreen(mousePositionOnScreen, (Component)((Object)this));
        if (mousePositionOnScreen.x < 24) {
            return 200;
        }
        return 1000;
    }

    public boolean updateTooltip(ExtTooltip activeToolTip, MouseEvent e) {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        return ret;
    }

    public boolean isTooltipWithoutFocusEnabled() {
        return true;
    }

    @Override
    public void setText(String text) {
        this.label.setText(text);
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.label != null) {
            this.label.setIcon(icon);
        }
    }

    public void onAfterLayerDone(JComponent root, MenuContainer md) {
        for (Component c : root.getComponents()) {
            if (!(c instanceof JCheckBoxMenuItem)) continue;
            this.label.setBorder(BorderFactory.createEmptyBorder(0, LAFOptions.getInstance().getExtension().customizeMenuItemIndentForToggleItems(), 0, 0));
            return;
        }
    }
}

