/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.components;

import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import jd.controlling.downloadcontroller.BadDestinationException;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.PathTooLongException;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateEvent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateEventSender;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.VariableAction;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.pathchooser.PathChooser;
import org.appwork.uio.UIOManager;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.gui.packagehistorycontroller.DownloadPathHistoryManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.DownloadFolderChooserDialog;
import org.jdownloader.translate._JDT;

public class FolderChooser
extends PathChooser
implements SettingsComponent {
    private static final long serialVersionUID = 1L;
    private StateUpdateEventSender<FolderChooser> eventSender = new StateUpdateEventSender();
    private boolean setting;
    private String originalPath = null;
    private String initialPath = null;

    public FolderChooser() {
        super("FolderChooser", true);
        this.txt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!FolderChooser.this.setting) {
                    FolderChooser.this.eventSender.fireEvent((DefaultEvent)new StateUpdateEvent<FolderChooser>(FolderChooser.this));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!FolderChooser.this.setting) {
                    FolderChooser.this.eventSender.fireEvent((DefaultEvent)new StateUpdateEvent<FolderChooser>(FolderChooser.this));
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!FolderChooser.this.setting) {
                    FolderChooser.this.eventSender.fireEvent((DefaultEvent)new StateUpdateEvent<FolderChooser>(FolderChooser.this));
                }
            }
        });
        this.destination.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                List list = DownloadPathHistoryManager.getInstance().listPaths(new String[]{FolderChooser.this.initialPath});
                FolderChooser.this.destination.setList(list);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public JPopupMenu getPopupMenu(ExtTextField txt, AbstractAction cutAction, AbstractAction copyAction, AbstractAction pasteAction, AbstractAction deleteAction, AbstractAction selectAction) {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)((Object)new VariableAction((JTextComponent)txt, _GUI.T.PackagizerFilterRuleDialog_createVariablesMenu_date(), "<jd:simpledate:dd.MM.yyyy>")));
        menu.add((Action)((Object)new VariableAction((JTextComponent)txt, _GUI.T.PackagizerFilterRuleDialog_createVariablesMenu_packagename(), "<jd:packagename>")));
        return menu;
    }

    @Override
    public String getConstraints() {
        return null;
    }

    public void addStateUpdateListener(StateUpdateListener listener) {
        this.eventSender.addListener(listener);
    }

    public void setPath(String downloadDestination) {
        if (this.initialPath == null) {
            this.initialPath = downloadDestination;
        }
        this.originalPath = downloadDestination;
        super.setPath(downloadDestination);
    }

    public void setText(String t) {
        this.setting = true;
        try {
            this.setPath(t);
        }
        finally {
            this.setting = false;
        }
    }

    public File doFileChooser() {
        try {
            File ret = DownloadFolderChooserDialog.open((File)new File(this.txt.getText()), (boolean)true, (String)_JDT.T.gui_setting_folderchooser_title());
            return ret;
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isMultiline() {
        return false;
    }

    public String getText() {
        return this.getText(true);
    }

    public String getText(Boolean checkPath) {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        if (Boolean.FALSE.equals(checkPath)) {
            return file.getAbsolutePath();
        }
        if ((file = FolderChooser.checkPath(file, this.originalPath == null ? null : new File(this.originalPath))) == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static File checkPath(File file, File presetPath) {
        String path = file.getAbsolutePath();
        File checkPath = file;
        int index = path.indexOf("<jd:");
        if (index >= 0) {
            path = path.substring(0, index);
            checkPath = new File(path);
        }
        File forbidden = null;
        try {
            DownloadWatchDog.getInstance().validateDestination(checkPath);
        }
        catch (PathTooLongException e) {
            forbidden = e.getFile();
        }
        catch (BadDestinationException e) {
            forbidden = e.getFile();
        }
        if (forbidden != null) {
            final File finalForbidden = forbidden;
            new EDTHelper<Void>(){

                public Void edtRun() {
                    UIOManager.I().showErrorMessage(_GUI.T.DownloadFolderChooserDialog_handleNonExistingFolders_couldnotcreatefolder(finalForbidden.getAbsolutePath()));
                    return null;
                }
            }.start(true);
            return null;
        }
        if (!checkPath.exists()) {
            if (presetPath != null && presetPath.equals(checkPath)) {
                return file;
            }
            File createFolder = index >= 0 ? checkPath : file;
            if (!createFolder.exists() && UIOManager.I().showConfirmDialog(32, _GUI.T.DownloadFolderChooserDialog_handleNonExistingFolders_title_(), _GUI.T.DownloadFolderChooserDialog_handleNonExistingFolders_msg_(createFolder.getAbsolutePath()), null, null, null, FolderChooser.class.getCanonicalName()) && !FileCreationManager.getInstance().mkdir(createFolder)) {
                UIOManager.I().showErrorMessage(_GUI.T.DownloadFolderChooserDialog_handleNonExistingFolders_couldnotcreatefolder(createFolder.getAbsolutePath()));
                return presetPath;
            }
        }
        return file;
    }
}

