/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import jd.controlling.TaskQueue;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.views.myjd.MyJDownloaderView;
import jd.gui.swing.jdgui.views.myjd.panels.MyJDownloaderSettingsPanelForTab;
import jd.gui.swing.jdgui.views.settings.components.PasswordInput;
import jd.gui.swing.jdgui.views.settings.components.SettingsButton;
import jd.gui.swing.jdgui.views.settings.components.TextInput;
import org.appwork.storage.StorageException;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtTextHighlighter;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.actions.AppAction;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectionStatus;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.myjdownloader.MyJDownloaderSettings;
import org.jdownloader.api.myjdownloader.event.MyJDownloaderListener;
import org.jdownloader.gui.settings.AbstractConfigPanel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_MYJD;

public class MyJDownloaderSettingsPanel
extends AbstractConfigPanel
implements GenericConfigEventListener<Enum>,
MyJDownloaderListener {
    private static final long serialVersionUID = 1L;
    private final SettingsButton openMyJDownloader = new SettingsButton(new AppAction(){
        {
            this.setName(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_open_());
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CrossSystem.openURL((String)"http://my.jdownloader.org?referer=JDownloader");
            }
            catch (StorageException e1) {
                e1.printStackTrace();
            }
        }
    });
    private final TextInput email;
    private final PasswordInput passWord;
    private final JTextArea timerText;
    private final JTextArea errorText;
    private final JTextArea statusText;
    private final JButton connectButton;
    private final AppAction connectAction;
    private final AppAction disconnectAction;
    private final AppAction reconnectAction;
    private final ExtButton disconnectButton;
    private final TextInput deviceName;
    private final SettingsButton openMyJDownloaderTab = new SettingsButton(new AppAction(){
        {
            this.setName(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_tab_());
        }

        public void actionPerformed(ActionEvent e) {
            JDGui.getInstance().setContent(MyJDownloaderView.getInstance(), true);
        }
    });
    private volatile Timer timer = null;

    public String getTitle() {
        return _GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_title_();
    }

    public MyJDownloaderSettingsPanel() {
        this.deviceName = new TextInput(CFG_MYJD.DEVICE_NAME);
        this.email = new TextInput(CFG_MYJD.EMAIL){
            {
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("^(\\s+)")));
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("(\\s+)$")));
                this.refreshTextHighlighter();
            }

            @Override
            protected void setKeyHandlerValue(String text) {
                super.setKeyHandlerValue(text != null ? text.trim() : null);
            }
        };
        this.passWord = new PasswordInput(CFG_MYJD.PASSWORD){
            {
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("^(\\s+)")));
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("(\\s+)$")));
                this.applyTextHighlighter(null);
            }
        };
        GenericConfigEventListener<String> loginsChangeListener = new GenericConfigEventListener<String>(){

            public void onConfigValidatorError(KeyHandler<String> keyHandler, String invalidValue, ValidationException validateException) {
            }

            public void onConfigValueModified(KeyHandler<String> keyHandler, String newValue) {
                MyJDownloaderSettingsPanel.this.updateContents();
            }
        };
        CFG_MYJD.EMAIL.getEventSender().addListener((EventListener)loginsChangeListener);
        CFG_MYJD.PASSWORD.getEventSender().addListener((EventListener)loginsChangeListener);
        CFG_MYJD.DEVICE_NAME.getEventSender().addListener((EventListener)loginsChangeListener);
        this.errorText = new JTextArea();
        SwingUtils.setOpaque((JComponent)this.errorText, (boolean)false);
        this.errorText.setEditable(false);
        this.errorText.setLineWrap(true);
        this.errorText.setWrapStyleWord(true);
        this.errorText.setFocusable(false);
        this.errorText.setForeground(Color.RED);
        SwingUtils.toBold((JTextComponent)this.errorText);
        this.statusText = new JTextArea();
        SwingUtils.setOpaque((JComponent)this.statusText, (boolean)false);
        this.statusText.setEditable(false);
        this.statusText.setLineWrap(true);
        this.statusText.setWrapStyleWord(true);
        this.statusText.setFocusable(false);
        SwingUtils.toBold((JTextComponent)this.statusText);
        this.timerText = new JTextArea();
        SwingUtils.setOpaque((JComponent)this.timerText, (boolean)false);
        this.timerText.setEditable(false);
        this.timerText.setLineWrap(true);
        this.timerText.setWrapStyleWord(true);
        this.timerText.setFocusable(false);
        this.timerText.setForeground(Color.YELLOW.darker());
        SwingUtils.toBold((JTextComponent)this.timerText);
        this.connectAction = new AppAction(){
            {
                this.setName(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_connect_());
            }

            public void actionPerformed(ActionEvent e) {
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        if (MyJDownloaderController.getInstance().isLoginValid(false)) {
                            MyJDownloaderController.getInstance().connect();
                        } else {
                            MyJDownloaderController.getInstance().onError(MyJDownloaderSettings.MyJDownloaderError.BAD_LOGINS);
                        }
                        return null;
                    }
                });
            }
        };
        this.disconnectAction = new AppAction(){
            {
                this.setName(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_disconnect_());
            }

            public void actionPerformed(ActionEvent e) {
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        MyJDownloaderController.getInstance().disconnect();
                        return null;
                    }
                });
            }
        };
        this.reconnectAction = new AppAction(){
            {
                this.setName(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_reconnect_());
            }

            public void actionPerformed(final ActionEvent e) {
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        MyJDownloaderSettingsPanel.this.disconnectAction.actionPerformed(e);
                        MyJDownloaderSettingsPanel.this.connectAction.actionPerformed(e);
                        return null;
                    }
                });
            }
        };
        this.connectButton = new ExtButton((AbstractAction)this.connectAction);
        this.disconnectButton = new ExtButton((AbstractAction)this.disconnectAction);
        MyJDownloaderController.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        CFG_MYJD.LATEST_ERROR.getEventSender().addListener((EventListener)((Object)this), true);
        this.addHeader(this.getTitle(), this.getIcon());
        this.addDescription(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_description());
        this.add((Component)((Object)this.openMyJDownloader), "gapleft 37,spanx,pushx,growx");
        if (!(this instanceof MyJDownloaderSettingsPanelForTab)) {
            this.add((Component)((Object)this.openMyJDownloaderTab), "gapleft 37,spanx,pushx,growx");
        }
        this.addHeader(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_logins_(), NewTheme.I().getIcon("logins", 32));
        this.addDescriptionPlain(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_jd_logins());
        this.addPair(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_email_(), null, this.email);
        this.addPair(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_password_(), null, this.passWord);
        this.addDescriptionPlain(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_jd_name());
        this.addPair(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_devicename_(), null, this.deviceName);
        MigPanel p = new MigPanel("ins 0 0 0 0", "[grow,fill][][]", "[]");
        p.setOpaque(false);
        p.add((Component)this.statusText, (Object)"wmin 10");
        p.add((Component)this.connectButton);
        p.add((Component)this.disconnectButton);
        this.add(Box.createHorizontalGlue(), "gapleft 37");
        this.add((Component)p, "spanx,pushx,growx");
        this.add(Box.createHorizontalGlue(), "gapleft 37");
        this.add(this.errorText, "gaptop 0,spanx,growx,pushx,gapbottom 5,wmin 10,hidemode 3");
        this.add(Box.createHorizontalGlue(), "gapleft 37");
        this.add(this.timerText, "gaptop 0,spanx,growx,pushx,gapbottom 5,wmin 10,hidemode 3");
    }

    public Icon getIcon() {
        return new AbstractIcon("logo/myjdownloader", 32);
    }

    public void save() {
    }

    protected void onHide() {
        super.onHide();
        this.timer = null;
    }

    protected void onShow() {
        super.onShow();
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == MyJDownloaderSettingsPanel.this.timer) {
                    long retryTimeStamp = MyJDownloaderController.getInstance().getRetryTimeStamp();
                    long wait = retryTimeStamp - System.currentTimeMillis();
                    if (retryTimeStamp > 0L && wait > 0L) {
                        MyJDownloaderSettingsPanel.this.timerText.setVisible(true);
                        MyJDownloaderSettingsPanel.this.timerText.setText("Retry in: " + TimeFormatter.formatMilliSeconds((long)wait, (int)0));
                    } else {
                        MyJDownloaderSettingsPanel.this.timerText.setVisible(false);
                    }
                } else {
                    ((Timer)e.getSource()).stop();
                }
            }
        }){};
        this.timer.start();
    }

    public void updateContents() {
        this.onMyJDownloaderConnectionStatusChanged(MyJDownloaderController.getInstance().getConnectionStatus(), MyJDownloaderController.getInstance().getEstablishedConnections());
        final MyJDownloaderSettings.MyJDownloaderError latestError = CFG_MYJD.CFG.getLatestError();
        new EDTRunner(){

            protected void runInEDT() {
                switch (latestError) {
                    case NONE: {
                        MyJDownloaderSettingsPanel.this.errorText.setVisible(false);
                        break;
                    }
                    case ACCOUNT_UNCONFIRMED: {
                        MyJDownloaderSettingsPanel.this.errorText.setVisible(true);
                        MyJDownloaderSettingsPanel.this.errorText.setForeground(Color.RED);
                        MyJDownloaderSettingsPanel.this.errorText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_account_unconfirmed_());
                        break;
                    }
                    case BAD_LOGINS: 
                    case EMAIL_INVALID: {
                        MyJDownloaderSettingsPanel.this.errorText.setVisible(true);
                        MyJDownloaderSettingsPanel.this.errorText.setForeground(Color.RED);
                        MyJDownloaderSettingsPanel.this.errorText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_account_badlogins());
                        break;
                    }
                    case SERVER_MAINTENANCE: {
                        MyJDownloaderSettingsPanel.this.errorText.setVisible(true);
                        MyJDownloaderSettingsPanel.this.errorText.setForeground(Color.YELLOW.darker());
                        MyJDownloaderSettingsPanel.this.errorText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_maintenance_());
                        break;
                    }
                    case SERVER_OVERLOAD: {
                        MyJDownloaderSettingsPanel.this.errorText.setVisible(true);
                        MyJDownloaderSettingsPanel.this.errorText.setForeground(Color.YELLOW.darker());
                        MyJDownloaderSettingsPanel.this.errorText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_disconnected_2(latestError.toString()));
                        break;
                    }
                    default: {
                        MyJDownloaderSettingsPanel.this.errorText.setVisible(true);
                        MyJDownloaderSettingsPanel.this.errorText.setForeground(Color.RED);
                        MyJDownloaderSettingsPanel.this.errorText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_disconnected_2(latestError.toString()));
                    }
                }
            }
        };
    }

    public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
        this.updateContents();
    }

    public void onMyJDownloaderConnectionStatusChanged(final MyJDownloaderConnectionStatus connectionStatus, final int connections) {
        new EDTRunner(){

            protected void runInEDT() {
                if (!MyJDownloaderSettingsPanel.this.isShowing()) {
                    return;
                }
                String cUser = MyJDownloaderController.getInstance().getCurrentEmail();
                String cPass = MyJDownloaderController.getInstance().getCurrentPassword();
                long retryTimeStamp = MyJDownloaderController.getInstance().getRetryTimeStamp();
                boolean connected = connectionStatus != MyJDownloaderConnectionStatus.UNCONNECTED;
                MyJDownloaderSettingsPanel.this.disconnectAction.setEnabled(connected);
                MyJDownloaderSettingsPanel.this.connectAction.setEnabled(!connected);
                MyJDownloaderSettingsPanel.this.reconnectAction.setEnabled(false);
                if (connected) {
                    String cDevice = MyJDownloaderController.getInstance().getCurrentDeviceName();
                    MyJDownloaderSettingsPanel.this.connectButton.setAction((Action)MyJDownloaderSettingsPanel.this.connectAction);
                    if (!(!MyJDownloaderController.getInstance().validateAndVerifyLogins(cUser, cPass, false) || cUser != null && cUser.equals(CFG_MYJD.EMAIL.getValue()) && cPass != null && cPass.equals(CFG_MYJD.PASSWORD.getValue()) && cDevice != null && cDevice.equals(CFG_MYJD.DEVICE_NAME.getValue()))) {
                        MyJDownloaderSettingsPanel.this.reconnectAction.setEnabled(true);
                        MyJDownloaderSettingsPanel.this.connectButton.setAction((Action)MyJDownloaderSettingsPanel.this.reconnectAction);
                    }
                    block0 : switch (connectionStatus) {
                        case PENDING: {
                            MyJDownloaderSettings.MyJDownloaderError latestError = CFG_MYJD.CFG.getLatestError();
                            switch (latestError) {
                                case SERVER_MAINTENANCE: 
                                case SERVER_OVERLOAD: {
                                    MyJDownloaderSettingsPanel.this.statusText.setForeground(Color.YELLOW.darker());
                                    MyJDownloaderSettingsPanel.this.statusText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_connections(connections));
                                    break block0;
                                }
                                case IO: 
                                case SERVER_DOWN: 
                                case NO_INTERNET_CONNECTION: {
                                    MyJDownloaderSettingsPanel.this.statusText.setForeground(Color.RED);
                                    MyJDownloaderSettingsPanel.this.statusText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_connections(connections));
                                    break block0;
                                }
                            }
                            MyJDownloaderSettingsPanel.this.statusText.setForeground(Color.GREEN.darker());
                            MyJDownloaderSettingsPanel.this.statusText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_connected_2() + "\r\n" + _GUI.T.MyJDownloaderSettingsPanel_runInEDT_connections(connections));
                            break;
                        }
                        case CONNECTED: {
                            MyJDownloaderSettingsPanel.this.statusText.setForeground(Color.GREEN);
                            MyJDownloaderSettingsPanel.this.statusText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_connected_2() + "\r\n" + _GUI.T.MyJDownloaderSettingsPanel_runInEDT_connections(connections));
                        }
                    }
                } else {
                    MyJDownloaderSettingsPanel.this.statusText.setText(_GUI.T.MyJDownloaderSettingsPanel_runInEDT_disconnected_());
                    MyJDownloaderSettingsPanel.this.statusText.setForeground(Color.RED);
                    MyJDownloaderSettingsPanel.this.connectButton.setAction((Action)MyJDownloaderSettingsPanel.this.connectAction);
                }
            }
        };
    }
}

