/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.advanced;

import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.TaskQueue;
import jd.gui.swing.jdgui.views.settings.panels.advanced.AdvancedValueColumn;
import jd.gui.swing.jdgui.views.settings.panels.advanced.EditColumn;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;
import org.jdownloader.settings.advanced.AdvancedConfigManager;

public class AdvancedConfigTableModel
extends ExtTableModel<AdvancedConfigEntry> {
    private static final long serialVersionUID = 1L;
    private volatile String text = null;
    private final AtomicBoolean resetOnlyFilter = new AtomicBoolean(false);

    public AdvancedConfigTableModel(String id) {
        super(id);
    }

    private boolean containsKeyword(AdvancedConfigEntry configEntry, String[] finds) {
        String[] keywords;
        String[] stringArray = keywords = configEntry != null ? configEntry.getKeywords() : null;
        if (keywords == null || keywords.length == 0 || finds == null) {
            return false;
        }
        boolean result = false;
        for (String find : finds) {
            if ("".equals(find)) continue;
            for (String keyword : keywords) {
                if (result) {
                    if (StringUtils.containsIgnoreCase((String)keyword, (String)find)) continue;
                    return false;
                }
                if (StringUtils.containsIgnoreCase((String)keyword, (String)find)) {
                    result = true;
                    continue;
                }
                return false;
            }
        }
        return result;
    }

    private boolean contains(String[] values, String[] finds) {
        if (values == null) {
            return false;
        }
        for (String value : values) {
            if (!this.contains(value, finds)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(String value, String[] finds) {
        if (StringUtils.isEmpty((String)value) || finds == null) {
            return false;
        }
        boolean result = false;
        for (String find : finds) {
            if ("".equals(find)) continue;
            if (result) {
                if (StringUtils.containsIgnoreCase((String)value, (String)find)) continue;
                return false;
            }
            if (StringUtils.containsIgnoreCase((String)value, (String)find)) {
                result = true;
                continue;
            }
            return false;
        }
        return result;
    }

    public void _fireTableStructureChanged(List<AdvancedConfigEntry> newtableData, boolean refreshSort) {
        String[] finds;
        String ltext;
        if (this.resetOnlyFilter.get()) {
            EditColumn.ResetAction resetAction = new EditColumn.ResetAction(null);
            Iterator<AdvancedConfigEntry> it = newtableData.iterator();
            while (it.hasNext()) {
                AdvancedConfigEntry next = it.next();
                resetAction.setEntry(next);
                if (resetAction.isEnabled()) continue;
                it.remove();
            }
        }
        if (!StringUtils.isEmpty((String)(ltext = this.text)) && (finds = ltext.replaceAll("[^a-zA-Z0-9 ,]+", "").replace("colour", "color").replace("directory", "folder").toLowerCase(Locale.ENGLISH).split("(\\s|,)")).length > 0) {
            Iterator<AdvancedConfigEntry> it = newtableData.iterator();
            while (it.hasNext()) {
                AdvancedConfigEntry next = it.next();
                if (next != null && (this.contains(next.getInternalKey(), finds) || this.containsKeyword(next, finds) || this.contains(next.getDescription(), finds) || this.contains(next.getKeyText(), finds))) continue;
                it.remove();
            }
        }
        super._fireTableStructureChanged(newtableData, refreshSort);
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new ExtTextColumn<AdvancedConfigEntry>(_GUI.T.AdvancedTableModel_initColumns_key_()){
            private static final long serialVersionUID = 1L;

            protected String getTooltipText(AdvancedConfigEntry obj) {
                return obj.getDescription();
            }

            public String getStringValue(AdvancedConfigEntry value) {
                return value.getKeyText();
            }

            public boolean isEditable(AdvancedConfigEntry obj) {
                return false;
            }

            public boolean onDoubleClick(MouseEvent e, AdvancedConfigEntry obj) {
                ClipboardMonitoring.getINSTANCE().setCurrentContent(obj.getKey());
                return true;
            }

            public int getDefaultWidth() {
                return 200;
            }

            public boolean isHidable() {
                return false;
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<AdvancedConfigEntry>(_GUI.T.AdvancedTableModel_initColumns_desc_()){
            private static final long serialVersionUID = 1L;

            protected String getTooltipText(AdvancedConfigEntry obj) {
                return obj.getDescription();
            }

            public String getStringValue(AdvancedConfigEntry value) {
                if (value.hasDescription()) {
                    return value.getDescription();
                }
                return null;
            }

            public boolean onDoubleClick(MouseEvent e, AdvancedConfigEntry obj) {
                ClipboardMonitoring.getINSTANCE().setCurrentContent(obj.getDescription());
                return true;
            }

            public boolean isEditable(AdvancedConfigEntry obj) {
                return false;
            }

            public int getDefaultWidth() {
                return 200;
            }

            public boolean isHidable() {
                return true;
            }
        });
        this.addColumn((ExtColumn)new AdvancedValueColumn());
        this.addColumn((ExtColumn)new ExtTextColumn<AdvancedConfigEntry>(_GUI.T.AdvancedTableModel_initColumns_type_()){
            private static final long serialVersionUID = 1L;

            public int getDefaultWidth() {
                return 100;
            }

            public boolean isDefaultVisible() {
                return false;
            }

            public String getStringValue(AdvancedConfigEntry value) {
                return value.getTypeString();
            }
        });
        this.addColumn((ExtColumn)new EditColumn(){

            @Override
            protected boolean isResetOnlyFilterEnabled() {
                return AdvancedConfigTableModel.this.resetOnlyFilter.get();
            }

            @Override
            protected void setResetOnlyFilterEnabled(boolean enabled) {
                if (AdvancedConfigTableModel.this.resetOnlyFilter.compareAndSet(!enabled, enabled)) {
                    AdvancedConfigTableModel.this.refresh(AdvancedConfigTableModel.this.text);
                }
            }
        });
    }

    public void refresh(String filterText) {
        this.text = filterText;
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                final List list = AdvancedConfigManager.getInstance().list();
                new EDTRunner(){

                    protected void runInEDT() {
                        AdvancedConfigTableModel.this._fireTableStructureChanged(list, true);
                    }
                };
                return null;
            }
        });
    }
}

